/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.server.AbstractSession;
import com.sibvisions.rad.server.DirectServerConnection;
import com.sibvisions.rad.server.IDirectServer;
import com.sibvisions.rad.server.MasterSession;
import com.sibvisions.rad.server.SubSession;
import com.sibvisions.rad.server.WrappedSession;
import com.sibvisions.rad.server.config.ServerZone;
import javax.rad.remote.IConnection;
import javax.rad.server.ICallHandler;
import javax.rad.server.IConfiguration;
import javax.rad.server.ISession;
import javax.rad.server.InjectObject;
import javax.rad.server.SessionContext;

final class SessionContextImpl
extends SessionContext {
    private WrappedSession wsessMaster;
    private WrappedSession wsessCurrent;
    private String sObjectName = null;
    private String sMethodName = null;

    SessionContextImpl(AbstractSession abstractSession) {
        this.wsessCurrent = new WrappedSession(abstractSession);
        this.setCurrentInstance(this);
    }

    public void destroy() {
        this.setCurrentInstance(null);
        this.wsessMaster = null;
        this.wsessCurrent = null;
    }

    public ISession getSession() {
        return this.wsessCurrent;
    }

    public ISession getMasterSession() {
        if (this.wsessMaster != null) {
            return this.wsessMaster;
        }
        if (this.wsessCurrent == null) {
            return null;
        }
        AbstractSession abstractSession = this.wsessCurrent.session;
        if (abstractSession instanceof MasterSession) {
            this.wsessMaster = this.wsessCurrent;
            return this.wsessMaster;
        }
        if (abstractSession instanceof SubSession) {
            this.wsessMaster = new WrappedSession(((SubSession)abstractSession).getMasterSession());
            return this.wsessMaster;
        }
        return null;
    }

    public IConfiguration getSessionConfig() {
        if (this.wsessCurrent == null) {
            return null;
        }
        return this.wsessCurrent.getConfig();
    }

    public IConfiguration getServerConfig() {
        if (this.wsessCurrent == null) {
            return null;
        }
        ServerZone serverZone = this.wsessCurrent.session.getApplicationZone().getServerZone();
        if (serverZone != null) {
            return serverZone.getConfig();
        }
        return null;
    }

    public IConnection getServerConnection() {
        if (this.wsessCurrent == null) {
            return null;
        }
        return new DirectServerConnection((IDirectServer)this.wsessCurrent.session.getSessionManager().getServer());
    }

    public String getObjectName() {
        return this.sObjectName;
    }

    public String getMethodName() {
        return this.sMethodName;
    }

    public InjectObject putObject(InjectObject injectObject) {
        return this.wsessCurrent.session.putObject(injectObject);
    }

    public InjectObject removeObject(InjectObject injectObject) {
        return this.wsessCurrent.session.removeObject(injectObject);
    }

    public InjectObject getObject(String string) {
        return this.wsessCurrent.session.getObject(string);
    }

    public ICallHandler getCallHandler() {
        return this.wsessCurrent.session.getCallHandler();
    }

    void setObjectName(String string) {
        this.sObjectName = string;
    }

    void setMethodName(String string) {
        this.sMethodName = string;
    }
}

