/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.server.AbstractSession;
import com.sibvisions.rad.server.Call;
import com.sibvisions.rad.server.SubSession;
import com.sibvisions.rad.server.WrappedSession;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.log.LoggerFactory;
import java.util.List;
import javax.rad.server.ICallHandler;
import javax.rad.server.ISession;
import javax.rad.server.event.CallEvent;
import javax.rad.server.event.CallEventHandler;
import javax.rad.server.event.CallResultEvent;
import javax.rad.server.event.SessionEvent;
import javax.rad.server.event.type.IAfterCallListener;
import javax.rad.server.event.type.IAfterLastCallListener;
import javax.rad.server.event.type.IBeforeCallListener;
import javax.rad.server.event.type.IBeforeFirstCallListener;
import javax.rad.util.EventHandler;
import javax.rad.util.ExceptionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SessionCallHandler
implements ICallHandler {
    private static EventHandler<Runnable> ehRunnable = new EventHandler<Runnable>(Runnable.class, new Class[0]);
    private WrappedSession wsessCurrent;
    private SessionCallHandler chMaster;
    private ArrayUtil<Runnable> auInvokeAfterCall;
    private ArrayUtil<Runnable> auInvokeAfterLastCall;
    private ArrayUtil<Runnable> auInvokeFinally;
    private Call callCurrent;
    private RecordingCallEventHandler<IBeforeFirstCallListener> eventBeforeFirstCall;
    private CallEventHandler<IAfterLastCallListener> eventAfterLastCall;
    private RecordingCallEventHandler<IBeforeCallListener> eventBeforeCall;
    private CallEventHandler<IAfterCallListener> eventAfterCall;

    SessionCallHandler(AbstractSession abstractSession) {
        this.wsessCurrent = new WrappedSession(abstractSession);
        if (abstractSession instanceof SubSession) {
            this.chMaster = ((SubSession)abstractSession).getMasterSession().getCallHandler();
        }
    }

    public RecordingCallEventHandler<IBeforeFirstCallListener> eventBeforeFirstCall() {
        if (this.eventBeforeFirstCall == null) {
            this.eventBeforeFirstCall = new RecordingCallEventHandler(IBeforeFirstCallListener.class);
        }
        return this.eventBeforeFirstCall;
    }

    @Override
    public CallEventHandler<IAfterLastCallListener> eventAfterLastCall() {
        if (this.eventAfterLastCall == null) {
            this.eventAfterLastCall = new CallEventHandler<IAfterLastCallListener>(IAfterLastCallListener.class);
        }
        return this.eventAfterLastCall;
    }

    public RecordingCallEventHandler<IBeforeCallListener> eventBeforeCall() {
        if (this.eventBeforeCall == null) {
            this.eventBeforeCall = new RecordingCallEventHandler(IBeforeCallListener.class);
        }
        return this.eventBeforeCall;
    }

    @Override
    public CallEventHandler<IAfterCallListener> eventAfterCall() {
        if (this.eventAfterCall == null) {
            this.eventAfterCall = new CallEventHandler<IAfterCallListener>(IAfterCallListener.class);
        }
        return this.eventAfterCall;
    }

    @Override
    public void invokeAfterCall(Runnable runnable) {
        if (this.auInvokeAfterCall == null) {
            this.auInvokeAfterCall = new ArrayUtil();
        }
        this.auInvokeAfterCall.add(runnable);
    }

    @Override
    public void invokeAfterCall(Object object, String string) {
        if (this.auInvokeAfterCall == null) {
            this.auInvokeAfterCall = new ArrayUtil();
        }
        this.auInvokeAfterCall.add(ehRunnable.createListener(object, string));
    }

    @Override
    public void invokeAfterLastCall(Runnable runnable) {
        if (this.auInvokeAfterLastCall == null) {
            this.auInvokeAfterLastCall = new ArrayUtil();
        }
        this.auInvokeAfterLastCall.add(runnable);
    }

    @Override
    public void invokeAfterLastCall(Object object, String string) {
        if (this.auInvokeAfterLastCall == null) {
            this.auInvokeAfterLastCall = new ArrayUtil();
        }
        this.auInvokeAfterLastCall.add(ehRunnable.createListener(object, string));
    }

    @Override
    public void invokeFinally(Runnable runnable) {
        if (this.auInvokeFinally == null) {
            this.auInvokeFinally = new ArrayUtil();
        }
        this.auInvokeFinally.add(runnable);
    }

    @Override
    public void invokeFinally(Object object, String string) {
        if (this.auInvokeFinally == null) {
            this.auInvokeFinally = new ArrayUtil();
        }
        this.auInvokeFinally.add(ehRunnable.createListener(object, string));
    }

    public ISession getSession() {
        return this.wsessCurrent;
    }

    void fireBeforeFirstCall() {
        if (this.eventBeforeFirstCall != null) {
            if (this.chMaster != null) {
                this.chMaster.fireBeforeFirstCall();
            }
            this.eventBeforeFirstCall.dispatchEvent(new SessionEvent(this.wsessCurrent));
            ((RecordingCallEventHandler)this.eventBeforeFirstCall).bRecord = true;
        } else {
            ((RecordingCallEventHandler)this.eventBeforeFirstCall()).bRecord = true;
        }
    }

    void fireAfterLastCall(boolean bl) {
        if (this.eventAfterLastCall != null) {
            this.eventAfterLastCall.dispatchEvent(new SessionEvent(this.wsessCurrent, bl));
        }
        this.processInvokeAfterLastCall();
        if (this.chMaster != null) {
            this.chMaster.fireAfterLastCall(bl);
        }
        if (this.eventBeforeFirstCall != null) {
            ((RecordingCallEventHandler)this.eventBeforeFirstCall).reset();
        }
    }

    void fireBeforeCall(Call call) {
        this.callCurrent = call;
        if (this.eventBeforeCall != null) {
            if (this.chMaster != null) {
                this.chMaster.fireBeforeCall(call);
            }
            this.eventBeforeCall.dispatchEvent(new CallEvent(this.wsessCurrent, call.getObjectName(), call.getMethodName(), call.getParameters(), call.isCallBack()));
            ((RecordingCallEventHandler)this.eventBeforeCall).bRecord = true;
        } else {
            if (this.chMaster != null) {
                this.chMaster.callCurrent = call;
            }
            ((RecordingCallEventHandler)this.eventBeforeCall()).bRecord = true;
        }
    }

    void fireAfterCall(Call call, Object object, Throwable throwable) {
        if (this.eventAfterCall != null) {
            this.eventAfterCall.dispatchEvent(new CallResultEvent(this.wsessCurrent, call.getObjectName(), call.getMethodName(), call.getParameters(), call.isCallBack(), object, throwable));
        }
        this.processInvokeAfterCall();
        if (this.chMaster != null) {
            this.chMaster.fireAfterCall(call, object, throwable);
        }
        if (this.eventBeforeCall != null) {
            ((RecordingCallEventHandler)this.eventBeforeCall).reset();
        }
        this.callCurrent = null;
    }

    private void processInvokeAfterCall() {
        this.clear("invokeAfterCall", this.auInvokeAfterCall);
        this.auInvokeAfterCall = null;
    }

    private void processInvokeAfterLastCall() {
        this.clear("invokeAfterLastCall", this.auInvokeAfterLastCall);
        this.clear("invokeFinally", this.auInvokeFinally);
        this.auInvokeAfterLastCall = null;
        this.auInvokeFinally = null;
    }

    private void clear(String string, ArrayUtil<Runnable> arrayUtil) {
        if (arrayUtil != null) {
            while (!arrayUtil.isEmpty()) {
                Runnable runnable = arrayUtil.remove(0);
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    LoggerFactory.getInstance(SessionCallHandler.class).error("Error in ", string, " call", throwable);
                }
            }
        }
    }

    void postObjectCreation() {
        this.redispatchBeforeFirstCall();
        this.redispatchBeforeCall();
    }

    private void redispatchBeforeFirstCall() {
        if (this.chMaster != null && this.chMaster.eventBeforeFirstCall != null) {
            this.chMaster.eventBeforeFirstCall.dispatchEvent(new SessionEvent(this.chMaster.wsessCurrent));
            this.chMaster.redispatchBeforeFirstCall();
        }
        if (this.eventBeforeFirstCall != null) {
            this.eventBeforeFirstCall.redispatchEvent(new SessionEvent(this.wsessCurrent));
        }
    }

    private void redispatchBeforeCall() {
        if (this.chMaster != null && this.chMaster.eventBeforeCall != null) {
            this.chMaster.eventBeforeCall.dispatchEvent(new CallEvent(this.chMaster.wsessCurrent, this.callCurrent.getObjectName(), this.callCurrent.getMethodName(), this.callCurrent.getParameters(), this.callCurrent.isCallBack()));
            this.chMaster.redispatchBeforeCall();
        }
        if (this.eventBeforeCall != null) {
            this.eventBeforeCall.redispatchEvent(new CallEvent(this.wsessCurrent, this.callCurrent.getObjectName(), this.callCurrent.getMethodName(), this.callCurrent.getParameters(), this.callCurrent.isCallBack()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RecordingCallEventHandler<L>
    extends CallEventHandler<L> {
        private List<EventHandler.ListenerHandler> liHandler;
        private boolean bRecord;

        private RecordingCallEventHandler(Class<L> clazz) {
            super(clazz);
        }

        @Override
        protected void addHandler(int n, EventHandler.ListenerHandler listenerHandler) {
            super.addHandler(n, listenerHandler);
            if (this.liHandler == null) {
                this.liHandler = new ArrayUtil<EventHandler.ListenerHandler>();
            }
            if (this.bRecord) {
                if (n < 0) {
                    this.liHandler.add(listenerHandler);
                } else {
                    this.liHandler.add(n, listenerHandler);
                }
            } else {
                this.liHandler.add(null);
            }
        }

        @Override
        protected EventHandler.ListenerHandler removeHandler(int n) {
            if (this.liHandler != null) {
                this.liHandler.remove(n);
                if (this.liHandler.isEmpty()) {
                    this.liHandler = null;
                }
            }
            return super.removeHandler(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object redispatchEvent(Object ... objectArray) {
            this.bRecord = false;
            if (this.liHandler != null) {
                try {
                    try {
                        int n = this.liHandler.size();
                        for (int i = 0; i < n; ++i) {
                            EventHandler.ListenerHandler listenerHandler = this.liHandler.get(i);
                            if (listenerHandler == null) continue;
                            this.liHandler.get(i).dispatchEvent(objectArray);
                        }
                        Object var6_6 = null;
                        this.clearHandler();
                    }
                    catch (Throwable throwable) {
                        ExceptionHandler.raise(throwable);
                        Object var6_7 = null;
                        this.clearHandler();
                    }
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    this.clearHandler();
                    throw throwable;
                }
            }
            return null;
        }

        private void clearHandler() {
            if (this.liHandler != null) {
                int n = this.liHandler.size();
                for (int i = 0; i < n; ++i) {
                    this.liHandler.set(i, null);
                }
            }
        }

        private void reset() {
            this.bRecord = false;
            this.clearHandler();
        }
    }
}

