/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.remote.ISerializer;
import com.sibvisions.rad.remote.UniversalSerializer;
import com.sibvisions.rad.server.AbstractSession;
import com.sibvisions.rad.server.Call;
import com.sibvisions.rad.server.DefaultObjectProvider;
import com.sibvisions.rad.server.DefaultSessionManager;
import com.sibvisions.rad.server.IDirectServer;
import com.sibvisions.rad.server.IRequest;
import com.sibvisions.rad.server.IResponse;
import com.sibvisions.rad.server.Monitoring;
import com.sibvisions.rad.server.ServerContextImpl;
import com.sibvisions.rad.server.SessionCallHandler;
import com.sibvisions.rad.server.config.Configuration;
import com.sibvisions.rad.server.config.ServerZone;
import com.sibvisions.rad.server.plugin.IServerPlugin;
import com.sibvisions.rad.server.protocol.ProtocolFactory;
import com.sibvisions.rad.server.protocol.Record;
import com.sibvisions.rad.server.security.AbstractSecurityManager;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.ChangedHashtable;
import com.sibvisions.util.Reflective;
import com.sibvisions.util.io.MagicByteInputStream;
import com.sibvisions.util.io.NonClosingInputStream;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.StringUtil;
import com.sibvisions.util.xml.XmlNode;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.naming.InitialContext;
import javax.rad.remote.IConnectionConstants;
import javax.rad.remote.SessionCancelException;
import javax.rad.remote.SessionExpiredException;
import javax.rad.remote.event.ICallBackListener;
import javax.rad.server.AbstractObjectProvider;
import javax.rad.server.ISession;
import javax.rad.server.ResultObject;
import javax.rad.server.ServerContext;
import javax.rad.server.event.ISessionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
implements IDirectServer {
    private static final Exception EXCEPTION_CONTENT = new Exception("Invalid content!");
    private static final byte[] MAGIC_BYTES = new byte[]{-128, 23, -1, -1, -1, -1};
    private static AtomicInteger aiSequence = new AtomicInteger(0);
    private ILogger log;
    private static Server instance = null;
    private DefaultSessionManager sessman = null;
    private AbstractObjectProvider objectprov = null;
    private Monitoring monitoring = null;
    private WeakHashMap<ISession, CachedResponse> whmResponse = new WeakHashMap();
    private HashMap<Object, SerializerInfo> hmpSerializer = new HashMap();
    private String sInitialSystemIdentifier;
    private String sInstanceKey;
    private long lStartupTime = System.currentTimeMillis();

    public Server() {
        Object object;
        this.sInstanceKey = Long.toString(this.lStartupTime, 36) + "#" + aiSequence.incrementAndGet();
        Server.initLogging();
        ServerZone serverZone = Configuration.getServerZone();
        this.log = LoggerFactory.getInstance(Server.class);
        try {
            object = serverZone.getProperty("/server/sessionmanager/class");
            this.sessman = (DefaultSessionManager)Reflective.construct((String)object, this);
            this.log.debug("Use ", object, " as SessionManager");
        }
        catch (Throwable throwable) {
            this.log.debug("NO PROBLEM! Use default SessionManager", throwable);
            this.sessman = new DefaultSessionManager(this);
        }
        this.hmpSerializer.put(null, new SerializerInfo(UniversalSerializer.class));
        this.sessman.addSessionListener(new SessionListener(this));
        try {
            object = serverZone.getProperty("/server/sessionmanager/controllerInterval");
            if (!StringUtil.isEmpty((String)object)) {
                DefaultSessionManager.setControllerInterval(Long.parseLong((String)object));
            }
        }
        catch (Throwable throwable) {
            this.log.debug(throwable);
        }
        try {
            object = serverZone.getProperty("/server/objectprovider/class");
            this.objectprov = (AbstractObjectProvider)Reflective.construct((String)object, this);
            this.log.debug("Use ", object, " as ObjectProvider");
        }
        catch (Throwable throwable) {
            this.log.debug("NO PROBLEM! Use default ObjectProvider", throwable);
            this.objectprov = new DefaultObjectProvider(this);
        }
        this.monitoring = new Monitoring(this);
        try {
            object = serverZone.getNodes("/server/plugin");
            if (object != null) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    XmlNode xmlNode = (XmlNode)iterator.next();
                    if (!Boolean.parseBoolean(CommonUtil.nvl(xmlNode.getNodeValue("enabled"), "true"))) continue;
                    String string = xmlNode.getNodeValue("/class");
                    try {
                        IServerPlugin iServerPlugin = (IServerPlugin)Reflective.construct(string, new Object[0]);
                        iServerPlugin.install(this);
                    }
                    catch (Throwable throwable) {
                        this.log.error("Can't install plugin '", string, "'", throwable);
                    }
                }
            }
        }
        catch (Exception exception) {
            this.log.debug("Can't access plugin configuration!", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Server getInstance() {
        if (instance == null) {
            Server.initLogging();
            try {
                InitialContext initialContext = new InitialContext();
                try {
                    instance = (Server)initialContext.lookup("java:/comp/env/jvx/server");
                }
                finally {
                    initialContext.close();
                }
            }
            catch (Exception exception) {
                LoggerFactory.getInstance(Server.class).debug("Server is not configured as JNDI resource", exception);
            }
            if (instance == null) {
                instance = new Server();
            }
        }
        return instance;
    }

    @Override
    public final DefaultSessionManager getSessionManager() {
        return this.sessman;
    }

    @Override
    public final AbstractObjectProvider getObjectProvider() {
        return this.objectprov;
    }

    /*
     * Loose catch block
     */
    @Override
    public Object createSession(ChangedHashtable<String, Object> changedHashtable) throws Throwable {
        ServerContext serverContext = this.createServerContextIntern();
        try {
            Object object;
            long l;
            Object object2;
            Throwable throwable;
            Record record;
            block13: {
                record = ProtocolFactory.openRecord("SERVER", "createSession", new Object[0]);
                throwable = null;
                object2 = null;
                l = System.currentTimeMillis();
                object = object2 = this.createSessionIntern(null, null, changedHashtable);
                if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) break block13;
                this.log(null, "direct", "Session!", "createSession", new Object[]{changedHashtable}, null, object2, throwable, System.currentTimeMillis() - l);
            }
            CommonUtil.close(record);
            return object;
            {
                catch (Throwable throwable2) {
                    try {
                        try {
                            if (record != null) {
                                record.setException(throwable2);
                            }
                            throwable = AbstractSecurityManager.prepareException(throwable2);
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                                this.log(null, "direct", "Session!", "createSession", new Object[]{changedHashtable}, null, object2, throwable, System.currentTimeMillis() - l);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable4) {
                        CommonUtil.close(record);
                        throw throwable4;
                    }
                }
            }
        }
        finally {
            serverContext.release();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public Object createSubSession(Object object, ChangedHashtable<String, Object> changedHashtable) throws Throwable {
        ServerContext serverContext = this.createServerContextIntern();
        try {
            Object object2;
            long l;
            Object object3;
            Throwable throwable;
            Record record;
            block13: {
                record = ProtocolFactory.openRecord("SERVER", "createSubSession", new Object[0]);
                throwable = null;
                object3 = null;
                l = System.currentTimeMillis();
                object2 = object3 = this.createSubSessionIntern(null, this.sessman.get(object), changedHashtable);
                if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) break block13;
                this.log(object, "direct", "Session!", "createSubSession", new Object[]{changedHashtable}, null, object3, throwable, System.currentTimeMillis() - l);
            }
            CommonUtil.close(record);
            return object2;
            {
                catch (Throwable throwable2) {
                    try {
                        try {
                            if (record != null) {
                                record.setException(throwable2);
                            }
                            throwable = AbstractSecurityManager.prepareException(throwable2);
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                                this.log(object, "direct", "Session!", "createSubSession", new Object[]{changedHashtable}, null, object3, throwable, System.currentTimeMillis() - l);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable4) {
                        CommonUtil.close(record);
                        throw throwable4;
                    }
                }
            }
        }
        finally {
            serverContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroySession(Object object) {
        ServerContext serverContext = this.createServerContextIntern();
        try {
            Record record = ProtocolFactory.openRecord("SERVER", "destroySession", new Object[0]);
            try {
                long l = System.currentTimeMillis();
                try {
                    this.destroySessionIntern(object);
                }
                catch (RuntimeException runtimeException) {
                    if (record != null) {
                        record.setException(runtimeException);
                    }
                    throw runtimeException;
                }
                finally {
                    if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                        this.log(object, "direct", "Session!", "destroySession", null, null, null, null, System.currentTimeMillis() - l);
                    }
                }
            }
            catch (Throwable throwable) {
                CommonUtil.close(record);
                throw throwable;
            }
            CommonUtil.close(record);
        }
        finally {
            serverContext.release();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Object execute(Object var1_1, String var2_2, String var3_3, Object ... var4_4) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeCallBack(Object object, Object object2, String string, String string2, Object ... objectArray) throws Throwable {
        ServerContext serverContext = this.createServerContextIntern();
        try {
            Record record = ProtocolFactory.openRecord("SERVER", "executeCallBack", string, string2, objectArray);
            try {
                Throwable throwable = null;
                long l = System.currentTimeMillis();
                try {
                    AbstractSession abstractSession = this.sessman.get(object);
                    ((ServerContextImpl)serverContext).setSession(abstractSession);
                    this.validateCallBack(abstractSession, string);
                    Call call = new Call(object2, string, string2, objectArray);
                    call.setForceCallBack(true);
                    this.executeIntern(abstractSession, call);
                }
                catch (Throwable throwable2) {
                    if (record != null) {
                        record.setException(throwable2);
                    }
                    throwable = AbstractSecurityManager.prepareException(throwable2);
                    throw throwable2;
                }
                finally {
                    if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                        this.log(object, "direct", string, string2, objectArray, object2, null, throwable, System.currentTimeMillis() - l);
                    }
                }
            }
            catch (Throwable throwable) {
                CommonUtil.close(record);
                throw throwable;
            }
            CommonUtil.close(record);
        }
        finally {
            serverContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeCallBack(Object object, ICallBackListener iCallBackListener, String string, String string2, Object ... objectArray) throws Throwable {
        ServerContext serverContext = this.createServerContextIntern();
        try {
            Record record = ProtocolFactory.openRecord("SERVER", "executeCallBack", string, string2, objectArray);
            try {
                Throwable throwable = null;
                long l = System.currentTimeMillis();
                try {
                    AbstractSession abstractSession = this.sessman.get(object);
                    ((ServerContextImpl)serverContext).setSession(abstractSession);
                    this.validateCallBack(abstractSession, string);
                    Call call = new Call(iCallBackListener, string, string2, objectArray);
                    call.setForceCallBack(true);
                    this.executeIntern(abstractSession, call);
                }
                catch (Throwable throwable2) {
                    if (record != null) {
                        record.setException(throwable2);
                    }
                    throwable = AbstractSecurityManager.prepareException(throwable2);
                    throw throwable2;
                }
                finally {
                    if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                        this.log(object, "direct", string, string2, objectArray, iCallBackListener, null, throwable, System.currentTimeMillis() - l);
                    }
                }
            }
            catch (Throwable throwable) {
                CommonUtil.close(record);
                throw throwable;
            }
            CommonUtil.close(record);
        }
        finally {
            serverContext.release();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Object executeAction(Object var1_1, String var2_2, Object ... var3_3) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeActionCallBack(Object object, Object object2, String string, Object ... objectArray) throws Throwable {
        ServerContext serverContext = this.createServerContextIntern();
        try {
            Record record = ProtocolFactory.openRecord("SERVER", "executeActionCallBack", string, objectArray);
            try {
                Throwable throwable = null;
                long l = System.currentTimeMillis();
                try {
                    AbstractSession abstractSession = this.sessman.get(object);
                    ((ServerContextImpl)serverContext).setSession(abstractSession);
                    this.validateCallBack(abstractSession, null);
                    Call call = new Call(object2, null, string, objectArray);
                    call.setForceCallBack(true);
                    this.executeIntern(abstractSession, call);
                }
                catch (Throwable throwable2) {
                    if (record != null) {
                        record.setException(throwable2);
                    }
                    throwable = AbstractSecurityManager.prepareException(throwable2);
                    throw throwable2;
                }
                finally {
                    if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                        this.log(object, "direct", null, string, objectArray, object2, null, throwable, System.currentTimeMillis() - l);
                    }
                }
            }
            catch (Throwable throwable) {
                CommonUtil.close(record);
                throw throwable;
            }
            CommonUtil.close(record);
        }
        finally {
            serverContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeActionCallBack(Object object, ICallBackListener iCallBackListener, String string, Object ... objectArray) throws Throwable {
        ServerContext serverContext = this.createServerContextIntern();
        try {
            Record record = ProtocolFactory.openRecord("SERVER", "executeActionCallBack", string, objectArray);
            try {
                Throwable throwable = null;
                long l = System.currentTimeMillis();
                try {
                    AbstractSession abstractSession = this.sessman.get(object);
                    ((ServerContextImpl)serverContext).setSession(abstractSession);
                    this.validateCallBack(abstractSession, null);
                    Call call = new Call(iCallBackListener, null, string, objectArray);
                    call.setForceCallBack(true);
                    this.executeIntern(abstractSession, call);
                }
                catch (Throwable throwable2) {
                    if (record != null) {
                        record.setException(throwable2);
                    }
                    throwable = AbstractSecurityManager.prepareException(throwable2);
                    throw throwable2;
                }
                finally {
                    if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                        this.log(object, "direct", null, string, objectArray, iCallBackListener, null, throwable, System.currentTimeMillis() - l);
                    }
                }
            }
            catch (Throwable throwable) {
                CommonUtil.close(record);
                throw throwable;
            }
            CommonUtil.close(record);
        }
        finally {
            serverContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setProperty(Object object, String string, Object object2) throws Throwable {
        ServerContext serverContext = this.createServerContextIntern();
        try {
            Throwable throwable = null;
            long l = System.currentTimeMillis();
            try {
                AbstractSession abstractSession = this.sessman.get(object);
                ((ServerContextImpl)serverContext).setSession(abstractSession);
                this.setPropertyIntern(abstractSession, string, object2);
                if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) return;
            }
            catch (Throwable throwable2) {
                try {
                    throwable = AbstractSecurityManager.prepareException(throwable2);
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) throw throwable3;
                    this.log(object, "direct", "Session!", "setProperty", new Object[]{string, object2}, null, null, throwable, System.currentTimeMillis() - l);
                    throw throwable3;
                }
            }
            this.log(object, "direct", "Session!", "setProperty", new Object[]{string, object2}, null, null, throwable, System.currentTimeMillis() - l);
            return;
        }
        finally {
            serverContext.release();
        }
    }

    @Override
    public Object getProperty(Object object, String string) throws Throwable {
        Throwable throwable = null;
        Object object2 = null;
        long l = System.currentTimeMillis();
        try {
            object2 = this.getPropertyIntern(this.sessman.get(object), string);
        }
        catch (Throwable throwable2) {
            throwable = AbstractSecurityManager.prepareException(throwable2);
            throw throwable2;
        }
        finally {
            if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                this.log(object, "direct", "Session!", "getProperty", null, null, object2, throwable, System.currentTimeMillis() - l);
            }
        }
        return object2;
    }

    @Override
    public ChangedHashtable<String, Object> getProperties(Object object) throws Throwable {
        Throwable throwable = null;
        ChangedHashtable<String, Object> changedHashtable = null;
        long l = System.currentTimeMillis();
        try {
            changedHashtable = this.getPropertiesIntern(this.sessman.get(object));
        }
        catch (Throwable throwable2) {
            throwable = AbstractSecurityManager.prepareException(throwable2);
            throw throwable2;
        }
        finally {
            if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                this.log(object, "direct", "Session!", "getProperties", null, null, changedHashtable, throwable, System.currentTimeMillis() - l);
            }
        }
        return changedHashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ResultObject> getCallBackResults(Object object) throws Throwable {
        ServerContext serverContext = this.createServerContextIntern();
        try {
            Object object2;
            ArrayUtil<ResultObject> arrayUtil;
            block7: {
                Throwable throwable = null;
                arrayUtil = null;
                long l = System.currentTimeMillis();
                try {
                    object2 = this.sessman.get(object);
                    ((ServerContextImpl)serverContext).setSession((ISession)object2);
                    arrayUtil = this.getCallBackResultsIntern((AbstractSession)object2);
                    if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) break block7;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = AbstractSecurityManager.prepareException(throwable2);
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) throw throwable3;
                        this.log(object, "direct", "Session!", "getCallBackResults", new Object[]{object}, null, arrayUtil, throwable, System.currentTimeMillis() - l);
                        throw throwable3;
                    }
                }
                this.log(object, "direct", "Session!", "getCallBackResults", new Object[]{object}, null, arrayUtil, throwable, System.currentTimeMillis() - l);
            }
            object2 = arrayUtil;
            return object2;
        }
        finally {
            serverContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] setAndCheckAlive(Object object, Object ... objectArray) throws Throwable {
        ServerContext serverContext = this.createServerContextIntern();
        try {
            Object[] objectArray2;
            Throwable throwable = null;
            Object[] objectArray3 = null;
            long l = System.currentTimeMillis();
            try {
                objectArray2 = this.sessman.get(object);
                ((ServerContextImpl)serverContext).setSession((ISession)objectArray2);
                objectArray3 = this.setAndCheckAliveIntern((AbstractSession)objectArray2, objectArray);
            }
            catch (Throwable throwable2) {
                throwable = AbstractSecurityManager.prepareException(throwable2);
                throw throwable2;
            }
            finally {
                if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                    this.log(object, "direct", "Session!", "setAndCheckAlive", objectArray, null, objectArray3, throwable, System.currentTimeMillis() - l);
                }
            }
            objectArray2 = objectArray3;
            return objectArray2;
        }
        finally {
            serverContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setNewPassword(Object object, String string, String string2) throws Throwable {
        ServerContext serverContext = this.createServerContextIntern();
        try {
            Record record;
            block10: {
                record = ProtocolFactory.openRecord("SERVER", "setNewPassword", new Object[0]);
                try {
                    Throwable throwable = null;
                    long l = System.currentTimeMillis();
                    try {
                        AbstractSession abstractSession = this.sessman.get(object);
                        ((ServerContextImpl)serverContext).setSession(abstractSession);
                        this.setNewPasswordInternal(abstractSession, string, string2);
                        if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) break block10;
                    }
                    catch (Throwable throwable2) {
                        try {
                            if (record != null) {
                                record.setException(throwable2);
                            }
                            throwable = AbstractSecurityManager.prepareException(throwable2);
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) throw throwable3;
                            this.log(object, "direct", "Session!", "setNewPassword", new Object[]{"****"}, null, null, throwable, System.currentTimeMillis() - l);
                            throw throwable3;
                        }
                    }
                    this.log(object, "direct", "Session!", "setNewPassword", new Object[]{"****"}, null, null, throwable, System.currentTimeMillis() - l);
                }
                catch (Throwable throwable) {
                    CommonUtil.close(record);
                    throw throwable;
                }
            }
            CommonUtil.close(record);
            return;
        }
        finally {
            serverContext.release();
        }
    }

    @Override
    public void beforeFirstCall(Object object) {
        AbstractSession abstractSession;
        SessionCallHandler sessionCallHandler;
        if (object != null && (sessionCallHandler = (abstractSession = object instanceof AbstractSession ? (AbstractSession)object : this.sessman.get(object)).getCallHandler()) != null) {
            sessionCallHandler.fireBeforeFirstCall();
        }
    }

    @Override
    public void afterLastCall(Object object, boolean bl) {
        AbstractSession abstractSession;
        SessionCallHandler sessionCallHandler;
        if (object != null && (sessionCallHandler = (abstractSession = object instanceof AbstractSession ? (AbstractSession)object : this.sessman.get(object)).getCallHandler()) != null) {
            sessionCallHandler.fireAfterLastCall(bl);
        }
    }

    public String getInstanceKey() {
        return this.sInstanceKey;
    }

    public long getStartupTime() {
        return this.lStartupTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ISession process(IRequest var1_1, IResponse var2_2) throws Exception {
        var3_3 = this.createServerContextIntern();
        try {
            var4_4 = ProtocolFactory.openRecord("SERVER", "process", new Object[0]);
            try {
                block167: {
                    block168: {
                        var5_5 = null;
                        var8_6 = null;
                        var9_7 = null;
                        var10_8 = null;
                        var12_9 = null;
                        var13_10 = null;
                        var14_11 = null;
                        var6_12 = var1_1.getInputStream();
                        if (!(var6_12 instanceof BufferedInputStream)) {
                            var6_12 = new BufferedInputStream(var6_12);
                        }
                        try {
                            var15_13 = var6_12.read();
                        }
                        catch (SocketException var16_16) {
                            var2_2.close();
                            throw var16_16;
                        }
                        if (var15_13 < 0) {
                            var2_2.close();
                            throw new SocketException("Client stream is closed!");
                        }
                        var16_17 = (char)var15_13;
                        if (var16_17 != 'A' && var16_17 != 'E') {
                            throw new IOException("Invalid stream identifier '" + var16_17 + "'");
                        }
                        var17_18 = var6_12.read();
                        if (var17_18 == 2) {
                            var14_11 = new MagicByteInputStream(new NonClosingInputStream(var6_12), Server.MAGIC_BYTES);
                            var18_19 = new GZIPInputStream(var14_11);
                        } else {
                            var18_19 = var6_12;
                        }
                        var19_20 = new DataInputStream(var18_19);
                        var20_21 = null;
                        if (var16_17 == 'A') {
                            var20_21 = var19_20.readUTF();
                            var8_6 = (ISerializer)Class.forName(var20_21).newInstance();
                        }
                        if ((var21_22 = var19_20.readUTF()).trim().length() == 0) {
                            var21_22 = null;
                        }
                        if (var21_22 != null) {
                            try {
                                var5_5 = this.sessman.get(var21_22);
                            }
                            catch (SessionExpiredException var22_23) {
                                var23_25 = new SessionCancelException(var22_23.getMessage(), var22_23.getCause());
                                var23_25.setStackTrace(var22_23.getStackTrace());
                                this.clearBuffer(var19_20, var21_22);
                                throw var23_25;
                            }
                            ((ServerContextImpl)var3_3).setSession(var5_5);
                            var8_6 = var5_5.getSerializer();
                        }
                        if (var8_6 == null) {
                            this.clearBuffer(var19_20, var21_22);
                            throw new SecurityException("Invalid serializer '" + var20_21 + "'");
                        }
                        var22_24 = var8_6.read(var19_20);
                        if (!(var22_24 instanceof String)) ** GOTO lbl95
                        var10_8 = Long.valueOf((String)var22_24);
                        if (var4_4 != null) {
                            var4_4.setParameter(new Object[]{var10_8});
                        }
                        if (var5_5 == null) ** GOTO lbl93
                        var23_26 = this.sessman.getMasterSession(var5_5);
                        var13_10 = this.whmResponse.get(var23_26);
                        if (var13_10 == null) ** GOTO lbl89
                        if (!var13_10.id.equals(var10_8)) ** GOTO lbl85
                        if (var13_10.content == null) {
                            var24_27 = var13_10;
                            synchronized (var24_27) {
                                var13_10.wait(10000L);
                            }
                        }
                        if (var13_10.content == null) break block167;
                        this.sendContent(var2_2, var13_10.content);
                        var24_27 = var5_5;
                        var38_30 = null;
                        if (var14_11 == null) break block168;
                        var14_11.close();
                    }
                    var1_1.close();
                    ** GOTO lbl106
                }
                try {
                    block171: {
                        block176: {
                            block175: {
                                var2_2.close();
                                throw Server.EXCEPTION_CONTENT;
lbl85:
                                // 1 sources

                                if (var13_10.id + 1L == var10_8) break block175;
                                var11_107 = (Integer)var8_6.read(var19_20);
                                var25_129 = 0;
                                ** GOTO lbl220
                            }
                            var13_10 = new CachedResponse(var10_8);
                            this.whmResponse.put((ISession)var23_26, (CachedResponse)var13_10);
lbl93:
                            // 2 sources

                            var22_24 = var8_6.read(var19_20);
                            break block176;
lbl95:
                            // 1 sources

                            if (var22_24 == null) {
                                var22_24 = var8_6.read(var19_20);
                            }
                        }
                        var11_108 = (Integer)var22_24;
                        var9_7 = new ArrayUtil<E>(var11_108);
                        var28_131 = false;
                        var29_132 = false;
                        try {
                            block177: {
                                break block177;
                                catch (Throwable var39_34) {
                                    this.log.error(new Object[]{var39_34});
                                }
lbl106:
                                // 2 sources

                                if (!var2_2.isClosed()) {
                                    var7_38 = new ByteArrayOutputStream();
                                    if (var8_6 == null) {
                                        var7_38.write(66);
                                        var7_38.write(1);
                                        var39_34 = new DataOutputStream(var7_38);
                                        var42_50 = var9_7.size();
                                        var43_58 = 0;
                                        for (var41_42 = 0; var41_42 < var42_50 && var43_58 == 0; ++var41_42) {
                                            if (((ResultObject)var9_7.get(var41_42)).getType() != 4) continue;
                                            var40_70 = (Throwable)((ResultObject)var9_7.get(var41_42)).getObject();
                                            if (var40_70 != null) {
                                                var44_78 = var40_70.getStackTrace();
                                                var39_34.writeUTF(var40_70.getClass().getName());
                                                var39_34.writeUTF(CommonUtil.nvl(var40_70.getMessage(), ""));
                                                if (var44_78 != null) {
                                                    var39_34.write(var44_78.length);
                                                    var46_90 = var44_78.length;
                                                    for (var45_86 = 0; var45_86 < var46_90; ++var45_86) {
                                                        var39_34.writeUTF(CommonUtil.nvl(var44_78[var45_86].getClassName(), ""));
                                                        var39_34.writeUTF(CommonUtil.nvl(var44_78[var45_86].getMethodName(), ""));
                                                        var39_34.writeUTF(CommonUtil.nvl(var44_78[var45_86].getFileName(), ""));
                                                        var39_34.writeInt(var44_78[var45_86].getLineNumber());
                                                    }
                                                } else {
                                                    var39_34.write(0);
                                                }
                                            } else {
                                                var39_34.writeUTF("");
                                            }
                                            ++var43_58;
                                        }
                                        var48_94 = null;
                                        var39_34.flush();
                                    }
                                    var39_34 = null;
                                    var40_71 = var5_5 != null ? var5_5.getProperties().getChanges(IConnectionConstants.PROPERTY_CLASSES) : (var12_9 != null ? var12_9.getChanges(IConnectionConstants.PROPERTY_CLASSES) : null);
                                    if (var40_71 != null && var40_71.size() > 0) {
                                        var41_43 = new ArrayUtil<E>(var40_71.size());
                                        for (Object var43_59 : var40_71) {
                                            var41_43.add(new Object[]{var43_59.getKey(), var43_59.getValue()});
                                            var2_2.setProperty((String)var43_59.getKey(), var43_59.getValue());
                                        }
                                        if (var39_34 == null) {
                                            var39_34 = new ArrayUtil<E>();
                                        }
                                        var39_34.add(new ResultObject(5, var41_43));
                                    }
                                    if (var5_5 != null) {
                                        if (var39_34 == null) {
                                            var39_34 = new ArrayUtil<ResultObject>();
                                        }
                                        if ((var41_43 = this.getCallBackResultsIntern(var5_5)) != null) {
                                            var39_34.addAll(var41_43);
                                        }
                                    }
                                    if (var9_7 != null) {
                                        if (var39_34 == null) {
                                            var39_34 = new ArrayUtil<E>();
                                        }
                                        var39_34.addAll(var9_7);
                                    }
                                    var11_106 = var39_34 != null ? var39_34.size() : 0;
                                    var41_43 = new ByteArrayOutputStream();
                                    var42_51 = new DataOutputStream((OutputStream)var41_43);
                                    var8_6.write(var42_51, var11_106);
                                    if (var39_34 != null) {
                                        var43_59 = var39_34.iterator();
                                        while (var43_59.hasNext()) {
                                            var44_79 = (ResultObject)var43_59.next();
                                            var8_6.write(var42_51, var44_79.getType());
                                            var8_6.write(var42_51, var44_79.getObject());
                                            if (var44_79.getType() != 2 && var44_79.getType() != 1) continue;
                                            var8_6.write(var42_51, var44_79.getCallBackId());
                                        }
                                    }
                                    var50_111 = null;
                                    var42_51.close();
                                    var7_38.write(69);
                                    v0 = var43_60 = var5_5 != null && Boolean.parseBoolean((String)var5_5.getProperties().get("client.session.compression")) != false;
                                    if (var43_60 && var41_43.size() > 256) {
                                        var7_38.write(2);
                                        var44_79 = new GZIPOutputStream(var7_38);
                                        var41_43.writeTo((OutputStream)var44_79);
                                        var44_79.close();
                                        var7_38.write(Server.MAGIC_BYTES);
                                    } else {
                                        var7_38.write(1);
                                        var41_43.writeTo(var7_38);
                                    }
                                    if (var13_10 != null) {
                                        var13_10.content = var7_38;
                                        var39_34 = var13_10;
                                        synchronized (var39_34) {
                                            var13_10.notifyAll();
                                        }
                                    } else if (var5_5 != null) {
                                        this.whmResponse.put(this.sessman.getMasterSession(var5_5), new CachedResponse(var10_8, var7_38));
                                    }
                                    this.sendContent(var2_2, var7_38);
                                }
                                var53_123 = null;
                                CommonUtil.close(new Object[]{var4_4});
                                var55_126 = null;
                                var3_3.release();
                                return var24_27;
                                catch (Throwable var47_102) {
                                    var48_95 = null;
                                    var39_34.flush();
                                    throw var47_102;
                                }
                                catch (Throwable var49_119) {
                                    var50_112 = null;
                                    var42_51.close();
                                    throw var49_119;
                                }
lbl220:
                                // 2 sources

                                while (var25_129 < var11_107) {
                                    var24_28 = (Object[])var8_6.read(var19_20);
                                    this.error(var5_5 != null ? var5_5.getId() : null, var10_8, (String)var24_28[0], (String)var24_28[1], (Object[])var24_28[2], var24_28[3], null, null, -1L);
                                    ++var25_129;
                                }
                                throw new IOException("Invalid communication state! " + (var13_10.id + 1L) + " <> " + var10_8);
                            }
                            for (var30_133 = 0; var30_133 < var11_108; ++var30_133) {
                                var26_134 = System.currentTimeMillis();
                                var25_130 = (Object[])var8_6.read(var19_20);
                                if (!var28_131 && var5_5 != null) {
                                    try {
                                        this.beforeFirstCall(var5_5);
                                        var32_139 = null;
                                        var28_131 = true;
                                    }
                                    catch (Throwable var31_136) {
                                        var32_139 = null;
                                        var28_131 = true;
                                        throw var31_136;
                                    }
                                }
                                try {
                                    if (!(var25_130.length != 4 || var25_130[0] != null && var25_130[0].getClass() != String.class || var25_130[1].getClass() != String.class || var25_130[2] != null && !(var25_130[2] instanceof Object[]))) {
                                        var23_26 = null;
                                        var24_29 = null;
                                        try {
                                            try {
                                                var24_29 = this.process(var1_1, var8_6, var5_5, (String)var25_130[0], (String)var25_130[1], (Object[])var25_130[2], var25_130[3], (ChangedHashtable<String, Object>)var12_9);
                                            }
                                            catch (Throwable var31_137) {
                                                var23_26 = var31_137;
                                                throw var31_137;
                                            }
                                            var34_144 = null;
                                            if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                                                this.log(var5_5 != null ? var5_5.getId() : null, var10_8, (String)var25_130[0], (String)var25_130[1], (Object[])var25_130[2], var25_130[3], var24_29, (Throwable)var23_26, System.currentTimeMillis() - var26_134);
                                            }
                                        }
                                        catch (Throwable var33_143) {
                                            var34_144 = null;
                                            if (this.log.isEnabled(ILogger.LogLevel.DEBUG) == false) throw var33_143;
                                            this.log(var5_5 != null ? var5_5.getId() : null, var10_8, (String)var25_130[0], (String)var25_130[1], (Object[])var25_130[2], var25_130[3], var24_29, (Throwable)var23_26, System.currentTimeMillis() - var26_134);
                                            throw var33_143;
                                        }
                                        if ("Session!".equals((String)var25_130[0]) && "setProperty".equals((String)var25_130[1])) {
                                            var31_135 = (List)var24_29;
                                            if (var31_135 == null) continue;
                                            var12_9 = new ChangedHashtable<String, ?>();
                                            var34_145 = var31_135.size();
                                            for (var33_142 = 0; var33_142 < var34_145; ++var33_142) {
                                                var32_139 = (Object[])var31_135.get(var33_142);
                                                var12_9.put((String)var32_139[0], var32_139[1], false);
                                            }
                                            continue;
                                        }
                                        if (var5_5 == null) {
                                            var5_5 = this.sessman.get(var24_29);
                                        }
                                        var9_7.add(new ResultObject(3, var24_29));
                                        continue;
                                    }
                                    this.log.debug(new Object[]{"Invalid request parameters!", var25_130});
                                    throw new SecurityException("Invalid request parameters!");
                                }
                                catch (Throwable var31_138) {
                                    try {
                                        for (var32_140 = var30_133 + 1; var32_140 < var11_108; ++var32_140) {
                                            var8_6.read(var19_20);
                                        }
                                    }
                                    catch (Throwable var32_141) {
                                        // empty catch block
                                    }
                                    var29_132 = true;
                                    throw var31_138;
                                }
                            }
                            var36_146 = null;
                            if (var28_131) {
                                this.afterLastCall(var5_5, var29_132);
                            }
                        }
                        catch (Throwable var35_148) {
                            var36_147 = null;
                            if (var28_131 == false) throw var35_148;
                            this.afterLastCall(var5_5, var29_132);
                            throw var35_148;
                        }
                        var38_31 = null;
                        if (var14_11 == null) break block171;
                        var14_11.close();
                    }
                    ** try [egrp 15[TRYBLOCK] [19 : 1507->1516)] { 
lbl308:
                    // 1 sources

                    var1_1.close();
                    ** GOTO lbl331
                    catch (Throwable var15_14) {
                        block179: {
                            block178: {
                                if (var15_14 == Server.EXCEPTION_CONTENT) {
                                    throw Server.EXCEPTION_CONTENT;
                                }
                                if (var2_2.isClosed()) {
                                    if (var15_14 instanceof Exception == false) throw new IOException("Unexpected server exception!", var15_14);
                                    throw (Exception)var15_14;
                                }
                                if (var4_4 != null) {
                                    var4_4.setException(var15_14);
                                }
                                this.log.error(new Object[]{var15_14});
                                if (var9_7 == null) {
                                    var9_7 = new ArrayUtil<ResultObject>(1);
                                }
                                var9_7.add(new ResultObject(4, AbstractSecurityManager.prepareException(var15_14)));
                                var38_32 = null;
                                if (var14_11 != null) {
                                    var14_11.close();
                                }
                                ** try [egrp 15[TRYBLOCK] [19 : 1507->1516)] { 
lbl327:
                                // 1 sources

                                var1_1.close();
                                break block178;
lbl329:
                                // 1 sources

                                catch (Throwable var39_35) {
                                    this.log.error(new Object[]{var39_35});
                                }
lbl331:
                                // 2 sources

                                if (var2_2.isClosed()) break block179;
                                var7_39 = new ByteArrayOutputStream();
                                if (var8_6 == null) {
                                    var7_39.write(66);
                                    var7_39.write(1);
                                    var39_35 = new DataOutputStream(var7_39);
                                    ** try [egrp 16[TRYBLOCK] [20 : 1583->1830)] { 
lbl338:
                                    // 1 sources

                                    var42_52 = var9_7.size();
                                    var43_61 = 0;
                                    for (var41_44 = 0; var41_44 < var42_52 && var43_61 == 0; ++var41_44) {
                                        if (((ResultObject)var9_7.get(var41_44)).getType() != 4) continue;
                                        var40_72 = (Throwable)((ResultObject)var9_7.get(var41_44)).getObject();
                                        if (var40_72 != null) {
                                            var44_80 = var40_72.getStackTrace();
                                            var39_35.writeUTF(var40_72.getClass().getName());
                                            var39_35.writeUTF(CommonUtil.nvl(var40_72.getMessage(), ""));
                                            if (var44_80 != null) {
                                                var39_35.write(var44_80.length);
                                                var46_91 = var44_80.length;
                                                for (var45_87 = 0; var45_87 < var46_91; ++var45_87) {
                                                    var39_35.writeUTF(CommonUtil.nvl(var44_80[var45_87].getClassName(), ""));
                                                    var39_35.writeUTF(CommonUtil.nvl(var44_80[var45_87].getMethodName(), ""));
                                                    var39_35.writeUTF(CommonUtil.nvl(var44_80[var45_87].getFileName(), ""));
                                                    var39_35.writeInt(var44_80[var45_87].getLineNumber());
                                                }
                                            } else {
                                                var39_35.write(0);
                                            }
                                        } else {
                                            var39_35.writeUTF("");
                                        }
                                        ++var43_61;
                                    }
                                    var48_96 = null;
                                    var39_35.flush();
                                } else {
                                    var39_35 = null;
                                    var40_73 = var5_5 != null ? var5_5.getProperties().getChanges(IConnectionConstants.PROPERTY_CLASSES) : (var12_9 != null ? var12_9.getChanges(IConnectionConstants.PROPERTY_CLASSES) : null);
                                    if (var40_73 != null && var40_73.size() > 0) {
                                        var41_45 = new ArrayUtil<E>(var40_73.size());
                                        for (Object var43_62 : var40_73) {
                                            var41_45.add(new Object[]{var43_62.getKey(), var43_62.getValue()});
                                            var2_2.setProperty((String)var43_62.getKey(), var43_62.getValue());
                                        }
                                        if (var39_35 == null) {
                                            var39_35 = new ArrayUtil<E>();
                                        }
                                        var39_35.add(new ResultObject(5, var41_45));
                                    }
                                    if (var5_5 != null) {
                                        if (var39_35 == null) {
                                            var39_35 = new ArrayUtil<ResultObject>();
                                        }
                                        if ((var41_45 = this.getCallBackResultsIntern(var5_5)) != null) {
                                            var39_35.addAll(var41_45);
                                        }
                                    }
                                    if (var9_7 != null) {
                                        if (var39_35 == null) {
                                            var39_35 = new ArrayUtil<E>();
                                        }
                                        var39_35.addAll(var9_7);
                                    }
                                    var11_108 = var39_35 != null ? var39_35.size() : 0;
                                    var41_45 = new ByteArrayOutputStream();
                                    var42_53 = new DataOutputStream((OutputStream)var41_45);
                                    ** try [egrp 17[TRYBLOCK] [22 : 2148->2268)] { 
lbl394:
                                    // 1 sources

                                    var8_6.write(var42_53, var11_108);
                                    if (var39_35 != null) {
                                        var43_62 = var39_35.iterator();
                                        while (var43_62.hasNext()) {
                                            var44_81 = (ResultObject)var43_62.next();
                                            var8_6.write(var42_53, var44_81.getType());
                                            var8_6.write(var42_53, var44_81.getObject());
                                            if (var44_81.getType() != 2 && var44_81.getType() != 1) continue;
                                            var8_6.write(var42_53, var44_81.getCallBackId());
                                        }
                                    }
                                    var50_113 = null;
                                    var42_53.close();
                                    var7_39.write(69);
                                    v1 = var43_63 = var5_5 != null && Boolean.parseBoolean((String)var5_5.getProperties().get("client.session.compression")) != false;
                                    if (var43_63 && var41_45.size() > 256) {
                                        var7_39.write(2);
                                        var44_81 = new GZIPOutputStream(var7_39);
                                        var41_45.writeTo((OutputStream)var44_81);
                                        var44_81.close();
                                        var7_39.write(Server.MAGIC_BYTES);
                                    } else {
                                        var7_39.write(1);
                                        var41_45.writeTo(var7_39);
                                    }
                                }
                                if (var13_10 != null) {
                                    var13_10.content = var7_39;
                                    var39_35 = var13_10;
                                    synchronized (var39_35) {
                                        var13_10.notifyAll();
                                    }
                                } else if (var5_5 != null) {
                                    this.whmResponse.put(this.sessman.getMasterSession(var5_5), new CachedResponse(var10_8, var7_39));
                                }
                                this.sendContent(var2_2, var7_39);
                                break block179;
lbl428:
                                // 1 sources

                                catch (Throwable var47_103) {
                                    var48_97 = null;
                                    var39_35.flush();
                                    throw var47_103;
                                }
lbl433:
                                // 1 sources

                                catch (Throwable var49_120) {
                                    var50_114 = null;
                                    var42_53.close();
                                    throw var49_120;
                                }
lbl439:
                                // 1 sources

                                catch (Throwable var39_36) {
                                    this.log.error(new Object[]{var39_36});
                                }
                            }
                            if (!var2_2.isClosed()) {
                                var7_40 = new ByteArrayOutputStream();
                                if (var8_6 == null) {
                                    var7_40.write(66);
                                    var7_40.write(1);
                                    var39_36 = new DataOutputStream(var7_40);
                                    ** try [egrp 16[TRYBLOCK] [20 : 1583->1830)] { 
lbl449:
                                    // 1 sources

                                    var42_54 = var9_7.size();
                                    var43_64 = 0;
                                    for (var41_46 = 0; var41_46 < var42_54 && var43_64 == 0; ++var41_46) {
                                        if (((ResultObject)var9_7.get(var41_46)).getType() != 4) continue;
                                        var40_74 = (Throwable)((ResultObject)var9_7.get(var41_46)).getObject();
                                        if (var40_74 != null) {
                                            var44_82 = var40_74.getStackTrace();
                                            var39_36.writeUTF(var40_74.getClass().getName());
                                            var39_36.writeUTF(CommonUtil.nvl(var40_74.getMessage(), ""));
                                            if (var44_82 != null) {
                                                var39_36.write(var44_82.length);
                                                var46_92 = var44_82.length;
                                                for (var45_88 = 0; var45_88 < var46_92; ++var45_88) {
                                                    var39_36.writeUTF(CommonUtil.nvl(var44_82[var45_88].getClassName(), ""));
                                                    var39_36.writeUTF(CommonUtil.nvl(var44_82[var45_88].getMethodName(), ""));
                                                    var39_36.writeUTF(CommonUtil.nvl(var44_82[var45_88].getFileName(), ""));
                                                    var39_36.writeInt(var44_82[var45_88].getLineNumber());
                                                }
                                            } else {
                                                var39_36.write(0);
                                            }
                                        } else {
                                            var39_36.writeUTF("");
                                        }
                                        ++var43_64;
                                    }
                                    var48_98 = null;
                                    var39_36.flush();
                                } else {
                                    var39_36 = null;
                                    var40_75 = var5_5 != null ? var5_5.getProperties().getChanges(IConnectionConstants.PROPERTY_CLASSES) : (var12_9 != null ? var12_9.getChanges(IConnectionConstants.PROPERTY_CLASSES) : null);
                                    if (var40_75 != null && var40_75.size() > 0) {
                                        var41_47 = new ArrayUtil<E>(var40_75.size());
                                        for (Object var43_65 : var40_75) {
                                            var41_47.add(new Object[]{var43_65.getKey(), var43_65.getValue()});
                                            var2_2.setProperty((String)var43_65.getKey(), var43_65.getValue());
                                        }
                                        if (var39_36 == null) {
                                            var39_36 = new ArrayUtil<E>();
                                        }
                                        var39_36.add(new ResultObject(5, var41_47));
                                    }
                                    if (var5_5 != null) {
                                        if (var39_36 == null) {
                                            var39_36 = new ArrayUtil<ResultObject>();
                                        }
                                        if ((var41_47 = this.getCallBackResultsIntern(var5_5)) != null) {
                                            var39_36.addAll(var41_47);
                                        }
                                    }
                                    if (var9_7 != null) {
                                        if (var39_36 == null) {
                                            var39_36 = new ArrayUtil<E>();
                                        }
                                        var39_36.addAll(var9_7);
                                    }
                                    var11_109 = var39_36 != null ? var39_36.size() : 0;
                                    var41_47 = new ByteArrayOutputStream();
                                    var42_55 = new DataOutputStream((OutputStream)var41_47);
                                    ** try [egrp 17[TRYBLOCK] [22 : 2148->2268)] { 
lbl505:
                                    // 1 sources

                                    var8_6.write(var42_55, var11_109);
                                    if (var39_36 != null) {
                                        var43_65 = var39_36.iterator();
                                        while (var43_65.hasNext()) {
                                            var44_83 = (ResultObject)var43_65.next();
                                            var8_6.write(var42_55, var44_83.getType());
                                            var8_6.write(var42_55, var44_83.getObject());
                                            if (var44_83.getType() != 2 && var44_83.getType() != 1) continue;
                                            var8_6.write(var42_55, var44_83.getCallBackId());
                                        }
                                    }
                                    var50_115 = null;
                                    var42_55.close();
                                    var7_40.write(69);
                                    v2 = var43_66 = var5_5 != null && Boolean.parseBoolean((String)var5_5.getProperties().get("client.session.compression")) != false;
                                    if (var43_66 && var41_47.size() > 256) {
                                        var7_40.write(2);
                                        var44_83 = new GZIPOutputStream(var7_40);
                                        var41_47.writeTo((OutputStream)var44_83);
                                        var44_83.close();
                                        var7_40.write(Server.MAGIC_BYTES);
                                    } else {
                                        var7_40.write(1);
                                        var41_47.writeTo(var7_40);
                                    }
                                }
                                if (var13_10 != null) {
                                    var13_10.content = var7_40;
                                    var39_36 = var13_10;
                                    synchronized (var39_36) {
                                        var13_10.notifyAll();
                                    }
                                } else if (var5_5 != null) {
                                    this.whmResponse.put(this.sessman.getMasterSession(var5_5), new CachedResponse(var10_8, var7_40));
                                }
                                this.sendContent(var2_2, var7_40);
                            }
                        }
                        var15_15 = var5_5;
                        var53_124 = null;
                        CommonUtil.close(new Object[]{var4_4});
                        var55_127 = null;
                        var3_3.release();
                        return var15_15;
lbl548:
                        // 1 sources

                        catch (Throwable var47_104) {
                            var48_99 = null;
                            var39_36.flush();
                            throw var47_104;
                        }
lbl553:
                        // 1 sources

                        catch (Throwable var49_121) {
                            var50_116 = null;
                            var42_55.close();
                            throw var49_121;
                        }
                    }
                }
                catch (Throwable var37_149) {
                    block182: {
                        block183: {
                            block181: {
                                block180: {
                                    var38_33 = null;
                                    if (var14_11 != null) {
                                        var14_11.close();
                                    }
                                    ** try [egrp 15[TRYBLOCK] [19 : 1507->1516)] { 
lbl564:
                                    // 1 sources

                                    var1_1.close();
                                    break block180;
lbl566:
                                    // 1 sources

                                    catch (Throwable var39_37 /* !! */ ) {
                                        this.log.error(new Object[]{var39_37 /* !! */ });
                                    }
                                }
                                if (var2_2.isClosed() != false) throw var37_149;
                                var7_41 = new ByteArrayOutputStream();
                                if (var8_6 != null) break block181;
                                var7_41.write(66);
                                var7_41.write(1);
                                var39_37 /* !! */  = new DataOutputStream(var7_41);
                                ** try [egrp 16[TRYBLOCK] [20 : 1583->1830)] { 
lbl576:
                                // 1 sources

                                var42_56 = var9_7.size();
                                var43_67 = 0;
                                for (var41_48 = 0; var41_48 < var42_56 && var43_67 == 0; ++var41_48) {
                                    if (((ResultObject)var9_7.get(var41_48)).getType() != 4) continue;
                                    var40_76 = (Throwable)((ResultObject)var9_7.get(var41_48)).getObject();
                                    if (var40_76 != null) {
                                        var44_84 = var40_76.getStackTrace();
                                        var39_37 /* !! */ .writeUTF(var40_76.getClass().getName());
                                        var39_37 /* !! */ .writeUTF(CommonUtil.nvl(var40_76.getMessage(), ""));
                                        if (var44_84 != null) {
                                            var39_37 /* !! */ .write(var44_84.length);
                                            var46_93 = var44_84.length;
                                            for (var45_89 = 0; var45_89 < var46_93; ++var45_89) {
                                                var39_37 /* !! */ .writeUTF(CommonUtil.nvl(var44_84[var45_89].getClassName(), ""));
                                                var39_37 /* !! */ .writeUTF(CommonUtil.nvl(var44_84[var45_89].getMethodName(), ""));
                                                var39_37 /* !! */ .writeUTF(CommonUtil.nvl(var44_84[var45_89].getFileName(), ""));
                                                var39_37 /* !! */ .writeInt(var44_84[var45_89].getLineNumber());
                                            }
                                        } else {
                                            var39_37 /* !! */ .write(0);
                                        }
                                    } else {
                                        var39_37 /* !! */ .writeUTF("");
                                    }
                                    ++var43_67;
                                }
                                var48_100 = null;
                                var39_37 /* !! */ .flush();
                                break block182;
lbl604:
                                // 1 sources

                                catch (Throwable var47_105) {
                                    var48_101 = null;
                                    var39_37 /* !! */ .flush();
                                    throw var47_105;
                                }
                            }
                            var39_37 /* !! */  = null;
                            var40_77 = var5_5 != null ? var5_5.getProperties().getChanges(IConnectionConstants.PROPERTY_CLASSES) : (var12_9 != null ? var12_9.getChanges(IConnectionConstants.PROPERTY_CLASSES) : null);
                            if (var40_77 != null && var40_77.size() > 0) {
                                var41_49 = new ArrayUtil<E>(var40_77.size());
                                for (Object var43_68 : var40_77) {
                                    var41_49.add(new Object[]{var43_68.getKey(), var43_68.getValue()});
                                    var2_2.setProperty((String)var43_68.getKey(), var43_68.getValue());
                                }
                                if (var39_37 /* !! */  == null) {
                                    var39_37 /* !! */  = new ArrayUtil<E>();
                                }
                                var39_37 /* !! */ .add(new ResultObject(5, var41_49));
                            }
                            if (var5_5 != null) {
                                if (var39_37 /* !! */  == null) {
                                    var39_37 /* !! */  = new ArrayUtil<ResultObject>();
                                }
                                if ((var41_49 = this.getCallBackResultsIntern(var5_5)) != null) {
                                    var39_37 /* !! */ .addAll((Collection<ResultObject>)var41_49);
                                }
                            }
                            if (var9_7 != null) {
                                if (var39_37 /* !! */  == null) {
                                    var39_37 /* !! */  = new ArrayUtil<E>();
                                }
                                var39_37 /* !! */ .addAll(var9_7);
                            }
                            var11_110 = var39_37 /* !! */  != null ? var39_37 /* !! */ .size() : 0;
                            var41_49 = new ByteArrayOutputStream();
                            var42_57 = new DataOutputStream((OutputStream)var41_49);
                            ** try [egrp 17[TRYBLOCK] [22 : 2148->2268)] { 
lbl638:
                            // 1 sources

                            var8_6.write(var42_57, var11_110);
                            if (var39_37 /* !! */  != null) {
                                for (Object var44_85 : var39_37 /* !! */ ) {
                                    var8_6.write(var42_57, var44_85.getType());
                                    var8_6.write(var42_57, var44_85.getObject());
                                    if (var44_85.getType() != 2 && var44_85.getType() != 1) continue;
                                    var8_6.write(var42_57, var44_85.getCallBackId());
                                }
                            }
                            break block183;
lbl647:
                            // 1 sources

                            catch (Throwable var49_122) {
                                var50_118 = null;
                                var42_57.close();
                                throw var49_122;
                            }
                        }
                        var50_117 = null;
                        var42_57.close();
                        var7_41.write(69);
                        v3 = var43_69 = var5_5 != null && Boolean.parseBoolean((String)var5_5.getProperties().get("client.session.compression")) != false;
                        if (var43_69 && var41_49.size() > 256) {
                            var7_41.write(2);
                            var44_85 = new GZIPOutputStream(var7_41);
                            var41_49.writeTo((OutputStream)var44_85);
                            var44_85.close();
                            var7_41.write(Server.MAGIC_BYTES);
                        } else {
                            var7_41.write(1);
                            var41_49.writeTo(var7_41);
                        }
                    }
                    if (var13_10 != null) {
                        var13_10.content = var7_41;
                        var39_37 /* !! */  = var13_10;
                        synchronized (var39_37 /* !! */ ) {
                            var13_10.notifyAll();
                        }
                    } else if (var5_5 != null) {
                        this.whmResponse.put(this.sessman.getMasterSession(var5_5), new CachedResponse(var10_8, var7_41));
                    }
                    this.sendContent(var2_2, var7_41);
                    throw var37_149;
                }
            }
            catch (Throwable var52_150) {
                var53_125 = null;
                CommonUtil.close(new Object[]{var4_4});
                throw var52_150;
            }
        }
        catch (Throwable var54_151) {
            var55_128 = null;
            var3_3.release();
            throw var54_151;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendContent(IResponse iResponse, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        try {
            OutputStream outputStream = iResponse.getOutputStream();
            byteArrayOutputStream.writeTo(outputStream);
            outputStream.flush();
            Object var5_4 = null;
            iResponse.close();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            iResponse.close();
            throw throwable;
        }
    }

    private Object process(IRequest iRequest, ISerializer iSerializer, AbstractSession abstractSession, String string, String string2, Object[] objectArray, Object object, ChangedHashtable<String, Object> changedHashtable) throws Throwable {
        if (object != null) {
            this.validateCallBack(abstractSession, string);
        }
        if (string != null && "Session!".equals(string)) {
            if ("createSession".equals(string2)) {
                if (abstractSession != null) {
                    throw new SecurityException("Session is already open!");
                }
                return this.createSessionIntern(iRequest, iSerializer, changedHashtable);
            }
            if ("createSubSession".equals(string2)) {
                if (abstractSession != null) {
                    throw new SecurityException("Session is already open!");
                }
                return this.createSubSessionIntern(iRequest, this.sessman.get(objectArray[0]), changedHashtable);
            }
            if ("setProperty".equals(string2) && abstractSession == null) {
                return (List)objectArray[0];
            }
            if (abstractSession != null) {
                if ("setAndCheckAlive".equals(string2)) {
                    return this.setAndCheckAliveIntern(abstractSession, objectArray);
                }
                if ("destroySession".equals(string2)) {
                    this.destroySessionIntern(abstractSession.getId());
                    return null;
                }
                if ("getProperty".equals(string2)) {
                    return this.getPropertyIntern(abstractSession, (String)objectArray[0]);
                }
                if ("getProperties".equals(string2)) {
                    return this.getPropertiesIntern(abstractSession);
                }
                if ("setProperty".equals(string2)) {
                    this.setPropertiesIntern(abstractSession, (List)objectArray[0]);
                    return null;
                }
                if ("setNewPassword".equals(string2)) {
                    this.setNewPasswordInternal(abstractSession, (String)objectArray[0], (String)objectArray[1]);
                    return null;
                }
            }
        }
        return this.executeIntern(abstractSession, new Call(object, string, string2, objectArray));
    }

    private Object executeIntern(AbstractSession abstractSession, Call call) throws Throwable {
        if (abstractSession != null) {
            return abstractSession.execute(call);
        }
        throw new SecurityException("No session for call '" + call.formatMethod() + "'");
    }

    private void validateCallBack(AbstractSession abstractSession, String string) {
        if (abstractSession == null) {
            throw new SecurityException("Call back is not allowed!");
        }
        if (string != null && "Session!".equals(string)) {
            throw new SecurityException("Call back is not allowed!");
        }
    }

    private Object createSessionIntern(IRequest iRequest, ISerializer iSerializer, ChangedHashtable<String, Object> changedHashtable) throws Throwable {
        return this.sessman.createSession(iRequest, iSerializer, changedHashtable);
    }

    private Object createSubSessionIntern(IRequest iRequest, AbstractSession abstractSession, ChangedHashtable<String, Object> changedHashtable) throws Throwable {
        return this.sessman.createSubSession(iRequest, abstractSession, changedHashtable);
    }

    private void destroySessionIntern(Object object) {
        this.sessman.destroy(object);
    }

    private void setPropertyIntern(AbstractSession abstractSession, String string, Object object) {
        abstractSession.setProperty(string, object);
    }

    private void setPropertiesIntern(AbstractSession abstractSession, List<Object[]> list) {
        abstractSession.setProperties(list);
    }

    private Object getPropertyIntern(AbstractSession abstractSession, String string) {
        Object object = abstractSession.getProperty(string);
        if (object != null) {
            for (int i = 0; i < IConnectionConstants.PROPERTY_CLASSES.length; ++i) {
                if (!IConnectionConstants.PROPERTY_CLASSES[i].isAssignableFrom(object.getClass())) continue;
                return object;
            }
        }
        return null;
    }

    private ChangedHashtable<String, Object> getPropertiesIntern(AbstractSession abstractSession) {
        List list = ((ChangedHashtable)abstractSession.getProperties()).getMapping(IConnectionConstants.PROPERTY_CLASSES);
        ChangedHashtable<String, Object> changedHashtable = new ChangedHashtable<String, Object>();
        for (Map.Entry entry : list) {
            Object obj = entry.getValue();
            if (obj == null) continue;
            changedHashtable.put((String)entry.getKey(), obj, false);
        }
        return changedHashtable;
    }

    private ArrayUtil<ResultObject> getCallBackResultsIntern(AbstractSession abstractSession) {
        if (abstractSession != null) {
            return abstractSession.removeCallBackResults();
        }
        return null;
    }

    private Object[] setAndCheckAliveIntern(AbstractSession abstractSession, Object[] objectArray) {
        abstractSession.setLastAliveTime(System.currentTimeMillis());
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        ArrayUtil<Object> arrayUtil = new ArrayUtil<Object>();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            try {
                this.sessman.get(objectArray[i]);
                continue;
            }
            catch (RuntimeException runtimeException) {
                arrayUtil.add(objectArray[i]);
            }
        }
        if (arrayUtil.size() > 0) {
            Object[] objectArray2 = new Object[arrayUtil.size()];
            arrayUtil.toArray(objectArray2);
            return objectArray2;
        }
        return null;
    }

    private void setNewPasswordInternal(AbstractSession abstractSession, String string, String string2) throws Throwable {
        abstractSession.setNewPassword(string, string2);
    }

    public final Monitoring getMonitoring() {
        return this.monitoring;
    }

    private final void log(Object object, Object object2, String string, String string2, Object[] objectArray, Object object3, Object object4, Throwable throwable, long l) {
        this.log.debug("SESSION-ID: ", object, "\nCOMMUNICATION-ID: ", object2, "\nOBJECTNAME: ", string, "\nMETHOD:     ", string2, "\nPARAMS:     ", objectArray, "\nCALLBACK:   ", object3, "\nRESULT:     ", object4, "\nEXCEPTION:  ", throwable, throwable != null ? "DURATION:   " : "\nDURATION:   ", l, " ms");
    }

    private final void error(Object object, Object object2, String string, String string2, Object[] objectArray, Object object3, Object object4, Throwable throwable, long l) {
        this.log.error("SESSION-ID: ", object, "\nCOMMUNICATION-ID: ", object2, "\nOBJECTNAME: ", string, "\nMETHOD:     ", string2, "\nPARAMS:     ", objectArray, "\nCALLBACK:   ", object3, "\nRESULT:     ", object4, "\nEXCEPTION:  ", throwable, throwable != null ? "DURATION:   " : "\nDURATION:   ", l, " ms");
    }

    private final ServerContext createServerContextIntern() {
        ServerContextImpl serverContextImpl = new ServerContextImpl(this);
        if (this.sInitialSystemIdentifier == null) {
            this.sInitialSystemIdentifier = serverContextImpl.getSystemIdentifier();
        }
        return serverContextImpl;
    }

    final ServerContext createServerContext() {
        ServerContextImpl serverContextImpl = new ServerContextImpl(this, this.sInitialSystemIdentifier);
        return serverContextImpl;
    }

    public static final void initLogging() {
        String string;
        try {
            string = Configuration.getServerZone().getProperty("/server/logfactory");
        }
        catch (Exception exception) {
            string = null;
        }
        LoggerFactory.init(string);
    }

    private void clearBuffer(DataInputStream dataInputStream, Object object) {
        SerializerInfo serializerInfo = this.hmpSerializer.get(object);
        if (serializerInfo == null) {
            serializerInfo = this.hmpSerializer.get(null);
        }
        try {
            ISerializer iSerializer = (ISerializer)serializerInfo.clsSerializer.newInstance();
            Object object2 = iSerializer.read(dataInputStream);
            if (object2 instanceof String) {
                object2 = iSerializer.read(dataInputStream);
            }
            int n = (Integer)object2;
            for (int i = 0; i < n; ++i) {
                iSerializer.read(dataInputStream);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SerializerInfo {
        private Class<? extends ISerializer> clsSerializer;
        private long lCreation = System.currentTimeMillis();

        private SerializerInfo(Class<? extends ISerializer> clazz) {
            this.clsSerializer = clazz;
        }
    }

    private static final class SessionListener
    implements ISessionListener {
        private Server server;

        private SessionListener(Server server) {
            this.server = server;
        }

        public void sessionCreated(ISession iSession) {
        }

        public void sessionDestroyed(ISession iSession) {
            ISerializer iSerializer;
            this.server.whmResponse.remove(this.server.sessman.getMasterSession(iSession));
            if (iSession instanceof AbstractSession && (iSerializer = ((AbstractSession)iSession).getSerializer()) != null) {
                Object object;
                if (this.server.hmpSerializer.size() > 1) {
                    object = (HashMap)this.server.hmpSerializer.clone();
                    long l = System.currentTimeMillis();
                    for (Map.Entry entry : ((HashMap)object).entrySet()) {
                        long l2 = ((SerializerInfo)entry.getValue()).lCreation;
                        if (l2 <= 0L || l2 + 3600000L >= l) continue;
                        this.server.hmpSerializer.remove(entry.getKey());
                    }
                }
                if (((SerializerInfo)(object = (SerializerInfo)this.server.hmpSerializer.get(null))).clsSerializer != iSerializer.getClass()) {
                    this.server.hmpSerializer.put(iSession.getId(), new SerializerInfo(iSerializer.getClass()));
                }
            }
        }
    }

    private static final class CachedResponse {
        protected Long id;
        protected ByteArrayOutputStream content;

        private CachedResponse(Long l) {
            this.id = l;
        }

        private CachedResponse(Long l, ByteArrayOutputStream byteArrayOutputStream) {
            this.id = l;
            this.content = byteArrayOutputStream;
        }
    }
}

