/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.remote.serializer;

import com.sibvisions.rad.remote.UniversalSerializer;
import com.sibvisions.rad.remote.serializer.ITypeSerializer;
import com.sibvisions.rad.remote.serializer.TypeCache;
import java.io.DataInputStream;
import java.io.DataOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerSerializer
implements ITypeSerializer<Integer> {
    private static final int TYPE_INTEGER = 11;
    private static final int TYPE_INTEGER_0 = 12;
    private static final Integer INTEGER_0 = 0;

    @Override
    public Class<Integer> getTypeClass() {
        return Integer.class;
    }

    @Override
    public int getMinValue() {
        return 11;
    }

    @Override
    public int getMaxValue() {
        return 12;
    }

    @Override
    public Integer read(UniversalSerializer universalSerializer, DataInputStream dataInputStream, int n, TypeCache typeCache) throws Exception {
        if (n == 11) {
            return dataInputStream.readInt();
        }
        return INTEGER_0;
    }

    @Override
    public void write(UniversalSerializer universalSerializer, DataOutputStream dataOutputStream, Integer n, TypeCache typeCache) throws Exception {
        int n2 = n;
        if (n2 == 0) {
            dataOutputStream.writeByte(12);
        } else {
            dataOutputStream.writeByte(11);
            dataOutputStream.writeInt(n2);
        }
    }
}

