/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.remote.serializer;

import com.sibvisions.rad.remote.UniversalSerializer;
import com.sibvisions.rad.remote.serializer.AbstractSizedSerializer;
import com.sibvisions.rad.remote.serializer.ITypeSerializer;
import com.sibvisions.rad.remote.serializer.TypeCache;
import java.io.DataInputStream;
import java.io.DataOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteArraySerializer
extends AbstractSizedSerializer
implements ITypeSerializer<byte[]> {
    private static final int TYPE_BYTE_ARRAY_MIN = 30;
    private static final int TYPE_BYTE_ARRAY_MAX = 32;

    @Override
    public Class<byte[]> getTypeClass() {
        return byte[].class;
    }

    @Override
    public int getMinValue() {
        return 30;
    }

    @Override
    public int getMaxValue() {
        return 32;
    }

    @Override
    public byte[] read(UniversalSerializer universalSerializer, DataInputStream dataInputStream, int n, TypeCache typeCache) throws Exception {
        int n2 = this.readSize(dataInputStream, n, 30, 32);
        byte[] byArray = new byte[n2];
        dataInputStream.readFully(byArray);
        return byArray;
    }

    @Override
    public void write(UniversalSerializer universalSerializer, DataOutputStream dataOutputStream, byte[] byArray, TypeCache typeCache) throws Exception {
        this.writeSize(dataOutputStream, byArray.length, 30, 32);
        dataOutputStream.write(byArray);
    }
}

