/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.persist.jdbc.Name;
import java.util.Arrays;

public class ForeignKey
implements Cloneable {
    private Name nPKTable;
    private Name nPKCatalog;
    private Name nPKSchema;
    private Name[] naPKColumns;
    private Name[] naFKColumns;
    private String sFKName;

    public ForeignKey(Name name, Name name2, Name name3) {
        this.nPKTable = name;
        this.nPKCatalog = name2;
        this.nPKSchema = name3;
    }

    public ForeignKey(String[] stringArray, String string, String[] stringArray2, String[] stringArray3) {
        int n = string.indexOf(46);
        if (n < 0) {
            this.nPKTable = new Name(string, string);
            this.nPKCatalog = null;
            this.nPKSchema = null;
        } else {
            this.nPKTable = new Name(string.substring(n + 1), string.substring(n + 1));
            this.nPKCatalog = null;
            this.nPKSchema = new Name(string.substring(0, n), string.substring(0, n));
        }
        this.naFKColumns = ForeignKey.createNames(stringArray);
        this.naPKColumns = ForeignKey.createNames(stringArray2);
    }

    private static Name[] createNames(String[] stringArray) {
        Name[] nameArray = new Name[stringArray.length];
        for (int i = 0; i < nameArray.length; ++i) {
            nameArray[i] = new Name(stringArray[i], stringArray[i]);
        }
        return nameArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("sPKTable :: ");
        stringBuilder.append(this.nPKTable);
        stringBuilder.append(", sPKCatalog=");
        stringBuilder.append(this.nPKCatalog);
        stringBuilder.append(", pPKSchema=");
        stringBuilder.append(this.nPKSchema);
        stringBuilder.append(", saPKColumns=");
        stringBuilder.append(Arrays.toString(this.naPKColumns));
        stringBuilder.append(", saFKColumns=");
        stringBuilder.append(Arrays.toString(this.naFKColumns));
        stringBuilder.append(", sFKName=");
        stringBuilder.append(this.sFKName);
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public ForeignKey clone() {
        try {
            ForeignKey foreignKey = (ForeignKey)super.clone();
            if (this.naFKColumns != null) {
                foreignKey.naFKColumns = (Name[])this.naFKColumns.clone();
            }
            if (this.naPKColumns != null) {
                foreignKey.naPKColumns = (Name[])this.naPKColumns.clone();
            }
            return foreignKey;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Name[] getPKColumns() {
        return this.naPKColumns;
    }

    public void setPKColumns(Name[] nameArray) {
        this.naPKColumns = nameArray;
    }

    public Name[] getFKColumns() {
        return this.naFKColumns;
    }

    public void setFKColumns(Name[] nameArray) {
        this.naFKColumns = nameArray;
    }

    public Name getPKTable() {
        return this.nPKTable;
    }

    public Name getPKCatalog() {
        return this.nPKCatalog;
    }

    public void setPKCatalog(Name name) {
        this.nPKCatalog = name;
    }

    public Name getPKSchema() {
        return this.nPKSchema;
    }

    public void setPKSchema(Name name) {
        this.nPKSchema = name;
    }

    public String getFKName() {
        return this.sFKName;
    }

    public void setFKName(String string) {
        this.sFKName = string;
    }
}

