/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist;

import com.sibvisions.rad.model.remote.RemoteDataBook;
import com.sibvisions.rad.model.remote.RemoteDataSource;
import com.sibvisions.rad.util.DirectObjectConnection;
import com.sibvisions.util.type.CommonUtil;
import javax.rad.model.IDataSource;
import javax.rad.model.ModelException;
import javax.rad.persist.IStorage;
import javax.rad.remote.MasterConnection;

public class StorageDataBook
extends RemoteDataBook {
    private DirectObjectConnection objectConnection = new DirectObjectConnection();
    private MasterConnection connection;
    private RemoteDataSource dataSource;

    public StorageDataBook() {
        this((IStorage)null);
    }

    public StorageDataBook(IStorage iStorage) {
        this.setStorageImplIntern(iStorage);
    }

    public void open() throws ModelException {
        if (!this.isOpen()) {
            if (this.getStorageImpl() == null) {
                throw new ModelException("Can't open databook without storage!");
            }
            try {
                this.connection = new MasterConnection(this.objectConnection);
                this.connection.setAliveInterval(-1L);
                this.connection.setTimeout(-1);
                this.connection.open();
                this.dataSource = new RemoteDataSource();
                this.dataSource.setConnection(this.connection);
                this.dataSource.open();
                super.setDataSource(this.dataSource);
                super.setName("storage");
            }
            catch (Throwable throwable) {
                throw new ModelException(throwable);
            }
        }
        super.open();
    }

    public void close() {
        super.close();
        CommonUtil.close(this.dataSource, this.connection);
    }

    public void setName(String string) {
        throw new UnsupportedOperationException("It's not allowed to use a custom name!");
    }

    public void setDataSource(IDataSource iDataSource) {
        throw new UnsupportedOperationException("It's not allowed to use a custom datasource!");
    }

    public void setStorageImpl(IStorage iStorage) {
        if (iStorage == null) {
            throw new IllegalArgumentException("Storage can't be null!");
        }
        this.setStorageImplIntern(iStorage);
    }

    private void setStorageImplIntern(IStorage iStorage) {
        this.objectConnection.put("storage", iStorage);
    }

    public IStorage getStorageImpl() {
        return (IStorage)this.objectConnection.get("storage");
    }
}

