/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.application;

import com.sibvisions.rad.application.event.ErrorHandler;
import com.sibvisions.rad.model.mem.MemDataBook;
import com.sibvisions.util.type.ExceptionUtil;
import javax.rad.application.IContent;
import javax.rad.genui.UIImage;
import javax.rad.genui.celleditor.UITextCellEditor;
import javax.rad.genui.component.UIButton;
import javax.rad.genui.component.UIIcon;
import javax.rad.genui.component.UITextArea;
import javax.rad.genui.component.UIToggleButton;
import javax.rad.genui.container.UIGroupPanel;
import javax.rad.genui.container.UIInternalFrame;
import javax.rad.genui.control.UIEditor;
import javax.rad.genui.control.UITable;
import javax.rad.genui.layout.UIBorderLayout;
import javax.rad.genui.layout.UIFormLayout;
import javax.rad.model.ColumnDefinition;
import javax.rad.model.ColumnView;
import javax.rad.model.IRowDefinition;
import javax.rad.model.ModelException;
import javax.rad.model.datatype.ObjectDataType;
import javax.rad.ui.IComponent;
import javax.rad.ui.container.IDesktopPanel;
import javax.rad.ui.event.UIActionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Error
extends UIInternalFrame
implements IContent {
    private Object opener;
    private ErrorHandler eventHideDetails;
    private ErrorHandler eventShowDetails;
    private UIFormLayout layMain = new UIFormLayout();
    private UIBorderLayout layDetails = new UIBorderLayout();
    private UIGroupPanel gpanDetails = new UIGroupPanel();
    private UITextArea taMessage = new UITextArea();
    private UIIcon icon = new UIIcon();
    private UIButton butOK = new UIButton();
    private UIToggleButton butDetails = new UIToggleButton();
    private UIEditor editErrorDetail = new UIEditor();
    private UITable tblError = new UITable();
    private MemDataBook mdbError = new MemDataBook();

    public Error(IDesktopPanel iDesktopPanel) throws Exception {
        super(iDesktopPanel);
        this.init();
    }

    private void init() throws Exception {
        this.setTitle("Information");
        this.setResizable(true);
        this.setIconImage(null);
        this.setMaximizable(false);
        this.setIconifiable(false);
        this.setModal(true);
        this.setMinimumSize(200, 140);
        this.icon.setImage(UIImage.getImage("MESSAGE_ERROR_LARGE"));
        this.icon.setVerticalAlignment(0);
        this.taMessage.setMinimumSize(0, 70);
        this.taMessage.setPreferredSize(470, 70);
        this.taMessage.setWordWrap(true);
        this.taMessage.setName("errordialog-message");
        this.taMessage.setEditable(false);
        this.butOK.eventAction().addListener(this, "doOk");
        this.butOK.setText("OK");
        this.butOK.setDefaultButton(true);
        this.butDetails.eventAction().addListener(this, "doDetails");
        this.butDetails.setText("Details");
        this.mdbError.setName("Error");
        this.mdbError.setUpdateEnabled(false);
        this.mdbError.setDeleteEnabled(false);
        IRowDefinition iRowDefinition = this.mdbError.getRowDefinition();
        iRowDefinition.addColumnDefinition(new ColumnDefinition("ERROR"));
        iRowDefinition.addColumnDefinition(new ColumnDefinition("DETAIL"));
        iRowDefinition.addColumnDefinition(new ColumnDefinition("CAUSE", new ObjectDataType()));
        iRowDefinition.setColumnView(null, new ColumnView("ERROR"));
        iRowDefinition.getColumnDefinition("ERROR").setLabel("Cause(s) of failure");
        this.mdbError.open();
        this.tblError.setDataBook(this.mdbError);
        this.tblError.setPreferredSize(0, 90);
        this.tblError.setMaximumSize(Integer.MAX_VALUE, 90);
        this.tblError.setAutoResize(true);
        this.editErrorDetail.setCellEditor(new UITextCellEditor("text/plain;multiline"));
        this.editErrorDetail.setDataRow(this.mdbError);
        this.editErrorDetail.setColumnName("DETAIL");
        this.editErrorDetail.setPreferredSize(0, 200);
        this.layDetails.setMargins(2, 2, 2, 2);
        this.gpanDetails.setText("Details");
        this.gpanDetails.setLayout(this.layDetails);
        this.gpanDetails.add((IComponent)this.tblError, "North");
        this.gpanDetails.add((IComponent)this.editErrorDetail, "Center");
        this.layMain.setVerticalAlignment(0);
        this.layMain.setMargins(7, 7, 7, 7);
        this.layMain.setAnchorConfiguration("t1=7,b-2=-7");
        this.setLayout(this.layMain);
        this.add((IComponent)this.icon, this.layMain.getConstraints(0, 0));
        this.add((IComponent)this.taMessage, this.layMain.getConstraints(1, 0, -1, -2));
        this.add((IComponent)this.butOK, this.layMain.getConstraints(-1, -1));
        this.add((IComponent)this.butDetails, this.layMain.getConstraints(-2, -1));
    }

    @Override
    public void notifyDestroy() {
    }

    @Override
    public void notifyVisible() {
    }

    @Override
    public <OP> void setOpener(OP OP) {
        this.opener = OP;
    }

    @Override
    public <OP> OP getOpener() {
        return (OP)this.opener;
    }

    public void addError(Throwable throwable) {
        if (throwable != null) {
            this.mdbError.setInsertEnabled(true);
            Throwable throwable2 = throwable;
            try {
                String string;
                do {
                    String string2;
                    if ((string2 = throwable2.getMessage()) == null || string2.trim().length() == 0) {
                        string2 = throwable2.getClass().getName();
                        string = throwable2.getClass().getSimpleName();
                    } else {
                        string = string2;
                    }
                    this.mdbError.insert(true);
                    this.mdbError.setValues(new String[]{"ERROR", "DETAIL", "CAUSE"}, new Object[]{string2, ExceptionUtil.dump(throwable2, false), throwable2});
                } while ((throwable2 = throwable2.getCause()) != null);
                this.mdbError.saveAllRows();
                this.taMessage.setText(string);
            }
            catch (ModelException modelException) {
                modelException.printStackTrace();
                this.debug(modelException);
            }
            this.mdbError.setInsertEnabled(false);
        }
    }

    protected void updateAnchors() {
        if (this.butDetails.isSelected()) {
            this.add((IComponent)this.taMessage, this.layMain.getConstraints(1, 0, -1, 0));
            this.add((IComponent)this.butOK, this.layMain.getConstraints(-1, 1));
            this.add((IComponent)this.butDetails, this.layMain.getConstraints(-2, 1));
            this.add((IComponent)this.gpanDetails, this.layMain.getConstraints(0, 2, -1, -1));
        } else {
            this.remove(this.gpanDetails);
            this.add((IComponent)this.taMessage, this.layMain.getConstraints(1, 0, -1, -2));
            this.add((IComponent)this.butOK, this.layMain.getConstraints(-1, -1));
            this.add((IComponent)this.butDetails, this.layMain.getConstraints(-2, -1));
        }
    }

    protected UITextArea getTextArea() {
        return this.taMessage;
    }

    protected UIButton getOKButton() {
        return this.butOK;
    }

    protected UIToggleButton getDetailsButton() {
        return this.butDetails;
    }

    protected UIGroupPanel getDetailsGroupPanel() {
        return this.gpanDetails;
    }

    public String getMessage() {
        return this.taMessage.getText();
    }

    public Throwable[] getErrors() {
        try {
            Throwable[] throwableArray = new Throwable[this.mdbError.getRowCount()];
            int n = this.mdbError.getRowCount();
            for (int i = 0; i < n; ++i) {
                throwableArray[i] = (Throwable)this.mdbError.getDataRow(i).getValue("CAUSE");
            }
            return throwableArray;
        }
        catch (ModelException modelException) {
            throw new RuntimeException(modelException);
        }
    }

    public ErrorHandler eventHideDetails() {
        if (this.eventHideDetails == null) {
            this.eventHideDetails = new ErrorHandler("hideDetails");
        }
        return this.eventHideDetails;
    }

    public ErrorHandler eventShowDetails() {
        if (this.eventShowDetails == null) {
            this.eventShowDetails = new ErrorHandler("showDetails");
        }
        return this.eventShowDetails;
    }

    public void doOk(UIActionEvent uIActionEvent) {
        this.dispose();
    }

    public void doDetails(UIActionEvent uIActionEvent) {
        this.updateAnchors();
        this.pack();
        if (this.butDetails.isSelected()) {
            if (this.eventShowDetails != null) {
                this.eventShowDetails.dispatchEvent(this);
            }
        } else if (this.eventHideDetails != null) {
            this.eventHideDetails.dispatchEvent(this);
        }
    }
}

