/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.ui;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.StringUtil;
import java.util.Arrays;
import javax.rad.ui.IComponent;

public class Style
implements Cloneable {
    private String[] saStyleNames;

    public Style(String ... stringArray) {
        this.saStyleNames = stringArray;
    }

    public Style clone() {
        try {
            Style style = (Style)super.clone();
            if (this.saStyleNames != null) {
                style.saStyleNames = (String[])this.saStyleNames.clone();
            }
            return style;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public int hashCode() {
        return 31 + Arrays.hashCode(this.saStyleNames);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Style style = (Style)object;
        return Arrays.equals(this.saStyleNames, style.saStyleNames);
    }

    private Style addStyleName(String string) {
        if (string != null && string.length() > 0 && ArrayUtil.indexOf(this.saStyleNames, string) < 0) {
            this.saStyleNames = ArrayUtil.add(this.saStyleNames, string);
        }
        return this;
    }

    private Style removeStyleName(String string) {
        if (string != null) {
            this.saStyleNames = ArrayUtil.remove(this.saStyleNames, string);
        }
        return this;
    }

    public String[] getStyleNames() {
        if (this.saStyleNames == null) {
            return new String[0];
        }
        return this.saStyleNames;
    }

    public boolean containsStyleName(String string) {
        return ArrayUtil.indexOf(this.saStyleNames, string) >= 0;
    }

    public static Style parse(String string) {
        if (string == null) {
            return new Style(new String[0]);
        }
        ArrayUtil<String> arrayUtil = StringUtil.separateList(string, " ", true);
        Style style = new Style(new String[0]);
        int n = arrayUtil.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)arrayUtil.get(i);
            if (string2.length() <= 0) continue;
            style.addStyleName(string2);
        }
        return style;
    }

    public static Style addStyleNames(IComponent iComponent, String ... stringArray) {
        Style style = iComponent.getStyle();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                style.addStyleName(stringArray[i]);
            }
            iComponent.setStyle(style);
        }
        return style;
    }

    public static Style removeStyleNames(IComponent iComponent, String ... stringArray) {
        Style style = iComponent.getStyle();
        if (style != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                style.removeStyleName(stringArray[i]);
            }
            iComponent.setStyle(style);
        }
        return style;
    }
}

