/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.server;

import javax.rad.server.ISession;

public abstract class ServerContext {
    private static ThreadLocal<ServerContext> instance = new ThreadLocal();

    protected abstract void destroy();

    public abstract ISession getSession();

    public abstract String getSystemIdentifier();

    public abstract String getServerIdentifier();

    public static ServerContext getCurrentInstance() {
        return instance.get();
    }

    public static ISession getCurrentSession() {
        ServerContext serverContext = instance.get();
        if (serverContext == null) {
            return null;
        }
        return serverContext.getSession();
    }

    protected synchronized void setInstance(ServerContext serverContext) {
        instance.set(serverContext);
    }

    public final synchronized void release() {
        this.destroy();
    }

    public boolean isReleased() {
        return instance.get() == null;
    }
}

