/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.genui;

import java.lang.reflect.Method;
import java.util.WeakHashMap;
import javax.rad.genui.UIImage;
import javax.rad.model.ui.ICellEditor;
import javax.rad.type.bean.Bean;
import javax.rad.type.bean.BeanType;
import javax.rad.ui.IColor;
import javax.rad.ui.IFactory;
import javax.rad.ui.IFont;
import javax.rad.ui.IImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIFactoryManager {
    private static IFactory factory = null;
    private static Class factoryClass = null;
    private static ThreadLocal<IFactory> threadLocal = null;
    private static WeakHashMap<Class, Boolean> whmpFactories = new WeakHashMap();

    protected UIFactoryManager() {
    }

    public static IFactory getFactory() {
        IFactory iFactory;
        if (threadLocal != null && (iFactory = threadLocal.get()) != null) {
            return iFactory;
        }
        return factory;
    }

    public static void setFactoryInstance(IFactory iFactory) {
        if (factory == null) {
            factory = iFactory;
            factoryClass = iFactory.getClass();
            UIImage.setDefaults();
        } else if (iFactory == null || factory.getClass() != iFactory.getClass()) {
            throw new IllegalStateException("Only one factory class is supported per virtual machine instance!");
        }
    }

    public static IFactory getFactoryInstance(Class clazz) {
        try {
            if (factory == null) {
                if (threadLocal != null) {
                    throw new IllegalStateException("A static factory instance can not be created in threaded factory mode!");
                }
                factory = (IFactory)clazz.newInstance();
                factoryClass = clazz;
                UIImage.setDefaults();
            } else if (factoryClass != clazz) {
                throw new IllegalStateException("Only one factory class is supported per virtual machine instance!");
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("It is impossible to instanciate an IFactory with the given class!", exception);
        }
        return factory;
    }

    public static synchronized void registerThreadFactoryInstance(IFactory iFactory) {
        try {
            if (factory != null) {
                throw new IllegalStateException("The threaded factory registration can not be used in static factory mode!");
            }
            if (threadLocal == null) {
                threadLocal = new ThreadLocal();
            } else {
                IFactory iFactory2 = threadLocal.get();
                if (iFactory2 != null && iFactory2.getClass() != iFactory.getClass()) {
                    throw new IllegalStateException("Only one factory class is supported per thread!");
                }
            }
            threadLocal.set(iFactory);
            if (whmpFactories.get(iFactory.getClass()) == null) {
                whmpFactories.put(iFactory.getClass(), Boolean.TRUE);
                UIImage.setDefaults();
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("It is impossible to register the given IFactory!", exception);
        }
    }

    public static synchronized void unregisterThreadFactoryInstance() {
        if (threadLocal != null) {
            threadLocal.set(null);
        }
    }

    public static <UI> UI cloneResource(UI UI) {
        if (UI == null) {
            return null;
        }
        if (UI instanceof IColor) {
            IColor iColor = (IColor)UI;
            return (UI)UIFactoryManager.getFactory().createColor(iColor.getRGBA());
        }
        if (UI instanceof IImage) {
            IImage iImage = (IImage)UI;
            return (UI)UIFactoryManager.getFactory().getImage(iImage.getImageName());
        }
        if (UI instanceof IFont) {
            IFont iFont = (IFont)UI;
            return (UI)UIFactoryManager.getFactory().createFont(iFont.getName(), iFont.getStyle(), iFont.getSize());
        }
        if (UI instanceof ICellEditor) {
            ICellEditor iCellEditor = (ICellEditor)UI;
            Class<?>[] classArray = iCellEditor.getClass().getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                if (!ICellEditor.class.isAssignableFrom(classArray[i])) continue;
                IFactory iFactory = UIFactoryManager.getFactory();
                Method[] methodArray = iFactory.getClass().getMethods();
                for (int j = 0; j < methodArray.length; ++j) {
                    if (methodArray[j].getReturnType() != classArray[i]) continue;
                    try {
                        Object object = methodArray[j].invoke((Object)iFactory, new Object[0]);
                        Class<?> clazz = classArray[i];
                        do {
                            BeanType beanType = BeanType.getBeanType(clazz);
                            Bean bean = new Bean(iCellEditor);
                            Bean bean2 = new Bean(object);
                            for (String string : beanType.getPropertyNames()) {
                                bean2.put(string, UIFactoryManager.cloneResource(bean.get(string)));
                            }
                        } while ((clazz = clazz.getSuperclass()) != null && ICellEditor.class.isAssignableFrom(clazz));
                        return (UI)object;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        return UI;
    }
}

