/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.log.jdk;

import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.jdk.JdkLineFormatter;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class JdkStandardLogger
implements ILogger {
    private static WeakHashMap<String, ILogger.LogLevel> htLogLevels = new WeakHashMap();
    private static JdkLineFormatter formatter = null;
    private String name;

    public JdkStandardLogger(String string) {
        this.name = string;
        ILogger.LogLevel logLevel = null;
        int n = string.lastIndexOf(46);
        while (n >= 0 && logLevel == null) {
            logLevel = htLogLevels.get(string.substring(0, n));
            n = string.lastIndexOf(46, n - 1);
        }
        this.setLevel(logLevel);
    }

    public String getName() {
        return this.name;
    }

    public void setLevel(ILogger.LogLevel logLevel) {
        ILogger.LogLevel logLevel2 = logLevel;
        if (logLevel2 == null) {
            logLevel2 = ILogger.LogLevel.OFF;
        }
        htLogLevels.put(this.name, logLevel2);
        String string = this.name + ".";
        for (Map.Entry<String, ILogger.LogLevel> entry : htLogLevels.entrySet()) {
            if (entry.getKey() == this.name || !entry.getKey().startsWith(string)) continue;
            entry.setValue(logLevel2);
        }
    }

    public boolean isLevelSet() {
        return htLogLevels.get(this.name) != null;
    }

    public ILogger.LogLevel getLevel() {
        return htLogLevels.get(this.name);
    }

    public void debug(Object ... objectArray) {
        this.logWithCaller(ILogger.LogLevel.DEBUG, objectArray);
    }

    public void info(Object ... objectArray) {
        this.logWithCaller(ILogger.LogLevel.INFO, objectArray);
    }

    public void error(Object ... objectArray) {
        this.logWithCaller(ILogger.LogLevel.ERROR, objectArray);
    }

    public boolean isEnabled(ILogger.LogLevel logLevel) {
        ILogger.LogLevel logLevel2 = this.getLevel();
        return logLevel2 != ILogger.LogLevel.OFF && logLevel.ordinal() >= logLevel2.ordinal();
    }

    private final void logWithCaller(ILogger.LogLevel logLevel, Object ... objectArray) {
        ILogger.LogLevel logLevel2 = this.getLevel();
        if (logLevel2 != ILogger.LogLevel.OFF && logLevel.ordinal() >= logLevel2.ordinal()) {
            Level level;
            String string = null;
            String string2 = null;
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                if (!this.name.equals(stackTraceElementArray[i].getClassName())) continue;
                string = stackTraceElementArray[i].getClassName();
                string2 = stackTraceElementArray[i].getMethodName() + " (Line: " + stackTraceElementArray[i].getLineNumber() + ")";
                i = stackTraceElementArray.length;
            }
            if (string == null && stackTraceElementArray.length > 2) {
                String string3 = this.getClass().getName();
                for (int i = 0; i < stackTraceElementArray.length; ++i) {
                    if (stackTraceElementArray[i].getClassName().equals(string3)) continue;
                    string = stackTraceElementArray[i].getClassName();
                    string2 = stackTraceElementArray[i].getMethodName() + " (Line: " + stackTraceElementArray[i].getLineNumber() + ")";
                    i = stackTraceElementArray.length;
                }
            }
            switch (logLevel) {
                case ALL: {
                    level = Level.ALL;
                    break;
                }
                case DEBUG: {
                    level = Level.FINE;
                    break;
                }
                case INFO: {
                    level = Level.INFO;
                    break;
                }
                case ERROR: {
                    level = Level.SEVERE;
                    break;
                }
                default: {
                    level = Level.OFF;
                }
            }
            LogRecord logRecord = new LogRecord(level, JdkLineFormatter.concat(objectArray));
            logRecord.setSourceClassName(string);
            logRecord.setSourceMethodName(string2);
            this.publish(logRecord);
        }
    }

    protected void publish(LogRecord logRecord) {
        if (formatter == null) {
            formatter = new JdkLineFormatter();
        }
        System.out.print(formatter.format(logRecord));
    }
}

