/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.server.AbstractSession;
import com.sibvisions.rad.server.DefaultObjectProvider;
import com.sibvisions.rad.server.ISubSession;
import com.sibvisions.rad.server.MasterSession;
import com.sibvisions.rad.server.config.ApplicationZone;
import com.sibvisions.rad.server.protocol.ProtocolFactory;
import com.sibvisions.rad.server.protocol.Record;
import com.sibvisions.rad.server.security.IAccessController;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.ChangedHashtable;
import com.sibvisions.util.type.CommonUtil;
import javax.rad.server.IConfiguration;
import javax.rad.server.ResultObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SubSession
extends AbstractSession
implements ISubSession {
    private MasterSession msMaster;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SubSession(MasterSession masterSession, ChangedHashtable<String, Object> changedHashtable) throws Exception {
        super(masterSession.getSessionManager(), changedHashtable);
        this.msMaster = masterSession;
        this.msMaster.addSubSession(this);
        this.msMaster.setLastAccessTime(this.getLastAccessTime());
        Record record = ProtocolFactory.openRecord("SESSION", "CHECK_ACCESS", new Object[0]);
        try {
            if (DefaultObjectProvider.isIsolated(this.msMaster)) {
                throw new SecurityException("It's not possible to create a sub session from an isolated session!");
            }
            this.checkAccess();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            CommonUtil.close(record);
            throw throwable;
        }
        CommonUtil.close(record);
        record = ProtocolFactory.openRecord("SESSION", "CONFIGURATION", new Object[0]);
        try {
            this.setUserName(masterSession.getUserName());
            this.setPassword(masterSession.getPassword());
            this.setApplicationName(masterSession.getApplicationName());
            if (changedHashtable.get("server.session.timeout") == null && changedHashtable.get("server.session.timeoutSeconds") == null) {
                String string = masterSession.getApplicationZone().getProperty("/application/timeout/subsession");
                if (string != null) {
                    try {
                        this.setMaxInactiveInterval(Integer.parseInt(string) * 60);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.log.info("Invalid timeout!", numberFormatException);
                        this.setMaxInactiveInterval(-1);
                    }
                } else {
                    this.setMaxInactiveInterval(-1);
                }
            }
            this.setSerializer(this.msMaster.getSerializer());
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            CommonUtil.close(record);
            throw throwable;
        }
        CommonUtil.close(record);
    }

    @Override
    protected ApplicationZone getApplicationZone() {
        return this.msMaster.getApplicationZone();
    }

    @Override
    public IAccessController getAccessController() {
        return this.msMaster.getAccessController();
    }

    @Override
    public final void setNewPassword(String string, String string2) throws Exception {
        this.msMaster.setNewPassword(string, string2);
    }

    @Override
    public IConfiguration getConfig() {
        return this.msMaster.getConfig();
    }

    protected void finalize() throws Throwable {
        this.msMaster.removeSubSession(this);
        super.finalize();
    }

    @Override
    public boolean isInactive(long l) {
        int n = this.getMaxInactiveInterval();
        if (n > 0 && n < this.msMaster.getMaxInactiveInterval()) {
            return super.isInactive(l);
        }
        return this.msMaster.isInactive(l);
    }

    @Override
    public void setLastAccessTime(long l) {
        super.setLastAccessTime(l);
        if (this.msMaster != null) {
            this.msMaster.setLastAccessTime(l);
        }
    }

    @Override
    public void setLastAliveTime(long l) {
        if (this.msMaster != null) {
            this.msMaster.setLastAliveTime(l);
        }
    }

    @Override
    public long getLastAliveTime() {
        return this.msMaster.getLastAliveTime();
    }

    @Override
    protected void addCallBackResult(ResultObject resultObject) {
        this.msMaster.addCallBackResult(resultObject);
    }

    @Override
    ArrayUtil<ResultObject> removeCallBackResults() {
        return this.msMaster.removeCallBackResults();
    }

    @Override
    protected void setExecuting(boolean bl) {
        this.msMaster.setExecuting(bl);
        super.setExecuting(bl);
    }

    @Override
    protected Record openRecord(String string, Object ... objectArray) {
        Record record = super.openRecord(string, objectArray);
        if (record != null) {
            record.addIdentifier(this.msMaster.getId(), 0);
            record.addIdentifier("MASTER", 1);
        }
        return record;
    }

    MasterSession getMasterSession() {
        return this.msMaster;
    }
}

