/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.persist.jdbc.DBAccess;
import com.sibvisions.rad.persist.jdbc.Name;
import com.sibvisions.rad.persist.jdbc.ServerColumnMetaData;
import com.sibvisions.rad.persist.jdbc.ServerMetaData;
import com.sibvisions.rad.persist.jdbc.TableInfo;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.StringUtil;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.rad.model.ModelException;
import javax.rad.model.condition.CompareCondition;
import javax.rad.model.condition.Equals;
import javax.rad.model.condition.ICondition;
import javax.rad.model.condition.Like;
import javax.rad.model.condition.LikeIgnoreCase;
import javax.rad.model.condition.LikeReverse;
import javax.rad.model.condition.LikeReverseIgnoreCase;
import javax.rad.persist.ColumnMetaData;
import javax.rad.persist.DataSourceException;
import org.postgresql.util.PGobject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgreSQLDBAccess
extends DBAccess {
    public static final int TYPE_ENUM = -900;

    public PostgreSQLDBAccess() {
        this.setDriver("org.postgresql.Driver");
    }

    @Override
    public String getDatabaseSpecificLockStatement(String string, ServerMetaData serverMetaData, ICondition iCondition) throws DataSourceException {
        return super.getDatabaseSpecificLockStatement(string, serverMetaData, iCondition) + " NOWAIT";
    }

    @Override
    public Object[] insertDatabaseSpecific(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, String string3) throws DataSourceException {
        return this.insertPostgres(string, string2, serverMetaData, objectArray, string3);
    }

    @Override
    protected Map<String, Object> getDefaultValuesIntern(String string, String string2, String string3) throws DataSourceException {
        return super.getDefaultValuesIntern(string, string2, string3.toLowerCase());
    }

    @Override
    protected Object translateDefaultValue(String string, int n, String string2) throws Exception {
        return super.translateDefaultValue(string, n, StringUtil.removeQuotes(string2, "'"));
    }

    @Override
    public SQLException formatSQLException(SQLException sQLException) {
        return this.formatSQLException(sQLException, sQLException.getMessage(), sQLException.getSQLState());
    }

    private Object[] insertPostgres(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, String string3) throws DataSourceException {
        Object[] objectArray2;
        boolean bl;
        int[] nArray = serverMetaData.getPrimaryKeyColumnIndices();
        if (nArray == null || nArray.length == 0) {
            bl = false;
        } else {
            bl = true;
            for (int i = 0; bl && nArray != null && i < nArray.length; ++i) {
                if (objectArray[nArray[i]] == null) continue;
                bl = false;
            }
        }
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer(string2);
            stringBuffer.append(" RETURNING ");
            for (int i = 0; nArray != null && i < nArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(serverMetaData.getServerColumnMetaData(nArray[i]).getColumnName().getQuotedName());
            }
            string2 = stringBuffer.toString();
        }
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        try {
            int n;
            String string4 = this.translateQuotes(string2);
            PostgreSQLDBAccess.debug("executeSQL->", string4);
            callableStatement = this.getConnection().prepareCall(string4);
            ServerColumnMetaData[] serverColumnMetaDataArray = serverMetaData.getServerColumnMetaData();
            int[] nArray2 = serverMetaData.getWritableColumnIndices();
            if (string3 == null) {
                this.setColumnsToStore(callableStatement, serverColumnMetaDataArray, nArray2, objectArray, null);
            } else {
                for (n = 0; n < serverColumnMetaDataArray.length; ++n) {
                    if (!serverColumnMetaDataArray[n].getColumnName().getQuotedName().equals(string3)) continue;
                    callableStatement.setObject(1, null, serverColumnMetaDataArray[n].getSQLType());
                    break;
                }
            }
            if (bl) {
                resultSet = callableStatement.executeQuery();
                if (resultSet.next()) {
                    for (n = 0; nArray != null && n < nArray.length; ++n) {
                        objectArray[nArray[n]] = resultSet.getObject(n + 1);
                    }
                }
            } else {
                callableStatement.executeUpdate();
            }
            objectArray2 = objectArray;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Insert failed! - " + string2, this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                CommonUtil.close(resultSet, callableStatement);
                throw throwable;
            }
        }
        CommonUtil.close(resultSet, callableStatement);
        return objectArray2;
    }

    @Override
    protected int setColumnsToStore(PreparedStatement preparedStatement, ServerColumnMetaData[] serverColumnMetaDataArray, int[] nArray, Object[] objectArray, Object[] objectArray2) throws DataSourceException {
        int n = 1;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (serverColumnMetaDataArray[n2].getDataType().compareTo(objectArray[n2], objectArray2 == null ? null : objectArray2[n2]) == 0) continue;
            try {
                preparedStatement.setObject(n, this.convertValueToDatabaseSpecificObject(objectArray[n2]), serverColumnMetaDataArray[n2].getSQLType());
                ++n;
                continue;
            }
            catch (SQLException sQLException) {
                throw new DataSourceException("Set value into PreparedStatement failed!", this.formatSQLException(sQLException));
            }
        }
        return --n;
    }

    @Override
    public boolean isAutoQuote(String string) {
        StringUtil.CaseSensitiveType caseSensitiveType = StringUtil.getCaseSensitiveType(string);
        return caseSensitiveType != StringUtil.CaseSensitiveType.LowerCase;
    }

    @Override
    public void setUsername(String string) {
        String string2 = string;
        if (string != null) {
            string2 = string2.equals(DBAccess.removeQuotes(string)) ? string2.toLowerCase() : DBAccess.removeQuotes(string);
        }
        super.setUsername(string2);
    }

    @Override
    protected ServerColumnMetaData[] getColumnMetaDataIntern(String string, String[] stringArray, String string2, String string3, String string4) throws DataSourceException {
        ServerColumnMetaData[] serverColumnMetaDataArray = super.getColumnMetaDataIntern(string, stringArray, string2, string3, string4);
        for (int i = 0; i < serverColumnMetaDataArray.length; ++i) {
            if (serverColumnMetaDataArray[i].getSQLType() != 1111 || !this.isEnum(serverColumnMetaDataArray[i])) continue;
            serverColumnMetaDataArray[i].setDetectedType(-900);
            try {
                List<Object> list = this.executeSql("select e.enumlabel from pg_enum e, pg_type t where e.enumtypid = t.oid and t.typtype = 'e' and t.typname = ?", serverColumnMetaDataArray[i].getSQLTypeName());
                if (list == null) continue;
                serverColumnMetaDataArray[i].setAllowedValues(list.toArray());
                continue;
            }
            catch (SQLException sQLException) {
                throw new DataSourceException("Create enum link reference to '" + serverColumnMetaDataArray[i].getName() + "' failed!", sQLException);
            }
        }
        return serverColumnMetaDataArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected TableInfo getTableInfoIntern(String string) throws DataSourceException {
        TableInfo tableInfo;
        long l;
        Object object;
        Object object2;
        block15: {
            Object object3;
            TableInfo tableInfo2 = super.getTableInfoIntern(string);
            String string2 = DBAccess.removeQuotes(tableInfo2.getTable());
            if (tableInfo2.getSchema() != null) {
                object2 = tableInfo2.getSchema();
                object = DBAccess.removeQuotes((String)object2);
                object2 = ((String)object).equals(object2) ? ((String)object2).toLowerCase() : object;
                List<Object[]> list = this.checkTablesAndViews((String)object2, string2);
                if (list.size() == 0) {
                    list = this.checkTablesAndViews(DBAccess.removeQuotes((String)object2), string2.toLowerCase());
                }
                if (list.size() == 1) {
                    return new TableInfo(tableInfo2.getCatalog(), ((Name)list.get(0)[0]).getRealName(), ((Name)list.get(0)[1]).getRealName());
                }
            }
            object2 = null;
            object = null;
            l = System.currentTimeMillis();
            try {
                object2 = this.getPreparedStatement("SHOW search_path", false);
                object = object2.executeQuery();
                if (object.next()) {
                    object3 = object.getString(1);
                    ArrayUtil<String> arrayUtil = StringUtil.separateList((String)object3, ",", true);
                    for (int i = 0; i < arrayUtil.size(); ++i) {
                        List<Object[]> list;
                        String string3 = arrayUtil.get(i);
                        if (string3.contains("$user")) {
                            string3 = this.getUsername();
                        }
                        if ((list = this.checkTablesAndViews(DBAccess.removeQuotes(string3), string2)).size() == 0) {
                            list = this.checkTablesAndViews(DBAccess.removeQuotes(string3), string2.toLowerCase());
                        }
                        if (list.size() != 1) continue;
                        tableInfo = new TableInfo(tableInfo2.getCatalog(), ((Name)list.get(0)[0]).getRealName(), ((Name)list.get(0)[1]).getRealName());
                        break block15;
                    }
                }
                object3 = tableInfo2;
            }
            catch (SQLException sQLException) {
                try {
                    throw new DataSourceException("Jdbc statement close failed", this.formatSQLException(sQLException));
                }
                catch (Throwable throwable) {
                    CommonUtil.close(object, object2);
                    if (PostgreSQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                        PostgreSQLDBAccess.debug("getColumnMetaData() - getDefaultSchema in time=", System.currentTimeMillis() - l);
                    }
                    throw throwable;
                }
            }
            CommonUtil.close(object, object2);
            if (PostgreSQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                PostgreSQLDBAccess.debug("getColumnMetaData() - getDefaultSchema in time=", System.currentTimeMillis() - l);
            }
            return object3;
        }
        CommonUtil.close(object, object2);
        if (PostgreSQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
            PostgreSQLDBAccess.debug("getColumnMetaData() - getDefaultSchema in time=", System.currentTimeMillis() - l);
        }
        return tableInfo;
    }

    @Override
    protected Object convertDatabaseSpecificObjectToValue(ServerColumnMetaData serverColumnMetaData, Object object) throws SQLException {
        if (object instanceof PGobject) {
            return ((PGobject)object).getValue();
        }
        return object;
    }

    @Override
    protected void initializeDataType(ResultSetMetaData resultSetMetaData, int n, ColumnMetaData columnMetaData) throws SQLException, DataSourceException {
        if (resultSetMetaData.getColumnType(n) == 1111) {
            columnMetaData.setTypeIdentifier(12);
            columnMetaData.setPrecision(Integer.MAX_VALUE);
        } else {
            super.initializeDataType(resultSetMetaData, n, columnMetaData);
        }
    }

    @Override
    protected String createWhereParam(ServerMetaData serverMetaData, CompareCondition compareCondition) {
        try {
            ServerColumnMetaData serverColumnMetaData = serverMetaData.getServerColumnMetaData(compareCondition.getColumnName());
            if (serverColumnMetaData.getDetectedType() == -900) {
                return "cast(? as " + serverColumnMetaData.getSQLTypeName() + ")";
            }
            Object object = compareCondition.getValue();
            if (compareCondition instanceof Equals && !this.isTypeEqual(serverColumnMetaData, compareCondition) && !(object instanceof String) || compareCondition instanceof LikeReverse || compareCondition instanceof LikeReverseIgnoreCase || compareCondition instanceof Like || compareCondition instanceof LikeIgnoreCase) {
                return "cast(? as varchar)";
            }
        }
        catch (ModelException modelException) {
            // empty catch block
        }
        return super.createWhereParam(serverMetaData, compareCondition);
    }

    @Override
    protected String createWhereColumn(ServerMetaData serverMetaData, CompareCondition compareCondition, String string) {
        try {
            ServerColumnMetaData serverColumnMetaData = serverMetaData.getServerColumnMetaData(compareCondition.getColumnName());
            if (compareCondition instanceof Equals && !this.isTypeEqual(serverColumnMetaData, compareCondition) && serverColumnMetaData.getTypeIdentifier() != 12 || compareCondition instanceof LikeReverse || compareCondition instanceof LikeReverseIgnoreCase || compareCondition instanceof Like || compareCondition instanceof LikeIgnoreCase) {
                return "cast(" + string + " as varchar)";
            }
        }
        catch (ModelException modelException) {
            // empty catch block
        }
        return super.createWhereColumn(serverMetaData, compareCondition, string);
    }

    private List<Object[]> checkTablesAndViews(String string, String string2) throws DataSourceException {
        ArrayUtil<Object[]> arrayUtil;
        long l = System.currentTimeMillis();
        ResultSet resultSet = null;
        try {
            resultSet = this.getConnection().getMetaData().getTables(this.getConnection().getCatalog(), string, string2, new String[]{"TABLE", "VIEW"});
            ArrayUtil<Object[]> arrayUtil2 = new ArrayUtil<Object[]>();
            while (resultSet.next()) {
                arrayUtil2.add(new Object[]{new Name(resultSet.getString("TABLE_SCHEM"), this.quote(resultSet.getString("TABLE_SCHEM"))), new Name(resultSet.getString("TABLE_NAME"), this.quote(resultSet.getString("TABLE_NAME"))), resultSet.getString("TABLE_TYPE"), resultSet.getString("REMARKS")});
            }
            arrayUtil = arrayUtil2;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Jdbc statement close failed", this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                CommonUtil.close(resultSet);
                if (PostgreSQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                    PostgreSQLDBAccess.debug("getTables() time=", System.currentTimeMillis() - l);
                }
                throw throwable;
            }
        }
        CommonUtil.close(resultSet);
        if (PostgreSQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
            PostgreSQLDBAccess.debug("getTables() time=", System.currentTimeMillis() - l);
        }
        return arrayUtil;
    }

    protected boolean isEnum(ServerColumnMetaData serverColumnMetaData) throws DataSourceException {
        if (serverColumnMetaData.getSQLType() == 1111) {
            String string = serverColumnMetaData.getSQLTypeName();
            try {
                List<Object> list = this.executeSql("select oid from pg_type where typname = ? and typtype = 'e'", string);
                if (list == null) {
                    return false;
                }
                return list.size() == 1;
            }
            catch (SQLException sQLException) {
                throw new DataSourceException("Enum detection failed", this.formatSQLException(sQLException));
            }
        }
        return false;
    }
}

