/*
 * Copyright 2013 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 01.10.2013 - [HM] - creation
 */
package javax.rad.ui.control;


/**
 * The <code>IControl</code> inform about changes in the 
 * <code>IDataRow/IDataBook</code> and GUI controls need to repaint the data part.
 * It also inform the GUI controls, that the editing mode in the control should be 
 * save or cancel the last change.
 * 
 * @see javax.rad.model.IDataRow
 * @see javax.rad.model.IDataBook
 * @author Roland Hrmann
 */
public interface INavigationControl
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Constants
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/** Navigation mode none. */
	public static final int NAVIGATION_NONE = 0;
	/** Navigation mode cell and focus. */
	public static final int NAVIGATION_CELL_AND_FOCUS = 1;
	/** Navigation mode cell and row and focus. */
	public static final int NAVIGATION_CELL_AND_ROW_AND_FOCUS = 2;
	/** Navigation mode row and focus. */
	public static final int NAVIGATION_ROW_AND_FOCUS = 3;
	
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Method definitions
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
     * Gets the ENTER navigation mode.
     *
     * @return the ENTER navigation mode.
     */
    public int getEnterNavigationMode();

	/**
     * Sets the ENTER navigation mode.
     *
     * @param pNavigationMode the ENTER navigation mode.
     */
    public void setEnterNavigationMode(int pNavigationMode);

	/**
     * Gets the ENTER navigation mode.
     *
     * @return the ENTER navigation mode.
     */
    public int getTabNavigationMode();

	/**
     * Sets the ENTER navigation mode.
     *
     * @param pNavigationMode the ENTER navigation mode.
     */
    public void setTabNavigationMode(int pNavigationMode);

} 	// INavigationControl
