/*
 * Copyright 2011 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 * 
 * 11.12.2011 - [JR] - creation
 */
package com.sibvisions.rad.server.http.rest.service;

import java.util.concurrent.ConcurrentMap;

import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.Put;

import com.sibvisions.rad.server.DirectServerSession;
import com.sibvisions.rad.server.http.rest.JSONUtil;
import com.sibvisions.rad.server.http.rest.LifeCycleConnector;
import com.sibvisions.rad.server.http.rest.RESTAdapter;

/**
 * The <code>CallService</code> allows action or object calls.
 * 
 * @author Ren Jahn
 */
public class CallService extends AbstractService
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// User-defined methods
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * Executes an object or action call without parameters.
	 * 
	 * @return the call result in JSON representation
	 */
	@Get
	public Representation call()
	{
		try
		{
			DirectServerSession session = ((LifeCycleConnector)getRequest().getClientInfo().getUser()).getSession();
			
			ConcurrentMap<String, Object> cmpAttrib = getRequest().getAttributes();
	
			String sObjectName = (String)cmpAttrib.get(RESTAdapter.PARAM_OBJECT_NAME);
			String sActionName = (String)cmpAttrib.get(RESTAdapter.PARAM_ACTION_NAME);
	
			Object oResult;
			
			if (sObjectName != null)
			{
				oResult = session.call(sObjectName, sActionName);
			}
			else
			{
				oResult = session.callAction(sActionName);
			}

			Representation rep = toRepresentation(oResult);

			setStatus(Status.SUCCESS_OK);
			
			return rep;
		}
		catch (Throwable th)
		{
		    return handleException(th);
		}
	}

	/**
	 * Executes an object or action call with or without parameters.
	 * 
	 * @param pParameter the call parameter
	 * @return call result in JSON representation
	 */
	@Put
	@Post
	public Representation call(Representation pParameter)
	{
		try
		{
			Object[] oParams;
			
			if (pParameter != null)
			{
				oParams = JSONUtil.getObject(pParameter, Object[].class);
			}
			else
			{
				oParams = null;
			}
			
			DirectServerSession session = ((LifeCycleConnector)getRequest().getClientInfo().getUser()).getSession();
			
			ConcurrentMap<String, Object> cmpAttrib = getRequest().getAttributes();
	
			String sObjectName = (String)cmpAttrib.get(RESTAdapter.PARAM_OBJECT_NAME);
			String sActionName = (String)cmpAttrib.get(RESTAdapter.PARAM_ACTION_NAME);
	
			Object oResult;
			
			if (sObjectName != null)
			{
				oResult = session.call(sObjectName, sActionName, oParams);
			}
			else
			{
				oResult = session.callAction(sActionName, oParams);
			}
			
			return toRepresentation(oResult);
		}
		catch (Throwable th)
		{
		    return handleException(th);
		}
	}
	
}	// CallService
