/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.model.datatype;

import com.sibvisions.util.type.FileUtil;
import java.io.IOException;
import javax.rad.io.RemoteFileHandle;
import javax.rad.model.ModelException;
import javax.rad.model.datatype.DataType;
import javax.rad.model.ui.ICellEditor;

public class BinaryDataType
extends DataType {
    public static final int TYPE_IDENTIFIER = -2;

    public BinaryDataType() {
    }

    public BinaryDataType(int n) {
        this.setSize(n);
    }

    public BinaryDataType(ICellEditor iCellEditor) {
        this.setCellEditor(iCellEditor);
    }

    public BinaryDataType(int n, ICellEditor iCellEditor) {
        this.setSize(n);
        this.setCellEditor(iCellEditor);
    }

    public int getTypeIdentifier() {
        return -2;
    }

    public Class getTypeClass() {
        if (this.getCellEditor() != null || this.getCellRenderer() != null) {
            return Object.class;
        }
        return byte[].class;
    }

    public Object convertAndCheckToTypeClass(Object object) throws ModelException {
        if (object instanceof RemoteFileHandle) {
            return object;
        }
        byte[] byArray = (byte[])this.convertToTypeClass(object);
        if (byArray == null) {
            return null;
        }
        if (byArray.length > this.getSize()) {
            throw new ModelException("Binary too large! - length from " + byArray.length + " to " + this.getSize());
        }
        return byArray;
    }

    public String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        return new String((byte[])object);
    }

    public Object convertToTypeClass(Object object) throws ModelException {
        if (object == null) {
            return null;
        }
        if (object instanceof RemoteFileHandle) {
            return object;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (byArray.length == 0) {
                return null;
            }
            return byArray;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0) {
                return null;
            }
            return string.getBytes();
        }
        throw new ModelException("Conversion failed! Type not supported ! from " + object.getClass().getName() + " to " + this.getTypeClass().getName());
    }

    public int compareTo(Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object != null && object2 != null && object instanceof byte[]) {
            try {
                byte[] byArray = (byte[])object;
                byte[] byArray2 = (byte[])this.convertToTypeClass(object2);
                if (byArray.length < byArray2.length) {
                    return -1;
                }
                if (byArray.length > byArray2.length) {
                    return 1;
                }
                for (int i = 0; i < byArray.length; ++i) {
                    if (byArray[i] < byArray2[i]) {
                        return -1;
                    }
                    if (byArray[i] <= byArray2[i]) continue;
                    return 1;
                }
                return 0;
            }
            catch (ModelException modelException) {
                return -1;
            }
        }
        return super.compareTo(object, object2);
    }

    public BinaryDataType clone() {
        return (BinaryDataType)super.clone();
    }

    public Object prepareValue(Object object) throws ModelException {
        if (object instanceof RemoteFileHandle && this.getCellEditor() != null) {
            RemoteFileHandle remoteFileHandle = (RemoteFileHandle)object;
            try {
                return FileUtil.getContent(remoteFileHandle.getInputStream());
            }
            catch (IOException iOException) {
                throw new ModelException(iOException);
            }
        }
        return object;
    }
}

