/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server.protocol;

import com.sibvisions.rad.server.protocol.IProtocolWriter;
import com.sibvisions.rad.server.protocol.Record;

public abstract class ProtocolFactory {
    private static ProtocolFactory factory = null;
    private static ThreadLocal<IProtocolWriter> thlWriter = null;

    protected ProtocolFactory() {
    }

    public abstract IProtocolWriter createWriter();

    public static synchronized void init(String string) {
        if (factory != null) {
            if (string == null) {
                throw new RuntimeException("The protocol factory can't be null!");
            }
            String string2 = string;
            if (!factory.getClass().getName().equals(string2)) {
                throw new RuntimeException("The protocol factory was already initialized!");
            }
        } else {
            try {
                factory = (ProtocolFactory)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static synchronized ProtocolFactory getInstance() {
        return factory;
    }

    public static synchronized IProtocolWriter getWriter() {
        if (factory == null) {
            return null;
        }
        if (thlWriter == null) {
            IProtocolWriter iProtocolWriter = factory.createWriter();
            thlWriter = new ThreadLocal();
            thlWriter.set(iProtocolWriter);
            return iProtocolWriter;
        }
        IProtocolWriter iProtocolWriter = thlWriter.get();
        if (iProtocolWriter == null) {
            iProtocolWriter = factory.createWriter();
            thlWriter.set(iProtocolWriter);
        }
        return iProtocolWriter;
    }

    public static Record openRecord(String string, Object ... objectArray) {
        IProtocolWriter iProtocolWriter = ProtocolFactory.getWriter();
        if (iProtocolWriter == null) {
            return null;
        }
        Record record = iProtocolWriter.openRecord(string);
        if (record != null) {
            record.setParameter(objectArray);
        }
        return record;
    }
}

