/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server.http.rest.service;

import com.sibvisions.rad.persist.AbstractStorage;
import com.sibvisions.rad.server.DirectServerSession;
import com.sibvisions.rad.server.http.rest.JSONUtil;
import com.sibvisions.rad.server.http.rest.LifeCycleConnector;
import com.sibvisions.rad.server.http.rest.service.AbstractService;
import com.sibvisions.util.ArrayUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.rad.model.ModelException;
import javax.rad.model.condition.BaseCondition;
import javax.rad.model.condition.Equals;
import javax.rad.model.condition.ICondition;
import javax.rad.persist.ColumnMetaData;
import javax.rad.persist.DataSourceException;
import javax.rad.persist.IStorage;
import javax.rad.persist.MetaData;
import javax.rad.type.bean.IBean;
import org.codehaus.jackson.map.util.StdDateFormat;
import org.restlet.data.Form;
import org.restlet.data.Parameter;
import org.restlet.data.Status;
import org.restlet.ext.jackson.JacksonRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;
import org.restlet.resource.Options;
import org.restlet.resource.Post;
import org.restlet.resource.Put;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorageService
extends AbstractService {
    private static final StdDateFormat DATE_FORMAT = StdDateFormat.instance;

    @Get
    public Representation executeFetch() {
        try {
            DirectServerSession directServerSession = this.getSession();
            ConcurrentMap concurrentMap = this.getRequest().getAttributes();
            AbstractStorage abstractStorage = (AbstractStorage)directServerSession.get((String)concurrentMap.get("OBJECT_NAME"));
            List<IBean> list = abstractStorage.fetchBean(this.getCondition(abstractStorage), null, 0, -1);
            JacksonRepresentation jacksonRepresentation = this.toRepresentation(list);
            this.setStatus(Status.SUCCESS_OK);
            return jacksonRepresentation;
        }
        catch (Throwable throwable) {
            return this.handleException(throwable);
        }
    }

    @Post
    public Representation executeInsert(Representation representation) {
        if (representation == null) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return null;
        }
        try {
            DirectServerSession directServerSession = this.getSession();
            ConcurrentMap concurrentMap = this.getRequest().getAttributes();
            AbstractStorage abstractStorage = (AbstractStorage)directServerSession.get((String)concurrentMap.get("OBJECT_NAME"));
            HashMap hashMap = (HashMap)JSONUtil.getObject(representation, HashMap.class);
            if (hashMap == null) {
                this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                return null;
            }
            IBean iBean = abstractStorage.createEmptyBean();
            this.copyValues(abstractStorage, iBean, hashMap);
            iBean = abstractStorage.insert(iBean);
            return this.toRepresentation(iBean);
        }
        catch (Throwable throwable) {
            return this.handleException(throwable);
        }
    }

    @Put
    public Representation executeUpdate(Representation representation) {
        if (representation == null) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return null;
        }
        try {
            DirectServerSession directServerSession = this.getSession();
            ConcurrentMap concurrentMap = this.getRequest().getAttributes();
            AbstractStorage abstractStorage = (AbstractStorage)directServerSession.get((String)concurrentMap.get("OBJECT_NAME"));
            List<IBean> list = abstractStorage.fetchBean(this.getCondition(abstractStorage), null, 0, 2);
            if (list.size() == 0) {
                this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                return null;
            }
            if (list.size() > 1) {
                this.setStatus(Status.CLIENT_ERROR_CONFLICT);
                return null;
            }
            HashMap hashMap = (HashMap)JSONUtil.getObject(representation, HashMap.class);
            if (hashMap == null) {
                this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                return null;
            }
            IBean iBean = list.get(0);
            this.copyValues(abstractStorage, iBean, hashMap);
            abstractStorage.update(iBean);
            return this.toRepresentation(iBean);
        }
        catch (Throwable throwable) {
            return this.handleException(throwable);
        }
    }

    @Delete
    public Representation executeDelete() {
        try {
            DirectServerSession directServerSession = this.getSession();
            ConcurrentMap concurrentMap = this.getRequest().getAttributes();
            AbstractStorage abstractStorage = (AbstractStorage)directServerSession.get((String)concurrentMap.get("OBJECT_NAME"));
            ICondition iCondition = this.getCondition(abstractStorage);
            List<IBean> list = abstractStorage.fetchBean(iCondition, null, 0, 2);
            if (list.size() == 0) {
                this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                return null;
            }
            if (concurrentMap.get("PK") != null && list.size() > 1) {
                this.setStatus(Status.CLIENT_ERROR_CONFLICT);
                return null;
            }
            this.info("Number of records to delete: ", list.size());
            if (!this.isDryRun()) {
                for (IBean iBean : list) {
                    abstractStorage.delete(iBean);
                }
            }
            return this.toRepresentation(list.size());
        }
        catch (Throwable throwable) {
            return this.handleException(throwable);
        }
    }

    @Options
    public Representation executeGetMetaData() {
        try {
            DirectServerSession directServerSession = this.getSession();
            ConcurrentMap concurrentMap = this.getRequest().getAttributes();
            AbstractStorage abstractStorage = (AbstractStorage)directServerSession.get((String)concurrentMap.get("OBJECT_NAME"));
            return this.toRepresentation(abstractStorage.getMetaData());
        }
        catch (Throwable throwable) {
            return this.handleException(throwable);
        }
    }

    private ICondition getCondition(IStorage iStorage) throws DataSourceException {
        BaseCondition baseCondition = null;
        MetaData metaData = iStorage.getMetaData();
        String[] stringArray = metaData.getPrimaryKeyColumnNames();
        Object v = this.getRequest().getAttributes().get("PK");
        if (v != null) {
            if (stringArray == null || stringArray.length > 1) {
                this.setStatus(Status.CLIENT_ERROR_CONFLICT);
                return null;
            }
            baseCondition = new Equals(stringArray[0], this.convertValue(metaData, stringArray[0], v));
        }
        String[] stringArray2 = metaData.getColumnNames();
        Form form = this.getQuery();
        int n = form.size();
        for (int i = 0; i < n; ++i) {
            Parameter parameter = (Parameter)form.get(i);
            String string = parameter.getName().toUpperCase();
            String string2 = parameter.getValue();
            if (string2 != null && string2.length() == 0) {
                string2 = null;
            }
            if (!ArrayUtil.contains(stringArray2, string)) continue;
            baseCondition = baseCondition == null ? new Equals(string, this.convertValue(metaData, string, string2)) : baseCondition.and(new Equals(string, this.convertValue(metaData, string, string2)));
        }
        return baseCondition;
    }

    private void copyValues(AbstractStorage abstractStorage, IBean iBean, HashMap<String, Object> hashMap) throws Exception {
        MetaData metaData = abstractStorage.getMetaData();
        String[] stringArray = metaData.getColumnNames();
        String[] stringArray2 = metaData.getPrimaryKeyColumnNames();
        for (Map.Entry<String, Object> entry : hashMap.entrySet()) {
            String string = entry.getKey().toUpperCase();
            if (!ArrayUtil.contains(stringArray, string) || stringArray2 != null && ArrayUtil.contains(stringArray2, string)) continue;
            Object object = entry.getValue();
            if (metaData.getColumnMetaData(string).getTypeIdentifier() == 93) {
                object = DATE_FORMAT.parse(object.toString());
            }
            if (object instanceof Number && !(object instanceof BigDecimal)) {
                object = object instanceof BigInteger ? new BigDecimal((BigInteger)object) : new BigDecimal(((Number)object).toString());
            }
            iBean.put(string, object);
        }
    }

    private Object convertValue(MetaData metaData, String string, Object object) {
        try {
            return ColumnMetaData.createDataType(metaData.getColumnMetaData(string)).convertToTypeClass(object);
        }
        catch (ModelException modelException) {
            throw new RuntimeException(modelException);
        }
    }

    private DirectServerSession getSession() {
        return ((LifeCycleConnector)this.getRequest().getClientInfo().getUser()).getSession();
    }
}

