/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server.config;

import com.sibvisions.rad.server.config.AppSettings;
import com.sibvisions.rad.server.config.ApplicationZone;
import com.sibvisions.rad.server.config.IVirtualZone;
import com.sibvisions.rad.server.config.ServerZone;
import com.sibvisions.rad.server.config.UpToDateConfigFile;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.SecureHash;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.FileUtil;
import com.sibvisions.util.type.ResourceUtil;
import com.sibvisions.util.xml.XmlNode;
import com.sibvisions.util.xml.XmlWorker;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import javax.naming.InitialContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Configuration {
    private static final String NAME_RAD = "rad";
    private static final String NAME_APPS = "apps";
    private static final String NAME_SERVER = "server";
    private static String sOldBaseDir = null;
    private static File fiBaseDir = null;
    private static File fiConfigDir = null;
    private static File fiAppsDir = null;
    private static File fiServerDir = null;
    private static Hashtable<String, ApplicationZone> htAppZones = null;
    private static ServerZone zoServer = null;
    private static AppSettings asApps = null;

    private Configuration() {
    }

    private static void initDirectories() {
        String string = ResourceUtil.getAccessibleProperty("Configuration.basedir", "");
        if (sOldBaseDir == null || !string.equals(sOldBaseDir)) {
            Configuration.clearCache();
            String string2 = ResourceUtil.getFqClassName(Configuration.class);
            String string3 = ResourceUtil.getLocationForClass(string2);
            if (string3 != null) {
                Object object;
                Object object2;
                if (string.trim().length() == 0 || !new File(string).exists()) {
                    object2 = new File(string3);
                    if (!((File)object2).isDirectory()) {
                        object2 = new File(((File)object2).getParentFile().getParentFile(), "classes");
                    }
                    fiBaseDir = ((File)object2).getParentFile();
                } else {
                    fiBaseDir = new File(string);
                }
                fiConfigDir = new File(fiBaseDir, NAME_RAD);
                if (!fiConfigDir.exists()) {
                    object2 = fiBaseDir;
                    for (int i = 0; object2 != null && i < 5; ++i) {
                        object = ((File)object2).getName();
                        if (((String)object).equalsIgnoreCase(NAME_APPS) || ((String)object).equalsIgnoreCase(NAME_SERVER)) {
                            if ((object2 = ((File)object2).getParentFile()) == null || !((File)object2).getName().equals(NAME_RAD)) continue;
                            fiBaseDir = ((File)object2).getParentFile();
                            fiConfigDir = new File(fiBaseDir, NAME_RAD);
                            object2 = null;
                            continue;
                        }
                        object2 = ((File)object2).getParentFile();
                    }
                }
                if (!fiConfigDir.exists()) {
                    Object object3;
                    object2 = ResourceUtil.getResourceAsStream("/jvx_rad.jar");
                    object = null;
                    if (object2 == null) {
                        URL uRL = ResourceUtil.getResource(ResourceUtil.getFqClassName(Configuration.class));
                        object3 = uRL.toExternalForm();
                        object3 = ((String)object3).substring(0, ((String)object3).indexOf(string2));
                        try {
                            int n = ((String)object3).lastIndexOf(47);
                            n = ((String)object3).lastIndexOf(47, n - 1);
                            object3 = ((String)object3).substring(0, n) + "/rad.zip";
                            object = new URL((String)object3);
                            object2 = ((URL)object).openStream();
                        }
                        catch (Exception exception) {
                            object = null;
                            LoggerFactory.getInstance(Configuration.class).debug("Base directory is not available!", exception);
                        }
                    }
                    if (object2 != null) {
                        try {
                            String string4 = SecureHash.getHash("MD5", (InputStream)object2);
                            object2 = (InputStream)CommonUtil.close(object2);
                            object2 = object == null ? ResourceUtil.getResourceAsStream("/jvx_rad.jar") : ((URL)object).openStream();
                            object3 = new File(System.getProperty("java.io.tmpdir"), "rad_" + string4);
                            if (!((File)object3).exists()) {
                                FileUtil.unzip((InputStream)object2, (File)object3);
                            }
                            fiConfigDir = new File((File)object3, NAME_RAD);
                        }
                        catch (Exception exception) {
                            LoggerFactory.getInstance(Configuration.class).debug("Base directory is not available!", exception);
                        }
                    }
                }
                fiAppsDir = new File(fiConfigDir, NAME_APPS);
                fiServerDir = new File(fiConfigDir, NAME_SERVER);
                sOldBaseDir = string;
            }
        }
    }

    public static File getConfigurationDir() {
        Configuration.initDirectories();
        return fiConfigDir;
    }

    public static File getApplicationsDir() {
        Configuration.initDirectories();
        return fiAppsDir;
    }

    public static File getServerDir() {
        Configuration.initDirectories();
        return fiServerDir;
    }

    public static ApplicationZone getApplicationZone(String string) throws Exception {
        ApplicationZone applicationZone = null;
        if (string == null || string.trim().length() == 0) {
            applicationZone = new ApplicationZone((File)null);
        } else {
            if (htAppZones != null && (applicationZone = htAppZones.get(string)) != null) {
                applicationZone.setUpdateEnabled(true);
            }
            if (applicationZone != null && !applicationZone.isValid()) {
                htAppZones.remove(string);
                applicationZone = null;
            }
            if (applicationZone == null) {
                Object object;
                int n;
                Object object2;
                Object object3;
                File file = new File(Configuration.getApplicationsDir(), string);
                if (!ApplicationZone.isValid(file)) {
                    object3 = Configuration.getAppSettings();
                    object2 = ((AppSettings)object3).getAppLocations();
                    if (object2 != null) {
                        n = object2.size();
                        for (int i = 0; i < n && applicationZone == null; ++i) {
                            object = new File(object2.get(i), string);
                            if (!ApplicationZone.isValid((File)object)) continue;
                            applicationZone = new ApplicationZone((File)object);
                        }
                    }
                } else {
                    applicationZone = new ApplicationZone(file);
                }
                if (applicationZone == null) {
                    object = new XmlWorker();
                    n = 0;
                    for (object3 = Configuration.getApplicationsDir(); object3 != null && applicationZone == null && n < 5; object3 = ((File)object3).getParentFile()) {
                        ++n;
                        object2 = new File((File)object3, "config.xml");
                        if (!((File)object2).exists() || !((File)object2).canRead()) continue;
                        if (string.equals(((File)object3).getName())) {
                            applicationZone = new ApplicationZone((File)object3);
                            continue;
                        }
                        try {
                            XmlNode xmlNode = ((XmlWorker)object).read((File)object2);
                            if (xmlNode != null && xmlNode.getSubNodes() != null && xmlNode.getNode("/application") == null) continue;
                            applicationZone = new ApplicationZone((File)object3);
                            continue;
                        }
                        catch (Exception exception) {
                            LoggerFactory.getInstance(Configuration.class).debug("Invalid config.xml '", object2, "'", exception);
                        }
                    }
                }
                if (applicationZone == null && (object3 = Configuration.loadConfiguration(string.toLowerCase())) != null) {
                    applicationZone = new ApplicationZone((InputStream)object3);
                }
                if (applicationZone == null && Boolean.getBoolean("Configuration.search.classpath")) {
                    object3 = ResourceUtil.getResourceAsStream("/rad/apps/" + string.toLowerCase() + "/config.xml");
                    if (object3 == null) {
                        object3 = ResourceUtil.getResourceAsStream("/config.xml");
                    }
                    if (object3 != null) {
                        applicationZone = new ApplicationZone((InputStream)object3);
                    }
                }
                if (applicationZone == null) {
                    applicationZone = new ApplicationZone(file);
                }
                if (htAppZones == null) {
                    htAppZones = new Hashtable();
                }
                htAppZones.put(string, applicationZone);
            }
        }
        return applicationZone;
    }

    public static ServerZone getServerZone() {
        if (zoServer == null) {
            Object object;
            Object object2;
            if (!Configuration.getServerDir().exists()) {
                XmlWorker xmlWorker = new XmlWorker();
                Object var4_4 = null;
                int n = 0;
                for (object2 = Configuration.getServerDir(); object2 != null && var4_4 == null && n < 5; object2 = ((File)object2).getParentFile()) {
                    ++n;
                    object = new File((File)object2, "server.xml");
                    if (!((File)object).exists() || !((File)object).canRead()) continue;
                    try {
                        XmlNode xmlNode = xmlWorker.read((File)object);
                        if (xmlNode != null && xmlNode.getSubNodes() != null && xmlNode.getNode("/server") == null) continue;
                        zoServer = new ServerZone((File)object2, "server.xml");
                        return zoServer;
                    }
                    catch (Exception exception) {
                        LoggerFactory.getInstance(Configuration.class).debug("Invalid server.xml '", object, "'", exception);
                    }
                }
            } else {
                try {
                    object2 = new ServerZone(Configuration.getServerDir());
                    if (((UpToDateConfigFile)object2).getNode("/server") != null) {
                        zoServer = object2;
                        return zoServer;
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            if ((object2 = Configuration.loadConfiguration(NAME_SERVER)) != null) {
                try {
                    zoServer = new ServerZone((InputStream)object2);
                    return zoServer;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            if (Boolean.getBoolean("Configuration.search.classpath")) {
                object = ResourceUtil.getResourceAsStream("/rad/server/config.xml");
                if (object == null) {
                    object = ResourceUtil.getResourceAsStream("/server.xml");
                }
                if (object != null) {
                    try {
                        zoServer = new ServerZone((InputStream)object);
                        return zoServer;
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
            }
            zoServer = new ServerZone();
        } else if (!zoServer.isValid()) {
            zoServer = null;
        } else {
            zoServer.setUpdateEnabled(true);
        }
        return zoServer;
    }

    public static List<String> listApplicationNames(ApplicationListOption applicationListOption) {
        ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
        for (File file : Configuration.listApplicationDirectories(applicationListOption)) {
            arrayUtil.add(file.getName());
        }
        return arrayUtil;
    }

    public static boolean isApplication(String string) {
        if (string != null) {
            if (!ApplicationZone.isValid(new File(Configuration.getApplicationsDir(), string))) {
                AppSettings appSettings = Configuration.getAppSettings();
                List<String> list = appSettings.getAppLocations();
                if (list != null) {
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        File file = new File(list.get(i), string);
                        if (!ApplicationZone.isValid(file)) continue;
                        return true;
                    }
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static AppSettings getAppSettings() {
        if (asApps == null) {
            Configuration.initDirectories();
            try {
                asApps = new AppSettings(fiConfigDir);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return asApps;
    }

    public static List<File> listApplicationDirectories(ApplicationListOption applicationListOption) {
        ArrayUtil<File> arrayUtil = new ArrayUtil<File>();
        File[] fileArray = Configuration.getApplicationsDir().listFiles();
        AppSettings appSettings = Configuration.getAppSettings();
        List<String> list = appSettings.getAppLocations();
        if (list != null) {
            for (String object : list) {
                File[] fileArray2;
                File file = new File(object);
                if (!file.exists() || (fileArray2 = new File(object).listFiles()) == null || fileArray2.length <= 0) continue;
                fileArray = ArrayUtil.addAll(fileArray, fileArray2);
            }
        }
        if (fileArray != null) {
            if (applicationListOption == null) {
                applicationListOption = ApplicationListOption.Visible;
            }
            block5: for (File file : fileArray) {
                if (!file.isDirectory()) continue;
                switch (applicationListOption) {
                    case Hidden: {
                        if (!file.isHidden() && file.getName().charAt(0) != '.') continue block5;
                        arrayUtil.add(file);
                        continue block5;
                    }
                    case Visible: {
                        if (file.isHidden() || file.getName().charAt(0) == '.') continue block5;
                        arrayUtil.add(file);
                        continue block5;
                    }
                    default: {
                        arrayUtil.add(file);
                    }
                }
            }
        }
        return arrayUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static InputStream loadConfiguration(String string) {
        try {
            InputStream inputStream;
            InitialContext initialContext;
            block10: {
                InputStream inputStream2;
                block9: {
                    InputStream inputStream3;
                    block8: {
                        InputStream inputStream4;
                        block7: {
                            initialContext = new InitialContext();
                            try {
                                Object object = initialContext.lookup("java:/comp/env/jvx/" + string + "/config");
                                if (object instanceof String) {
                                    inputStream4 = ResourceUtil.getResourceAsStream((String)object);
                                    Object var5_8 = null;
                                    break block7;
                                }
                                if (object instanceof IVirtualZone) {
                                    inputStream3 = ((IVirtualZone)object).getConfiguration();
                                    break block8;
                                }
                                if (object instanceof InputStream) {
                                    inputStream2 = (InputStream)object;
                                    break block9;
                                }
                                inputStream = null;
                                break block10;
                            }
                            catch (Throwable throwable) {
                                Object var5_12 = null;
                                initialContext.close();
                                throw throwable;
                            }
                        }
                        initialContext.close();
                        return inputStream4;
                    }
                    Object var5_9 = null;
                    initialContext.close();
                    return inputStream3;
                }
                Object var5_10 = null;
                initialContext.close();
                return inputStream2;
            }
            Object var5_11 = null;
            initialContext.close();
            return inputStream;
        }
        catch (Exception exception) {
            LoggerFactory.getInstance(Configuration.class).debug("Couldn't load virtual zone '", string, "' via JNDI!", exception);
            return null;
        }
    }

    public static void clearCache() {
        zoServer = null;
        htAppZones = null;
        asApps = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ApplicationListOption {
        All,
        Visible,
        Hidden;

    }
}

