/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.remote.ISerializer;
import com.sibvisions.rad.server.AbstractSession;
import com.sibvisions.rad.server.Call;
import com.sibvisions.rad.server.DefaultObjectProvider;
import com.sibvisions.rad.server.DefaultSessionManager;
import com.sibvisions.rad.server.IDirectServer;
import com.sibvisions.rad.server.IRequest;
import com.sibvisions.rad.server.IResponse;
import com.sibvisions.rad.server.Monitoring;
import com.sibvisions.rad.server.ServerContextImpl;
import com.sibvisions.rad.server.config.Configuration;
import com.sibvisions.rad.server.config.ServerZone;
import com.sibvisions.rad.server.plugin.IServerPlugin;
import com.sibvisions.rad.server.protocol.ProtocolFactory;
import com.sibvisions.rad.server.protocol.Record;
import com.sibvisions.rad.server.security.AbstractSecurityManager;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.ChangedHashtable;
import com.sibvisions.util.Reflective;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.StringUtil;
import com.sibvisions.util.xml.XmlNode;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.naming.InitialContext;
import javax.rad.remote.IConnectionConstants;
import javax.rad.remote.event.ICallBackListener;
import javax.rad.server.AbstractObjectProvider;
import javax.rad.server.ISession;
import javax.rad.server.ResultObject;
import javax.rad.server.ServerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
implements IDirectServer {
    private static final Exception EXCEPTION_CONTENT = new Exception("Invalid content!");
    private ILogger log;
    private static Server instance = null;
    private DefaultSessionManager sessman = null;
    private AbstractObjectProvider objectprov = null;
    private Monitoring monitoring = null;
    private WeakHashMap<ISession, CachedResponse> whmResponse = new WeakHashMap();

    public Server() {
        Object object;
        String string;
        ServerZone serverZone = Configuration.getServerZone();
        try {
            string = serverZone.getProperty("logfactory");
        }
        catch (Exception exception) {
            string = null;
        }
        LoggerFactory.init(string);
        this.log = LoggerFactory.getInstance(Server.class);
        try {
            object = serverZone.getProperty("/server/sessionmanager/class");
            this.sessman = (DefaultSessionManager)Reflective.construct((String)object, this);
            this.log.debug("Use ", object, " as SessionManager");
        }
        catch (Throwable throwable) {
            this.log.debug("NO PROBLEM! Use default SessionManager", throwable);
            this.sessman = new DefaultSessionManager(this);
        }
        try {
            object = serverZone.getProperty("/server/sessionmanager/controllerInterval");
            if (!StringUtil.isEmpty((String)object)) {
                DefaultSessionManager.setControllerInterval(Long.parseLong((String)object));
            }
        }
        catch (Throwable throwable) {
            this.log.debug(throwable);
        }
        try {
            object = serverZone.getProperty("/server/objectprovider/class");
            this.objectprov = (AbstractObjectProvider)Reflective.construct((String)object, this);
            this.log.debug("Use ", object, " as ObjectProvider");
        }
        catch (Throwable throwable) {
            this.log.debug("NO PROBLEM! Use default ObjectProvider", throwable);
            this.objectprov = new DefaultObjectProvider(this);
        }
        this.monitoring = new Monitoring(this);
        try {
            object = serverZone.getNodes("/server/plugin");
            if (object != null) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    XmlNode xmlNode = (XmlNode)iterator.next();
                    String string2 = xmlNode.getNodeValue("/class");
                    try {
                        IServerPlugin iServerPlugin = (IServerPlugin)Reflective.construct(string2, new Object[0]);
                        iServerPlugin.install(this);
                    }
                    catch (Throwable throwable) {
                        this.log.error("Can't install plugin '", string2, "'", throwable);
                    }
                }
            }
        }
        catch (Exception exception) {
            this.log.debug("Can't access plugin configuration!", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Server getInstance() {
        if (instance == null) {
            try {
                InitialContext initialContext = new InitialContext();
                try {
                    if (initialContext != null) {
                        instance = (Server)initialContext.lookup("java:/comp/env/jvx/server");
                    }
                    Object var2_2 = null;
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    initialContext.close();
                    throw throwable;
                }
                initialContext.close();
                {
                }
            }
            catch (Exception exception) {
                LoggerFactory.getInstance(Server.class).debug("Server is not configured as JNDI resource", exception);
            }
            if (instance == null) {
                instance = new Server();
            }
        }
        return instance;
    }

    @Override
    public final DefaultSessionManager getSessionManager() {
        return this.sessman;
    }

    @Override
    public final AbstractObjectProvider getObjectProvider() {
        return this.objectprov;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object createSession(ChangedHashtable<String, Object> changedHashtable) throws Throwable {
        Object object;
        Record record = ProtocolFactory.openRecord("createSession", new Object[0]);
        ServerContext serverContext = this.createServerContext();
        try {
            block7: {
                Throwable throwable = null;
                Object object2 = null;
                long l = System.currentTimeMillis();
                try {
                    object = object2 = this.createSessionIntern(null, null, changedHashtable);
                    Object var10_9 = null;
                    if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) break block7;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = AbstractSecurityManager.prepareException(throwable2);
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        Object var10_10 = null;
                        if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) throw throwable3;
                        this.log(null, "Session!", "createSession", new Object[]{changedHashtable}, null, object2, throwable, System.currentTimeMillis() - l);
                        throw throwable3;
                    }
                }
                this.log(null, "Session!", "createSession", new Object[]{changedHashtable}, null, object2, throwable, System.currentTimeMillis() - l);
            }
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            CommonUtil.close(record);
            serverContext.release();
            throw throwable;
        }
        CommonUtil.close(record);
        serverContext.release();
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object createSubSession(Object object, ChangedHashtable<String, Object> changedHashtable) throws Throwable {
        Object object2;
        ServerContext serverContext = this.createServerContext();
        Record record = ProtocolFactory.openRecord("createSubSession", new Object[0]);
        try {
            block7: {
                Throwable throwable = null;
                Object object3 = null;
                long l = System.currentTimeMillis();
                try {
                    object2 = object3 = this.createSubSessionIntern(null, this.sessman.get(object), changedHashtable);
                    Object var11_10 = null;
                    if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) break block7;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = AbstractSecurityManager.prepareException(throwable2);
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        Object var11_11 = null;
                        if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) throw throwable3;
                        this.log(object, "Session!", "createSubSession", new Object[]{changedHashtable}, null, object3, throwable, System.currentTimeMillis() - l);
                        throw throwable3;
                    }
                }
                this.log(object, "Session!", "createSubSession", new Object[]{changedHashtable}, null, object3, throwable, System.currentTimeMillis() - l);
            }
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            CommonUtil.close(record);
            serverContext.release();
            throw throwable;
        }
        CommonUtil.close(record);
        serverContext.release();
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroySession(Object object) {
        ServerContext serverContext = this.createServerContext();
        Record record = ProtocolFactory.openRecord("destroySession", new Object[0]);
        try {
            long l = System.currentTimeMillis();
            try {
                this.destroySessionIntern(object);
                Object var7_5 = null;
                if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                    this.log(object, "Session!", "destroySession", null, null, null, null, System.currentTimeMillis() - l);
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                    this.log(object, "Session!", "destroySession", null, null, null, null, System.currentTimeMillis() - l);
                }
                throw throwable;
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            CommonUtil.close(record);
            serverContext.release();
            throw throwable;
        }
        CommonUtil.close(record);
        serverContext.release();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object execute(Object object, String string, String string2, Object ... objectArray) throws Throwable {
        ServerContext serverContext = this.createServerContext();
        Record record = ProtocolFactory.openRecord("execute", string, string2, objectArray);
        try {
            Object object2;
            block6: {
                Throwable throwable = null;
                Object object3 = null;
                long l = System.currentTimeMillis();
                try {
                    AbstractSession abstractSession = this.sessman.get(object);
                    ((ServerContextImpl)serverContext).setSession(abstractSession);
                    object2 = object3 = this.executeIntern(abstractSession, new Call(null, string, string2, objectArray));
                    Object var14_13 = null;
                    if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) break block6;
                    this.log(object, string, string2, objectArray, null, object3, throwable, System.currentTimeMillis() - l);
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = AbstractSecurityManager.prepareException(throwable2);
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        Object var14_14 = null;
                        if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) throw throwable3;
                        this.log(object, string, string2, objectArray, null, object3, throwable, System.currentTimeMillis() - l);
                        throw throwable3;
                    }
                }
            }
            Object var16_15 = null;
            CommonUtil.close(record);
            serverContext.release();
            return object2;
        }
        catch (Throwable throwable4) {
            Object var16_16 = null;
            CommonUtil.close(record);
            serverContext.release();
            throw throwable4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeCallBack(Object object, Object object2, String string, String string2, Object ... objectArray) throws Throwable {
        ServerContext serverContext = this.createServerContext();
        Record record = ProtocolFactory.openRecord("executeCallBack", string, string2, objectArray);
        try {
            Throwable throwable = null;
            long l = System.currentTimeMillis();
            try {
                try {
                    AbstractSession abstractSession = this.sessman.get(object);
                    ((ServerContextImpl)serverContext).setSession(abstractSession);
                    this.validateCallBack(abstractSession, string);
                    Call call = new Call(object2, string, string2, objectArray);
                    call.setForceCallBack(true);
                    this.executeIntern(abstractSession, call);
                }
                catch (Throwable throwable2) {
                    throwable = AbstractSecurityManager.prepareException(throwable2);
                    throw throwable2;
                }
                Object var14_13 = null;
                if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                    this.log(object, string, string2, objectArray, object2, null, throwable, System.currentTimeMillis() - l);
                }
            }
            catch (Throwable throwable3) {
                Object var14_14 = null;
                if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                    this.log(object, string, string2, objectArray, object2, null, throwable, System.currentTimeMillis() - l);
                }
                throw throwable3;
            }
            Object var16_16 = null;
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            CommonUtil.close(record);
            serverContext.release();
            throw throwable;
        }
        CommonUtil.close(record);
        serverContext.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeCallBack(Object object, ICallBackListener iCallBackListener, String string, String string2, Object ... objectArray) throws Throwable {
        ServerContext serverContext = this.createServerContext();
        Record record = ProtocolFactory.openRecord("executeCallBack", string, string2, objectArray);
        try {
            Throwable throwable = null;
            long l = System.currentTimeMillis();
            try {
                try {
                    AbstractSession abstractSession = this.sessman.get(object);
                    ((ServerContextImpl)serverContext).setSession(abstractSession);
                    this.validateCallBack(abstractSession, string);
                    Call call = new Call(iCallBackListener, string, string2, objectArray);
                    call.setForceCallBack(true);
                    this.executeIntern(abstractSession, call);
                }
                catch (Throwable throwable2) {
                    throwable = AbstractSecurityManager.prepareException(throwable2);
                    throw throwable2;
                }
                Object var14_13 = null;
                if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                    this.log(object, string, string2, objectArray, iCallBackListener, null, throwable, System.currentTimeMillis() - l);
                }
            }
            catch (Throwable throwable3) {
                Object var14_14 = null;
                if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                    this.log(object, string, string2, objectArray, iCallBackListener, null, throwable, System.currentTimeMillis() - l);
                }
                throw throwable3;
            }
            Object var16_16 = null;
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            CommonUtil.close(record);
            serverContext.release();
            throw throwable;
        }
        CommonUtil.close(record);
        serverContext.release();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object executeAction(Object object, String string, Object ... objectArray) throws Throwable {
        ServerContext serverContext = this.createServerContext();
        Record record = ProtocolFactory.openRecord("executeAction", string, objectArray);
        try {
            Object object2;
            block6: {
                Throwable throwable = null;
                Object object3 = null;
                long l = System.currentTimeMillis();
                try {
                    AbstractSession abstractSession = this.sessman.get(object);
                    ((ServerContextImpl)serverContext).setSession(abstractSession);
                    object2 = object3 = this.executeIntern(abstractSession, new Call(null, null, string, objectArray));
                    Object var13_12 = null;
                    if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) break block6;
                    this.log(object, null, string, objectArray, null, object3, throwable, System.currentTimeMillis() - l);
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = AbstractSecurityManager.prepareException(throwable2);
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        Object var13_13 = null;
                        if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) throw throwable3;
                        this.log(object, null, string, objectArray, null, object3, throwable, System.currentTimeMillis() - l);
                        throw throwable3;
                    }
                }
            }
            Object var15_14 = null;
            CommonUtil.close(record);
            serverContext.release();
            return object2;
        }
        catch (Throwable throwable4) {
            Object var15_15 = null;
            CommonUtil.close(record);
            serverContext.release();
            throw throwable4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeActionCallBack(Object object, Object object2, String string, Object ... objectArray) throws Throwable {
        ServerContext serverContext = this.createServerContext();
        Record record = ProtocolFactory.openRecord("executeActionCallBack", string, objectArray);
        try {
            Throwable throwable = null;
            long l = System.currentTimeMillis();
            try {
                try {
                    AbstractSession abstractSession = this.sessman.get(object);
                    ((ServerContextImpl)serverContext).setSession(abstractSession);
                    this.validateCallBack(abstractSession, null);
                    Call call = new Call(object2, null, string, objectArray);
                    call.setForceCallBack(true);
                    this.executeIntern(abstractSession, call);
                }
                catch (Throwable throwable2) {
                    throwable = AbstractSecurityManager.prepareException(throwable2);
                    throw throwable2;
                }
                Object var13_12 = null;
                if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                    this.log(object, null, string, objectArray, object2, null, throwable, System.currentTimeMillis() - l);
                }
            }
            catch (Throwable throwable3) {
                Object var13_13 = null;
                if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                    this.log(object, null, string, objectArray, object2, null, throwable, System.currentTimeMillis() - l);
                }
                throw throwable3;
            }
            Object var15_15 = null;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            CommonUtil.close(record);
            serverContext.release();
            throw throwable;
        }
        CommonUtil.close(record);
        serverContext.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeActionCallBack(Object object, ICallBackListener iCallBackListener, String string, Object ... objectArray) throws Throwable {
        ServerContext serverContext = this.createServerContext();
        Record record = ProtocolFactory.openRecord("executeActionCallBack", string, objectArray);
        try {
            Throwable throwable = null;
            long l = System.currentTimeMillis();
            try {
                try {
                    AbstractSession abstractSession = this.sessman.get(object);
                    ((ServerContextImpl)serverContext).setSession(abstractSession);
                    this.validateCallBack(abstractSession, null);
                    Call call = new Call(iCallBackListener, null, string, objectArray);
                    call.setForceCallBack(true);
                    this.executeIntern(abstractSession, call);
                }
                catch (Throwable throwable2) {
                    throwable = AbstractSecurityManager.prepareException(throwable2);
                    throw throwable2;
                }
                Object var13_12 = null;
                if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                    this.log(object, null, string, objectArray, iCallBackListener, null, throwable, System.currentTimeMillis() - l);
                }
            }
            catch (Throwable throwable3) {
                Object var13_13 = null;
                if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                    this.log(object, null, string, objectArray, iCallBackListener, null, throwable, System.currentTimeMillis() - l);
                }
                throw throwable3;
            }
            Object var15_15 = null;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            CommonUtil.close(record);
            serverContext.release();
            throw throwable;
        }
        CommonUtil.close(record);
        serverContext.release();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setProperty(Object object, String string, Object object2) throws Throwable {
        ServerContext serverContext;
        block6: {
            serverContext = this.createServerContext();
            Throwable throwable = null;
            long l = System.currentTimeMillis();
            try {
                try {
                    AbstractSession abstractSession = this.sessman.get(object);
                    ((ServerContextImpl)serverContext).setSession(abstractSession);
                    this.setPropertyIntern(abstractSession, string, object2);
                }
                catch (Throwable throwable2) {
                    throwable = AbstractSecurityManager.prepareException(throwable2);
                    throw throwable2;
                }
                Object var10_9 = null;
                if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) break block6;
            }
            catch (Throwable throwable3) {
                Object var10_10 = null;
                if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                    this.log(object, "Session!", "setProperty", new Object[]{string, object2}, null, null, throwable, System.currentTimeMillis() - l);
                }
                serverContext.release();
                throw throwable3;
            }
            this.log(object, "Session!", "setProperty", new Object[]{string, object2}, null, null, throwable, System.currentTimeMillis() - l);
        }
        serverContext.release();
    }

    @Override
    public Object getProperty(Object object, String string) throws Throwable {
        Throwable throwable = null;
        Object object2 = null;
        long l = System.currentTimeMillis();
        try {
            try {
                object2 = this.getPropertyIntern(this.sessman.get(object), string);
            }
            catch (Throwable throwable2) {
                throwable = AbstractSecurityManager.prepareException(throwable2);
                throw throwable2;
            }
            Object var9_6 = null;
            if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                this.log(object, "Session!", "getProperty", null, null, object2, throwable, System.currentTimeMillis() - l);
            }
        }
        catch (Throwable throwable3) {
            Object var9_7 = null;
            if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                this.log(object, "Session!", "getProperty", null, null, object2, throwable, System.currentTimeMillis() - l);
            }
            throw throwable3;
        }
        return object2;
    }

    @Override
    public ChangedHashtable<String, Object> getProperties(Object object) throws Throwable {
        Throwable throwable = null;
        ChangedHashtable<String, Object> changedHashtable = null;
        long l = System.currentTimeMillis();
        try {
            try {
                changedHashtable = this.getPropertiesIntern(this.sessman.get(object));
            }
            catch (Throwable throwable2) {
                throwable = AbstractSecurityManager.prepareException(throwable2);
                throw throwable2;
            }
            Object var8_5 = null;
            if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                this.log(object, "Session!", "getProperties", null, null, changedHashtable, throwable, System.currentTimeMillis() - l);
            }
        }
        catch (Throwable throwable3) {
            Object var8_6 = null;
            if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                this.log(object, "Session!", "getProperties", null, null, changedHashtable, throwable, System.currentTimeMillis() - l);
            }
            throw throwable3;
        }
        return changedHashtable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ResultObject> getCallBackResults(Object object) throws Throwable {
        ArrayUtil<ResultObject> arrayUtil;
        ServerContext serverContext;
        block6: {
            serverContext = this.createServerContext();
            Throwable throwable = null;
            arrayUtil = null;
            long l = System.currentTimeMillis();
            try {
                try {
                    AbstractSession abstractSession = this.sessman.get(object);
                    ((ServerContextImpl)serverContext).setSession(abstractSession);
                    arrayUtil = this.getCallBackResultsIntern(abstractSession);
                }
                catch (Throwable throwable2) {
                    throwable = AbstractSecurityManager.prepareException(throwable2);
                    throw throwable2;
                }
                Object var9_8 = null;
                if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) break block6;
            }
            catch (Throwable throwable3) {
                Object var9_9 = null;
                if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                    this.log(object, "Session!", "getCallBackResults", new Object[]{object}, null, arrayUtil, throwable, System.currentTimeMillis() - l);
                }
                serverContext.release();
                throw throwable3;
            }
            this.log(object, "Session!", "getCallBackResults", new Object[]{object}, null, arrayUtil, throwable, System.currentTimeMillis() - l);
        }
        serverContext.release();
        return arrayUtil;
    }

    @Override
    public Object[] setAndCheckAlive(Object object, Object ... objectArray) throws Throwable {
        ServerContext serverContext = this.createServerContext();
        Throwable throwable = null;
        Object[] objectArray2 = null;
        long l = System.currentTimeMillis();
        try {
            try {
                AbstractSession abstractSession = this.sessman.get(object);
                ((ServerContextImpl)serverContext).setSession(abstractSession);
                objectArray2 = this.setAndCheckAliveIntern(abstractSession, objectArray);
            }
            catch (Throwable throwable2) {
                throwable = AbstractSecurityManager.prepareException(throwable2);
                throw throwable2;
            }
            Object var10_9 = null;
            if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                this.log(object, "Session!", "setAndCheckAlive", objectArray, null, objectArray2, throwable, System.currentTimeMillis() - l);
            }
            serverContext.release();
        }
        catch (Throwable throwable3) {
            Object var10_10 = null;
            if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                this.log(object, "Session!", "setAndCheckAlive", objectArray, null, objectArray2, throwable, System.currentTimeMillis() - l);
            }
            serverContext.release();
            throw throwable3;
        }
        return objectArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setNewPassword(Object object, String string, String string2) throws Throwable {
        ServerContext serverContext = this.createServerContext();
        Record record = ProtocolFactory.openRecord("setNewPassword", new Object[0]);
        try {
            block6: {
                Throwable throwable = null;
                long l = System.currentTimeMillis();
                try {
                    try {
                        AbstractSession abstractSession = this.sessman.get(object);
                        ((ServerContextImpl)serverContext).setSession(abstractSession);
                        this.setNewPasswordInternal(abstractSession, string, string2);
                    }
                    catch (Throwable throwable2) {
                        throwable = AbstractSecurityManager.prepareException(throwable2);
                        throw throwable2;
                    }
                    Object var11_10 = null;
                    if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) break block6;
                }
                catch (Throwable throwable3) {
                    Object var11_11 = null;
                    if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) throw throwable3;
                    this.log(object, "Session!", "setNewPassword", new Object[]{"****"}, null, null, throwable, System.currentTimeMillis() - l);
                    throw throwable3;
                }
                this.log(object, "Session!", "setNewPassword", new Object[]{"****"}, null, null, throwable, System.currentTimeMillis() - l);
            }
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            CommonUtil.close(record);
            serverContext.release();
            throw throwable;
        }
        CommonUtil.close(record);
        serverContext.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ISession process(IRequest var1_1, IResponse var2_2) throws Exception {
        var3_3 = this.createServerContext();
        var4_4 = ProtocolFactory.openRecord("process", new Object[0]);
        try {
            block139: {
                var5_5 = null;
                var8_6 = null;
                var9_7 = null;
                var10_8 = null;
                var12_9 = null;
                var13_10 = null;
                var6_11 = var1_1.getInputStream();
                var14_12 = (char)var6_11.read();
                if (var14_12 != 'A' && var14_12 != 'E') {
                    throw new IOException("Invalid stream identifier '" + var14_12 + "'");
                }
                var15_15 = var6_11.read();
                var16_16 = var15_15 == 2 ? new GZIPInputStream(var6_11) : var6_11;
                var17_17 = new DataInputStream(var16_16);
                var18_18 = null;
                if (var14_12 == 'A') {
                    var18_18 = var17_17.readUTF();
                    var8_6 = (ISerializer)Class.forName(var18_18).newInstance();
                }
                if ((var19_19 = var17_17.readUTF()).trim().length() == 0) {
                    var19_19 = null;
                }
                if (var19_19 != null) {
                    var5_5 = this.sessman.get(var19_19);
                    ((ServerContextImpl)var3_3).setSession(var5_5);
                    var8_6 = var5_5.getSerializer();
                }
                if (var8_6 == null) {
                    throw new SecurityException("Invalid serializer '" + var18_18 + "'");
                }
                var20_20 = var8_6.read(var17_17);
                if (!(var20_20 instanceof String)) ** GOTO lbl61
                var10_8 = Long.valueOf((String)var20_20);
                if (var5_5 == null) ** GOTO lbl60
                var21_21 = this.sessman.getMasterSession(var5_5);
                var13_10 = this.whmResponse.get(var21_21);
                if (var13_10 == null) ** GOTO lbl57
                if (!var13_10.id.equals(var10_8)) ** GOTO lbl55
                if (var13_10.content == null) {
                    var22_22 = var13_10;
                    synchronized (var22_22) {
                        var13_10.wait(10000L);
                    }
                }
                if (var13_10.content == null) break block139;
                this.sendContent(var2_2, var13_10.content);
                var22_22 = var5_5;
                var32_24 = null;
                var1_1.close();
                ** GOTO lbl66
            }
            try {
                block145: {
                    var2_2.close();
                    throw Server.EXCEPTION_CONTENT;
lbl55:
                    // 1 sources

                    if (var13_10.id + 1L != var10_8) {
                        throw new IOException("Invalid communication state!");
                    }
lbl57:
                    // 3 sources

                    var13_10 = new CachedResponse(var10_8);
                    this.whmResponse.put((ISession)var21_21, (CachedResponse)var13_10);
lbl60:
                    // 2 sources

                    var20_20 = var8_6.read(var17_17);
lbl61:
                    // 2 sources

                    var11_101 = (Integer)var20_20;
                    var9_7 = new ArrayUtil<E>(var11_101);
                    break block145;
                    catch (Throwable var33_28) {
                        this.log.error(new Object[]{var33_28});
                    }
lbl66:
                    // 2 sources

                    if (!var2_2.isClosed()) {
                        var7_32 = new ByteArrayOutputStream();
                        if (var8_6 == null) {
                            var7_32.write(66);
                            var7_32.write(1);
                            var33_28 = new DataOutputStream(var7_32);
                            var36_44 = var9_7.size();
                            var37_52 = 0;
                            for (var35_36 = 0; var35_36 < var36_44 && var37_52 == 0; ++var35_36) {
                                if (((ResultObject)var9_7.get(var35_36)).getType() != 4) continue;
                                var34_64 = (Throwable)((ResultObject)var9_7.get(var35_36)).getObject();
                                if (var34_64 != null) {
                                    var38_72 = var34_64.getStackTrace();
                                    var33_28.writeUTF(var34_64.getClass().getName());
                                    var33_28.writeUTF(CommonUtil.nvl(var34_64.getMessage(), ""));
                                    if (var38_72 != null) {
                                        var33_28.write(var38_72.length);
                                        var40_84 = var38_72.length;
                                        for (var39_80 = 0; var39_80 < var40_84; ++var39_80) {
                                            var33_28.writeUTF(CommonUtil.nvl(var38_72[var39_80].getClassName(), ""));
                                            var33_28.writeUTF(CommonUtil.nvl(var38_72[var39_80].getMethodName(), ""));
                                            var33_28.writeUTF(CommonUtil.nvl(var38_72[var39_80].getFileName(), ""));
                                            var33_28.writeInt(var38_72[var39_80].getLineNumber());
                                        }
                                    } else {
                                        var33_28.write(0);
                                    }
                                } else {
                                    var33_28.writeUTF("");
                                }
                                ++var37_52;
                            }
                            var42_88 = null;
                            var33_28.flush();
                        }
                        var33_28 = null;
                        var34_65 = var5_5 != null ? var5_5.getProperties().getChanges(IConnectionConstants.PROPERTY_CLASSES) : (var12_9 != null ? var12_9.getChanges(IConnectionConstants.PROPERTY_CLASSES) : null);
                        if (var34_65 != null && var34_65.size() > 0) {
                            var35_37 = new ArrayUtil<E>(var34_65.size());
                            for (Object var37_53 : var34_65) {
                                var35_37.add(new Object[]{var37_53.getKey(), var37_53.getValue()});
                                var2_2.setProperty((String)var37_53.getKey(), var37_53.getValue());
                            }
                            if (var33_28 == null) {
                                var33_28 = new ArrayUtil<E>();
                            }
                            var33_28.add(new ResultObject(5, var35_37));
                        }
                        if (var5_5 != null) {
                            if (var33_28 == null) {
                                var33_28 = new ArrayUtil<ResultObject>();
                            }
                            if ((var35_37 = this.getCallBackResultsIntern(var5_5)) != null) {
                                var33_28.addAll(var35_37);
                            }
                        }
                        if (var9_7 != null) {
                            if (var33_28 == null) {
                                var33_28 = new ArrayUtil<E>();
                            }
                            var33_28.addAll(var9_7);
                        }
                        var11_100 = var33_28 != null ? var33_28.size() : 0;
                        var35_37 = new ByteArrayOutputStream(256);
                        var36_45 = new DataOutputStream((OutputStream)var35_37);
                        var8_6.write(var36_45, var11_100);
                        if (var33_28 != null) {
                            var37_53 = var33_28.iterator();
                            while (var37_53.hasNext()) {
                                var38_73 = (ResultObject)var37_53.next();
                                var8_6.write(var36_45, var38_73.getType());
                                var8_6.write(var36_45, var38_73.getObject());
                                if (var38_73.getType() != 2 && var38_73.getType() != 1) continue;
                                var8_6.write(var36_45, var38_73.getCallBackId());
                            }
                        }
                        var44_104 = null;
                        var35_37.close();
                        var36_45.close();
                        var7_32.write(69);
                        v0 = var37_54 = var5_5 != null && Boolean.parseBoolean((String)var5_5.getProperties().get("client.session.compression")) != false;
                        if (var37_54 && var35_37.size() > 256) {
                            var7_32.write(2);
                            var38_73 = new GZIPOutputStream(var7_32);
                            var38_73.write(var35_37.toByteArray());
                            var38_73.flush();
                            var38_73.finish();
                        } else {
                            var7_32.write(1);
                            var7_32.write(var35_37.toByteArray());
                        }
                        var7_32.flush();
                        var7_32.close();
                        if (var13_10 != null) {
                            var13_10.content = var7_32;
                            var33_28 = var13_10;
                            synchronized (var33_28) {
                                var13_10.notifyAll();
                            }
                        } else if (var5_5 != null) {
                            this.whmResponse.put(this.sessman.getMasterSession(var5_5), new CachedResponse(var10_8, var7_32));
                        }
                        this.sendContent(var2_2, var7_32);
                    }
                    var47_116 = null;
                    CommonUtil.close(new Object[]{var4_4});
                    var3_3.release();
                    return var22_22;
                    catch (Throwable var41_96) {
                        var42_89 = null;
                        var33_28.flush();
                        throw var41_96;
                    }
                    catch (Throwable var43_112) {
                        var44_105 = null;
                        var35_37.close();
                        var36_45.close();
                        throw var43_112;
                    }
                }
                for (var26_119 = 0; var26_119 < var11_101; ++var26_119) {
                    var24_121 = System.currentTimeMillis();
                    var23_120 = (Object[])var8_6.read(var17_17);
                    if (!(var23_120.length != 4 || var23_120[0] != null && var23_120[0].getClass() != String.class || var23_120[1].getClass() != String.class || var23_120[2] != null && !(var23_120[2] instanceof Object[]))) {
                        var21_21 = null;
                        var22_23 = null;
                        try {
                            try {
                                var22_23 = this.process(var1_1, var8_6, var5_5, (String)var23_120[0], (String)var23_120[1], (Object[])var23_120[2], var23_120[3], (ChangedHashtable<String, Object>)var12_9);
                            }
                            catch (Throwable var27_123) {
                                var21_21 = var27_123;
                                throw var27_123;
                            }
                            var29_126 = null;
                            if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                                this.log(var5_5 != null ? var5_5.getId() : null, (String)var23_120[0], (String)var23_120[1], (Object[])var23_120[2], var23_120[3], var22_23, (Throwable)var21_21, System.currentTimeMillis() - var24_121);
                            }
                        }
                        catch (Throwable var28_125) {
                            var29_126 = null;
                            if (this.log.isEnabled(ILogger.LogLevel.DEBUG) == false) throw var28_125;
                            this.log(var5_5 != null ? var5_5.getId() : null, (String)var23_120[0], (String)var23_120[1], (Object[])var23_120[2], var23_120[3], var22_23, (Throwable)var21_21, System.currentTimeMillis() - var24_121);
                            throw var28_125;
                        }
                        if ("Session!".equals((String)var23_120[0]) && "setProperty".equals((String)var23_120[1])) {
                            var27_122 = (List)var22_23;
                            if (var27_122 == null) continue;
                            var12_9 = new ChangedHashtable<String, ?>();
                            var30_128 = var27_122.size();
                            for (var29_127 = 0; var29_127 < var30_128; ++var29_127) {
                                var28_124 = (Object[])var27_122.get(var29_127);
                                var12_9.put((String)var28_124[0], var28_124[1], false);
                            }
                            continue;
                        }
                        if (var5_5 == null) {
                            var5_5 = this.sessman.get(var22_23);
                        }
                        var9_7.add(new ResultObject(3, var22_23));
                        continue;
                    }
                    this.log.debug(new Object[]{"Invalid request parameters!", var23_120});
                    throw new SecurityException("Invalid request parameters!");
                }
                var32_25 = null;
                ** try [egrp 7[TRYBLOCK] [11 : 1010->1019)] { 
lbl227:
                // 1 sources

                var1_1.close();
                ** GOTO lbl244
                catch (Throwable var14_13) {
                    block147: {
                        block146: {
                            if (var14_13 == Server.EXCEPTION_CONTENT) {
                                throw Server.EXCEPTION_CONTENT;
                            }
                            this.log.error(new Object[]{var14_13});
                            if (var9_7 == null) {
                                var9_7 = new ArrayUtil<ResultObject>(1);
                            }
                            var9_7.add(new ResultObject(4, AbstractSecurityManager.prepareException(var14_13)));
                            var32_26 = null;
                            ** try [egrp 7[TRYBLOCK] [11 : 1010->1019)] { 
lbl240:
                            // 1 sources

                            var1_1.close();
                            break block146;
lbl242:
                            // 1 sources

                            catch (Throwable var33_29) {
                                this.log.error(new Object[]{var33_29});
                            }
lbl244:
                            // 2 sources

                            if (var2_2.isClosed()) break block147;
                            var7_33 = new ByteArrayOutputStream();
                            if (var8_6 == null) {
                                var7_33.write(66);
                                var7_33.write(1);
                                var33_29 = new DataOutputStream(var7_33);
                                ** try [egrp 8[TRYBLOCK] [12 : 1086->1333)] { 
lbl251:
                                // 1 sources

                                var36_46 = var9_7.size();
                                var37_55 = 0;
                                for (var35_38 = 0; var35_38 < var36_46 && var37_55 == 0; ++var35_38) {
                                    if (((ResultObject)var9_7.get(var35_38)).getType() != 4) continue;
                                    var34_66 = (Throwable)((ResultObject)var9_7.get(var35_38)).getObject();
                                    if (var34_66 != null) {
                                        var38_74 = var34_66.getStackTrace();
                                        var33_29.writeUTF(var34_66.getClass().getName());
                                        var33_29.writeUTF(CommonUtil.nvl(var34_66.getMessage(), ""));
                                        if (var38_74 != null) {
                                            var33_29.write(var38_74.length);
                                            var40_85 = var38_74.length;
                                            for (var39_81 = 0; var39_81 < var40_85; ++var39_81) {
                                                var33_29.writeUTF(CommonUtil.nvl(var38_74[var39_81].getClassName(), ""));
                                                var33_29.writeUTF(CommonUtil.nvl(var38_74[var39_81].getMethodName(), ""));
                                                var33_29.writeUTF(CommonUtil.nvl(var38_74[var39_81].getFileName(), ""));
                                                var33_29.writeInt(var38_74[var39_81].getLineNumber());
                                            }
                                        } else {
                                            var33_29.write(0);
                                        }
                                    } else {
                                        var33_29.writeUTF("");
                                    }
                                    ++var37_55;
                                }
                                var42_90 = null;
                                var33_29.flush();
                            } else {
                                var33_29 = null;
                                var34_67 = var5_5 != null ? var5_5.getProperties().getChanges(IConnectionConstants.PROPERTY_CLASSES) : (var12_9 != null ? var12_9.getChanges(IConnectionConstants.PROPERTY_CLASSES) : null);
                                if (var34_67 != null && var34_67.size() > 0) {
                                    var35_39 = new ArrayUtil<E>(var34_67.size());
                                    for (Object var37_56 : var34_67) {
                                        var35_39.add(new Object[]{var37_56.getKey(), var37_56.getValue()});
                                        var2_2.setProperty((String)var37_56.getKey(), var37_56.getValue());
                                    }
                                    if (var33_29 == null) {
                                        var33_29 = new ArrayUtil<E>();
                                    }
                                    var33_29.add(new ResultObject(5, var35_39));
                                }
                                if (var5_5 != null) {
                                    if (var33_29 == null) {
                                        var33_29 = new ArrayUtil<ResultObject>();
                                    }
                                    if ((var35_39 = this.getCallBackResultsIntern(var5_5)) != null) {
                                        var33_29.addAll(var35_39);
                                    }
                                }
                                if (var9_7 != null) {
                                    if (var33_29 == null) {
                                        var33_29 = new ArrayUtil<E>();
                                    }
                                    var33_29.addAll(var9_7);
                                }
                                var11_101 = var33_29 != null ? var33_29.size() : 0;
                                var35_39 = new ByteArrayOutputStream(256);
                                var36_47 = new DataOutputStream((OutputStream)var35_39);
                                ** try [egrp 9[TRYBLOCK] [14 : 1654->1774)] { 
lbl307:
                                // 1 sources

                                var8_6.write(var36_47, var11_101);
                                if (var33_29 != null) {
                                    var37_56 = var33_29.iterator();
                                    while (var37_56.hasNext()) {
                                        var38_75 = (ResultObject)var37_56.next();
                                        var8_6.write(var36_47, var38_75.getType());
                                        var8_6.write(var36_47, var38_75.getObject());
                                        if (var38_75.getType() != 2 && var38_75.getType() != 1) continue;
                                        var8_6.write(var36_47, var38_75.getCallBackId());
                                    }
                                }
                                var44_106 = null;
                                var35_39.close();
                                var36_47.close();
                                var7_33.write(69);
                                v1 = var37_57 = var5_5 != null && Boolean.parseBoolean((String)var5_5.getProperties().get("client.session.compression")) != false;
                                if (var37_57 && var35_39.size() > 256) {
                                    var7_33.write(2);
                                    var38_75 = new GZIPOutputStream(var7_33);
                                    var38_75.write(var35_39.toByteArray());
                                    var38_75.flush();
                                    var38_75.finish();
                                } else {
                                    var7_33.write(1);
                                    var7_33.write(var35_39.toByteArray());
                                }
                            }
                            var7_33.flush();
                            var7_33.close();
                            if (var13_10 != null) {
                                var13_10.content = var7_33;
                                var33_29 = var13_10;
                                synchronized (var33_29) {
                                    var13_10.notifyAll();
                                }
                            } else if (var5_5 != null) {
                                this.whmResponse.put(this.sessman.getMasterSession(var5_5), new CachedResponse(var10_8, var7_33));
                            }
                            this.sendContent(var2_2, var7_33);
                            break block147;
lbl344:
                            // 1 sources

                            catch (Throwable var41_97) {
                                var42_91 = null;
                                var33_29.flush();
                                throw var41_97;
                            }
lbl349:
                            // 1 sources

                            catch (Throwable var43_113) {
                                var44_107 = null;
                                var35_39.close();
                                var36_47.close();
                                throw var43_113;
                            }
lbl356:
                            // 1 sources

                            catch (Throwable var33_30) {
                                this.log.error(new Object[]{var33_30});
                            }
                        }
                        if (!var2_2.isClosed()) {
                            var7_34 = new ByteArrayOutputStream();
                            if (var8_6 == null) {
                                var7_34.write(66);
                                var7_34.write(1);
                                var33_30 = new DataOutputStream(var7_34);
                                ** try [egrp 8[TRYBLOCK] [12 : 1086->1333)] { 
lbl366:
                                // 1 sources

                                var36_48 = var9_7.size();
                                var37_58 = 0;
                                for (var35_40 = 0; var35_40 < var36_48 && var37_58 == 0; ++var35_40) {
                                    if (((ResultObject)var9_7.get(var35_40)).getType() != 4) continue;
                                    var34_68 = (Throwable)((ResultObject)var9_7.get(var35_40)).getObject();
                                    if (var34_68 != null) {
                                        var38_76 = var34_68.getStackTrace();
                                        var33_30.writeUTF(var34_68.getClass().getName());
                                        var33_30.writeUTF(CommonUtil.nvl(var34_68.getMessage(), ""));
                                        if (var38_76 != null) {
                                            var33_30.write(var38_76.length);
                                            var40_86 = var38_76.length;
                                            for (var39_82 = 0; var39_82 < var40_86; ++var39_82) {
                                                var33_30.writeUTF(CommonUtil.nvl(var38_76[var39_82].getClassName(), ""));
                                                var33_30.writeUTF(CommonUtil.nvl(var38_76[var39_82].getMethodName(), ""));
                                                var33_30.writeUTF(CommonUtil.nvl(var38_76[var39_82].getFileName(), ""));
                                                var33_30.writeInt(var38_76[var39_82].getLineNumber());
                                            }
                                        } else {
                                            var33_30.write(0);
                                        }
                                    } else {
                                        var33_30.writeUTF("");
                                    }
                                    ++var37_58;
                                }
                                var42_92 = null;
                                var33_30.flush();
                            } else {
                                var33_30 = null;
                                var34_69 = var5_5 != null ? var5_5.getProperties().getChanges(IConnectionConstants.PROPERTY_CLASSES) : (var12_9 != null ? var12_9.getChanges(IConnectionConstants.PROPERTY_CLASSES) : null);
                                if (var34_69 != null && var34_69.size() > 0) {
                                    var35_41 = new ArrayUtil<E>(var34_69.size());
                                    for (Object var37_59 : var34_69) {
                                        var35_41.add(new Object[]{var37_59.getKey(), var37_59.getValue()});
                                        var2_2.setProperty((String)var37_59.getKey(), var37_59.getValue());
                                    }
                                    if (var33_30 == null) {
                                        var33_30 = new ArrayUtil<E>();
                                    }
                                    var33_30.add(new ResultObject(5, var35_41));
                                }
                                if (var5_5 != null) {
                                    if (var33_30 == null) {
                                        var33_30 = new ArrayUtil<ResultObject>();
                                    }
                                    if ((var35_41 = this.getCallBackResultsIntern(var5_5)) != null) {
                                        var33_30.addAll(var35_41);
                                    }
                                }
                                if (var9_7 != null) {
                                    if (var33_30 == null) {
                                        var33_30 = new ArrayUtil<E>();
                                    }
                                    var33_30.addAll(var9_7);
                                }
                                var11_102 = var33_30 != null ? var33_30.size() : 0;
                                var35_41 = new ByteArrayOutputStream(256);
                                var36_49 = new DataOutputStream((OutputStream)var35_41);
                                ** try [egrp 9[TRYBLOCK] [14 : 1654->1774)] { 
lbl422:
                                // 1 sources

                                var8_6.write(var36_49, var11_102);
                                if (var33_30 != null) {
                                    var37_59 = var33_30.iterator();
                                    while (var37_59.hasNext()) {
                                        var38_77 = (ResultObject)var37_59.next();
                                        var8_6.write(var36_49, var38_77.getType());
                                        var8_6.write(var36_49, var38_77.getObject());
                                        if (var38_77.getType() != 2 && var38_77.getType() != 1) continue;
                                        var8_6.write(var36_49, var38_77.getCallBackId());
                                    }
                                }
                                var44_108 = null;
                                var35_41.close();
                                var36_49.close();
                                var7_34.write(69);
                                v2 = var37_60 = var5_5 != null && Boolean.parseBoolean((String)var5_5.getProperties().get("client.session.compression")) != false;
                                if (var37_60 && var35_41.size() > 256) {
                                    var7_34.write(2);
                                    var38_77 = new GZIPOutputStream(var7_34);
                                    var38_77.write(var35_41.toByteArray());
                                    var38_77.flush();
                                    var38_77.finish();
                                } else {
                                    var7_34.write(1);
                                    var7_34.write(var35_41.toByteArray());
                                }
                            }
                            var7_34.flush();
                            var7_34.close();
                            if (var13_10 != null) {
                                var13_10.content = var7_34;
                                var33_30 = var13_10;
                                synchronized (var33_30) {
                                    var13_10.notifyAll();
                                }
                            } else if (var5_5 != null) {
                                this.whmResponse.put(this.sessman.getMasterSession(var5_5), new CachedResponse(var10_8, var7_34));
                            }
                            this.sendContent(var2_2, var7_34);
                        }
                    }
                    var14_14 = var5_5;
                    var47_117 = null;
                    CommonUtil.close(new Object[]{var4_4});
                    var3_3.release();
                    return var14_14;
lbl466:
                    // 1 sources

                    catch (Throwable var41_98) {
                        var42_93 = null;
                        var33_30.flush();
                        throw var41_98;
                    }
lbl471:
                    // 1 sources

                    catch (Throwable var43_114) {
                        var44_109 = null;
                        var35_41.close();
                        var36_49.close();
                        throw var43_114;
                    }
                }
            }
            catch (Throwable var31_129) {
                block150: {
                    block151: {
                        block149: {
                            block148: {
                                var32_27 = null;
                                ** try [egrp 7[TRYBLOCK] [11 : 1010->1019)] { 
lbl481:
                                // 1 sources

                                var1_1.close();
                                break block148;
lbl483:
                                // 1 sources

                                catch (Throwable var33_31 /* !! */ ) {
                                    this.log.error(new Object[]{var33_31 /* !! */ });
                                }
                            }
                            if (var2_2.isClosed() != false) throw var31_129;
                            var7_35 = new ByteArrayOutputStream();
                            if (var8_6 != null) break block149;
                            var7_35.write(66);
                            var7_35.write(1);
                            var33_31 /* !! */  = new DataOutputStream(var7_35);
                            ** try [egrp 8[TRYBLOCK] [12 : 1086->1333)] { 
lbl493:
                            // 1 sources

                            var36_50 = var9_7.size();
                            var37_61 = 0;
                            for (var35_42 = 0; var35_42 < var36_50 && var37_61 == 0; ++var35_42) {
                                if (((ResultObject)var9_7.get(var35_42)).getType() != 4) continue;
                                var34_70 = (Throwable)((ResultObject)var9_7.get(var35_42)).getObject();
                                if (var34_70 != null) {
                                    var38_78 = var34_70.getStackTrace();
                                    var33_31 /* !! */ .writeUTF(var34_70.getClass().getName());
                                    var33_31 /* !! */ .writeUTF(CommonUtil.nvl(var34_70.getMessage(), ""));
                                    if (var38_78 != null) {
                                        var33_31 /* !! */ .write(var38_78.length);
                                        var40_87 = var38_78.length;
                                        for (var39_83 = 0; var39_83 < var40_87; ++var39_83) {
                                            var33_31 /* !! */ .writeUTF(CommonUtil.nvl(var38_78[var39_83].getClassName(), ""));
                                            var33_31 /* !! */ .writeUTF(CommonUtil.nvl(var38_78[var39_83].getMethodName(), ""));
                                            var33_31 /* !! */ .writeUTF(CommonUtil.nvl(var38_78[var39_83].getFileName(), ""));
                                            var33_31 /* !! */ .writeInt(var38_78[var39_83].getLineNumber());
                                        }
                                    } else {
                                        var33_31 /* !! */ .write(0);
                                    }
                                } else {
                                    var33_31 /* !! */ .writeUTF("");
                                }
                                ++var37_61;
                            }
                            var42_94 = null;
                            var33_31 /* !! */ .flush();
                            break block150;
lbl521:
                            // 1 sources

                            catch (Throwable var41_99) {
                                var42_95 = null;
                                var33_31 /* !! */ .flush();
                                throw var41_99;
                            }
                        }
                        var33_31 /* !! */  = null;
                        var34_71 = var5_5 != null ? var5_5.getProperties().getChanges(IConnectionConstants.PROPERTY_CLASSES) : (var12_9 != null ? var12_9.getChanges(IConnectionConstants.PROPERTY_CLASSES) : null);
                        if (var34_71 != null && var34_71.size() > 0) {
                            var35_43 = new ArrayUtil<E>(var34_71.size());
                            for (Object var37_62 : var34_71) {
                                var35_43.add(new Object[]{var37_62.getKey(), var37_62.getValue()});
                                var2_2.setProperty((String)var37_62.getKey(), var37_62.getValue());
                            }
                            if (var33_31 /* !! */  == null) {
                                var33_31 /* !! */  = new ArrayUtil<E>();
                            }
                            var33_31 /* !! */ .add(new ResultObject(5, var35_43));
                        }
                        if (var5_5 != null) {
                            if (var33_31 /* !! */  == null) {
                                var33_31 /* !! */  = new ArrayUtil<ResultObject>();
                            }
                            if ((var35_43 = this.getCallBackResultsIntern(var5_5)) != null) {
                                var33_31 /* !! */ .addAll((Collection<ResultObject>)var35_43);
                            }
                        }
                        if (var9_7 != null) {
                            if (var33_31 /* !! */  == null) {
                                var33_31 /* !! */  = new ArrayUtil<E>();
                            }
                            var33_31 /* !! */ .addAll(var9_7);
                        }
                        var11_103 = var33_31 /* !! */  != null ? var33_31 /* !! */ .size() : 0;
                        var35_43 = new ByteArrayOutputStream(256);
                        var36_51 = new DataOutputStream((OutputStream)var35_43);
                        ** try [egrp 9[TRYBLOCK] [14 : 1654->1774)] { 
lbl555:
                        // 1 sources

                        var8_6.write(var36_51, var11_103);
                        if (var33_31 /* !! */  != null) {
                            for (Object var38_79 : var33_31 /* !! */ ) {
                                var8_6.write(var36_51, var38_79.getType());
                                var8_6.write(var36_51, var38_79.getObject());
                                if (var38_79.getType() != 2 && var38_79.getType() != 1) continue;
                                var8_6.write(var36_51, var38_79.getCallBackId());
                            }
                        }
                        break block151;
lbl564:
                        // 1 sources

                        catch (Throwable var43_115) {
                            var44_111 = null;
                            var35_43.close();
                            var36_51.close();
                            throw var43_115;
                        }
                    }
                    var44_110 = null;
                    var35_43.close();
                    var36_51.close();
                    var7_35.write(69);
                    v3 = var37_63 = var5_5 != null && Boolean.parseBoolean((String)var5_5.getProperties().get("client.session.compression")) != false;
                    if (var37_63 && var35_43.size() > 256) {
                        var7_35.write(2);
                        var38_79 = new GZIPOutputStream(var7_35);
                        var38_79.write(var35_43.toByteArray());
                        var38_79.flush();
                        var38_79.finish();
                    } else {
                        var7_35.write(1);
                        var7_35.write(var35_43.toByteArray());
                    }
                }
                var7_35.flush();
                var7_35.close();
                if (var13_10 != null) {
                    var13_10.content = var7_35;
                    var33_31 /* !! */  = var13_10;
                    synchronized (var33_31 /* !! */ ) {
                        var13_10.notifyAll();
                    }
                } else if (var5_5 != null) {
                    this.whmResponse.put(this.sessman.getMasterSession(var5_5), new CachedResponse(var10_8, var7_35));
                }
                this.sendContent(var2_2, var7_35);
                throw var31_129;
            }
        }
        catch (Throwable var46_130) {
            var47_118 = null;
            CommonUtil.close(new Object[]{var4_4});
            var3_3.release();
            throw var46_130;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendContent(IResponse iResponse, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        try {
            OutputStream outputStream = iResponse.getOutputStream();
            byteArrayOutputStream.writeTo(outputStream);
            outputStream.flush();
            Object var5_4 = null;
            iResponse.close();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            iResponse.close();
            throw throwable;
        }
    }

    private Object process(IRequest iRequest, ISerializer iSerializer, AbstractSession abstractSession, String string, String string2, Object[] objectArray, Object object, ChangedHashtable<String, Object> changedHashtable) throws Throwable {
        if (object != null) {
            this.validateCallBack(abstractSession, string);
        }
        if (string != null && "Session!".equals(string)) {
            if ("createSession".equals(string2)) {
                if (abstractSession != null) {
                    throw new SecurityException("Session is already open!");
                }
                return this.createSessionIntern(iRequest, iSerializer, changedHashtable);
            }
            if ("createSubSession".equals(string2)) {
                if (abstractSession != null) {
                    throw new SecurityException("Session is already open!");
                }
                return this.createSubSessionIntern(iRequest, this.sessman.get(objectArray[0]), changedHashtable);
            }
            if ("setProperty".equals(string2) && abstractSession == null) {
                return (List)objectArray[0];
            }
            if (abstractSession != null) {
                if ("setAndCheckAlive".equals(string2)) {
                    return this.setAndCheckAliveIntern(abstractSession, objectArray);
                }
                if ("destroySession".equals(string2)) {
                    this.destroySessionIntern(abstractSession.getId());
                    return null;
                }
                if ("getProperty".equals(string2)) {
                    return this.getPropertyIntern(abstractSession, (String)objectArray[0]);
                }
                if ("getProperties".equals(string2)) {
                    return this.getPropertiesIntern(abstractSession);
                }
                if ("setProperty".equals(string2)) {
                    this.setPropertiesIntern(abstractSession, (List)objectArray[0]);
                    return null;
                }
                if ("setNewPassword".equals(string2)) {
                    this.setNewPasswordInternal(abstractSession, (String)objectArray[0], (String)objectArray[1]);
                    return null;
                }
            }
        }
        return this.executeIntern(abstractSession, new Call(object, string, string2, objectArray));
    }

    private Object executeIntern(AbstractSession abstractSession, Call call) throws Throwable {
        if (abstractSession != null) {
            return abstractSession.execute(call);
        }
        throw new SecurityException("No session for call '" + call.formatMethod() + "'");
    }

    private void validateCallBack(AbstractSession abstractSession, String string) {
        if (abstractSession == null) {
            throw new SecurityException("Call back is not allowed!");
        }
        if (string != null && "Session!".equals(string)) {
            throw new SecurityException("Call back is not allowed!");
        }
    }

    private Object createSessionIntern(IRequest iRequest, ISerializer iSerializer, ChangedHashtable<String, Object> changedHashtable) throws Throwable {
        return this.sessman.createSession(iRequest, iSerializer, changedHashtable);
    }

    private Object createSubSessionIntern(IRequest iRequest, AbstractSession abstractSession, ChangedHashtable<String, Object> changedHashtable) throws Throwable {
        return this.sessman.createSubSession(iRequest, abstractSession, changedHashtable);
    }

    private void destroySessionIntern(Object object) {
        this.sessman.destroy(object);
    }

    private void setPropertyIntern(AbstractSession abstractSession, String string, Object object) {
        abstractSession.setProperty(string, object);
    }

    private void setPropertiesIntern(AbstractSession abstractSession, List<Object[]> list) {
        abstractSession.setProperties(list);
    }

    private Object getPropertyIntern(AbstractSession abstractSession, String string) {
        Object object = abstractSession.getProperty(string);
        if (object != null) {
            for (int i = 0; i < IConnectionConstants.PROPERTY_CLASSES.length; ++i) {
                if (!IConnectionConstants.PROPERTY_CLASSES[i].isAssignableFrom(object.getClass())) continue;
                return object;
            }
        }
        return null;
    }

    private ChangedHashtable<String, Object> getPropertiesIntern(AbstractSession abstractSession) {
        List list = ((ChangedHashtable)abstractSession.getProperties()).getMapping(IConnectionConstants.PROPERTY_CLASSES);
        ChangedHashtable<String, Object> changedHashtable = new ChangedHashtable<String, Object>();
        for (Map.Entry entry : list) {
            Object obj = entry.getValue();
            if (obj == null) continue;
            changedHashtable.put((String)entry.getKey(), obj, false);
        }
        return changedHashtable;
    }

    private ArrayUtil<ResultObject> getCallBackResultsIntern(AbstractSession abstractSession) {
        if (abstractSession != null) {
            return abstractSession.removeCallBackResults();
        }
        return null;
    }

    private Object[] setAndCheckAliveIntern(AbstractSession abstractSession, Object[] objectArray) {
        abstractSession.setLastAliveTime(System.currentTimeMillis());
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        ArrayUtil<Object> arrayUtil = new ArrayUtil<Object>();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            try {
                this.sessman.get(objectArray[i]);
                continue;
            }
            catch (RuntimeException runtimeException) {
                arrayUtil.add(objectArray[i]);
            }
        }
        if (arrayUtil.size() > 0) {
            Object[] objectArray2 = new Object[arrayUtil.size()];
            arrayUtil.toArray(objectArray2);
            return objectArray2;
        }
        return null;
    }

    private void setNewPasswordInternal(AbstractSession abstractSession, String string, String string2) throws Throwable {
        abstractSession.setNewPassword(string, string2);
    }

    public final Monitoring getMonitoring() {
        return this.monitoring;
    }

    private final void log(Object object, String string, String string2, Object[] objectArray, Object object2, Object object3, Throwable throwable, long l) {
        this.log.debug("SESSION-ID: ", object, "\nOBJECTNAME: ", string, "\nMETHOD:     ", string2, "\nPARAMS:     ", objectArray, "\nCALLBACK:   ", object2, "\nRESULT:     ", object3, "\nEXCEPTION:  ", throwable, throwable != null ? "DURATION:   " : "\nDURATION:   ", l, " ms");
    }

    final ServerContext createServerContext() {
        ServerContextImpl serverContextImpl = new ServerContextImpl(this);
        return serverContextImpl;
    }

    private final class CachedResponse {
        protected Long id;
        protected ByteArrayOutputStream content;

        private CachedResponse(Long l) {
            this.id = l;
        }

        private CachedResponse(Long l, ByteArrayOutputStream byteArrayOutputStream) {
            this.id = l;
            this.content = byteArrayOutputStream;
        }
    }
}

