/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.server.AbstractSession;
import com.sibvisions.rad.server.DefaultSessionManager;
import com.sibvisions.rad.server.Server;
import com.sibvisions.rad.server.security.ISecurityManager;
import com.sibvisions.util.ArrayUtil;
import javax.rad.server.ISession;
import javax.rad.server.event.ISessionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Monitoring
implements ISessionListener {
    private Server server = null;
    private Object oLastDestroyedSessionId = null;

    public Monitoring(Server server) {
        this.server = server;
        this.server.getSessionManager().addSessionListener(this);
    }

    @Override
    public void sessionCreated(ISession iSession) {
    }

    @Override
    public void sessionDestroyed(ISession iSession) {
        if (iSession != null) {
            this.oLastDestroyedSessionId = iSession.getId();
        }
    }

    public int getSessionCount() {
        return this.server.getSessionManager().getSessionCount();
    }

    public Object getLastDestroyedSessionId() {
        return this.oLastDestroyedSessionId;
    }

    public ArrayUtil<Object> getSessionIds() {
        return this.server.getSessionManager().getSessionIds();
    }

    public void closeConnections(String string) {
        DefaultSessionManager defaultSessionManager = this.server.getSessionManager();
        ArrayUtil<Object> arrayUtil = defaultSessionManager.getSessionIds();
        for (Object e : arrayUtil) {
            try {
                AbstractSession abstractSession = defaultSessionManager.get(e);
                if (!string.equals(abstractSession.getApplicationName())) continue;
                this.server.destroySession(e);
            }
            catch (Throwable throwable) {}
        }
        this.releaseSecurityManager(defaultSessionManager.getSecurityManagerFromCache(string));
    }

    public void releaseSecurityManager(String string) {
        this.releaseSecurityManager(this.server.getSessionManager().getSecurityManagerFromCache(string));
    }

    private void releaseSecurityManager(ISecurityManager[] iSecurityManagerArray) {
        if (iSecurityManagerArray != null) {
            for (int i = 0; i < iSecurityManagerArray.length; ++i) {
                iSecurityManagerArray[i].release();
            }
        }
    }
}

