/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.server.IDirectServer;
import com.sibvisions.rad.server.Server;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.ChangedHashtable;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import javax.rad.remote.ConnectionInfo;
import javax.rad.remote.IConnection;
import javax.rad.remote.event.CallBackForward;
import javax.rad.remote.event.ICallBackListener;
import javax.rad.remote.event.IConnectionPropertyChangedListener;
import javax.rad.remote.event.PropertyEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectServerConnection
implements IConnection {
    private IDirectServer server = null;
    private boolean bCalling = false;
    private ArrayUtil<IConnectionPropertyChangedListener> auPropertyChangedListeners;

    public DirectServerConnection() {
        if (this.server == null) {
            this.server = Server.getInstance();
        }
    }

    public DirectServerConnection(IDirectServer iDirectServer) {
        this.server = iDirectServer;
    }

    @Override
    public synchronized void open(ConnectionInfo connectionInfo) throws Throwable {
        connectionInfo.setLastCallTime(System.currentTimeMillis());
        if (connectionInfo.getConnectionId() != null) {
            throw new SecurityException("Session is already open!");
        }
        Object object = this.server.createSession(connectionInfo.getProperties());
        connectionInfo.setConnectionId(object);
        this.syncProperties(connectionInfo);
    }

    @Override
    public synchronized void openSub(ConnectionInfo connectionInfo, ConnectionInfo connectionInfo2) throws Throwable {
        connectionInfo.setLastCallTime(System.currentTimeMillis());
        if (connectionInfo2.getConnectionId() != null) {
            throw new SecurityException("Session is already open!");
        }
        Object object = this.server.createSubSession(connectionInfo.getConnectionId(), connectionInfo2.getProperties());
        connectionInfo2.setConnectionId(object);
        this.syncProperties(connectionInfo2);
    }

    @Override
    public boolean isOpen(ConnectionInfo connectionInfo) {
        return connectionInfo != null && connectionInfo.getConnectionId() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close(ConnectionInfo connectionInfo) throws Throwable {
        if (this.isOpen(connectionInfo)) {
            connectionInfo.setLastCallTime(System.currentTimeMillis());
            try {
                this.server.destroySession(connectionInfo.getConnectionId());
                Object var3_2 = null;
                connectionInfo.setConnectionId(null);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                connectionInfo.setConnectionId(null);
                throw throwable;
            }
        } else {
            throw new IllegalStateException("Connection not open");
        }
    }

    @Override
    public synchronized void reopen(ConnectionInfo connectionInfo) throws Throwable {
        connectionInfo.setLastCallTime(System.currentTimeMillis());
        try {
            this.close(connectionInfo);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.open(connectionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object[] call(ConnectionInfo connectionInfo, String[] stringArray, String[] stringArray2, Object[][] objectArray, ICallBackListener[] iCallBackListenerArray) throws Throwable {
        try {
            this.bCalling = true;
            if (connectionInfo == null) {
                throw new IllegalArgumentException("Invalid connection information: null");
            }
            if (connectionInfo.getConnectionId() == null) {
                throw new IllegalStateException("The connection is not open!");
            }
            if (stringArray2 == null) {
                throw new IllegalArgumentException("No remote method specified!");
            }
            if (stringArray != null && stringArray2.length != stringArray.length) {
                throw new IllegalArgumentException("More or less objects than methods!");
            }
            if (objectArray != null && objectArray.length != stringArray2.length) {
                throw new IllegalArgumentException("More or less params than methods!");
            }
            Object object = connectionInfo.getConnectionId();
            if (!(object != null || stringArray != null && "Session!".equals(stringArray[0]) && ("createSession".equals(stringArray2[0]) || "createSubSession".equals(stringArray2[0])))) {
                throw new IOException("Connection is not open!");
            }
            if (iCallBackListenerArray != null && iCallBackListenerArray.length != stringArray2.length) {
                throw new IllegalArgumentException("More or less callbacks than methods!");
            }
            Object[] objectArray2 = new Object[stringArray2.length];
            Object object2 = connectionInfo.getConnectionId();
            int n = objectArray2.length;
            for (int i = 0; i < n; ++i) {
                Object var16_17;
                Object var14_16;
                Throwable throwable = null;
                try {
                    block20: {
                        try {
                            if (iCallBackListenerArray == null || iCallBackListenerArray[i] == null) {
                                objectArray2[i] = this.server.execute(object2, stringArray != null ? stringArray[i] : null, stringArray2[i], objectArray != null ? objectArray[i] : null);
                                break block20;
                            }
                            this.server.executeCallBack(object2, new CallBackForward(this, iCallBackListenerArray[i]), stringArray != null ? stringArray[i] : null, stringArray2[i], objectArray != null ? objectArray[i] : null);
                            objectArray2[i] = null;
                        }
                        catch (Throwable throwable2) {
                            objectArray2[i] = null;
                            throwable = throwable2;
                            var14_16 = null;
                            connectionInfo.setLastCallTime(System.currentTimeMillis());
                        }
                    }
                    var14_16 = null;
                    connectionInfo.setLastCallTime(System.currentTimeMillis());
                }
                catch (Throwable throwable3) {
                    var14_16 = null;
                    connectionInfo.setLastCallTime(System.currentTimeMillis());
                    throw throwable3;
                }
                try {
                    try {
                        this.syncProperties(connectionInfo);
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        }
                        var16_17 = null;
                        connectionInfo.setLastCallTime(System.currentTimeMillis());
                    }
                    var16_17 = null;
                    connectionInfo.setLastCallTime(System.currentTimeMillis());
                }
                catch (Throwable throwable5) {
                    var16_17 = null;
                    connectionInfo.setLastCallTime(System.currentTimeMillis());
                    throw throwable5;
                }
                if (throwable == null) continue;
                throw throwable;
            }
            Object[] objectArray3 = objectArray2;
            Object var18_20 = null;
            this.bCalling = false;
            return objectArray3;
        }
        catch (Throwable throwable) {
            Object var18_21 = null;
            this.bCalling = false;
            throw throwable;
        }
    }

    @Override
    public boolean isCalling() {
        return this.bCalling;
    }

    @Override
    public synchronized ConnectionInfo[] setAndCheckAlive(ConnectionInfo connectionInfo, ConnectionInfo[] connectionInfoArray) throws Throwable {
        Object[] objectArray;
        Hashtable<Object, ConnectionInfo> hashtable;
        connectionInfo.setLastCallTime(System.currentTimeMillis());
        if (connectionInfoArray != null) {
            hashtable = new Hashtable<Object, ConnectionInfo>();
            objectArray = new Object[connectionInfoArray.length];
            int n = connectionInfoArray.length;
            for (int i = 0; i < n; ++i) {
                objectArray[i] = connectionInfoArray[i].getConnectionId();
                hashtable.put(objectArray[i], connectionInfoArray[i]);
            }
        } else {
            hashtable = null;
            objectArray = null;
        }
        Object[] objectArray2 = this.server.setAndCheckAlive(connectionInfo.getConnectionId(), objectArray);
        this.syncProperties(connectionInfo);
        if (objectArray2 == null) {
            return null;
        }
        ConnectionInfo[] connectionInfoArray2 = new ConnectionInfo[objectArray2.length];
        int n = objectArray2.length;
        for (int i = 0; i < n; ++i) {
            connectionInfoArray2[i] = (ConnectionInfo)hashtable.get(objectArray2[i]);
        }
        return connectionInfoArray2;
    }

    @Override
    public synchronized void setProperty(ConnectionInfo connectionInfo, String string, Object object) throws Throwable {
        if (string != null && string.startsWith("client.")) {
            if (this.isOpen(connectionInfo)) {
                throw new SecurityException("Client properties are not accessible after the connection was opened!");
            }
            Object object2 = connectionInfo.getProperties().put(string, object, false);
            this.firePropertyChanged(string, object2, object);
        } else {
            Object object3 = connectionInfo.getProperties().put(string, object, false);
            this.firePropertyChanged(string, object3, object);
            if (this.isOpen(connectionInfo)) {
                connectionInfo.setLastCallTime(System.currentTimeMillis());
                this.server.setProperty(connectionInfo.getConnectionId(), string, object);
                this.syncProperties(connectionInfo);
            }
        }
    }

    @Override
    public synchronized Object getProperty(ConnectionInfo connectionInfo, String string) throws Throwable {
        if (connectionInfo != null) {
            connectionInfo.setLastCallTime(System.currentTimeMillis());
            if (this.isOpen(connectionInfo)) {
                this.syncProperties(connectionInfo);
            }
            return connectionInfo.getProperties().get(string);
        }
        return null;
    }

    @Override
    public synchronized Hashtable<String, Object> getProperties(ConnectionInfo connectionInfo) throws Throwable {
        if (connectionInfo != null) {
            connectionInfo.setLastCallTime(System.currentTimeMillis());
            if (this.isOpen(connectionInfo)) {
                this.syncProperties(connectionInfo);
            }
            return (Hashtable)connectionInfo.getProperties().clone();
        }
        return null;
    }

    @Override
    public void addPropertyChangedListener(IConnectionPropertyChangedListener iConnectionPropertyChangedListener) {
        if (this.auPropertyChangedListeners == null) {
            this.auPropertyChangedListeners = new ArrayUtil();
        }
        this.auPropertyChangedListeners.add(iConnectionPropertyChangedListener);
    }

    @Override
    public void removePropertyChangedListener(IConnectionPropertyChangedListener iConnectionPropertyChangedListener) {
        if (this.auPropertyChangedListeners != null) {
            this.auPropertyChangedListeners.remove(iConnectionPropertyChangedListener);
        }
    }

    @Override
    public synchronized void setNewPassword(ConnectionInfo connectionInfo, String string, String string2) throws Throwable {
        connectionInfo.setLastCallTime(System.currentTimeMillis());
        this.server.setNewPassword(connectionInfo.getConnectionId(), string, string2);
        this.syncProperties(connectionInfo);
    }

    private void syncProperties(ConnectionInfo connectionInfo) throws Throwable {
        ChangedHashtable<String, Object> changedHashtable = this.server.getProperties(connectionInfo.getConnectionId());
        ChangedHashtable<String, Object> changedHashtable2 = connectionInfo.getProperties();
        for (Map.Entry object : changedHashtable.entrySet()) {
            String string = (String)object.getKey();
            Object v = object.getValue();
            Object object2 = changedHashtable2.put(string, v, false);
            this.firePropertyChanged(string, object2, v);
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(changedHashtable2);
        for (String string : hashtable.keySet()) {
            if (changedHashtable.containsKey(string)) continue;
            changedHashtable2.remove(string);
        }
    }

    private void firePropertyChanged(String string, Object object, Object object2) {
        if (!(this.auPropertyChangedListeners == null || object == null && object2 == null || object != null && object.equals(object2))) {
            PropertyEvent propertyEvent = new PropertyEvent(string, object, object2);
            for (IConnectionPropertyChangedListener iConnectionPropertyChangedListener : this.auPropertyChangedListeners) {
                iConnectionPropertyChangedListener.propertyChanged(propertyEvent);
            }
        }
    }
}

