/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.persist.jdbc.CheckConstraintSupport;
import com.sibvisions.rad.persist.jdbc.DBAccess;
import com.sibvisions.rad.persist.jdbc.ForeignKey;
import com.sibvisions.rad.persist.jdbc.Key;
import com.sibvisions.rad.persist.jdbc.Name;
import com.sibvisions.rad.persist.jdbc.ServerColumnMetaData;
import com.sibvisions.rad.persist.jdbc.ServerMetaData;
import com.sibvisions.rad.persist.jdbc.TableInfo;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.StringUtil;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.rad.model.condition.ICondition;
import javax.rad.model.datatype.BigDecimalDataType;
import javax.rad.model.datatype.IDataType;
import javax.rad.model.datatype.TimestampDataType;
import javax.rad.persist.ColumnMetaData;
import javax.rad.persist.DataSourceException;
import oracle.sql.Datum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDBAccess
extends DBAccess {
    private static String sUKSelect = "SELECT cons.constraint_name FROM all_constraints cons WHERE cons.table_name = ? AND cons.constraint_type = 'U' AND cons.owner = ? ";
    private static String sConstraintColumnsSelect = "SELECT cols.column_name ,cols.table_name FROM all_cons_columns cols WHERE cols.owner = ? AND cols.constraint_name = ? ORDER BY POSITION";
    private static String sPKSelect = "SELECT cons.constraint_name FROM all_constraints cons WHERE cons.constraint_type = 'P' AND cons.table_name = ? AND cons.owner = ?";
    private static String sFKSelect = "SELECT  c.constraint_name   fk_name  ,r_owner             pktable_schem  ,c.r_constraint_name pk_name FROM all_constraints c WHERE c.table_name = ? AND c.constraint_type = 'R' AND c.owner = ? ORDER BY c.owner, c.table_name, c.constraint_name";
    private static String sCheckSelect = "select /*+ rule */ search_condition from user_constraints where constraint_type = 'C' and generated = 'USER NAME' and status = 'ENABLED' and table_name = ?";
    private static String sSynonymSelect = "select s.table_owner, s.table_name, s.db_link FROM user_synonyms s WHERE s.synonym_name = ?";

    public OracleDBAccess() {
        this.setDriver("oracle.jdbc.OracleDriver");
    }

    @Override
    public String getDatabaseSpecificLockStatement(String string, ServerMetaData serverMetaData, ICondition iCondition) throws DataSourceException {
        return super.getDatabaseSpecificLockStatement(string, serverMetaData, iCondition) + " NOWAIT";
    }

    @Override
    public Object[] insertDatabaseSpecific(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, String string3) throws DataSourceException {
        return this.insertOracle(string, string2, serverMetaData, objectArray, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void open() throws DataSourceException {
        super.open();
        Statement statement = null;
        try {
            try {
                statement = this.getConnection().createStatement();
                statement.executeUpdate("ALTER SESSION SET NLS_COMP='BINARY'");
                statement.executeUpdate("ALTER SESSION SET NLS_SORT='BINARY'");
            }
            catch (SQLException sQLException) {
                Object var4_3 = null;
                CommonUtil.close(statement);
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            CommonUtil.close(statement);
            throw throwable;
        }
        CommonUtil.close(statement);
    }

    @Override
    protected List<Key> getUniqueKeysIntern(String string, String string2, String string3) throws DataSourceException {
        Object object;
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet2 = null;
        PreparedStatement preparedStatement2 = null;
        try {
            ArrayUtil<Key> arrayUtil = new ArrayUtil<Key>();
            ArrayUtil<Name> arrayUtil2 = new ArrayUtil<Name>();
            long l = System.currentTimeMillis();
            preparedStatement = this.getPreparedStatement(sUKSelect, false);
            preparedStatement2 = this.getPreparedStatement(sConstraintColumnsSelect, false);
            preparedStatement.setString(1, OracleDBAccess.removeQuotes(string3));
            preparedStatement.setString(2, OracleDBAccess.removeQuotes(string2));
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = resultSet.getString("CONSTRAINT_NAME");
                preparedStatement2.setString(1, OracleDBAccess.removeQuotes(string2));
                preparedStatement2.setString(2, (String)object);
                resultSet2 = preparedStatement2.executeQuery();
                while (resultSet2.next()) {
                    arrayUtil2.add(new Name(resultSet2.getString("COLUMN_NAME"), this.quote(resultSet2.getString("COLUMN_NAME"))));
                }
                CommonUtil.close(resultSet2);
                Key key = new Key((String)object, arrayUtil2.toArray(new Name[arrayUtil2.size()]));
                arrayUtil.add(key);
                arrayUtil2.clear();
            }
            if (OracleDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                OracleDBAccess.debug("getUKs(", string3, ") in ", System.currentTimeMillis() - l, "ms");
            }
            object = arrayUtil;
            Object var15_14 = null;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Unique Keys couldn't determined from database! - " + string3, this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                CommonUtil.close(resultSet, preparedStatement, resultSet2, preparedStatement2);
                throw throwable;
            }
        }
        CommonUtil.close(resultSet, preparedStatement, resultSet2, preparedStatement2);
        return object;
    }

    @Override
    protected Key getPrimaryKeyIntern(String string, String string2, String string3) throws DataSourceException {
        String string4;
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        try {
            Key key = null;
            ArrayUtil<Name> arrayUtil = new ArrayUtil<Name>();
            long l = System.currentTimeMillis();
            preparedStatement = this.getPreparedStatement(sPKSelect, false);
            preparedStatement.setString(1, OracleDBAccess.removeQuotes(string3));
            preparedStatement.setString(2, OracleDBAccess.removeQuotes(string2));
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string4 = resultSet.getString("CONSTRAINT_NAME");
                CommonUtil.close(resultSet, preparedStatement);
                preparedStatement = this.getPreparedStatement(sConstraintColumnsSelect, false);
                preparedStatement.setString(1, OracleDBAccess.removeQuotes(string2));
                preparedStatement.setString(2, string4);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    do {
                        arrayUtil.add(new Name(resultSet.getString("COLUMN_NAME"), this.quote(resultSet.getString("COLUMN_NAME"))));
                    } while (resultSet.next());
                    if (arrayUtil.size() > 0) {
                        key = new Key(string4, arrayUtil.toArray(new Name[arrayUtil.size()]));
                    }
                }
            }
            if (OracleDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                OracleDBAccess.debug("getPK(", string3, ") in ", System.currentTimeMillis() - l, "ms");
            }
            string4 = key;
            Object var12_11 = null;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Primary Key couldn't determined from database! - " + string3, this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                CommonUtil.close(resultSet, preparedStatement);
                throw throwable;
            }
        }
        CommonUtil.close(resultSet, preparedStatement);
        return string4;
    }

    @Override
    protected List<ForeignKey> getForeignKeysIntern(String string, String string2, String string3) throws DataSourceException {
        Object object;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        ResultSet resultSet2 = null;
        PreparedStatement preparedStatement2 = null;
        try {
            ArrayUtil<ForeignKey> arrayUtil = new ArrayUtil<ForeignKey>();
            long l = System.currentTimeMillis();
            String string4 = this.getConnection().getCatalog();
            preparedStatement = this.getPreparedStatement(sFKSelect, false);
            preparedStatement2 = this.getPreparedStatement(sConstraintColumnsSelect, false);
            preparedStatement.setString(1, OracleDBAccess.removeQuotes(string3));
            preparedStatement.setString(2, OracleDBAccess.removeQuotes(string2));
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = resultSet.getString("FK_NAME");
                String string5 = resultSet.getString("PK_NAME");
                String string6 = resultSet.getString("PKTABLE_SCHEM");
                String string7 = null;
                ArrayUtil<Name> arrayUtil2 = new ArrayUtil<Name>();
                ArrayUtil<Name> arrayUtil3 = new ArrayUtil<Name>();
                preparedStatement2.setString(1, OracleDBAccess.removeQuotes(string2));
                preparedStatement2.setString(2, (String)object);
                resultSet2 = preparedStatement2.executeQuery();
                while (resultSet2.next()) {
                    arrayUtil3.add(new Name(resultSet2.getString("COLUMN_NAME"), this.quote(resultSet2.getString("COLUMN_NAME"))));
                }
                CommonUtil.close(resultSet2);
                preparedStatement2.setString(1, string6);
                preparedStatement2.setString(2, string5);
                resultSet2 = preparedStatement2.executeQuery();
                while (resultSet2.next()) {
                    if (string7 == null) {
                        string7 = resultSet2.getString("TABLE_NAME");
                    }
                    arrayUtil2.add(new Name(resultSet2.getString("COLUMN_NAME"), this.quote(resultSet2.getString("COLUMN_NAME"))));
                }
                CommonUtil.close(resultSet2);
                ForeignKey foreignKey = new ForeignKey(new Name(string7, this.quote(string7)), new Name(string4, this.quote(string4)), new Name(string6, this.quote(string6)));
                foreignKey.setFKName((String)object);
                foreignKey.setFKColumns(arrayUtil3.toArray(new Name[arrayUtil3.size()]));
                foreignKey.setPKColumns(arrayUtil2.toArray(new Name[arrayUtil2.size()]));
                arrayUtil.add(foreignKey);
                arrayUtil2.clear();
                arrayUtil3.clear();
            }
            if (OracleDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                OracleDBAccess.debug("getFKs(", string3, ") in ", System.currentTimeMillis() - l, "ms");
            }
            object = arrayUtil;
            Object var20_19 = null;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Foreign Keys couldn't determined from database! - " + string3, this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                Object var20_20 = null;
                CommonUtil.close(resultSet, preparedStatement, resultSet2, preparedStatement2);
                throw throwable;
            }
        }
        CommonUtil.close(resultSet, preparedStatement, resultSet2, preparedStatement2);
        return object;
    }

    @Override
    protected String getTableForSynonymIntern(String string) throws DataSourceException {
        String string2;
        long l;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block8: {
            preparedStatement = null;
            resultSet = null;
            l = System.currentTimeMillis();
            preparedStatement = this.getPreparedStatement(sSynonymSelect, false);
            preparedStatement.setString(1, OracleDBAccess.removeQuotes(string));
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) break block8;
            String string3 = string;
            Object var12_8 = null;
            CommonUtil.close(resultSet, preparedStatement);
            return string3;
        }
        try {
            String string4 = resultSet.getString("TABLE_OWNER");
            String string5 = resultSet.getString("TABLE_NAME");
            String string6 = resultSet.getString("DB_LINK");
            StringBuilder stringBuilder = new StringBuilder();
            if (string4 != null) {
                stringBuilder.append(string4);
                stringBuilder.append('.');
            }
            stringBuilder.append(string5);
            if (string6 != null) {
                stringBuilder.append('@');
                stringBuilder.append(string6);
            }
            if (OracleDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                OracleDBAccess.debug("getTableForSynonym(", string, ") in ", System.currentTimeMillis() - l, "ms");
            }
            string2 = stringBuilder.toString();
            Object var12_9 = null;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Synonyms couldn't determined from database! - " + string, this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                Object var12_10 = null;
                CommonUtil.close(resultSet, preparedStatement);
                throw throwable;
            }
        }
        CommonUtil.close(resultSet, preparedStatement);
        return string2;
    }

    @Override
    protected Map<String, Object> getDefaultValuesIntern(String string, String string2, String string3) throws DataSourceException {
        return super.getDefaultValuesIntern(string, string2, string3.toUpperCase());
    }

    @Override
    protected Object translateDefaultValue(String string, int n, String string2) throws Exception {
        return super.translateDefaultValue(string, n, StringUtil.removeQuotes(string2, "'"));
    }

    @Override
    protected Map<String, Object[]> getAllowedValuesIntern(String string, String string2, String string3) throws DataSourceException {
        Hashtable<String, Object[]> hashtable;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Hashtable<String, List<String>> hashtable2 = null;
        try {
            try {
                preparedStatement = this.getPreparedStatement(sCheckSelect, false);
                preparedStatement.setString(1, string3);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    hashtable2 = CheckConstraintSupport.parseCondition(resultSet.getString(1), hashtable2, true);
                }
                hashtable = CheckConstraintSupport.translateValues(this, string, string2, string3, hashtable2);
            }
            catch (SQLException sQLException) {
                throw new DataSourceException("Can't access check constraints for: '" + string3 + "'", this.formatSQLException(sQLException));
            }
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            CommonUtil.close(resultSet, preparedStatement);
            throw throwable;
        }
        CommonUtil.close(resultSet, preparedStatement);
        return hashtable;
    }

    @Override
    protected Object convertDatabaseSpecificObjectToValue(ServerColumnMetaData serverColumnMetaData, Object object) throws SQLException {
        if (object instanceof Datum) {
            return ((Datum)object).timestampValue();
        }
        return object;
    }

    private Object[] insertOracle(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, String string3) throws DataSourceException {
        CallableStatement callableStatement;
        StringBuffer stringBuffer;
        block14: {
            int n;
            int n2;
            stringBuffer = new StringBuffer("BEGIN " + string2);
            stringBuffer.append(" RETURNING ");
            int[] nArray = serverMetaData.getPrimaryKeyColumnIndices();
            for (n2 = 0; nArray != null && n2 < nArray.length; ++n2) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(serverMetaData.getServerColumnMetaData(nArray[n2]).getColumnName().getQuotedName());
            }
            stringBuffer.append(" INTO ");
            for (n2 = 0; nArray != null && n2 < nArray.length; ++n2) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("?");
            }
            stringBuffer.append("; END;");
            callableStatement = null;
            String string4 = this.translateQuotes(stringBuffer.toString());
            OracleDBAccess.debug("executeSQL->", string4);
            callableStatement = this.getConnection().prepareCall(string4);
            ServerColumnMetaData[] serverColumnMetaDataArray = serverMetaData.getServerColumnMetaData();
            int[] nArray2 = serverMetaData.getWritableColumnIndices();
            int n3 = 0;
            if (string3 == null) {
                n3 = this.setColumnsToStore(callableStatement, serverColumnMetaDataArray, nArray2, objectArray, null);
            } else {
                for (n = 0; n < serverColumnMetaDataArray.length; ++n) {
                    if (!serverColumnMetaDataArray[n].getColumnName().getQuotedName().equals(string3)) continue;
                    callableStatement.setObject(1, null, serverColumnMetaDataArray[n].getSQLType());
                    break;
                }
                n3 = 1;
            }
            for (n = 0; nArray != null && n < nArray.length; ++n) {
                IDataType iDataType = ColumnMetaData.createDataType(serverColumnMetaDataArray[nArray[n]].getColumnMetaData());
                int n4 = iDataType instanceof BigDecimalDataType ? 2 : (iDataType instanceof TimestampDataType ? 93 : 1);
                callableStatement.registerOutParameter(n3 + n + 1, n4);
            }
            if (this.executeUpdate(callableStatement) != 1) break block14;
            for (n = 0; nArray != null && n < nArray.length; ++n) {
                objectArray[nArray[n]] = callableStatement.getObject(n3 + n + 1);
            }
            Object[] objectArray2 = objectArray;
            Object var17_19 = null;
            CommonUtil.close(callableStatement);
            return objectArray2;
        }
        try {
            try {
                throw new DataSourceException("Insert failed ! - Result row count != 1 ! - " + stringBuffer);
            }
            catch (SQLException sQLException) {
                throw new DataSourceException("Insert failed! - " + stringBuffer, this.formatSQLException(sQLException));
            }
        }
        catch (Throwable throwable) {
            Object var17_20 = null;
            CommonUtil.close(callableStatement);
            throw throwable;
        }
    }

    @Override
    protected TableInfo getTableInfoIntern(String string) throws DataSourceException {
        String string2;
        TableInfo tableInfo = super.getTableInfoIntern(string);
        String string3 = tableInfo.getSchema();
        if (string3 == null) {
            string3 = this.getUsername().toUpperCase();
        }
        if ((string2 = tableInfo.getTable()) != null && !string2.startsWith("`") && !string2.endsWith("`")) {
            string2 = string2.toUpperCase();
        }
        return new TableInfo(tableInfo.getCatalog(), string3, string2);
    }
}

