/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.model.DataBookCSVExporter;
import com.sibvisions.rad.model.Filter;
import com.sibvisions.rad.persist.AbstractCachedStorage;
import com.sibvisions.rad.persist.jdbc.DBAccess;
import com.sibvisions.rad.persist.jdbc.ForeignKey;
import com.sibvisions.rad.persist.jdbc.IDBAccess;
import com.sibvisions.rad.persist.jdbc.Key;
import com.sibvisions.rad.persist.jdbc.Name;
import com.sibvisions.rad.persist.jdbc.ServerColumnMetaData;
import com.sibvisions.rad.persist.jdbc.ServerMetaData;
import com.sibvisions.rad.persist.jdbc.TableInfo;
import com.sibvisions.rad.server.protocol.ProtocolFactory;
import com.sibvisions.rad.server.protocol.Record;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.BeanUtil;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.StringUtil;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.rad.model.ModelException;
import javax.rad.model.RowDefinition;
import javax.rad.model.SortDefinition;
import javax.rad.model.condition.And;
import javax.rad.model.condition.ICondition;
import javax.rad.model.datatype.IDataType;
import javax.rad.model.reference.StorageReferenceDefinition;
import javax.rad.persist.ColumnMetaData;
import javax.rad.persist.DataSourceException;
import javax.rad.persist.MetaData;
import javax.rad.util.TranslationMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBStorage
extends AbstractCachedStorage {
    public static final String SUBSTORAGE_PREFIX = ".subStorages.";
    private static final String AUTOMATICLINKREFERENCE_PREFIX = ".FK.";
    private ServerMetaData mdServerMetaData = new ServerMetaData();
    private HashMap<String, DBStorage> hmpSubStorages = new HashMap();
    private ArrayUtil<StorageReferenceDefinition> auManualLinkReferences = new ArrayUtil();
    private ArrayUtil<StorageReferenceDefinition> auAutomaticLinkReferences = new ArrayUtil();
    private boolean bIsOpen = false;
    private DBAccess dbAccess;
    private String sFromClause;
    private String sFromClauseBeforeOpen;
    private String[] saQueryColumns;
    private String[] saQueryColumnsBeforeOpen;
    private String sBeforeQueryColumns;
    private String sWhereClause;
    private String sAfterWhereClause;
    private String sOrderByClause;
    private String[] saWritebackColumns;
    private String sWritebackTable;
    private String sSchema;
    private String sCatalog;
    private SortDefinition sdDefaultSort;
    private ICondition cRestrictCondition;
    private Boolean bAutoLinkReference;
    private static boolean bDefaultAutoLinkReference = true;
    private Boolean bDefaultValue;
    private static boolean bDefaultDefaultValue = true;
    private Boolean bAllowedValues;
    private boolean bLazyFetchEnabled = true;
    private static boolean bDefaultAllowedValues = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeCSV(OutputStream outputStream, String[] stringArray, String[] stringArray2, ICondition iCondition, SortDefinition sortDefinition, String string) throws Exception {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "ISO-8859-15");
        try {
            int n;
            if (this.cRestrictCondition != null) {
                iCondition = iCondition == null ? this.cRestrictCondition : new And(this.cRestrictCondition, iCondition);
            }
            if (sortDefinition == null) {
                sortDefinition = this.sdDefaultSort;
            }
            if (stringArray == null) {
                stringArray = this.mdServerMetaData.getColumnNames();
            }
            if (stringArray2 == null) {
                stringArray2 = new String[stringArray.length];
                for (n = 0; n < stringArray.length; ++n) {
                    stringArray2[n] = this.mdServerMetaData.getServerColumnMetaData(stringArray[n]).getLabel();
                    if (stringArray2[n] != null) continue;
                    stringArray2[n] = ColumnMetaData.getDefaultLabel(stringArray[n]);
                }
            }
            for (n = 0; n < stringArray2.length; ++n) {
                if (n > 0) {
                    outputStreamWriter.write(string);
                }
                outputStreamWriter.write(StringUtil.quote(stringArray2[n], '\"'));
            }
            outputStreamWriter.write("\n");
            IDataType[] iDataTypeArray = new IDataType[stringArray.length];
            int[] nArray = new int[stringArray.length];
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                iDataTypeArray[i] = ColumnMetaData.createDataType(this.mdServerMetaData.getServerColumnMetaData(stringArray[i]).getColumnMetaData());
                nArray[i] = this.mdServerMetaData.getServerColumnMetaDataIndex(stringArray[i]);
            }
            int n3 = 0;
            boolean bl = false;
            String string2 = this.getFromClauseIntern();
            while (!bl) {
                List<Object[]> list = this.dbAccess.fetch(this.mdServerMetaData, this.sBeforeQueryColumns, this.saQueryColumns, string2, iCondition, this.sWhereClause, this.sAfterWhereClause, sortDefinition, this.sOrderByClause, n3, 1000, false);
                n3 += list.size();
                int n4 = list.size();
                for (int i = 0; i < n4; ++i) {
                    Object[] objectArray = list.get(i);
                    if (objectArray != null) {
                        for (int j = 0; j < stringArray.length; ++j) {
                            if (j > 0) {
                                outputStreamWriter.write(string);
                            }
                            DataBookCSVExporter.writeQuoted(outputStreamWriter, iDataTypeArray[j], objectArray[nArray[j]], string);
                        }
                        outputStreamWriter.write("\n");
                        continue;
                    }
                    bl = true;
                }
            }
            outputStreamWriter.flush();
            Object var19_21 = null;
        }
        catch (Throwable throwable) {
            Object var19_22 = null;
            CommonUtil.close(outputStreamWriter);
            throw throwable;
        }
        CommonUtil.close(outputStreamWriter);
    }

    @Override
    public MetaData getMetaData() throws DataSourceException {
        return this.mdServerMetaData.getMetaData();
    }

    @Override
    public int getEstimatedRowCount(ICondition iCondition) throws DataSourceException {
        List<Object[]> list;
        if (!this.isOpen()) {
            throw new DataSourceException("DBStorage isn't open!");
        }
        if (this.cRestrictCondition != null) {
            iCondition = iCondition == null ? this.cRestrictCondition : new And(this.cRestrictCondition, iCondition);
        }
        if ((list = this.dbAccess.fetch(this.mdServerMetaData, this.sBeforeQueryColumns, new String[]{"COUNT(*)"}, this.getFromClauseIntern(), iCondition, this.sWhereClause, this.sAfterWhereClause, null, 0, 1, false)) != null && list.size() >= 1 && list.get(0).length > 0) {
            Object object = list.get(0)[0];
            if (object instanceof Integer) {
                return (Integer)object;
            }
            if (object instanceof BigDecimal) {
                return ((BigDecimal)object).intValue();
            }
            throw new DataSourceException("countRows() result data typ not supported! - " + object.getClass().getName());
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<Object[]> executeFetch(ICondition iCondition, SortDefinition sortDefinition, int n, int n2) throws DataSourceException {
        List<Object[]> list;
        Record record = ProtocolFactory.openRecord("EXECUTE_FETCH", new Object[0]);
        try {
            if (!this.isOpen()) {
                throw new DataSourceException("DBStorage isn't open!");
            }
            if (this.cRestrictCondition != null) {
                iCondition = iCondition == null ? this.cRestrictCondition : new And(this.cRestrictCondition, iCondition);
            }
            if (sortDefinition == null) {
                sortDefinition = this.sdDefaultSort;
            }
            if (record != null) {
                record.setParameter(iCondition, sortDefinition, n, n2);
            }
            list = this.dbAccess.fetch(this.mdServerMetaData, this.sBeforeQueryColumns, this.saQueryColumns, this.getFromClauseIntern(), iCondition, this.sWhereClause, this.sAfterWhereClause, sortDefinition, this.sOrderByClause, n, n2, this.bLazyFetchEnabled);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            CommonUtil.close(record);
            throw throwable;
        }
        CommonUtil.close(record);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object[] executeRefetchRow(Object[] objectArray) throws DataSourceException {
        Object[] objectArray2;
        Record record = ProtocolFactory.openRecord("EXECUTE_REFETCH", new Object[0]);
        try {
            if (!this.isOpen()) {
                throw new DataSourceException("DBStorage isn't open!");
            }
            objectArray2 = this.refetchRow(objectArray, true);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            CommonUtil.close(record);
            throw throwable;
        }
        CommonUtil.close(record);
        return objectArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object[] executeInsert(Object[] objectArray) throws DataSourceException {
        Object[] objectArray2;
        Object[] objectArray3;
        Record record;
        block6: {
            block5: {
                Object[] objectArray4;
                record = ProtocolFactory.openRecord("EXECUTE_INSERT", new Object[0]);
                try {
                    if (!this.isOpen()) {
                        throw new DataSourceException("DBStorage isn't open!");
                    }
                    if (this.getWritebackTable() != null) break block5;
                    objectArray4 = null;
                    Object var7_5 = null;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    CommonUtil.close(record);
                    throw throwable;
                }
                CommonUtil.close(record);
                return objectArray4;
            }
            objectArray3 = this.dbAccess.insert(this.getWritebackTable(), this.mdServerMetaData, objectArray);
            if (!this.isRefetch() || (objectArray2 = this.refetchRow(objectArray3, false)) == null) break block6;
            Object[] objectArray5 = objectArray2;
            Object var7_6 = null;
            CommonUtil.close(record);
            return objectArray5;
        }
        objectArray2 = objectArray3;
        Object var7_7 = null;
        CommonUtil.close(record);
        return objectArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object[] executeUpdate(Object[] objectArray, Object[] objectArray2) throws DataSourceException {
        Object[] objectArray3;
        Record record;
        block6: {
            block5: {
                Object[] objectArray4;
                record = ProtocolFactory.openRecord("EXECUTE_UPDATE", new Object[0]);
                try {
                    if (!this.isOpen()) {
                        throw new DataSourceException("DBStorage isn't open!");
                    }
                    if (this.getWritebackTable() != null) break block5;
                    objectArray4 = null;
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    CommonUtil.close(record);
                    throw throwable;
                }
                CommonUtil.close(record);
                return objectArray4;
            }
            objectArray3 = this.dbAccess.update(this.getWritebackTable(), this.mdServerMetaData, objectArray, objectArray2);
            if (!this.isRefetch()) break block6;
            Object[] objectArray5 = this.refetchRow(objectArray3, false);
            Object var7_7 = null;
            CommonUtil.close(record);
            return objectArray5;
        }
        Object[] objectArray6 = objectArray3;
        Object var7_8 = null;
        CommonUtil.close(record);
        return objectArray6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void executeDelete(Object[] objectArray) throws DataSourceException {
        Record record;
        block5: {
            block4: {
                record = ProtocolFactory.openRecord("EXECUTE_DELETE", new Object[0]);
                try {
                    if (!this.isOpen()) {
                        throw new DataSourceException("DBStorage isn't open!");
                    }
                    if (this.getWritebackTable() == null) {
                        Object var4_3 = null;
                        break block4;
                    }
                    this.dbAccess.delete(this.getWritebackTable(), this.mdServerMetaData, objectArray);
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    CommonUtil.close(record);
                    throw throwable;
                }
            }
            CommonUtil.close(record);
            return;
        }
        Object var4_4 = null;
        CommonUtil.close(record);
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IsOpen()=");
        stringBuffer.append(this.bIsOpen);
        stringBuffer.append("\n");
        stringBuffer.append(this.dbAccess);
        stringBuffer.append("\n");
        stringBuffer.append(this.sBeforeQueryColumns);
        stringBuffer.append(" ");
        for (n = 0; this.saQueryColumns != null && n < this.saQueryColumns.length; ++n) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.saQueryColumns[n]);
        }
        stringBuffer.append("\n");
        stringBuffer.append(this.sFromClause);
        stringBuffer.append("\n");
        stringBuffer.append(this.sWhereClause);
        stringBuffer.append("\n");
        stringBuffer.append(this.sAfterWhereClause);
        stringBuffer.append("\n");
        stringBuffer.append("Writeback:\n");
        stringBuffer.append(this.getWritebackTable());
        stringBuffer.append("\n");
        for (n = 0; this.saWritebackColumns != null && n < this.saWritebackColumns.length; ++n) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.saWritebackColumns[n]);
        }
        return stringBuffer.toString();
    }

    public void setMetaData(MetaData metaData) throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBStorage isn't open!");
        }
        this.mdServerMetaData.setMetaData(metaData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws DataSourceException {
        Record record = ProtocolFactory.openRecord("OPEN_STORAGE", new Object[0]);
        try {
            this.sFromClauseBeforeOpen = this.getFromClause();
            String[] stringArray = this.getQueryColumns();
            this.saQueryColumnsBeforeOpen = stringArray != null ? stringArray : null;
            this.openInternal(false);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            CommonUtil.close(record);
            throw throwable;
        }
        CommonUtil.close(record);
    }

    protected void openInternal(boolean bl) throws DataSourceException {
        if (this.dbAccess == null) {
            throw new DataSourceException("DBAccess isn't set!");
        }
        this.createMetaData(this.getBeforeQueryColumns(), this.getQueryColumns(), this.getFromClause(), this.getWhereClause(), this.getAfterWhereClause(), this.getWritebackTable(), this.getWritebackColumns(), this.isAutoLinkReference(), bl);
        this.bIsOpen = true;
    }

    protected void refreshMetaData() throws DataSourceException {
        this.hmpSubStorages.clear();
        this.setFromClause(this.sFromClauseBeforeOpen);
        this.setQueryColumns(this.saQueryColumnsBeforeOpen);
        this.openInternal(false);
    }

    private String putSubStorage(DBStorage dBStorage) {
        String string = this.createSubStorageName(dBStorage);
        this.hmpSubStorages.put(string, dBStorage);
        return SUBSTORAGE_PREFIX + string;
    }

    private DBStorage getSubStorage(String string) {
        if (string.startsWith(SUBSTORAGE_PREFIX)) {
            return this.hmpSubStorages.get(string.substring(SUBSTORAGE_PREFIX.length()));
        }
        return null;
    }

    public void createAutomaticLinkReference(String[] stringArray, String string, String[] stringArray2) throws DataSourceException {
        if (this.isOpen()) {
            StorageReferenceDefinition storageReferenceDefinition = new StorageReferenceDefinition(stringArray, string, stringArray2);
            this.createAutomaticLinkStorage(storageReferenceDefinition, this.mdServerMetaData.getWritableColumnNames());
            this.installAutomaticLinkReferenceIntern(storageReferenceDefinition);
        } else {
            this.auManualLinkReferences.add(new StorageReferenceDefinition(stringArray, string, stringArray2));
        }
    }

    public void createAutomaticLinkReference(String[] stringArray, DBStorage dBStorage, String[] stringArray2) throws DataSourceException {
        String string = this.putSubStorage(dBStorage);
        StorageReferenceDefinition storageReferenceDefinition = new StorageReferenceDefinition(stringArray, string, stringArray2);
        if (this.isOpen()) {
            this.installAutomaticLinkReferenceIntern(storageReferenceDefinition);
        } else {
            this.auManualLinkReferences.add(new StorageReferenceDefinition(stringArray, string, stringArray2));
        }
    }

    private void addAutomaticLinkReferenceIntern(StorageReferenceDefinition storageReferenceDefinition, String[] stringArray) {
        String[] stringArray2 = ArrayUtil.intersect(storageReferenceDefinition.getColumnNames(), stringArray);
        int n = this.auAutomaticLinkReferences.size();
        for (int i = 0; i < n; ++i) {
            StorageReferenceDefinition storageReferenceDefinition2 = this.auAutomaticLinkReferences.get(i);
            String[] stringArray3 = ArrayUtil.intersect(storageReferenceDefinition2.getColumnNames(), stringArray);
            if (stringArray3.length == 0) {
                stringArray3 = storageReferenceDefinition2.getColumnNames();
            }
            if (stringArray3.length > stringArray2.length) {
                this.auAutomaticLinkReferences.add(i, storageReferenceDefinition);
                return;
            }
            if (stringArray3.length != stringArray2.length || !ArrayUtil.containsAll(stringArray3, stringArray2)) continue;
            this.auAutomaticLinkReferences.set(i, storageReferenceDefinition);
            return;
        }
        this.auAutomaticLinkReferences.add(storageReferenceDefinition);
    }

    private List<StorageReferenceDefinition> getSubAutomaticLinkReferences(StorageReferenceDefinition storageReferenceDefinition, String[] stringArray) {
        String[] stringArray2 = ArrayUtil.intersect(storageReferenceDefinition.getColumnNames(), stringArray);
        ArrayUtil<StorageReferenceDefinition> arrayUtil = new ArrayUtil<StorageReferenceDefinition>();
        for (StorageReferenceDefinition storageReferenceDefinition2 : this.auAutomaticLinkReferences) {
            String[] stringArray3 = ArrayUtil.intersect(storageReferenceDefinition2.getColumnNames(), stringArray);
            if (stringArray3.length >= stringArray2.length) {
                return arrayUtil;
            }
            if (stringArray3.length <= 0 || !ArrayUtil.containsAll(stringArray2, stringArray3)) continue;
            arrayUtil.add(storageReferenceDefinition2);
        }
        return arrayUtil;
    }

    protected void installAutomaticLinkReferenceIntern(StorageReferenceDefinition storageReferenceDefinition) throws DataSourceException {
        String[] stringArray = this.mdServerMetaData.getWritableColumnNames();
        this.addAutomaticLinkReferenceIntern(storageReferenceDefinition, stringArray);
        if (this.isAutoLinkReference()) {
            String[] stringArray2 = storageReferenceDefinition.getColumnNames();
            List<StorageReferenceDefinition> list = this.getSubAutomaticLinkReferences(storageReferenceDefinition, stringArray);
            for (StorageReferenceDefinition storageReferenceDefinition2 : list) {
                stringArray2 = ArrayUtil.removeAll(stringArray2, storageReferenceDefinition2.getColumnNames());
            }
            for (int i = 0; i < stringArray2.length; ++i) {
                try {
                    this.mdServerMetaData.getServerColumnMetaData(stringArray2[i]).setLinkReference(storageReferenceDefinition);
                    continue;
                }
                catch (ModelException modelException) {
                    throw new DataSourceException("Can't install automatic link reference!", modelException);
                }
            }
        }
    }

    protected String createSubStorageName(DBStorage dBStorage) {
        int n;
        Object object;
        String string;
        if (dBStorage.getName() != null) {
            string = dBStorage.getName();
        } else {
            object = dBStorage;
            string = ((DBStorage)object).getWritebackTable() != null ? ((DBStorage)object).getWritebackTable() : ((DBStorage)object).getFromClause();
            n = string.lastIndexOf(46);
            if (n >= 0) {
                string = string.substring(n + 1);
            }
            string = StringUtil.convertToMemberName(string);
        }
        object = string;
        n = 1;
        while (this.hasDifferentStorageWithName(dBStorage, (String)object)) {
            object = string + ++n;
        }
        return object;
    }

    private boolean hasDifferentStorageWithName(DBStorage dBStorage, String string) {
        DBStorage dBStorage2 = this.hmpSubStorages.get(string);
        if (dBStorage2 == null) {
            return false;
        }
        return !CommonUtil.equals(dBStorage2.getBeforeQueryColumns(), dBStorage.getBeforeQueryColumns()) || !Arrays.equals(dBStorage2.getQueryColumns(), dBStorage.getQueryColumns()) || !CommonUtil.equals(dBStorage2.getFromClause(), dBStorage.getFromClause()) || !CommonUtil.equals(dBStorage2.getWhereClause(), dBStorage.getWhereClause()) || !CommonUtil.equals(dBStorage2.getAfterWhereClause(), dBStorage.getAfterWhereClause()) || !CommonUtil.equals(dBStorage2.getWritebackTable(), dBStorage.getWritebackTable()) || !Arrays.equals(dBStorage2.getWritebackColumns(), dBStorage.getWritebackColumns()) || dBStorage2.isAutoLinkReference() != dBStorage.isAutoLinkReference();
    }

    protected void createAutomaticLinkStorage(StorageReferenceDefinition storageReferenceDefinition, String[] stringArray) throws DataSourceException {
        Object object;
        String[] stringArray2;
        Object object2;
        TranslationMap translationMap = DBAccess.getAutomaticLinkColumnNameTranslation();
        String string = storageReferenceDefinition.getReferencedStorage();
        String[] stringArray3 = storageReferenceDefinition.getColumnNames();
        String[] stringArray4 = storageReferenceDefinition.getReferencedColumnNames();
        String[] stringArray5 = ArrayUtil.intersect(stringArray3, stringArray);
        boolean bl = string.startsWith(AUTOMATICLINKREFERENCE_PREFIX);
        if (bl) {
            string = string.substring(AUTOMATICLINKREFERENCE_PREFIX.length());
        }
        DBStorage dBStorage = new DBStorage();
        dBStorage.setDBAccess(this.dbAccess);
        dBStorage.setWritebackTable(string);
        dBStorage.setAutoLinkReference(false);
        List<StorageReferenceDefinition> list = this.getSubAutomaticLinkReferences(storageReferenceDefinition, stringArray);
        if (list.size() > 0) {
            for (StorageReferenceDefinition storageReferenceDefinition2 : list) {
                object2 = storageReferenceDefinition2.getColumnNames();
                stringArray2 = storageReferenceDefinition2.getReferencedColumnNames();
                String string2 = storageReferenceDefinition2.getReferencedStorage();
                object = new String[((String[])object2).length];
                for (int i = 0; i < ((String[])object).length; ++i) {
                    int n = ArrayUtil.indexOf(stringArray3, object2[i]);
                    if (n < 0) {
                        Object object3 = object2[i];
                        int n2 = ((String)object2[i]).indexOf(95);
                        if (n2 >= 0) {
                            String string3 = ((String)object3).substring(0, n2);
                            String string4 = null;
                            for (int j = 0; string4 == null && j < stringArray3.length; ++j) {
                                if (!string3.equals(translationMap.translate(stringArray3[j]))) continue;
                                string4 = translationMap.translate(stringArray4[j]);
                            }
                            if (string4 != null) {
                                object3 = string4 + ((String)object3).substring(string3.length());
                            }
                        }
                        object[i] = object3;
                        stringArray3 = (String[])ArrayUtil.add(stringArray3, object2[i]);
                        stringArray4 = (String[])ArrayUtil.add(stringArray4, object[i]);
                        continue;
                    }
                    object[i] = stringArray4[n];
                    stringArray5 = (String[])ArrayUtil.remove(stringArray5, object2[i]);
                }
                dBStorage.createAutomaticLinkReference((String[])object, this.getSubStorage(string2), stringArray2);
            }
        }
        dBStorage.openInternal(false);
        if (bl) {
            int n = this.dbAccess.getMaxColumnLength();
            int n3 = n / 2 + 5;
            object2 = translationMap.translate(stringArray5[0]) + "_";
            if (((String)object2).length() > n3) {
                object2 = ((String)object2).substring(0, n3 - 1) + '_';
            }
            stringArray2 = dBStorage.getMetaData().getRepresentationColumnNames();
            for (int i = 0; i < stringArray2.length; ++i) {
                if (ArrayUtil.contains(stringArray4, stringArray2[i])) continue;
                object = (String)object2 + stringArray2[i];
                if (((String)object).length() > n) {
                    object = ((String)object).substring(0, n);
                }
                stringArray3 = (String[])ArrayUtil.add(stringArray3, object);
                stringArray4 = ArrayUtil.add(stringArray4, stringArray2[i]);
            }
        }
        String string5 = this.putSubStorage(dBStorage);
        storageReferenceDefinition.setColumnNames(stringArray3);
        storageReferenceDefinition.setReferencedColumnNames(stringArray4);
        storageReferenceDefinition.setReferencedStorage(string5);
    }

    protected boolean isAutomaticLinkNullable(String[] stringArray, ServerColumnMetaData[] serverColumnMetaDataArray) {
        for (int i = 0; i < serverColumnMetaDataArray.length; ++i) {
            ServerColumnMetaData serverColumnMetaData = serverColumnMetaDataArray[i];
            if (!ArrayUtil.contains(stringArray, serverColumnMetaData.getName()) || !serverColumnMetaData.isWritable() || !serverColumnMetaData.isNullable()) continue;
            return true;
        }
        return false;
    }

    private String getFromClause(String string, ServerColumnMetaData[] serverColumnMetaDataArray) throws DataSourceException {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(" m ");
        ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
        for (int i = 0; i < serverColumnMetaDataArray.length; ++i) {
            arrayUtil.add(serverColumnMetaDataArray[i].getName());
        }
        String[] stringArray = arrayUtil.toArray(new String[arrayUtil.size()]);
        int n = 0;
        for (StorageReferenceDefinition storageReferenceDefinition : this.auAutomaticLinkReferences) {
            String[] stringArray2 = arrayUtil.toArray(new String[arrayUtil.size()]);
            String[] stringArray3 = storageReferenceDefinition.getColumnNames();
            String[] stringArray4 = storageReferenceDefinition.getReferencedColumnNames();
            String[] stringArray5 = ArrayUtil.removeAll(stringArray3, stringArray2);
            if (stringArray5.length <= 0) continue;
            ++n;
            if (this.isAutomaticLinkNullable(stringArray3, serverColumnMetaDataArray)) {
                stringBuilder.append("LEFT OUTER JOIN ");
            } else {
                stringBuilder.append("INNER JOIN ");
            }
            DBStorage dBStorage = this.getSubStorage(storageReferenceDefinition.getReferencedStorage());
            if (dBStorage.getFromClause() == null) {
                stringBuilder.append(dBStorage.getWritebackTable());
            } else {
                stringBuilder.append("(");
                stringBuilder.append(this.dbAccess.getSelectStatement(dBStorage.mdServerMetaData, dBStorage.getBeforeQueryColumns(), dBStorage.getQueryColumns(), dBStorage.getFromClause(), null, dBStorage.getWhereClause(), dBStorage.getAfterWhereClause(), null, null));
                stringBuilder.append(")");
            }
            stringBuilder.append(" l");
            stringBuilder.append(n);
            stringBuilder.append(" ON ");
            boolean bl = true;
            for (int i = 0; i < stringArray3.length; ++i) {
                int n2 = ArrayUtil.indexOf(stringArray, stringArray3[i]);
                if (n2 < 0) continue;
                ServerColumnMetaData serverColumnMetaData = serverColumnMetaDataArray[n2];
                if (!bl) {
                    stringBuilder.append(" AND ");
                }
                bl = false;
                stringBuilder.append("m.");
                stringBuilder.append(serverColumnMetaData.getColumnName().getQuotedName());
                stringBuilder.append(" = ");
                stringBuilder.append("l");
                stringBuilder.append(n);
                stringBuilder.append('.');
                try {
                    stringBuilder.append(dBStorage.mdServerMetaData.getServerColumnMetaData(stringArray4[i]).getColumnName().getQuotedName());
                    continue;
                }
                catch (ModelException modelException) {
                    throw new DataSourceException(modelException.getMessage());
                }
            }
            stringBuilder.append("\n");
            arrayUtil.addAll(stringArray5);
        }
        return stringBuilder.toString();
    }

    private String[] getQueryColumns(ServerColumnMetaData[] serverColumnMetaDataArray) throws DataSourceException {
        ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
        ArrayUtil<String> arrayUtil2 = new ArrayUtil<String>();
        for (int i = 0; i < serverColumnMetaDataArray.length; ++i) {
            arrayUtil.add("m." + serverColumnMetaDataArray[i].getColumnName().getQuotedName());
            arrayUtil2.add(serverColumnMetaDataArray[i].getName());
        }
        String[] stringArray = arrayUtil2.toArray(new String[arrayUtil2.size()]);
        int n = 0;
        for (StorageReferenceDefinition storageReferenceDefinition : this.auAutomaticLinkReferences) {
            int n2;
            String[] stringArray2 = arrayUtil2.toArray(new String[arrayUtil2.size()]);
            String[] stringArray3 = storageReferenceDefinition.getColumnNames();
            String[] stringArray4 = storageReferenceDefinition.getReferencedColumnNames();
            String[] stringArray5 = ArrayUtil.removeAll(stringArray3, stringArray2);
            if (stringArray5.length <= 0) continue;
            ++n;
            DBStorage dBStorage = this.getSubStorage(storageReferenceDefinition.getReferencedStorage());
            String[] stringArray6 = ArrayUtil.intersect(stringArray3, stringArray);
            int n3 = -1;
            for (int i = 0; i < stringArray6.length; ++i) {
                n2 = arrayUtil2.indexOf(stringArray6[i]);
                if (n2 <= n3) continue;
                n3 = n2;
            }
            String[] stringArray7 = new String[stringArray5.length];
            for (n2 = 0; n2 < stringArray5.length; ++n2) {
                String string = stringArray4[ArrayUtil.indexOf(stringArray3, stringArray5[n2])];
                try {
                    stringArray7[n2] = "l" + n + "." + dBStorage.mdServerMetaData.getServerColumnMetaData(string).getColumnName().getQuotedName() + " " + stringArray5[n2];
                    continue;
                }
                catch (ModelException modelException) {
                    throw new DataSourceException("Column was not found!", modelException);
                }
            }
            arrayUtil.addAll(n3 + 1, stringArray7);
            arrayUtil2.addAll(n3 + 1, stringArray5);
        }
        return arrayUtil.toArray(new String[arrayUtil.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected ServerMetaData createMetaData(String string, String[] objectArray, String string2, String string3, String string4, String string5, String[] stringArray, boolean bl, boolean bl2) throws DataSourceException {
        ServerColumnMetaData serverColumnMetaData;
        Cloneable cloneable;
        Object object;
        ServerColumnMetaData[] serverColumnMetaDataArray;
        boolean bl3;
        boolean bl4;
        Record record = ProtocolFactory.openRecord("METADATA_DETECT", string2, string5);
        Key key = null;
        List<Key> list = null;
        Map<String, Object> map = null;
        Map<String, Object[]> map2 = null;
        Object[] objectArray2 = null;
        String[] stringArray3 = null;
        try {
            MetaData metaData = this.mdServerMetaData.getMetaData();
            bl4 = metaData.getPrimaryKeyColumnNames() != null;
            boolean bl5 = bl3 = metaData.getRepresentationColumnNames() != null;
            if (string5 != null) {
                String string6;
                Object[] objectArray3;
                int n;
                serverColumnMetaDataArray = this.dbAccess.getTableForSynonym(string5);
                object = this.dbAccess.getTableInfo((String)serverColumnMetaDataArray);
                objectArray2 = this.dbAccess.getColumnMetaData((String)serverColumnMetaDataArray, null, null, null, null);
                for (int i = 0; i < objectArray2.length; ++i) {
                    objectArray2[i].setWritable(true);
                }
                stringArray3 = BeanUtil.toArray(objectArray2, new String[objectArray2.length], "name");
                this.sCatalog = ((TableInfo)object).getCatalog();
                this.sSchema = ((TableInfo)object).getSchema();
                this.debug("WritebackTable Schema=", this.sSchema, ",Catalog=", this.sCatalog);
                String string7 = ((TableInfo)object).getTable();
                if (this.isDefaultValue()) {
                    map = this.dbAccess.getDefaultValues(this.sCatalog, this.sSchema, string7);
                }
                if (this.isAllowedValues()) {
                    map2 = this.dbAccess.getAllowedValues(this.sCatalog, this.sSchema, string7);
                    int n2 = objectArray2.length;
                    for (n = 0; n < n2; ++n) {
                        if (map2 != null && map2.get(((ServerColumnMetaData)objectArray2[n]).getName()) != null || (objectArray3 = this.dbAccess.getDefaultAllowedValues(this.sCatalog, this.sSchema, string7, (ServerColumnMetaData)objectArray2[n])) == null) continue;
                        if (map2 == null) {
                            map2 = new Hashtable<String, Object[]>();
                        }
                        map2.put(((ServerColumnMetaData)objectArray2[n]).getName(), objectArray3);
                    }
                }
                if (!bl4) {
                    key = this.dbAccess.getPrimaryKey(this.sCatalog, this.sSchema, string7);
                }
                if (!bl3) {
                    list = this.dbAccess.getUniqueKeys(this.sCatalog, this.sSchema, string7);
                }
                if (bl) {
                    objectArray3 = this.dbAccess.getForeignKeys(this.sCatalog, this.sSchema, string7);
                    String string8 = null;
                    if (this.dbAccess instanceof DBAccess) {
                        string8 = this.dbAccess.getDefaultSchema();
                    }
                    for (ForeignKey stringArray22 : objectArray3) {
                        String string9 = stringArray22.getPKTable().getQuotedName();
                        String string10 = string6 = stringArray22.getPKSchema() == null ? null : stringArray22.getPKSchema().getQuotedName();
                        if (string8 == null && string6 != null || string8 != null && !string8.equals(string6)) {
                            string9 = string6 + "." + string9;
                        }
                        cloneable = new StorageReferenceDefinition(BeanUtil.toArray(stringArray22.getFKColumns(), new String[stringArray22.getFKColumns().length], "name"), AUTOMATICLINKREFERENCE_PREFIX + string9, BeanUtil.toArray(stringArray22.getPKColumns(), new String[stringArray22.getPKColumns().length], "name"));
                        this.addAutomaticLinkReferenceIntern((StorageReferenceDefinition)cloneable, stringArray3);
                    }
                }
                for (StorageReferenceDefinition storageReferenceDefinition : this.auManualLinkReferences) {
                    this.addAutomaticLinkReferenceIntern(storageReferenceDefinition, stringArray3);
                }
                for (StorageReferenceDefinition storageReferenceDefinition : this.auAutomaticLinkReferences) {
                    String string11 = storageReferenceDefinition.getReferencedStorage();
                    if (string11.startsWith(SUBSTORAGE_PREFIX)) continue;
                    this.createAutomaticLinkStorage(storageReferenceDefinition, stringArray3);
                }
                if (this.auAutomaticLinkReferences.size() > 0 && string2 == null) {
                    objectArray3 = this.getQueryColumns((ServerColumnMetaData[])objectArray2);
                    if (objectArray == null) {
                        objectArray = objectArray3;
                    } else {
                        for (n = 0; n < objectArray.length; ++n) {
                            void var26_59;
                            String string12 = ((String)objectArray[n]).toLowerCase();
                            if (string12.contains(".") || StringUtil.containsWhitespace(string12)) continue;
                            Object var26_58 = null;
                            for (int i = 0; var26_59 == null && i < objectArray3.length; ++i) {
                                string6 = ((String)objectArray3[i]).toLowerCase();
                                int n2 = string6.length() - string12.length() - 1;
                                if (!string6.endsWith(string12) || n2 >= 0 && !Character.isWhitespace(string6.charAt(n2)) && string6.charAt(n2) != '.') continue;
                                Object object2 = objectArray3[i];
                            }
                            if (var26_59 == null) continue;
                            objectArray[n] = var26_59;
                        }
                    }
                    this.setQueryColumns((String[])objectArray);
                    string2 = this.getFromClause(string5, (ServerColumnMetaData[])objectArray2);
                    this.setFromClause(string2);
                }
                if (string2 == null) {
                    string2 = string5;
                }
            }
            if (string5 == null) {
                metaData.removeFeature(MetaData.Feature.WriteBack);
            }
            Object var31_79 = null;
        }
        catch (Throwable throwable) {
            Object var31_80 = null;
            CommonUtil.close(record);
            throw throwable;
        }
        CommonUtil.close(record);
        record = ProtocolFactory.openRecord("METADATA_VALUES", string2);
        try {
            serverColumnMetaDataArray = this.dbAccess.getColumnMetaData(string2, (String[])objectArray, string, string3, string4);
            this.mdServerMetaData.setServerColumnMetaData(serverColumnMetaDataArray);
            object = new ArrayUtil();
            for (int i = 0; i < serverColumnMetaDataArray.length; ++i) {
                int n;
                Object[] objectArray4;
                serverColumnMetaDataArray[i].setCalculated(false);
                if (serverColumnMetaDataArray[i].isAutoIncrement()) {
                    ((ArrayUtil)object).add(serverColumnMetaDataArray[i].getColumnName());
                }
                if (map != null) {
                    serverColumnMetaDataArray[i].setDefaultValue(map.get(serverColumnMetaDataArray[i].getName()));
                }
                if (map2 != null && (objectArray4 = (Object[])map2.get(serverColumnMetaDataArray[i].getName())) != null && objectArray4.length > 0) {
                    serverColumnMetaDataArray[i].setAllowedValues(objectArray4);
                }
                if (objectArray2 == null || (n = ServerMetaData.getServerColumnMetaDataIndex((ServerColumnMetaData[])objectArray2, serverColumnMetaDataArray[i].getName())) < 0) continue;
                serverColumnMetaDataArray[i].setDetectedType(((ServerColumnMetaData)objectArray2[n]).getDetectedType());
                serverColumnMetaDataArray[i].setSQLTypeName(((ServerColumnMetaData)objectArray2[n]).getSQLTypeName());
                if (serverColumnMetaDataArray[i].getAllowedValues() == null && ((ServerColumnMetaData)objectArray2[n]).getAllowedValues() != null) {
                    serverColumnMetaDataArray[i].setAllowedValues(((ServerColumnMetaData)objectArray2[n]).getAllowedValues());
                }
                serverColumnMetaDataArray[i].setNullable(((ServerColumnMetaData)objectArray2[n]).isNullable());
                serverColumnMetaDataArray[i].setWritable(true);
            }
            if (!((ArrayUtil)object).isEmpty()) {
                this.mdServerMetaData.setAutoIncrementColumnNames(((ArrayUtil)object).toArray(new Name[((ArrayUtil)object).size()]));
            }
            serverColumnMetaData = null;
        }
        catch (Throwable throwable) {
            Object var33_87 = null;
            CommonUtil.close(record);
            throw throwable;
        }
        CommonUtil.close(record);
        record = ProtocolFactory.openRecord("METADATA_KEYS", new Object[0]);
        try {
            if (string5 != null) {
                if (!bl4) {
                    if (key != null && key.getColumns() != null && key.getColumns().length > 0) {
                        this.mdServerMetaData.setPrimaryKeyColumnNames(key.getColumns());
                        this.mdServerMetaData.setPrimaryKeyType(ServerMetaData.PrimaryKeyType.PrimaryKeyColumns);
                    } else if (list != null && list.size() > 0) {
                        this.mdServerMetaData.setPrimaryKeyColumnNames(list.get(0).getColumns());
                        this.mdServerMetaData.setPrimaryKeyType(ServerMetaData.PrimaryKeyType.UniqueKeyColumns);
                    } else {
                        object = ArrayUtil.intersect(this.mdServerMetaData.getColumnNames(), stringArray3);
                        ArrayUtil<Name> arrayUtil = new ArrayUtil<Name>();
                        for (int i = 0; i < ((Object)object).length; ++i) {
                            try {
                                ServerColumnMetaData serverColumnMetaData2 = this.mdServerMetaData.getServerColumnMetaData((String)object[i]);
                                if (serverColumnMetaData2.getColumnMetaData().getTypeIdentifier() == -2) continue;
                                arrayUtil.add(serverColumnMetaData2.getColumnName());
                                continue;
                            }
                            catch (ModelException modelException) {
                                // empty catch block
                            }
                        }
                        if (arrayUtil.size() > 0) {
                            this.mdServerMetaData.setPrimaryKeyColumnNames(arrayUtil.toArray(new Name[arrayUtil.size()]));
                            this.mdServerMetaData.setPrimaryKeyType(ServerMetaData.PrimaryKeyType.AllColumns);
                        }
                    }
                }
                if (!bl3 && list != null && list.size() > 0) {
                    object = new ArrayUtil();
                    for (int i = 0; i < list.size(); ++i) {
                        Name[] nameArray = list.get(i).getColumns();
                        for (int j = 0; j < nameArray.length; ++j) {
                            if (((ArrayUtil)object).indexOf(nameArray[j]) >= 0) continue;
                            ((ArrayUtil)object).add(nameArray[j]);
                        }
                    }
                    if (((ArrayUtil)object).size() > 0) {
                        Name[] nameArray = new Name[((ArrayUtil)object).size()];
                        ((ArrayUtil)object).toArray(nameArray);
                        this.mdServerMetaData.setRepresentationColumnNames(nameArray);
                    }
                }
                if (bl) {
                    Object[] objectArray3;
                    object = BeanUtil.toArray(objectArray2, new String[objectArray2.length], "label");
                    HashMap<Object[], Object[]> hashMap = new HashMap<Object[], Object[]>();
                    for (StorageReferenceDefinition storageReferenceDefinition : this.auAutomaticLinkReferences) {
                        String[] stringArray4 = storageReferenceDefinition.getColumnNames();
                        String[] stringArray2 = storageReferenceDefinition.getReferencedColumnNames();
                        DBStorage dBStorage = this.getSubStorage(storageReferenceDefinition.getReferencedStorage());
                        try {
                            for (int i = 0; i < stringArray4.length; ++i) {
                                cloneable = this.mdServerMetaData.getServerColumnMetaData(stringArray4[i]);
                                if (cloneable.getLinkReference() != null || cloneable.isWritable() || hashMap.put(objectArray3 = dBStorage.getMetaData().getColumnMetaData(stringArray2[i]).getLabel(), objectArray3) == null || ArrayUtil.contains(object, objectArray3)) continue;
                                object = (String[])ArrayUtil.add(object, objectArray3);
                            }
                        }
                        catch (ModelException modelException) {
                        }
                    }
                    for (StorageReferenceDefinition storageReferenceDefinition : this.auAutomaticLinkReferences) {
                        int n;
                        Object[] objectArray6 = storageReferenceDefinition.getColumnNames();
                        String[] stringArray4 = storageReferenceDefinition.getReferencedColumnNames();
                        String string11 = storageReferenceDefinition.getReferencedStorage();
                        DBStorage dBStorage = this.getSubStorage(string11);
                        int n3 = string11.lastIndexOf(".");
                        if (n3 >= 0) {
                            string11 = string11.substring(n3 + 1);
                        }
                        string11 = StringUtil.formatInitCap(string11) + " ";
                        objectArray3 = ArrayUtil.intersect(objectArray6, this.mdServerMetaData.getColumnNames());
                        if (!Arrays.equals(objectArray6, objectArray3)) {
                            String[] stringArray5 = new String[objectArray3.length];
                            for (n = 0; n < stringArray5.length; ++n) {
                                stringArray5[n] = stringArray4[ArrayUtil.indexOf(objectArray6, objectArray3[n])];
                            }
                            objectArray6 = objectArray3;
                            String[] stringArray6 = stringArray5;
                            storageReferenceDefinition.setColumnNames((String[])objectArray6);
                            storageReferenceDefinition.setReferencedColumnNames(stringArray6);
                        }
                        try {
                            boolean bl6 = this.isAutomaticLinkNullable((String[])objectArray6, (ServerColumnMetaData[])objectArray2);
                            for (n = 0; n < objectArray6.length; ++n) {
                                serverColumnMetaData = this.mdServerMetaData.getServerColumnMetaData((String)objectArray6[n]);
                                if (serverColumnMetaData.getLinkReference() != null) continue;
                                if (!serverColumnMetaData.isWritable()) {
                                    void var26_66;
                                    String string12 = dBStorage.getMetaData().getColumnMetaData((String)var26_66[n]).getLabel();
                                    if (ArrayUtil.contains(object, string12)) {
                                        string12 = string11 + string12;
                                    }
                                    serverColumnMetaData.setLabel(string12);
                                    serverColumnMetaData.setNullable(bl6);
                                }
                                serverColumnMetaData.setLinkReference(storageReferenceDefinition);
                            }
                        }
                        catch (ModelException modelException) {
                            this.debug(Arrays.toString(this.mdServerMetaData.getColumnNames()));
                            this.debug(modelException);
                        }
                    }
                }
            }
            Object var36_91 = null;
        }
        catch (Throwable throwable) {
            Object var36_92 = null;
            CommonUtil.close(record);
            throw throwable;
        }
        CommonUtil.close(record);
        record = ProtocolFactory.openRecord("METADATA_COLUMNS", new Object[0]);
        try {
            if (!bl3 && this.mdServerMetaData.getRepresentationColumnNames() != null) {
                object = this.mdServerMetaData.getRepresentationColumnNames();
                String[] stringArray6 = null;
                for (int i = 0; stringArray6 == null && i < ((Object)object).length; ++i) {
                    try {
                        if (this.mdServerMetaData.getMetaData().getColumnMetaData((String)object[i]).getTypeIdentifier() != 12) continue;
                        stringArray6 = new String[]{object[i]};
                        continue;
                    }
                    catch (ModelException modelException) {
                        // empty catch block
                    }
                }
                if (stringArray6 != null) {
                    this.mdServerMetaData.setRepresentationColumnNames(stringArray6);
                }
            }
            if (!bl3 && this.mdServerMetaData.getRepresentationColumnNames() == null) {
                object = null;
                ArrayUtil<Name> arrayUtil = new ArrayUtil<Name>();
                ArrayUtil<Name> arrayUtil2 = new ArrayUtil<Name>();
                for (int i = 0; object == null && i < serverColumnMetaDataArray.length; ++i) {
                    if (!ArrayUtil.contains(this.mdServerMetaData.getPrimaryKeyColumnNames(), serverColumnMetaDataArray[i].getName()) && !RowDefinition.isColumnIgnored(serverColumnMetaDataArray[i].getName())) {
                        if (serverColumnMetaDataArray[i].getColumnMetaData().getTypeIdentifier() == 12) {
                            object = serverColumnMetaDataArray[i].getColumnName();
                        }
                        if (serverColumnMetaDataArray[i].getColumnMetaData().getTypeIdentifier() != -2) {
                            arrayUtil.add(serverColumnMetaDataArray[i].getColumnName());
                        }
                    }
                    if (serverColumnMetaDataArray[i].getColumnMetaData().getTypeIdentifier() == -2) continue;
                    arrayUtil2.add(serverColumnMetaDataArray[i].getColumnName());
                }
                if (object != null) {
                    this.mdServerMetaData.setRepresentationColumnNames(new Name[]{object});
                } else if (arrayUtil.size() > 0) {
                    this.mdServerMetaData.setRepresentationColumnNames(arrayUtil.toArray(new Name[arrayUtil.size()]));
                } else {
                    this.mdServerMetaData.setRepresentationColumnNames(arrayUtil2.toArray(new Name[arrayUtil2.size()]));
                }
            }
            object = this.mdServerMetaData;
            Object var38_94 = null;
        }
        catch (Throwable throwable) {
            Object var38_95 = null;
            CommonUtil.close(record);
            throw throwable;
        }
        CommonUtil.close(record);
        return object;
    }

    public boolean isOpen() {
        return this.bIsOpen;
    }

    @Override
    public void close() {
        this.bIsOpen = false;
        this.setFromClause(this.sFromClauseBeforeOpen);
        this.setQueryColumns(this.saQueryColumnsBeforeOpen);
        this.auAutomaticLinkReferences.clear();
    }

    public void setDBAccess(IDBAccess iDBAccess) {
        this.dbAccess = (DBAccess)iDBAccess;
    }

    public IDBAccess getDBAccess() {
        return this.dbAccess;
    }

    public String getFromClause() {
        return this.sFromClause;
    }

    private String getFromClauseIntern() {
        if (this.sFromClause == null) {
            return this.sWritebackTable;
        }
        return this.sFromClause;
    }

    public void setFromClause(String string) {
        this.sFromClause = string;
    }

    public String[] getQueryColumns() {
        return this.saQueryColumns;
    }

    public void setQueryColumns(String[] stringArray) {
        this.saQueryColumns = stringArray;
    }

    public String getBeforeQueryColumns() {
        return this.sBeforeQueryColumns;
    }

    public void setBeforeQueryColumns(String string) {
        this.sBeforeQueryColumns = string;
    }

    public String getWhereClause() {
        return this.sWhereClause;
    }

    public void setWhereClause(String string) {
        this.sWhereClause = string;
    }

    public String getAfterWhereClause() {
        return this.sAfterWhereClause;
    }

    public void setAfterWhereClause(String string) {
        this.sAfterWhereClause = string;
    }

    public String getOrderByClause() {
        return this.sOrderByClause;
    }

    public void setOrderByClause(String string) {
        this.sOrderByClause = string;
    }

    public String[] getWritebackColumns() {
        return this.saWritebackColumns;
    }

    public void setWritebackColumns(String[] stringArray) {
        this.saWritebackColumns = stringArray;
    }

    public String getWritebackTable() {
        return this.sWritebackTable;
    }

    public void setWritebackTable(String string) {
        this.sWritebackTable = string;
    }

    public SortDefinition getDefaultSort() {
        return this.sdDefaultSort;
    }

    public void setDefaultSort(SortDefinition sortDefinition) {
        this.sdDefaultSort = sortDefinition;
    }

    public ICondition getRestrictCondition() {
        return this.cRestrictCondition;
    }

    public void setRestrictCondition(ICondition iCondition) {
        this.cRestrictCondition = iCondition;
    }

    public void setAutoLinkReference(boolean bl) {
        this.bAutoLinkReference = bl;
    }

    public boolean isAutoLinkReference() {
        if (this.bAutoLinkReference == null) {
            return bDefaultAutoLinkReference;
        }
        return this.bAutoLinkReference;
    }

    public static void setDefaultAutoLinkReference(boolean bl) {
        bDefaultAutoLinkReference = bl;
    }

    public static boolean isDefaultAutoLinkReference() {
        return bDefaultAutoLinkReference;
    }

    public void setDefaultValue(boolean bl) {
        this.bDefaultValue = bl;
    }

    public boolean isDefaultValue() {
        if (this.bDefaultValue == null) {
            return bDefaultDefaultValue;
        }
        return this.bDefaultValue;
    }

    public static void setDefaultDefaultValue(boolean bl) {
        bDefaultDefaultValue = bl;
    }

    public static boolean isDefaultDefaultValue() {
        return bDefaultDefaultValue;
    }

    public void setAllowedValues(boolean bl) {
        this.bAllowedValues = bl;
    }

    public boolean isAllowedValues() {
        if (this.bAllowedValues == null) {
            return bDefaultAllowedValues;
        }
        return this.bAllowedValues;
    }

    public static void setDefaultAllowedValues(boolean bl) {
        bDefaultAllowedValues = bl;
    }

    public static boolean isDefaultAllowedValues() {
        return bDefaultAllowedValues;
    }

    public boolean isLazyFetchEnabled() {
        return this.bLazyFetchEnabled;
    }

    public void setLazyFetchEnabled(boolean bl) {
        this.bLazyFetchEnabled = bl;
    }

    protected String getWritebackTableCatalog() {
        return this.sCatalog;
    }

    protected String getWritebackTableSchema() {
        return this.sSchema;
    }

    protected Object[] refetchRow(Object[] objectArray, boolean bl) throws DataSourceException {
        List<Object[]> list;
        if (objectArray == null) {
            return null;
        }
        if (this.getWritebackTable() == null) {
            return null;
        }
        ICondition iCondition = Filter.createEqualsFilter(this.mdServerMetaData.getPrimaryKeyColumnNames(), objectArray, this.mdServerMetaData.getMetaData().getColumnMetaData());
        if (bl) {
            this.dbAccess.lockRow(this.getWritebackTable(), this.mdServerMetaData, iCondition);
        }
        if ((list = this.dbAccess.fetch(this.mdServerMetaData, this.sBeforeQueryColumns, this.saQueryColumns, this.getFromClauseIntern(), iCondition, this.sWhereClause, this.sAfterWhereClause, null, 0, 2, false)) != null && list.size() == 2 && list.get(1) == null) {
            return list.get(0);
        }
        return null;
    }

    public Map<String, DBStorage> getSubStorages() {
        return this.hmpSubStorages;
    }
}

