/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.model.mem;

import com.sibvisions.rad.model.DataBookSorter;
import com.sibvisions.rad.model.mem.ChangeableDataRow;
import com.sibvisions.rad.model.mem.MemDataBook;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.StringUtil;
import javax.rad.model.IChangeableDataRow;
import javax.rad.model.IDataBook;
import javax.rad.model.IDataPage;
import javax.rad.model.IDataRow;
import javax.rad.model.IRowDefinition;
import javax.rad.model.ModelException;
import javax.rad.model.SortDefinition;
import javax.rad.model.condition.ICondition;
import javax.rad.model.datatype.BigDecimalDataType;
import javax.rad.model.datatype.DataType;
import javax.rad.model.datatype.IDataType;

public class MemDataPage
implements IDataPage {
    private static final int INIT_STORAGE_SIZE = 16;
    private MemDataBook dbDataBook;
    private IDataRow drMasterDataRow;
    private ArrayUtil<Object[]> alStorage;
    private int[] iaChangedRows = new int[0];
    private boolean bAllFetched = true;
    private int[] iaUsedRows;

    public MemDataPage(MemDataBook memDataBook, IDataRow iDataRow) {
        this.dbDataBook = memDataBook;
        this.drMasterDataRow = iDataRow;
        this.alStorage = new ArrayUtil(16);
    }

    public IDataBook getDataBook() {
        return this.dbDataBook;
    }

    public IDataRow getMasterDataRow() {
        return this.drMasterDataRow;
    }

    public IChangeableDataRow getDataRow(int n) throws ModelException {
        this.initFilterSort();
        if (!this.bAllFetched && n >= this.alStorage.size()) {
            this.fetchToRow(n);
        }
        if (n >= 0 && n < this.getRowCountInternal()) {
            return this.getDataRowWithoutSort(this.getInternalRowIndex(n));
        }
        return null;
    }

    public void fetchAll() throws ModelException {
        if (!this.bAllFetched) {
            this.fetchToRow(-1);
        }
    }

    public boolean isAllFetched() throws ModelException {
        return this.bAllFetched;
    }

    public int getRowCount() throws ModelException {
        this.initFilterSort();
        return this.getRowCountInternal();
    }

    public int[] getChangedDataRows() {
        if (this.iaChangedRows == null || this.iaChangedRows.length == 0 || this.iaUsedRows == null) {
            return this.iaChangedRows;
        }
        int[] nArray = new int[this.iaChangedRows.length];
        int n = 0;
        for (int i = 0; i < this.iaChangedRows.length; ++i) {
            int n2 = ArrayUtil.indexOf(this.iaUsedRows, this.iaChangedRows[i]);
            if (n2 < 0) continue;
            nArray[n] = n2;
            ++n;
        }
        return ArrayUtil.truncate(nArray, n);
    }

    public int searchNext(ICondition iCondition) throws ModelException {
        return this.searchNext(iCondition, 0);
    }

    public int searchNext(ICondition iCondition, int n) throws ModelException {
        if (iCondition != null && n >= 0) {
            this.initFilterSort();
            if (!this.bAllFetched && n >= this.alStorage.size()) {
                this.fetchToRow(n);
            }
            while (n < this.getRowCountInternal()) {
                if (iCondition.isFulfilled(this.getDataRowWithoutSort(this.getInternalRowIndex(n)))) {
                    return n;
                }
                if (this.bAllFetched || ++n < this.alStorage.size()) continue;
                this.fetchToRow(n);
            }
        }
        return -1;
    }

    public int searchPrevious(ICondition iCondition) throws ModelException {
        return this.searchPrevious(iCondition, -1);
    }

    public int searchPrevious(ICondition iCondition, int n) throws ModelException {
        if (iCondition != null && n != 0) {
            this.fetchAll();
            this.initFilterSort();
            int n2 = this.getRowCountInternal();
            n = n < 0 || n > n2 ? n2 - 1 : --n;
            while (n >= 0) {
                if (iCondition.isFulfilled(this.getDataRowWithoutSort(this.getInternalRowIndex(n)))) {
                    return n;
                }
                --n;
            }
        }
        return -1;
    }

    public String toString() {
        return this.toString("");
    }

    protected void setAllFetched(boolean bl) {
        this.bAllFetched = bl;
    }

    protected void addFetchedRow(Object[] objectArray) throws ModelException {
        this.alStorage.add(objectArray);
    }

    void insert(int n) throws ModelException {
        if (n > this.alStorage.size()) {
            throw new ModelException("DataRow index out of bounds");
        }
        this.initFilterSort();
        ChangeableDataRow changeableDataRow = new ChangeableDataRow(this.dbDataBook.getRowDefinition(), null, this, n);
        changeableDataRow.setDefaultValues();
        changeableDataRow.setInserting();
        changeableDataRow.setUID(MemDataBook.getNextUID());
        this.alStorage.add(n, changeableDataRow.getStorage());
        if (this.iaUsedRows != null) {
            this.shiftIndicies(this.iaUsedRows, n, 1);
            this.iaUsedRows = ArrayUtil.add(this.iaUsedRows, n, n);
        }
        this.shiftIndicies(this.iaChangedRows, n, 1);
        this.addChange(n);
    }

    boolean delete(int n) throws ModelException {
        int n2 = this.getInternalRowIndex(n);
        if (n2 >= this.alStorage.size()) {
            throw new ModelException("Row index out of bounds");
        }
        ChangeableDataRow changeableDataRow = this.getDataRowWithoutSort(n2);
        if (changeableDataRow.isInserting()) {
            this.deleteRow(n2);
            return true;
        }
        changeableDataRow.setDeleting();
        this.setDataRow(n2, changeableDataRow);
        return false;
    }

    void update(int n) throws ModelException {
        int n2 = this.getInternalRowIndex(n);
        if (n2 >= this.alStorage.size()) {
            throw new ModelException("DataRow index out of bounds");
        }
        ChangeableDataRow changeableDataRow = this.getDataRowWithoutSort(n2);
        changeableDataRow.setUpdating();
        this.setDataRow(n2, changeableDataRow);
    }

    void restore(int n) throws ModelException {
        int n2 = this.getInternalRowIndex(n);
        if (n2 >= this.alStorage.size()) {
            throw new ModelException("DataRow index out of bounds");
        }
        ChangeableDataRow changeableDataRow = this.getDataRowWithoutSort(n2);
        if (changeableDataRow.isInserting()) {
            this.deleteRow(n2);
            return;
        }
        changeableDataRow.restore();
        this.setDataRow(n2, changeableDataRow);
    }

    protected boolean store(int n) throws ModelException {
        int n2 = this.getInternalRowIndex(n);
        if (n2 >= this.alStorage.size()) {
            throw new ModelException("DataRow index out of bounds");
        }
        ChangeableDataRow changeableDataRow = this.getDataRowWithoutSort(n2);
        if (changeableDataRow.isDeleting()) {
            this.deleteRow(n2);
            return true;
        }
        changeableDataRow.store();
        this.setDataRow(n2, changeableDataRow);
        return false;
    }

    protected void setDetailChanged(int n, boolean bl) throws ModelException {
        int n2 = this.getInternalRowIndex(n);
        if (n2 >= this.alStorage.size()) {
            throw new ModelException("DataRow index out of bounds");
        }
        ChangeableDataRow changeableDataRow = this.getDataRowWithoutSort(n2);
        changeableDataRow.setDetailChanged(bl);
        this.setDataRow(n2, changeableDataRow);
        if (bl) {
            this.addChange(n2);
        } else {
            this.removeChange(n2);
        }
    }

    protected Object[] getDataRowStorage(int n) throws ModelException {
        this.initFilterSort();
        return this.alStorage.get(this.getInternalRowIndex(n));
    }

    protected void setMasterDataRow(IDataRow iDataRow) throws ModelException {
        int n;
        this.drMasterDataRow = iDataRow;
        String[] stringArray = this.dbDataBook.getMasterReference().getColumnNames();
        int[] nArray = new int[stringArray.length];
        IRowDefinition iRowDefinition = this.dbDataBook.getRowDefinition();
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = iRowDefinition.getColumnDefinitionIndex(stringArray[n]);
        }
        this.initFilterSort();
        for (n = 0; n < this.alStorage.size(); ++n) {
            for (int i = 0; i < nArray.length; ++i) {
                IDataType iDataType = iRowDefinition.getColumnDefinition(nArray[i]).getDataType();
                this.alStorage.get((int)this.getInternalRowIndex((int)n))[nArray[i]] = iDataType.convertAndCheckToTypeClass(this.drMasterDataRow.getValue(i));
            }
        }
    }

    public int getEstimatedRowCount() throws ModelException {
        return this.getRowCount();
    }

    public void fetchToRow(int n) throws ModelException {
    }

    protected int getRowCountInternal() {
        if (this.iaUsedRows != null) {
            return this.iaUsedRows.length;
        }
        return this.alStorage.size();
    }

    private ChangeableDataRow getDataRowWithoutSort(int n) {
        return new ChangeableDataRow(this.dbDataBook.getRowDefinition(), this.alStorage.get(n), this, n);
    }

    private int getInternalRowIndex(int n) {
        if (this.iaUsedRows == null) {
            return n;
        }
        return this.iaUsedRows[n];
    }

    protected void setDataRow(int n, ChangeableDataRow changeableDataRow) throws ModelException {
        this.alStorage.set(n, changeableDataRow.getStorage());
        if (changeableDataRow.isDeleting() || changeableDataRow.isInserting() || changeableDataRow.isUpdating()) {
            this.addChange(n);
        } else {
            this.removeChange(n);
        }
    }

    private void shiftIndicies(int[] nArray, int n, int n2) {
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            if (n3 < n) continue;
            nArray[i] = n3 += n2;
        }
    }

    private void addChange(int n) {
        if (ArrayUtil.indexOf(this.iaChangedRows, n) < 0) {
            this.iaChangedRows = ArrayUtil.add(this.iaChangedRows, n);
        }
    }

    private void removeChange(int n) throws ModelException {
        int n2 = ArrayUtil.indexOf(this.iaChangedRows, n);
        if (n2 >= 0) {
            ChangeableDataRow changeableDataRow = null;
            if (n < this.alStorage.size()) {
                changeableDataRow = this.getDataRowWithoutSort(n);
            }
            if (changeableDataRow == null || !changeableDataRow.isDeleting() && !changeableDataRow.isDetailChanged() && !changeableDataRow.isInserting() && !changeableDataRow.isUpdating()) {
                this.iaChangedRows = ArrayUtil.remove(this.iaChangedRows, n2);
            }
        }
    }

    private void removeChangeAlways(int n) throws ModelException {
        int n2 = ArrayUtil.indexOf(this.iaChangedRows, n);
        if (n2 >= 0) {
            this.iaChangedRows = ArrayUtil.remove(this.iaChangedRows, n2);
        }
    }

    private void deleteRow(int n) throws ModelException {
        this.alStorage.remove(n);
        if (this.iaUsedRows != null) {
            this.iaUsedRows = ArrayUtil.remove(this.iaUsedRows, ArrayUtil.indexOf(this.iaUsedRows, n));
            this.shiftIndicies(this.iaUsedRows, n, -1);
        }
        this.removeChangeAlways(n);
        this.shiftIndicies(this.iaChangedRows, n, -1);
    }

    private void initFilterSort() throws ModelException {
        if (this.iaUsedRows == null && this.dbDataBook != null) {
            if (this.dbDataBook.isMemFilter()) {
                this.iaUsedRows = this.filter();
            }
            if (this.dbDataBook.isMemSort()) {
                this.iaUsedRows = this.sort();
            }
        }
    }

    protected void clear() {
        this.iaUsedRows = null;
    }

    private int[] filter() throws ModelException {
        ICondition iCondition = this.dbDataBook.getFilter();
        if (iCondition != null) {
            this.fetchAll();
            int[] nArray = new int[this.getRowCountInternal()];
            int n = 0;
            for (int i = 0; i < nArray.length; ++i) {
                if (!iCondition.isFulfilled(this.getDataRowWithoutSort(i))) continue;
                nArray[n] = i;
                ++n;
            }
            return ArrayUtil.truncate(nArray, n);
        }
        return null;
    }

    private int[] sort() throws ModelException {
        SortDefinition sortDefinition = this.dbDataBook.getSort();
        if (sortDefinition == null) {
            return this.iaUsedRows;
        }
        this.fetchAll();
        int[] nArray = this.getInteralDataRowIndexes();
        IDataRow[] iDataRowArray = this.getDataRowsInternBy(nArray);
        int[] nArray2 = new DataBookSorter(sortDefinition).sort(iDataRowArray);
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = nArray[nArray2[i]];
        }
        return nArray2;
    }

    private int[] getInteralDataRowIndexes() {
        int[] nArray = new int[this.getRowCountInternal()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.getInternalRowIndex(i);
        }
        return nArray;
    }

    private IDataRow[] getDataRowsInternBy(int[] nArray) {
        IDataRow[] iDataRowArray = new IDataRow[this.getRowCountInternal()];
        for (int i = 0; i < iDataRowArray.length; ++i) {
            iDataRowArray[i] = this.getDataRowWithoutSort(nArray[i]);
        }
        return iDataRowArray;
    }

    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.dbDataBook != null) {
            stringBuilder.append(string);
            stringBuilder.append("DataBook = ");
            stringBuilder.append(this.dbDataBook.getName());
            stringBuilder.append("\n");
        }
        try {
            if (this.dbDataBook != null && this.dbDataBook.getRowDefinition() != null) {
                stringBuilder.append(string);
                stringBuilder.append("Changes  = [");
                for (int i = 0; i < this.iaChangedRows.length; ++i) {
                    if (i > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(this.iaChangedRows[i]);
                }
                stringBuilder.append("]");
                IRowDefinition iRowDefinition = this.dbDataBook.getRowDefinition();
                String[] stringArray = (String[])iRowDefinition.getColumnNames().clone();
                int[] nArray = new int[stringArray.length];
                int[] nArray2 = new int[stringArray.length];
                int n = 0;
                if (this.getRowCount() > 0) {
                    Object[] objectArray;
                    int n2;
                    stringBuilder.append("\n\n");
                    stringBuilder.append(string);
                    stringBuilder.append("[    #][       UID][CHANGES] |");
                    int n3 = stringArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        IDataType iDataType = iRowDefinition.getColumnDefinition(stringArray[n2]).getDataType();
                        if (iDataType instanceof DataType) {
                            nArray[n2] = ((DataType)iDataType).getSize();
                            if (nArray[n2] > 50) {
                                switch (iDataType.getTypeIdentifier()) {
                                    case 3: {
                                        nArray[n2] = 15;
                                        break;
                                    }
                                    case 93: {
                                        nArray[n2] = 20;
                                        break;
                                    }
                                    default: {
                                        nArray[n2] = 50;
                                    }
                                }
                            }
                        }
                        nArray2[n2] = 0;
                        if (iDataType instanceof BigDecimalDataType) {
                            nArray2[n2] = 1;
                        }
                        if (stringArray[n2] != null && stringArray[n2].length() > nArray[n2]) {
                            stringArray[n2] = stringArray[n2].substring(0, nArray[n2]);
                        }
                        objectArray = StringUtil.padRight(stringArray[n2], nArray[n2]);
                        n += objectArray.length();
                        stringBuilder.append((String)objectArray);
                        if (n2 + 1 >= n3) continue;
                        stringBuilder.append("|");
                        ++n;
                    }
                    stringBuilder.append("\n");
                    stringBuilder.append(string);
                    stringBuilder.append("-------------------------------");
                    for (n2 = 0; n2 < n; ++n2) {
                        stringBuilder.append('-');
                    }
                    n3 = this.getRowCount();
                    for (n2 = 0; n2 < n3; ++n2) {
                        stringBuilder.append("\n");
                        stringBuilder.append(string);
                        stringBuilder.append("[");
                        stringBuilder.append(StringUtil.padLeft("" + n2, 5));
                        stringBuilder.append("]");
                        int n4 = this.getInternalRowIndex(n2);
                        objectArray = this.alStorage.get(n4);
                        ChangeableDataRow changeableDataRow = this.getDataRowWithoutSort(n4);
                        stringBuilder.append("[");
                        stringBuilder.append(StringUtil.padLeft(changeableDataRow.getUID() != null ? "" + changeableDataRow.getUID() : "", 10));
                        stringBuilder.append("]");
                        stringBuilder.append("[");
                        if (changeableDataRow.isInserting()) {
                            stringBuilder.append("I");
                        }
                        if (changeableDataRow.isUpdating()) {
                            stringBuilder.append("U");
                        }
                        if (changeableDataRow.isDeleting()) {
                            stringBuilder.append("D");
                        }
                        if (!(changeableDataRow.isInserting() || changeableDataRow.isUpdating() || changeableDataRow.isDeleting())) {
                            stringBuilder.append(" ");
                        }
                        if (changeableDataRow.isDetailChanged()) {
                            stringBuilder.append("DC");
                        } else {
                            stringBuilder.append("  ");
                        }
                        stringBuilder.append("    ] |");
                        for (int i = 0; i < stringArray.length; ++i) {
                            Object object = objectArray[i];
                            if (object == null) {
                                object = "null";
                            } else if (((String)(object = StringUtil.toString(object).replace("\n", "\\n"))).length() > nArray[i]) {
                                object = ((String)object).substring(0, nArray[i]);
                            }
                            if (nArray2[i] == 0) {
                                stringBuilder.append(StringUtil.padRight(object, nArray[i]));
                            } else {
                                stringBuilder.append(StringUtil.padLeft(object, nArray[i]));
                            }
                            if (i + 1 >= stringArray.length) continue;
                            stringBuilder.append("|");
                        }
                    }
                }
            }
        }
        catch (ModelException modelException) {
            stringBuilder.append("\n");
            stringBuilder.append(CommonUtil.dump(modelException, true));
            return stringBuilder.toString();
        }
        return stringBuilder.toString();
    }
}

