/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.model.mem;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.CommonUtil;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.rad.model.ColumnDefinition;
import javax.rad.model.IDataRow;
import javax.rad.model.IRowDefinition;
import javax.rad.model.ModelException;
import javax.rad.model.RowDefinition;
import javax.rad.model.SortDefinition;
import javax.rad.model.event.DataRowEvent;
import javax.rad.model.event.DataRowHandler;
import javax.rad.model.ui.IControl;

public class DataRow
implements IDataRow,
Serializable {
    protected IRowDefinition rdRowDefinition;
    protected Object[] oaStorage = null;
    private transient ArrayUtil<WeakReference<IControl>> auControls;
    private transient Map<String, DataRowHandler> hmpEventValuesChanged;

    public DataRow() {
        this(null, null);
    }

    public DataRow(IRowDefinition iRowDefinition) {
        this(iRowDefinition, null);
    }

    protected DataRow(IRowDefinition iRowDefinition, Object[] objectArray) {
        if (iRowDefinition == null) {
            iRowDefinition = new RowDefinition();
        }
        if (objectArray == null) {
            this.oaStorage = new Object[iRowDefinition.getColumnCount()];
        } else {
            this.oaStorage = objectArray.length <= iRowDefinition.getColumnCount() ? new Object[iRowDefinition.getColumnCount()] : new Object[objectArray.length];
            System.arraycopy(objectArray, 0, this.oaStorage, 0, objectArray.length);
        }
        this.rdRowDefinition = iRowDefinition;
    }

    public IRowDefinition getRowDefinition() {
        return this.rdRowDefinition;
    }

    public Object getValue(int n) throws ModelException {
        if (n < 0 || n >= this.rdRowDefinition.getColumnCount()) {
            throw new ModelException("Column index '" + n + "' doesn't exist!");
        }
        if (n >= this.oaStorage.length) {
            return null;
        }
        Object object = this.oaStorage[n];
        Object object2 = this.rdRowDefinition.getColumnDefinition(n).getDataType().prepareValue(object);
        if (object2 != object) {
            this.oaStorage[n] = object2;
            return object2;
        }
        return object;
    }

    public Object getValue(String string) throws ModelException {
        int n = this.rdRowDefinition.getColumnDefinitionIndex(string);
        if (n < 0) {
            throw new ModelException("Column name '" + string + "' doesn't exist!");
        }
        return this.getValue(n);
    }

    public String getValueAsString(String string) throws ModelException {
        Object object = this.getValue(string);
        return this.rdRowDefinition.getColumnDefinition(string).getDataType().convertToString(object);
    }

    public void setValue(String string, Object object) throws ModelException {
        IDataRow iDataRow = this.createDataRow(null);
        this.setValueDRInternal(string, object);
        if (this.hmpEventValuesChanged != null) {
            if (this.hmpEventValuesChanged.containsKey(null)) {
                this.hmpEventValuesChanged.get(null).dispatchEvent(new DataRowEvent(this, new String[]{string}, iDataRow));
            }
            if (this.hmpEventValuesChanged.containsKey(string)) {
                this.hmpEventValuesChanged.get(string).dispatchEvent(new DataRowEvent(this, new String[]{string}, iDataRow));
            }
        }
        this.invokeRepaintListeners();
    }

    public Object[] getValues(String[] stringArray) throws ModelException {
        if (stringArray == null) {
            return (Object[])this.oaStorage.clone();
        }
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = this.getValue(stringArray[i]);
        }
        return objectArray;
    }

    public String[] getValuesAsString(String[] stringArray) throws ModelException {
        String[] stringArray2 = stringArray == null ? this.rdRowDefinition.getColumnNames() : stringArray;
        String[] stringArray3 = new String[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray3[i] = this.getValueAsString(stringArray2[i]);
        }
        return stringArray3;
    }

    public void setValues(String[] stringArray, Object[] objectArray) throws ModelException {
        if (stringArray == null) {
            stringArray = this.rdRowDefinition.getColumnNames();
        } else if (stringArray.length == 0) {
            return;
        }
        IDataRow iDataRow = this.createDataRow(null);
        for (int i = 0; i < stringArray.length; ++i) {
            if (objectArray == null || i >= objectArray.length) {
                this.setValueDRInternal(stringArray[i], null);
                continue;
            }
            this.setValueDRInternal(stringArray[i], objectArray[i]);
        }
        if (this.hmpEventValuesChanged != null) {
            if (this.hmpEventValuesChanged.containsKey(null)) {
                this.hmpEventValuesChanged.get(null).dispatchEvent(new DataRowEvent(this, stringArray, iDataRow));
            }
            for (String string : stringArray) {
                if (!this.hmpEventValuesChanged.containsKey(string)) continue;
                this.hmpEventValuesChanged.get(string).dispatchEvent(new DataRowEvent(this, new String[]{string}, iDataRow));
            }
        }
        this.invokeRepaintListeners();
    }

    public IDataRow createDataRow(String[] stringArray) throws ModelException {
        return new DataRow(this.rdRowDefinition.createRowDefinition(stringArray), this.getValues(stringArray));
    }

    public IDataRow createEmptyRow(String[] stringArray) throws ModelException {
        return new DataRow(this.rdRowDefinition.createRowDefinition(stringArray));
    }

    public boolean equals(Object object) {
        if (object instanceof IDataRow) {
            return this.compareTo((IDataRow)object) == 0;
        }
        return super.equals(object);
    }

    public int compareTo(IDataRow iDataRow) {
        return this.compareTo(iDataRow, null);
    }

    public int compareTo(IDataRow iDataRow, SortDefinition sortDefinition) {
        if (iDataRow == null) {
            return 1;
        }
        if (sortDefinition == null) {
            sortDefinition = new SortDefinition(iDataRow.getRowDefinition().getColumnNames());
        }
        String[] stringArray = sortDefinition.getColumns();
        boolean[] blArray = sortDefinition.isAscending();
        for (int i = 0; i < stringArray.length; ++i) {
            int n = this.rdRowDefinition.getColumnDefinitionIndex(stringArray[i]);
            if (n >= 0) {
                try {
                    int n2 = this.rdRowDefinition.getColumnDefinition(n).getDataType().compareTo(this.getValue(n), iDataRow.getValue(stringArray[i]));
                    if (n2 == 0) continue;
                    if (blArray != null && i < blArray.length && !blArray[i]) {
                        return -n2;
                    }
                    return n2;
                }
                catch (ModelException modelException) {
                    return -1;
                }
            }
            throw new IllegalArgumentException("Column with the name '" + stringArray[i] + "' does not exist!");
        }
        return 0;
    }

    public boolean equals(IDataRow iDataRow, String[] stringArray) {
        return this.compareTo(iDataRow, new SortDefinition(stringArray)) == 0;
    }

    public void addControl(IControl iControl) {
        if (this.auControls == null) {
            this.auControls = new ArrayUtil();
        } else {
            for (int i = this.auControls.size() - 1; i >= 0; --i) {
                if (this.auControls.get(i).get() != null) continue;
                this.auControls.remove(i);
            }
        }
        if (this.auControls.indexOf(iControl) < 0) {
            this.auControls.add(new WeakReference<IControl>(iControl));
        }
        this.rdRowDefinition.addControl(iControl);
    }

    public void removeControl(IControl iControl) {
        if (this.auControls != null) {
            for (int i = this.auControls.size() - 1; i >= 0; --i) {
                IControl iControl2 = (IControl)this.auControls.get(i).get();
                if (iControl2 != null && iControl2 != iControl) continue;
                this.auControls.remove(i);
            }
        }
        this.rdRowDefinition.removeControl(iControl);
    }

    public IControl[] getControls() {
        ArrayUtil<IControl> arrayUtil = new ArrayUtil<IControl>();
        if (this.auControls != null) {
            for (int i = this.auControls.size() - 1; i >= 0; --i) {
                IControl iControl = (IControl)this.auControls.get(i).get();
                if (iControl == null) {
                    this.auControls.remove(i);
                    continue;
                }
                arrayUtil.add(0, iControl);
            }
        }
        return arrayUtil.toArray(new IControl[arrayUtil.size()]);
    }

    public DataRowHandler eventValuesChanged() {
        return this.eventValuesChanged(null);
    }

    public DataRowHandler eventValuesChanged(String string) {
        DataRowHandler dataRowHandler;
        if (this.hmpEventValuesChanged == null) {
            this.hmpEventValuesChanged = new HashMap<String, DataRowHandler>();
        }
        if ((dataRowHandler = this.hmpEventValuesChanged.get(string)) == null) {
            dataRowHandler = new DataRowHandler();
            this.hmpEventValuesChanged.put(string, dataRowHandler);
        }
        return dataRowHandler;
    }

    public void notifyRepaintControls() {
        this.invokeRepaintListeners();
    }

    public void saveEditingControls() throws ModelException {
        this.invokeSaveEditingControls();
    }

    public void cancelEditingControls() {
        this.invokeCancelEditingControls();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = this.getRowDefinition().getColumnNames();
        try {
            stringBuilder.append("{");
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(string);
                stringBuilder.append("=");
                stringBuilder.append(this.getValue(string));
            }
            stringBuilder.append("}");
        }
        catch (ModelException modelException) {
            stringBuilder.append("\n");
            stringBuilder.append(CommonUtil.dump(modelException, true));
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        String[] stringArray = this.rdRowDefinition.getColumnNames();
        int n = 0;
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                n *= 37;
                Object object = this.getValue(stringArray[i]);
                if (object == null) continue;
                n += object.hashCode();
            }
        }
        catch (ModelException modelException) {
            return n;
        }
        return n;
    }

    protected void setValueDRInternal(String string, Object object) throws ModelException {
        Object object2;
        int n = this.getRowDefinition().getColumnDefinitionIndex(string);
        if (n >= this.oaStorage.length) {
            object2 = new Object[this.getRowDefinition().getColumnCount()];
            System.arraycopy(this.oaStorage, 0, object2, 0, this.oaStorage.length);
            this.oaStorage = object2;
        } else if (n < 0) {
            throw new ModelException("Column name doesn't exist! - " + string);
        }
        object2 = this.getRowDefinition().getColumnDefinition(n).getDataType();
        this.oaStorage[n] = object2.convertAndCheckToTypeClass(object);
    }

    protected void invokeRepaintListeners() {
        if (this.auControls != null) {
            IControl[] iControlArray = this.getControls();
            for (int i = 0; i < iControlArray.length; ++i) {
                iControlArray[i].notifyRepaint();
            }
        }
    }

    protected void invokeSaveEditingControls() throws ModelException {
        if (this.auControls != null) {
            IControl[] iControlArray = this.getControls();
            for (int i = 0; i < iControlArray.length; ++i) {
                iControlArray[i].saveEditing();
            }
        }
    }

    protected void invokeCancelEditingControls() {
        if (this.auControls != null) {
            IControl[] iControlArray = this.getControls();
            for (int i = 0; i < iControlArray.length; ++i) {
                iControlArray[i].cancelEditing();
            }
        }
    }

    public void setDefaultValues() throws ModelException {
        int n = this.rdRowDefinition.getColumnCount();
        for (int i = 0; i < n; ++i) {
            ColumnDefinition columnDefinition = this.rdRowDefinition.getColumnDefinition(i);
            this.setValue(columnDefinition.getName(), columnDefinition.getDefaultValue());
        }
    }
}

