/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 * 
 * 09.06.2009 - [HM] - creation
 */
package javax.rad.util;

import javax.rad.util.event.ICallable;

/**
 * The <code>CallableHandler</code> is a <code>EventHandler</code> that 
 * handles <code>ICallable</code>. 
 * 
 * @author Martin Handsteiner
 */
public class CallableHandler extends RuntimeEventHandler<ICallable>
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Initialization
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * Constructs a new CallableHandler.
	 *  
	 * @param pParameterTypes the parameter types.
	 */
	public CallableHandler(Class... pParameterTypes)
	{
		super(ICallable.class, pParameterTypes);
	}				

}	// CallableHandler
