/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 20.04.2008 - [HM] - creation
 */
package javax.rad.ui.event;

/**
 * Platform and technology independent window listener definition.
 * It is designed for use with AWT, Swing, SWT, JSP, JSF, ... .
 * 
 * @author Martin Handsteiner
 * @see    java.awt.event.WindowListener
 */
public interface IWindowListener
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Method definitions
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
     * Invoked the first time a window is made visible.
     * 
     * @param pWindowEvent the window event.
     */
    public void windowOpened(UIWindowEvent pWindowEvent);

    /**
     * Invoked when the user attempts to close the window
     * from the window's system menu.
     * 
     * @param pWindowEvent the window event.
     */
    public void windowClosing(UIWindowEvent pWindowEvent);

    /**
     * Invoked when a window has been closed as the result
     * of calling dispose on the window.
     * 
     * @param pWindowEvent the window event.
     */
    public void windowClosed(UIWindowEvent pWindowEvent);

    /**
     * Invoked when a window is changed from a normal to a
     * minimized state. For many platforms, a minimized window 
     * is displayed as the icon specified in the window's 
     * iconImage property.
     * 
     * @param pWindowEvent the window event.
     */
    public void windowIconified(UIWindowEvent pWindowEvent);

    /**
     * Invoked when a window is changed from a minimized
     * to a normal state.
     * 
     * @param pWindowEvent the window event.
     */
    public void windowDeiconified(UIWindowEvent pWindowEvent);

    /**
     * Invoked when the Window is set to be the active Window. Only a Frame or
     * a Dialog can be the active Window. The native windowing system may
     * denote the active Window or its children with special decorations, such
     * as a highlighted title bar. The active Window is always either the
     * focused Window, or the first Frame or Dialog that is an owner of the
     * focused Window.
     * 
     * @param pWindowEvent the window event.
     */
    public void windowActivated(UIWindowEvent pWindowEvent);

    /**
     * Invoked when a Window is no longer the active Window. Only a Frame or a
     * Dialog can be the active Window. The native windowing system may denote
     * the active Window or its children with special decorations, such as a
     * highlighted title bar. The active Window is always either the focused
     * Window, or the first Frame or Dialog that is an owner of the focused
     * Window.
     * 
     * @param pWindowEvent the window event.
     */
    public void windowDeactivated(UIWindowEvent pWindowEvent);

}	// IWindowListener
