/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 20.04.2008 - [HM] - creation
 */
package javax.rad.ui.event;

/**
 * Platform and technology independent mouse listener definition.
 * It is designed for use with AWT, Swing, SWT, JSP, JSF, ... .
 * 
 * @author Martin Handsteiner
 * @see    java.awt.event.MouseListener
 */
public interface IMouseListener
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Method definitions
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
     * Invoked when the mouse button has been clicked (pressed
     * and released) on a component.
     * 
     * @param pMouseEvent the mouse event.
     */
    public void mouseClicked(UIMouseEvent pMouseEvent);

    /**
     * Invoked when a mouse button has been pressed on a component.
     * 
     * @param pMouseEvent the mouse event.
     */
    public void mousePressed(UIMouseEvent pMouseEvent);

    /**
     * Invoked when a mouse button has been released on a component.
     * 
     * @param pMouseEvent the mouse event.
     */
    public void mouseReleased(UIMouseEvent pMouseEvent);

    /**
     * Invoked when the mouse enters a component.
     * 
     * @param pMouseEvent the mouse event.
     */
    public void mouseEntered(UIMouseEvent pMouseEvent);

    /**
     * Invoked when the mouse exits a component.
     * 
     * @param pMouseEvent the mouse event.
     */
    public void mouseExited(UIMouseEvent pMouseEvent);

}	// IMouseListener
