/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 25.01.2009 - [HM] - creation
 */
package javax.rad.ui.control;

import javax.rad.ui.IColor;
import javax.rad.ui.IFont;
import javax.rad.ui.IImage;
import javax.rad.ui.IResource;

/**
 * Platform and technology independent CellFormat definition.
 * It is designed for use with AWT, Swing, SWT, JSP, JSF, ... .
 * 
 * @author Martin Handsteiner
 */
public interface ICellFormat extends IResource
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Method definitions
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * Gets the background.
	 * 
	 * @return the background.
	 */
	public IColor getBackground();
	
	/**
	 * Gets the foreground.
	 * 
	 * @return the foreground.
	 */
	public IColor getForeground();
	
	/**
	 * Gets the font.
	 * 
	 * @return the font.
	 */
	public IFont getFont();
	
	/**
	 * Gets the image.
	 * 
	 * @return the image.
	 */
	public IImage getImage();
	
	/**
	 * Left indent.
	 * 
	 * @return the left indent.
	 */
	public int getLeftIndent();
	
}	// ICellFormat
