/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 07.10.2008 - [HM] - creation
 */
package javax.rad.ui;

/**
 * Platform and technology independent Insets definition.
 * 
 * @author Martin Handsteiner
 * @see	java.awt.Insets
 */
public interface IInsets extends IResource 
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Method definitions
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
    /**
     * The left margin of the <code>IInsets</code>.
     * 
     * @return the left margin.
     */
    public int getLeft();

    /**
     * Sets the left margin of the <code>IInsets</code>.
     *
     * @param pLeft the left margin
     */
    public void setLeft(int pLeft);

    /**
     * The right margin of the <code>IInsets</code>.
     * 
     * @return the right margin.
     */
    public int getRight();

    /**
     * Sets the right margin of the <code>IInsets</code>.
     *
     * @param pRight the right margin
     */
    public void setRight(int pRight);

    /**
     * The top margin of the <code>IInsets</code>.
     * 
     * @return the top margin.
     */
    public int getTop();

    /**
     * Sets the top margin of the <code>IInsets</code>.
     *
     * @param pTop the top margin
     */
    public void setTop(int pTop);

    /**
     * The bottom margin of the <code>IInsets</code>.
     * 
     * @return the bottom margin.
     */
    public int getBottom();

    /**
     * Sets the bottom margin of the <code>IInsets</code>.
     *
     * @param pBottom the bottom margin
     */
    public void setBottom(int pBottom);

}	// IInsets
