/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 01.10.2008 - [RH] - creation
 * 09.04.2009 - [RH] - interface review - extends now Excpetion instead of BaseException
 */
package javax.rad.model;

/**
 * The <code>ModelException</code> is used to throw model depending 
 * <code>Exception</code>'s. 
 * 
 * @author Roland Hrmann
 */
public class ModelException extends Exception
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Initialization
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * Constructs the <code>ModelException</code> with the specified error message.
	 * 
	 * @param pErrorMessage the error message of the <code>Exception</code>
	 */
	public ModelException(String pErrorMessage)
	{
		super(pErrorMessage);
	}

	/**
	 * Constructs the <code>ModelException</code> with the specified error message.
	 * 
	 * @param pMainCause the cause (which is saved for later retrieval by the
     *                   {@link #getCause()} method).  (A <tt>null</tt> value is
     *                   permitted, and indicates that the cause is nonexistent or
     *                   unknown.)
	 */
	public ModelException(Throwable pMainCause)
	{
		super(pMainCause);
	}
	
	/**
	 * Constructs the <code>ModelException</code> with the specified error message 
	 * and main cause.
	 * 
	 * @param pErrorMessage the error message of the <code>Exception</code>
	 * @param pMainCause the cause (which is saved for later retrieval by the
     *                   {@link #getCause()} method).  (A <tt>null</tt> value is
     *                   permitted, and indicates that the cause is nonexistent or
     *                   unknown.)
	 */
	public ModelException(String pErrorMessage, Throwable pMainCause)
	{
		super(pErrorMessage, pMainCause);
	}

} 	// ModelException
