/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 14.11.2008 - [HM] - creation
 * 24.10.2012 - [JR] - #604: added constructor
 */
package javax.rad.genui;

import javax.rad.ui.IDimension;
import javax.rad.ui.IPoint;
import javax.rad.ui.IRectangle;

/**
 * Platform and technology independent rectangle.
 * 
 * @author Martin Handsteiner
 */
public class UIRectangle extends UIResource<IRectangle> 
                         implements IRectangle
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Initialization
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	  
    /**
     * Creates a new instance of <code>UIRectangle</code> with x=0, y=0, with=0 and height=0.
     *
     * @see IRectangle
     */
    public UIRectangle()
	{
		super(UIFactoryManager.getFactory().createRectangle(0, 0, 0, 0));
	}
    
    /**
     * Creates a new instance of <code>UIRectangle</code> with the given rectangle.
     *
     * @param pRectangle the rectangle
     * @see IRectangle
     */
    protected UIRectangle(IRectangle pRectangle)
	{
		super(pRectangle);
	}

    /**
     * Creates a new instance of <code>UIRectangle</code> with the given <code>IPoint</code> and 
     * <code>IDimension</code>.
     *
     * @param pPoint the point value
     * @param pDimension the dimension value
     * @see IRectangle
     * @see IPoint
     * @see IDimension
     */
    public UIRectangle(IPoint pPoint, IDimension pDimension)
	{
		super(UIFactoryManager.getFactory().createRectangle(pPoint.getX(), pPoint.getY(), pDimension.getWidth(), pDimension.getHeight()));
	}
    
    /**
     * Creates a new instance of <code>IRectangle</code> with the given x, y, width and height.
     *
     * @param pX the x value
     * @param pY the y value
     * @param pWidth the width 
     * @param pHeight the height 
     * @see IRectangle
     */
    public UIRectangle(int pX, int pY, int pWidth, int pHeight)
	{
		super(UIFactoryManager.getFactory().createRectangle(pX, pY, pWidth, pHeight));
	}
    
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Interface implementation
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * {@inheritDoc}
	 */
    public int getX()
    {
    	return uiResource.getX();
    }

	/**
	 * {@inheritDoc}
	 */
    public void setX(int pX)
    {
    	uiResource.setX(pX);
    }

	/**
	 * {@inheritDoc}
	 */
    public int getY()
    {
    	return uiResource.getY();
    }

	/**
	 * {@inheritDoc}
	 */
    public void setY(int pY)
    {
    	uiResource.setY(pY);
    }
    
	/**
	 * {@inheritDoc}
	 */
    public int getWidth()
    {
    	return uiResource.getWidth();
    }

	/**
	 * {@inheritDoc}
	 */
    public void setWidth(int pWidth)
    {
    	uiResource.setWidth(pWidth);
    }

	/**
	 * {@inheritDoc}
	 */
    public int getHeight()
    {
    	return uiResource.getHeight();
    }

	/**
	 * {@inheritDoc}
	 */
    public void setHeight(int pHeight)
    {
    	uiResource.setHeight(pHeight);
    }
	  
}	// UIRectangle
