/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 01.10.2008 - [HM] - creation
 */
package com.sibvisions.rad.ui.swing.impl.component;

import javax.rad.ui.component.ITextArea;
import javax.swing.JTextArea;

import com.sibvisions.rad.ui.swing.ext.JVxScrollPane;

/**
 * The <code>SwingTextArea</code> is the <code>ITextArea</code>
 * implementation for swing.
 *  
 * @author Martin Handsteiner
 * @see	ITextArea
 * @see	javax.swing.JTextArea
 */
public class SwingTextArea extends SwingTextComponent<JVxScrollPane, JTextArea> 
						   implements ITextArea
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Initialization
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * Creates a new instance of <code>SwingTextArea</code>.
	 */
	public SwingTextArea()
	{
		super(new JVxScrollPane(new JTextArea()));
		
		component.setWrapStyleWord(true);
		
		component.setColumns(10);
		component.setRows(5);
	}

	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface implementation
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
    /**
	 * {@inheritDoc}
	 */
    public int getColumns()
    {
    	return component.getColumns();
    }

    /**
	 * {@inheritDoc}
	 */
    public void setColumns(int pColumns)
    {
    	component.setColumns(pColumns);
    }

    /**
	 * {@inheritDoc}
	 */
	public int getRows()
	{
		return component.getRows();
	}

    /**
	 * {@inheritDoc}
	 */
	public void setRows(int pRows)
	{
		component.setRows(pRows);
	}

    /**
	 * {@inheritDoc}
	 */
	public boolean isWordWrap()
	{
		return component.getLineWrap();
	}

    /**
	 * {@inheritDoc}
	 */
	public void setWordWrap(boolean pWordWrap)
	{
		component.setLineWrap(pWordWrap);
	}

}	// SwingTextArea
