/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 01.10.2008 - [JR] - creation
 */
package com.sibvisions.rad.ui.swing.ext.plaf.smart;

import java.awt.Color;
import java.awt.Font;

import javax.swing.SwingConstants;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.InsetsUIResource;

/**
 * The <code>SmartTheme</code> is a utility class with all constant values
 * for the Smart look and feel.
 * 
 * @author Ren Jahn
 */
public class SmartTheme
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Class members
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	/*
	 * DEFAULT 
	 */

	/** the default background color. */
	public static final Color COL_BACKGROUND = new Color(247, 248, 251);

	/** the default background color for textboxes. */
	public static final Color COL_BACKGROUND_TEXT = new ColorUIResource(255, 255, 255);
	
	/** the default foreground color for textboxes. */
	public static final Color COL_FOREGROUND_TEXT = new ColorUIResource(0, 0, 0);

	/** the default arrow color. */
	public static final Color COL_ARROW = new Color(77, 97, 133);

	/** the default font for components. */
	public static final Font FONT_DEFAULT = new Font("dialog", Font.PLAIN, 12);
	
	/*
	 * TAB 
	 */
	
	/** the color of enabled tab borders. */
	public static final Color COL_TAB_BORDER_ENABLED = new Color(84, 84, 84);
	
	/** the color of disabled tab borders. */
	public static final Color COL_TAB_BORDER_DISABLED = Color.LIGHT_GRAY;

	/** the background color of active tabs. */
	public static final Color COL_TAB_ACTIVE_BACKGROUND = new Color(187, 203, 229);
	
	/** the background color of inactive tabs. */
	public static final Color COL_TAB_INACTIVE_BACKGROUND = new Color(235, 235, 235);

	/*
	 * SPLIT 
	 */
	
	/** the border color of the split pane. */
	public static final Color COL_SPLIT_BORDER = COL_TAB_BORDER_ENABLED;
	
	/*
	 * VIEWPORT/SCROLLPANE 
	 */
	
	/** the background color of the viewport. */
	public static final Color COL_VIEWPORT_BACKGROUND = Color.WHITE;
	
	/** the border color of the viewport. */
	public static final Color COL_VIEWPORT_BORDER = COL_TAB_BORDER_ENABLED;

	/** the background color of the scrollpane. */
	public static final Color COL_SCROLLPANE_BACKGROUND = new Color(236, 233, 216);
	
	/*
	 * SCROLLBAR 
	 */
	
	/** the (gradient)background colors of the scroll bar area. */
	public static final Color[] COL_SCROLLBAR_BACKGROUND = { new Color(230, 229, 223), new Color(254, 254, 251) };

	/** the (gradient)background colors of the scroll bar track, when it's pressed. */
	public static final Color[] COL_SCROLLBAR_BACKGROUND_PRESSED = { new Color(219, 214, 204), new Color(254, 254, 251) };
	
	/** the color of an inactive scrollbar. */
	public static final Color COL_SCROLLBAR_INACTIVE = new Color(235, 235, 227);

	/** the border color of the scroll bar slider. */
	public static final Color COL_SCROLLBAR_THUMB_INNER_BORDER = Color.WHITE;

	/** the color of the scroll bar slider border, when the scrollbar is active. */
	public static final Color COL_SCROLLBAR_THUMB_OUTER_ACTIVE_BORDER = new Color(159, 181, 210);

	/** the color of the scroll bar slider border, when the scrollbar is inactive. */
	public static final Color COL_SCROLLBAR_THUMB_OUTER_INACTIVE_BORDER = new Color(196, 196, 175);

	/** the color of the scroll bar slider. */
	public static final Color COL_SCROLLBAR_THUMB_BACKGROUND = new Color(194, 213, 252);
	
	/** the color of the scroll bar slider, when it's pressed. */
	public static final Color COL_SCROLLBAR_THUMB_PRESSED_BACKGROUND = new Color(146, 179, 249);
	
	/** the color of the scroll bar slider, when the mouse is over. */
	public static final Color COL_SCROLLBAR_THUMB_OVER = new Color(216, 232, 255);

	/** the colors of the scroll bar grip. */
	public static final Color[] COL_SCROLLBAR_GRIP = {new Color(238, 244, 254), new Color(140, 176, 248)};

	/*
	 * TABLE 
	 */

	/** the background color of the table header. */
	public static final Color COL_TABLE_HEADER_BACKGROUND = new Color(238, 237, 229);

	/** the background color of the table. */
	public static final Color COL_TABLE_BACKGROUND = COL_VIEWPORT_BACKGROUND;
	
	/** the color of an active row. */
	public static final Color COL_TABLE_ROW_ACTIVE = new Color(208, 228, 253);
	
	/** the gridline color in tables. */
	public static final Color COL_TABLE_GRIDLINES = Color.LIGHT_GRAY;
	
	/** the colors of the bottom tableheader lines. */
	public static final Color[] COL_TABLE_HEADER_BOOTM_LINE = {new Color(226, 222, 205), new Color(214, 210, 194), new Color(203, 199, 184)};

	/*
	 * TOOLBAR 
	 */

	/** the name of the toolbar handle size property. */
	public static final String NAME_TOOLBAR_HANDLESIZE = "Smart/LF.ToolBar.handleSize";
	
	/** the name of the toolbar insets property. */
	public static final String NAME_TOOLBAR_INSETS = "Smart/LF.ToolBar.insets";
	
	/** the name of the toolbar close button. */
	public static final String NAME_TOOLBAR_CLOSE_BUTTON = "Smart/LF.ToolBar.close";

		/** the border color for docking toolbars during drag. */
	public static final Color COL_TOOLBAR_DOCKING = Color.RED;

	/** the border color for default/non docking toolbars during drag. */
	public static final Color COL_TOOLBAR_FLOATING = Color.BLACK;
	
	/** the color for the toolbar handle. */
	public static final Color COL_TOOLBAR_HANDLE = Color.BLACK;

	/** the background color for a toolbar. */
	public static final Color COL_TOOLBAR_BACKGROUND = new Color(167, 186, 216);

	/** the (gradient) background color for sub toolbars. */
	public static final Color[] COL_TOOLBAR_SUB_BACKGROUND = { new Color(230, 238, 250), new Color(187, 203, 229) };

	/** the border color for sub toolbars. */
	public static final Color COL_TOOLBAR_SUB_BORDER = new Color(153, 172, 205);
	
	/** the (gradient)background color for buttons in a toolbar panel .*/ 
	public static final Color[] COL_TOOLBAR_BUTTON_BACKGROUND_ENABLED = { new Color(187, 203, 229), new Color(105, 141, 201) };
	
	/** the background color for enabled buttons in a toolbar panel .*/ 
	public static final Color COL_TOOLBAR_BUTTON_BACKGROUND_DISABLED = new Color(209, 217, 230);

	/** the border color for enabled buttons in a toolbar panel .*/ 
	public static final Color COL_TOOLBAR_BUTTON_BORDER_ENABLED = Color.BLACK;
		
	/** the border color for disabled buttons in a toolbar panel .*/ 
	public static final Color COL_TOOLBAR_BUTTON_BORDER_DISABLED = new Color(122, 127, 137);

	/*
	 * TEXT
	 */

	/** the background color for disabled textfields. */
	public static final Color COL_TEXT_DISABLED_BACKGROUND = new Color(245, 244, 244);
	
	/** the text color for disabled textfields. */
	public static final Color COL_TEXT_DISABLED_FOREGROUND = new Color(160, 160, 160);

	/** the border color for textfields. */
	public static final Color COL_TEXT_BORDER = new Color(170, 174, 201);
	
	/** the border color for disabled textfields. */
	public static final Color COL_TEXT_BORDER_DISABLED = new Color(207, 207, 207);
	
	/** the color for text selections. */
	public static final Color COL_TEXT_SELECTION = new Color(187, 203, 229);
	
	/*
	 * INTERNAL FRAMES 
	 */

	/** the background color of the desktop pane. */
	public static final Color COL_DESKTOP_PANE_BACKGROUND = new Color(235, 238, 245);
	
	/** the background color of the internal frame title. */
	public static final Color COL_INTFRAME_TITLE_BACKGROUND_ACTIVE = new Color(97, 131, 184);
	
	/** the background color of the modal internal frame title. */
	public static final Color COL_INTFRAME_MODAL_TITLE_BACKGROUND_ACTIVE = new Color(101, 148, 224);

	/** the outer border color for activated internal frames. */
	public static final Color COL_INTFRAME_OUTER_BORDER_ACTIVE = new Color(43, 46, 51);
	
	/** the outer border color for inactive internal frames. */
	public static final Color COL_INTFRAME_OUTER_BORDER_INACTIVE = new Color(136, 141, 151);

	/** the inner (content-area) border color for activated internal frames. */
	public static final Color COL_INTFRAME_INNER_BORDER_ACTIVE = new Color(108, 114, 128);
	
	/** the inner (content-area) border color for inactive internal frames. */
	public static final Color COL_INTFRAME_INNER_BORDER_INACTIVE = new Color(158, 163, 173);
	
	/** the background color for the content-area of activated internal frames. */
	public static final Color COL_INTFRAME_BACKGROUND_ACTIVE = new Color(105, 141, 201);
	
	/** the background color for the content-area of activated modal internal frames. */
	public static final Color COL_INTFRAME_MODAL_BACKGROUND_ACTIVE = new Color(121, 159, 224);

	/** the background color for the content-area of inactive internal frames. */
	public static final Color COL_INTFRAME_BACKGROUND_INACTIVE = new Color(190, 194, 201);
	
	
	/** the background color for the active close button of an internal frame [default, mouse_over]. */
	public static final Color[] COL_INTFRAME_CLOSE_BACKGROUND_ACTIVE = { new Color(218, 74, 74), new Color(219, 119, 119) };
	
	/** the background color for active minimize and maximize buttons of an internal frame. */
	public static final Color[] COL_INTFRAME_BUTTONS_BACKGROUND_ACTIVE = { new Color(80, 132, 199), new Color(123, 156, 199) };
	
	/** the background color for inactive internal frame title buttons. */
	public static final Color COL_INTFRAME_BUTTONS_BACKGROUND_INACTIVE = new Color(176, 181, 188);
	
	/** 
	 * the border colors for the active close button of an internal frame 
	 * [active_outer, active_inner, active_symbol, mouseover_outer, mouseover_inner, mouseover_symbol]. 
	 */
	public static final Color[] COL_INTFRAME_CLOSE_BORDER_ACTIVE = 
	{ 
		Color.WHITE, new Color(161, 26, 13), Color.WHITE, 
		Color.WHITE, COL_INTFRAME_CLOSE_BACKGROUND_ACTIVE[0], Color.WHITE 
	};
	
	/** 
	 * the border color for active minimize and maximize buttons of an internal frame 
	 * [active_outer, active_inner, active_symbol, mouseover_outer, mouseover_inner, mouseover_symbol]. 
	 */
	public static final Color[] COL_INTFRAME_BUTTONS_BORDER_ACTIVE = 
	{ 
		Color.WHITE, new Color(42, 84, 137), Color.WHITE, 
		Color.WHITE, COL_INTFRAME_BUTTONS_BACKGROUND_ACTIVE[0], Color.WHITE 
	};
	
	/** 
	 * the border color for inactive title buttons of an internal frame.
	 * [inactive_outer, inactive_inner, inactive_symbol] 
	 */
	public static final Color[] COL_INTFRAME_BUTTONS_BORDER_INACTIVE = { new Color(122, 127, 137), new Color(163, 166, 174), new Color(102, 105, 111)};
	
	/** the space between the buttons in an internal frame title. */
	public static final int SPACE_INTFRAME_TITLE_BUTTONS = 2;
	
	/** the space between menu button and text in an internal frame title. */
	public static final int SPACE_INTFRAME_TITLE_TEXT = 5;
	
	/** the height/width of the buttons in an internal frame title. */
	public static final int SIZE_INTFRAME_BUTTONS = 19;
	
	/** the alignment of the title of an internal frame. */
	public static final int ALIGN_INTFRAME_TITLE = SwingConstants.LEADING;
	
	/** the font for the title of an internal frame. */
	public static final Font FONT_INTFRAME_TITLE = new Font("dialog", Font.BOLD, 12);
	
	/** the text color for the title of an active internal frame. */ 
	public static final Color COL_INTFRAME_TITLE_ACTIVE = Color.BLACK;
	
	/** the text color for the title of an inactive internal frame. */
	public static final Color COL_INTFRAME_TITLE_INACTIVE = new Color(122, 127, 137);
	
	/*
	 * BUTTONS 
	 */
	
	/** the text color for enabled buttons. */
	public static final Color COL_BUTTON_FOREGROUND_ENABLED = Color.BLACK;
	
	/** the text color for disabled buttons. */
	public static final Color COL_BUTTON_FOREGROUND_DISABLED = new Color(122, 127, 137);
	
	/** the (gradient)background colors for buttons when the mouse is over. */
	public static final Color[] COL_BUTTON_BACKGROUND_OVER = { new Color(251, 251, 252), new Color(205, 221, 247) };
	
	/** the background color for selected buttons. */
	public static final Color COL_BUTTON_BACKGROUND_OVER_SELECTED = new Color(187, 203, 229);

	/** the (gradient)background colors for default buttons. */
	public static final Color[] COL_BUTTON_BACKGROUND = { new Color(251, 251, 252), COL_BUTTON_BACKGROUND_OVER_SELECTED };
	
	/** the background color for selected buttons. */
	public static final Color COL_BUTTON_BACKGROUND_SELECTED = new Color(138, 170, 222);
	
	/** the (gradient)background colors for disabled buttons. */
	public static final Color[] COL_BUTTON_BACKGROUND_DISABLED = { new Color(251, 251, 252), new Color(218, 218, 218) };
	
	/** the background color for disabled and selected buttons. */
	public static final Color COL_BUTTON_BACKGROUND_DISABLED_SELECTED = new Color(208, 208, 208);	
	
	/** the (gradient)background colors for pressed buttons. */
	public static final Color[] COL_BUTTON_BACKGROUND_PRESSED = { new Color(251, 251, 252), COL_BUTTON_BACKGROUND_SELECTED};
	
	/** the border color for default buttons. */
	public static final Color COL_BUTTON_BORDER = new Color(33, 54, 73);
	
	/** the border color for disabled buttons. */
	public static final Color COL_BUTTON_BORDER_DISABLED = new Color(136, 141, 151);
	
	/** the border color for buttons when the mouse is over. */
	public static final Color COL_BUTTON_BORDER_OVER = new Color(61, 111, 156);	
	
	/** the default button insets. */
	public static final InsetsUIResource INS_BUTTON_MARGINS = new InsetsUIResource(0, 5, 0, 5);
	
	/*
	 * TOOLTIP 
	 */

	/** the background color for enabled tooltips. */
	public static final Color COL_TOOLTIP_BACKGROUND_ENABLED = new Color(187, 203, 229);
	
	/** the background color for disabled tooltips. */
	public static final Color COL_TOOLTIP_BACKGROUND_DISABLED = new Color(219, 219, 219);
	
	/** the border color for enabled tooltips. */
	public static final Color COL_TOOLTIP_BORDER_ENABLED = Color.BLACK;

	/** the border color for disabled tooltips. */
	public static final Color COL_TOOLTIP_BORDER_DISABLED = new Color(122, 127, 137);
	
	/*
	 * MENU
	 */
	
	/** the background color for menu bars. */
	public static final Color COL_MENU_BAR_BACKGROUND = new Color(147, 171, 215);
	
	/** the color of the bottom menu bar line. */
	public static final Color COL_MENU_BAR_BORDER = new Color(136, 141, 151);
	
	/** the background color for the menu when the mouse is over. */
	public static final Color COL_MENU_BACKGROUND_OVER = new Color(105, 136, 191);

	/** the foreground color for menus. */
	public static final Color COL_MENU_FOREGROUND = Color.BLACK;
	
	/** the color for disabled menus. */
	public static final Color COL_MENU_DISABLED = COL_BUTTON_FOREGROUND_DISABLED; 

	/** the background color for menus. */
	public static final Color COL_MENU_BACKGROUND = new Color(244, 245, 250);
	
	/** the border color for menus. */
	public static final Color COL_MENU_BORDER = new Color(84, 84, 84);

	/** the color for menu speparators. */
	public static final Color COL_MENU_SEPARATOR = new Color(158, 163, 173);

	/** the color for enabled sub menu arrows. */
	public static final Color COL_MENU_ARROW = COL_MENU_BORDER;
	
	/** the color for menu arrows when the mouse is over. */
	public static final Color COL_MENU_ARROW_MOUSE_OVER = Color.WHITE;
	
	/** the border color for radio/checkbox menu items. */
	public static final Color COL_MENU_RADIOCHECK_BORDER = COL_INTFRAME_OUTER_BORDER_ACTIVE;
	
	/** the selected color for radio/checkbox menu items. */
	public static final Color COL_MENU_RADIOCHECK_SELECTED = new Color(44, 82, 148);
	
	/** the text color for the accelerator of menu items. */
	public static final Color COL_MENU_ACCELERATOR = new Color(84, 84, 84);
	
	/** the font for the accelerator of menu items. */
	public static final Font FONT_MENU_ACCELERATOR = new Font("dialog", Font.PLAIN, 11);
	
	/*
	 * RadioButton, CheckBox 
	 */
	
	/** the border color for radio buttons or checkboxes. */
	public static final Color COL_RADIOCHECK_BORDER = COL_INTFRAME_OUTER_BORDER_ACTIVE;
	
	/** the icon color for disabled radio buttons or checkboxes. */
	public static final Color COL_RADIOCHECK_DISABLED = COL_BUTTON_FOREGROUND_DISABLED;
	
	/** the color for the selected icon of radio buttons or checkboxes. */ 
	public static final Color COL_RADIOCHECK_SELECTED = new Color(44, 82, 148);
	
	/*
	 * List
	 */
	
	/** the color for highlighted list items. */
	public static final Color COL_LIST_SELECTED_BACKGROUND = new Color(205, 221, 247);
	
	/*
	 * ComboBox, Spinner Buttons
	 */
	
	/** the width of spinner and combobox arrow buttons. */
	public static final int WIDTH_TEXT_ARROWBUTTONS = 17;

	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Initialization
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * Hidden constructor because the <code>SmartTheme</code> is a utility class.
	 */
	protected SmartTheme()
	{
	}
	
}	//SmartTheme
