/*
 * Copyright 2013 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 27.09.2013 - [HM] - creation
 */
package com.sibvisions.rad.ui.swing.ext.celleditor;

import javax.rad.ui.celleditor.IComboCellEditor;

/**
 * The <code>JVxComboCellEditor</code> defines popup handling of in place editors.
 * 
 * @author Martin Handsteiner
 */
public abstract class JVxComboCellEditor extends JVxInplaceCellEditor 
                                         implements IComboCellEditor
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Class members
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	/** showing popup on focus. */
	private boolean	autoOpenPopup = true;
	
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Initialization
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	/**
	 * Creates a new instance of <code>JVxComboCellEditor</code>.
	 */
	public JVxComboCellEditor()
	{
	}
	
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Interface implementation
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	/**
	 * {@inheritDoc}
	 */
	public boolean isAutoOpenPopup()
	{
		return autoOpenPopup;
	}

	/**
	 * {@inheritDoc}
	 */
	public void setAutoOpenPopup(boolean pAutoOpenPopup)
	{
		autoOpenPopup = pAutoOpenPopup;
	}

}	// JVxComboCellEditor
