/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 11.10.2009 - [JR] - creation
 */
package com.sibvisions.rad.ui.swing.ext;

import java.awt.Graphics;

import javax.swing.ImageIcon;
import javax.swing.JPanel;

/**
 * The <code>JVxPanel</code> is a {@link JPanel} with a background image.
 *  
 * @author Ren Jahn
 */
public class JVxPanel extends JPanel
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Class members
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/** the background image. */
	private ImageIcon imgBack = null;
	
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Overwritten methods
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * Paints the background image if set.
	 * 
	 * @param pGraphics {@inheritDoc}
	 */
	@Override
	public void paintComponent(Graphics pGraphics)
	{
		if (imgBack != null)
		{
			imgBack.paintIcon(this, pGraphics, 0, 0);
		}
		else
		{
			super.paintComponent(pGraphics);
		}
	}
	
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // User-defined methods
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * Sets the background image.
	 * 
	 * @param pImage the background image or <code>null</code> to unset the background image
	 */
	public void setBackgroundImage(ImageIcon pImage)
	{
		imgBack = pImage;
	}
	
	/**
	 * Gets the current background image.
	 * 
	 * @return the background image or <code>null</code> if there is no background image set
	 */
	public ImageIcon getBackgroundImage()
	{
		return imgBack;
	}
	
}	// JVxPanel
