/*
 * Copyright 2014 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 28.03.2014 - [HM] - creation
 */
package com.sibvisions.rad.ui.swing.ext;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;

/**
 * The <code>JVxCheckBox</code> class is a check box that checks the mouse position.
 * The state changes only, if the mouse position is inside the check box rectangle.
 *  
 * @author Martin Handsteiner
 */
public class JVxCheckBox extends JCheckBox
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Initialization
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    /**
     * Creates an initially unselected check box menu item with no set text or icon.
     */
	public JVxCheckBox()
	{
		super();
	}
	
    /**
     * Creates a menu item whose properties are taken from the Action supplied.
     *
     * @param pAction the action of the CheckBoxMenuItem
     */
	public JVxCheckBox(Action pAction)
	{
		super(pAction);
	}
	
    /**
     * Creates an initially unselected check box menu item with an icon.
     *
     * @param pIcon the icon of the CheckBoxMenuItem.
     */
	public JVxCheckBox(Icon pIcon)
	{
		super(pIcon);
	}
	
    /**
     * Creates an initially unselected check box menu item with text.
     *
     * @param pText the text of the CheckBoxMenuItem
     */
	public JVxCheckBox(String pText)
	{
		super(pText);
	}
	
    /**
     * Creates a check box menu item with the specified text and selection state.
     *
     * @param pText the text of the check box menu item.
     * @param pSelected the selected state of the check box menu item
     */
	public JVxCheckBox(String pText, boolean pSelected)
	{
		super(pText, pSelected);
	}
	
    /**
     * Creates an initially unselected check box menu item with the specified text and icon.
     *
     * @param pText the text of the CheckBoxMenuItem
     * @param pIcon the icon of the CheckBoxMenuItem
     */
	public JVxCheckBox(String pText, Icon pIcon)
	{
		super(pText, pIcon);
	}
	
    /**
     * Creates a check box menu item with the specified text, icon, and selection state.
     *
     * @param pText the text of the check box menu item
     * @param pIcon the icon of the check box menu item
     * @param pSelected the selected state of the check box menu item
     */
	public JVxCheckBox(String pText, Icon pIcon, boolean pSelected)
	{
		super(pText, pIcon, pSelected);
	}

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Overwritten methods
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * {@inheritDoc}
	 */
	@Override
    protected void processMouseEvent(MouseEvent pMouseEvent)
    {
    	Rectangle bounds = getBounds();
    	Dimension prefSize = getPreferredSize();
    	
    	switch (getHorizontalAlignment())
    	{
    		case JVxConstants.LEFT:
    			bounds.width = prefSize.width;
    			break;
    		case JVxConstants.CENTER:
    			bounds.x += (bounds.width - prefSize.width) / 2;
    			bounds.width = prefSize.width;
    			break;
    		case JVxConstants.RIGHT:
    			bounds.x += bounds.width - prefSize.width;
    			bounds.width = prefSize.width;
    			break;
    		default: // Do NOthing
    	}
    	switch (getVerticalAlignment())
    	{
    		case JVxConstants.TOP:
    			bounds.height = prefSize.height;
    			break;
    		case JVxConstants.CENTER:
    			bounds.y += (bounds.height - prefSize.height) / 2;
    			bounds.height = prefSize.height;
    			break;
    		case JVxConstants.RIGHT:
    			bounds.y += bounds.height - prefSize.height;
    			bounds.height = prefSize.height;
    			break;
    		default: // Do NOthing
    	}
    	
    	if (bounds.contains(pMouseEvent.getX(), pMouseEvent.getY()))
    	{
    		super.processMouseEvent(pMouseEvent);
    	}
    }
    
}	// JVxCheckBox
