/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.remote;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.ChangedHashtable;
import com.sibvisions.util.ICloseable;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.StringUtil;
import java.text.DecimalFormatSymbols;
import java.util.AbstractList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.rad.remote.CommunicationException;
import javax.rad.remote.ConnectionInfo;
import javax.rad.remote.IConnection;
import javax.rad.remote.event.CallBackEvent;
import javax.rad.remote.event.CallBackForward;
import javax.rad.remote.event.CallErrorEvent;
import javax.rad.remote.event.CallEvent;
import javax.rad.remote.event.ConnectionEvent;
import javax.rad.remote.event.ICallBackListener;
import javax.rad.remote.event.IConnectionListener;
import javax.rad.util.UIInvoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConnection
implements ICloseable {
    private static final String[] USED_SYSPROPS = new String[]{"user.name", "os.name", "os.version", "os.arch", "java.vendor", "java.version", "java.class.version", "java.vm.name", "file.encoding", "file.separator", "path.separator", "line.separator", "user.language", "user.timezone"};
    private static final ICallBackListener CBL_INTERN = new ICallBackListener(){

        public void callBack(CallBackEvent callBackEvent) {
            try {
                log.debug(callBackEvent.getObject());
            }
            catch (Throwable throwable) {
                log.debug(throwable);
            }
        }
    };
    private static ILogger log = LoggerFactory.getInstance(AbstractConnection.class);
    protected IConnection connection;
    protected ConnectionInfo coninf;
    private ArrayUtil<IConnectionListener> auConListener = null;
    private static boolean bTimeoutEnabled = true;

    protected AbstractConnection(IConnection iConnection) {
        this.connection = iConnection;
        this.coninf = new ConnectionInfo(this.createConnectionProperties());
    }

    protected abstract void openConnection() throws Throwable;

    protected abstract UIInvoker getUIInvoker();

    protected void finalize() throws Throwable {
        this.auConListener = null;
        this.close();
        super.finalize();
    }

    public void setLifeCycleName(String string) {
        this.coninf.getProperties().put("client.lifecyclename", string);
    }

    public String getLifeCycleName() {
        return (String)this.coninf.getProperties().get("client.lifecyclename");
    }

    public void setApplicationName(String string) {
        if (!this.isOpen()) {
            this.coninf.getProperties().put("client.application", string);
        }
    }

    public String getApplicationName() {
        return (String)this.coninf.getProperties().get("client.application");
    }

    public void setUserName(String string) {
        this.coninf.getProperties().put("client.username", string);
    }

    public String getUserName() {
        return (String)this.coninf.getProperties().get("client.username");
    }

    public void setPassword(String string) {
        if (!this.isOpen()) {
            this.coninf.getProperties().put("client.password", string);
        }
    }

    public String getPassword() {
        return (String)this.coninf.getProperties().get("client.password");
    }

    public void open() throws Throwable {
        long l = System.currentTimeMillis();
        String string = null;
        try {
            this.openConnection();
            if (log.isEnabled(ILogger.LogLevel.DEBUG)) {
                string = "open" + StringUtil.getShortenedWords(this.getClass().getSimpleName(), 2);
                this.logCommunication(l, string, null, new Object[0]);
            }
            this.fireOpen();
        }
        catch (Throwable throwable) {
            if (log.isEnabled(ILogger.LogLevel.DEBUG)) {
                this.logCommunication(l, string, throwable, new Object[0]);
            }
            throw this.handleCallError(throwable);
        }
    }

    public boolean isOpen() {
        return this.connection.isOpen(this.coninf);
    }

    @Override
    public void close() throws Throwable {
        this.close(true);
    }

    protected void close(boolean bl) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            if (bl) {
                this.connection.close(this.coninf);
            } else {
                this.coninf.setConnectionId(null);
            }
            this.logCommunication(l, "close", null, new Object[0]);
            this.fireClose();
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "close", throwable, new Object[0]);
            throw this.handleCallError(throwable);
        }
    }

    public void reopen() throws Throwable {
        long l = System.currentTimeMillis();
        try {
            this.connection.close(this.coninf);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.openConnection();
            this.logCommunication(l, "reopen", null, new Object[0]);
            this.fireReOpen();
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "reopen", throwable, new Object[0]);
            throw this.handleCallError(throwable);
        }
    }

    public IConnection getConnection() {
        return this.connection;
    }

    public Object getConnectionId() {
        return this.coninf.getConnectionId();
    }

    public void call(ICallBackListener[] iCallBackListenerArray, String[] stringArray, String[] stringArray2, Object[][] objectArray) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            this.connection.call(this.coninf, stringArray, stringArray2, objectArray, this.createListener(stringArray2, iCallBackListenerArray));
            this.logCommunication(l, "call", null, iCallBackListenerArray, stringArray, stringArray2);
            if (this.auConListener != null && stringArray2 != null) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    this.fireCall(true, stringArray != null && stringArray.length > i ? stringArray[i] : null, stringArray2[i], objectArray != null && objectArray.length > i ? objectArray[i] : null);
                }
            }
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "call", throwable, iCallBackListenerArray, stringArray, stringArray2);
            throw this.handleCallError(throwable);
        }
    }

    public void call(ICallBackListener iCallBackListener, String string, String string2, Object ... objectArray) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            this.connection.call(this.coninf, new String[]{string}, new String[]{string2}, new Object[][]{objectArray}, new ICallBackListener[]{this.createListener(iCallBackListener)});
            this.logCommunication(l, "call", null, iCallBackListener, string, string2);
            this.fireCall(true, string, string2, objectArray);
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "call", throwable, iCallBackListener, string);
            throw this.handleCallError(throwable);
        }
    }

    public void call(ICallBackListener iCallBackListener, String string, String string2) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            this.connection.call(this.coninf, new String[]{string}, new String[]{string2}, null, new ICallBackListener[]{this.createListener(iCallBackListener)});
            this.logCommunication(l, "call", null, iCallBackListener, string, string2);
            this.fireCall(true, string, string2, new Object[0]);
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "call", throwable, iCallBackListener, string, string2);
            throw this.handleCallError(throwable);
        }
    }

    public Object[] call(String[] stringArray, String[] stringArray2, Object[][] objectArray) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            Object[] objectArray2 = this.connection.call(this.coninf, stringArray, stringArray2, objectArray, null);
            this.logCommunication(l, "call", null, null, stringArray, stringArray2);
            if (this.auConListener != null && objectArray2 != null) {
                for (int i = 0; i < objectArray2.length; ++i) {
                    this.fireCall(false, stringArray != null && stringArray.length > i ? stringArray[i] : null, stringArray2[i], objectArray != null && objectArray.length > i ? objectArray[i] : null);
                }
            }
            return objectArray2;
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "call", throwable, null, stringArray, stringArray2);
            throw this.handleCallError(throwable);
        }
    }

    public Object[] call(String[] stringArray, String[] stringArray2) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            Object[] objectArray = this.connection.call(this.coninf, stringArray, stringArray2, null, null);
            this.logCommunication(l, "call", null, null, stringArray, stringArray2);
            if (this.auConListener != null && objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    this.fireCall(false, stringArray != null && stringArray.length > i ? stringArray[i] : null, stringArray2[i], new Object[0]);
                }
            }
            return objectArray;
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "call", throwable, null, stringArray, stringArray2);
            throw this.handleCallError(throwable);
        }
    }

    public Object call(String string, String string2, Object ... objectArray) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            Object object = this.connection.call(this.coninf, new String[]{string}, new String[]{string2}, new Object[][]{objectArray}, null)[0];
            this.logCommunication(l, "call", null, null, string, string2);
            this.fireCall(false, string, string2, objectArray);
            return object;
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "call", throwable, null, string, string2);
            throw this.handleCallError(throwable);
        }
    }

    public Object call(String string, String string2) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            Object object = this.connection.call(this.coninf, new String[]{string}, new String[]{string2}, null, null)[0];
            this.logCommunication(l, "call", null, null, string, string2);
            this.fireCall(false, string, string2, new Object[0]);
            return object;
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "call", throwable, null, string, string2);
            throw this.handleCallError(throwable);
        }
    }

    public Object callAction(String string) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            Object object = this.connection.call(this.coninf, null, new String[]{string}, null, null)[0];
            this.logCommunication(l, "callAction", null, null, string);
            this.fireCallAction(false, string, new Object[0]);
            return object;
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "callAction", throwable, null, string);
            throw this.handleCallError(throwable);
        }
    }

    public Object callAction(String string, Object ... objectArray) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            Object object = this.connection.call(this.coninf, null, new String[]{string}, new Object[][]{objectArray}, null)[0];
            this.logCommunication(l, "callAction", null, null, string);
            this.fireCallAction(false, string, objectArray);
            return object;
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "callAction", throwable, null, string);
            throw this.handleCallError(throwable);
        }
    }

    public Object[] callAction(String[] stringArray, Object[][] objectArray) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            Object[] objectArray2 = this.connection.call(this.coninf, null, stringArray, objectArray, null);
            this.logCommunication(l, "callAction", null, null, stringArray);
            if (objectArray2 != null) {
                for (int i = 0; i < objectArray2.length; ++i) {
                    this.fireCallAction(false, stringArray[i], objectArray != null && objectArray.length > i ? objectArray[i] : null);
                }
            }
            return objectArray2;
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "callAction", throwable, null, stringArray);
            throw this.handleCallError(throwable);
        }
    }

    public Object[] callAction(String[] stringArray) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            Object[] objectArray = this.connection.call(this.coninf, null, stringArray, null, null);
            this.logCommunication(l, "callAction", null, null, stringArray);
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    this.fireCallAction(false, stringArray[i], new Object[0]);
                }
            }
            return objectArray;
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "callAction", throwable, null, stringArray);
            throw this.handleCallError(throwable);
        }
    }

    public void callAction(ICallBackListener iCallBackListener, String string) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            this.connection.call(this.coninf, null, new String[]{string}, null, new ICallBackListener[]{this.createListener(iCallBackListener)});
            this.logCommunication(l, "callAction", null, iCallBackListener, string);
            this.fireCallAction(true, string, new Object[0]);
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "callAction", throwable, iCallBackListener, string);
            throw this.handleCallError(throwable);
        }
    }

    public void callAction(ICallBackListener iCallBackListener, String string, Object ... objectArray) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            this.connection.call(this.coninf, null, new String[]{string}, new Object[][]{objectArray}, new ICallBackListener[]{this.createListener(iCallBackListener)});
            this.logCommunication(l, "callAction", null, iCallBackListener, string);
            this.fireCallAction(true, string, objectArray);
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "callAction", throwable, iCallBackListener, string);
            throw this.handleCallError(throwable);
        }
    }

    public void callAction(ICallBackListener[] iCallBackListenerArray, String[] stringArray, Object[][] objectArray) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            this.connection.call(this.coninf, null, stringArray, objectArray, this.createListener(stringArray, iCallBackListenerArray));
            this.logCommunication(l, "callAction", null, iCallBackListenerArray, stringArray);
            if (this.auConListener != null && stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.fireCallAction(true, stringArray[i], objectArray != null && objectArray.length > i ? objectArray[i] : null);
                }
            }
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "callAction", throwable, iCallBackListenerArray, stringArray);
            throw this.handleCallError(throwable);
        }
    }

    public void setProperty(String string, Object object) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            this.connection.setProperty(this.coninf, string, object);
            this.logCommunication(l, "setProperty", null, string);
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "setProperty", throwable, string);
            throw this.handleCallError(throwable);
        }
    }

    public Object getProperty(String string) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            Object object = this.connection.getProperty(this.coninf, string);
            this.logCommunication(l, "getProperty", null, string);
            return object;
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "getProperty", throwable, string);
            throw this.handleCallError(throwable);
        }
    }

    public Hashtable<String, Object> getProperties() throws Throwable {
        long l = System.currentTimeMillis();
        try {
            Hashtable<String, Object> hashtable = this.connection.getProperties(this.coninf);
            this.logCommunication(l, "getProperties", null, new Object[0]);
            return hashtable;
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "getProperties", null, new Object[0]);
            throw this.handleCallError(throwable);
        }
    }

    public void setTimeout(int n) throws Throwable {
        if (bTimeoutEnabled) {
            this.setProperty("server.session.timeout", n);
        }
    }

    public int getTimeout() throws Throwable {
        if (bTimeoutEnabled) {
            Integer n = (Integer)this.getProperty("server.session.timeout");
            if (n != null) {
                return n / 60;
            }
            return -2;
        }
        return -1;
    }

    public static void setTimeoutEnabled(boolean bl) {
        bTimeoutEnabled = bl;
    }

    public static boolean isTimeoutEnabled() {
        return bTimeoutEnabled;
    }

    protected ChangedHashtable<String, Object> createConnectionProperties() {
        Object object;
        String string;
        ChangedHashtable<String, Object> changedHashtable = new ChangedHashtable<String, Object>();
        String string2 = "client.sysprop.";
        int n = USED_SYSPROPS.length;
        for (int i = 0; i < n; ++i) {
            try {
                string = System.getProperty(USED_SYSPROPS[i]);
                if (string == null) continue;
                changedHashtable.put(string2 + USED_SYSPROPS[i], string);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        string2 = "client.envprop.";
        try {
            object = System.getenv();
            for (Map.Entry<String, String> entry : object.entrySet()) {
                String string3 = entry.getKey();
                string = entry.getValue();
                if (string3 == null || string == null) continue;
                changedHashtable.put(string2 + entry.getKey(), string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = new DecimalFormatSymbols();
        string2 = "client.decimalFormatSymbols.";
        changedHashtable.put(string2 + "currencySymbol", ((DecimalFormatSymbols)object).getCurrencySymbol());
        changedHashtable.put(string2 + "currencyCode", ((DecimalFormatSymbols)object).getCurrency().getCurrencyCode());
        changedHashtable.put(string2 + "internationalCurrencySymbol", ((DecimalFormatSymbols)object).getInternationalCurrencySymbol());
        changedHashtable.put(string2 + "decimalsSparator", Character.toString(((DecimalFormatSymbols)object).getDecimalSeparator()));
        changedHashtable.put(string2 + "digit", Character.toString(((DecimalFormatSymbols)object).getDigit()));
        changedHashtable.put(string2 + "groupingSeparator", Character.toString(((DecimalFormatSymbols)object).getGroupingSeparator()));
        changedHashtable.put(string2 + "infinity", ((DecimalFormatSymbols)object).getInfinity());
        changedHashtable.put(string2 + "minusSign", Character.toString(((DecimalFormatSymbols)object).getMinusSign()));
        changedHashtable.put(string2 + "monetaryDecimalSeparator", Character.toString(((DecimalFormatSymbols)object).getMonetaryDecimalSeparator()));
        changedHashtable.put(string2 + "NaN", ((DecimalFormatSymbols)object).getNaN());
        changedHashtable.put(string2 + "patternSeparator", Character.toString(((DecimalFormatSymbols)object).getPatternSeparator()));
        changedHashtable.put(string2 + "percent", Character.toString(((DecimalFormatSymbols)object).getPercent()));
        changedHashtable.put(string2 + "perMill", Character.toString(((DecimalFormatSymbols)object).getPerMill()));
        changedHashtable.put(string2 + "zeroDigit", Character.toString(((DecimalFormatSymbols)object).getZeroDigit()));
        Locale locale = Locale.getDefault();
        changedHashtable.put("client.locale.country", locale.getCountry());
        changedHashtable.put("client.locale.language", locale.getLanguage());
        changedHashtable.put("client.locale.variant", locale.getVariant());
        changedHashtable.put("client.oslib_version", "2.1.1");
        changedHashtable.put("client.spec_version", "0.4.1");
        changedHashtable.put("client.creationTime", new Date());
        IConnection iConnection = this.getConnection();
        if (iConnection != null) {
            changedHashtable.put("client.connectionClass", iConnection.getClass().getName());
        }
        changedHashtable.put("client.session.compression", "true");
        if (!bTimeoutEnabled) {
            changedHashtable.put("server.session.timeout", -1);
        }
        return changedHashtable;
    }

    public void addConnectionListener(IConnectionListener iConnectionListener) {
        if (iConnectionListener != null) {
            if (this.auConListener == null) {
                this.auConListener = new ArrayUtil();
            }
            if (this.auConListener.indexOf(iConnectionListener) < 0) {
                this.auConListener.add(iConnectionListener);
                this.connection.addPropertyChangedListener(iConnectionListener);
            }
        }
    }

    public void removeConnectionListener(IConnectionListener iConnectionListener) {
        if (this.auConListener != null && iConnectionListener != null) {
            this.connection.removePropertyChangedListener(iConnectionListener);
            this.auConListener.remove(iConnectionListener);
            if (this.auConListener.size() == 0) {
                this.auConListener = null;
            }
        }
    }

    public IConnectionListener[] getConnectionListener() {
        if (this.auConListener != null) {
            IConnectionListener[] iConnectionListenerArray = new IConnectionListener[this.auConListener.size()];
            return this.auConListener.toArray(iConnectionListenerArray);
        }
        return null;
    }

    protected void fireCallError(Throwable throwable) {
        if (this.auConListener != null) {
            CallErrorEvent callErrorEvent = new CallErrorEvent(this, throwable);
            Iterator iterator = ((AbstractList)this.auConListener.clone()).iterator();
            while (iterator.hasNext()) {
                IConnectionListener iConnectionListener = (IConnectionListener)iterator.next();
                iConnectionListener.callError(callErrorEvent);
            }
        }
    }

    protected Throwable handleCallError(Throwable throwable) {
        Throwable throwable2 = this.setConnection(throwable);
        this.fireCallError(throwable2);
        return throwable2;
    }

    protected Throwable setConnection(Throwable throwable) {
        if (throwable != null) {
            for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
                if (!(throwable2 instanceof CommunicationException)) continue;
                ((CommunicationException)throwable2).setConnection(this);
            }
        }
        return throwable;
    }

    protected void fireOpen() {
        if (this.auConListener != null) {
            ConnectionEvent connectionEvent = new ConnectionEvent(this);
            Iterator iterator = ((AbstractList)this.auConListener.clone()).iterator();
            while (iterator.hasNext()) {
                IConnectionListener iConnectionListener = (IConnectionListener)iterator.next();
                iConnectionListener.connectionOpened(connectionEvent);
            }
        }
    }

    protected void fireReOpen() {
        if (this.auConListener != null) {
            ConnectionEvent connectionEvent = new ConnectionEvent(this);
            Iterator iterator = ((AbstractList)this.auConListener.clone()).iterator();
            while (iterator.hasNext()) {
                IConnectionListener iConnectionListener = (IConnectionListener)iterator.next();
                iConnectionListener.connectionReOpened(connectionEvent);
            }
        }
    }

    protected void fireClose() {
        if (this.auConListener != null) {
            ConnectionEvent connectionEvent = new ConnectionEvent(this);
            Iterator iterator = ((AbstractList)this.auConListener.clone()).iterator();
            while (iterator.hasNext()) {
                IConnectionListener iConnectionListener = (IConnectionListener)iterator.next();
                iConnectionListener.connectionClosed(connectionEvent);
            }
        }
    }

    protected void fireCall(boolean bl, String string, String string2, Object ... objectArray) {
        if (this.auConListener != null) {
            CallEvent callEvent = new CallEvent(this, string, string2, objectArray, bl);
            Iterator iterator = ((AbstractList)this.auConListener.clone()).iterator();
            while (iterator.hasNext()) {
                IConnectionListener iConnectionListener = (IConnectionListener)iterator.next();
                iConnectionListener.objectCalled(callEvent);
            }
        }
    }

    protected void fireCallAction(boolean bl, String string, Object ... objectArray) {
        if (this.auConListener != null) {
            CallEvent callEvent = new CallEvent(this, null, string, objectArray, bl);
            Iterator iterator = ((AbstractList)this.auConListener.clone()).iterator();
            while (iterator.hasNext()) {
                IConnectionListener iConnectionListener = (IConnectionListener)iterator.next();
                iConnectionListener.actionCalled(callEvent);
            }
        }
    }

    private ICallBackListener createListener(ICallBackListener iCallBackListener) {
        if (iCallBackListener == null) {
            return CBL_INTERN;
        }
        return new CallBackForward(this.getUIInvoker(), this, iCallBackListener);
    }

    private ICallBackListener[] createListener(String[] stringArray, ICallBackListener[] iCallBackListenerArray) {
        ICallBackListener[] iCallBackListenerArray2 = iCallBackListenerArray;
        if (iCallBackListenerArray == null && stringArray != null) {
            iCallBackListenerArray2 = new ICallBackListener[stringArray.length];
        }
        if (iCallBackListenerArray2 != null) {
            for (int i = 0; i < iCallBackListenerArray2.length; ++i) {
                iCallBackListenerArray2[i] = iCallBackListenerArray2[i] == null ? CBL_INTERN : new CallBackForward(this.getUIInvoker(), this, iCallBackListenerArray2[i]);
            }
        }
        return iCallBackListenerArray2;
    }

    protected void logCommunication(long l, String string, Throwable throwable, Object ... objectArray) {
        if (log.isEnabled(ILogger.LogLevel.DEBUG)) {
            if (throwable != null) {
                log.debug(string, " error: " + Long.valueOf(System.currentTimeMillis() - l), " ms", " ", objectArray, throwable);
            } else {
                log.debug(string, ": ", System.currentTimeMillis() - l, " ms", " ", objectArray);
            }
        }
    }
}

