/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.model.datatype;

import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.rad.io.IFileHandle;
import javax.rad.io.RemoteFileHandle;
import javax.rad.model.ModelException;
import javax.rad.model.datatype.DataType;
import javax.rad.model.ui.ICellEditor;

public class BinaryDataType
extends DataType {
    public static final int TYPE_IDENTIFIER = -2;

    public BinaryDataType() {
    }

    public BinaryDataType(int n) {
        this.setSize(n);
    }

    public BinaryDataType(ICellEditor iCellEditor) {
        this.setCellEditor(iCellEditor);
    }

    public BinaryDataType(int n, ICellEditor iCellEditor) {
        this.setSize(n);
        this.setCellEditor(iCellEditor);
    }

    public int getTypeIdentifier() {
        return -2;
    }

    public Class getTypeClass() {
        if (this.getCellEditor() != null || this.getCellRenderer() != null) {
            return Object.class;
        }
        return byte[].class;
    }

    public Object convertAndCheckToTypeClass(Object object) throws ModelException {
        int n;
        Object object2 = this.convertToTypeClass(object);
        if (object2 == null) {
            return null;
        }
        if (object2 instanceof byte[]) {
            n = ((byte[])object2).length;
        } else if (object2 instanceof RemoteFileHandle) {
            try {
                n = (int)((RemoteFileHandle)object2).getLength();
            }
            catch (Exception exception) {
                n = 0;
            }
        } else {
            throw new ModelException("Object type is not supported!");
        }
        if (n > this.getSize()) {
            throw new ModelException("Binary too large! - length from " + n + " to " + this.getSize());
        }
        return object2;
    }

    public String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return new String((byte[])object);
        }
        if (object instanceof RemoteFileHandle) {
            try {
                return new String(FileUtil.getContent(((RemoteFileHandle)object).getInputStream()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Object convertToTypeClass(Object object) throws ModelException {
        if (object == null) {
            return null;
        }
        if (object instanceof RemoteFileHandle) {
            return object;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (byArray.length == 0) {
                return null;
            }
            return byArray;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0) {
                return null;
            }
            return string.getBytes();
        }
        throw new ModelException("Conversion failed! Type not supported ! from " + object.getClass().getName() + " to " + this.getTypeClass().getName());
    }

    public int compareTo(Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        try {
            RemoteFileHandle remoteFileHandle = null;
            RemoteFileHandle remoteFileHandle2 = null;
            if (object instanceof RemoteFileHandle) {
                remoteFileHandle = (RemoteFileHandle)object;
            }
            if (object2 instanceof RemoteFileHandle) {
                remoteFileHandle2 = (RemoteFileHandle)object2;
            }
            if (remoteFileHandle != null && remoteFileHandle2 != null && CommonUtil.equals(remoteFileHandle.getObjectCacheKey(), remoteFileHandle2.getObjectCacheKey())) {
                return 0;
            }
            if (object != null && object2 != null) {
                byte[] byArray;
                byte[] byArray2;
                if (remoteFileHandle != null) {
                    object = FileUtil.getContent(remoteFileHandle.getInputStream());
                }
                if ((byArray2 = (byte[])object).length < (byArray = (byte[])(object2 = remoteFileHandle2 != null ? (Object)FileUtil.getContent(remoteFileHandle2.getInputStream()) : this.convertToTypeClass(object2))).length) {
                    return -1;
                }
                if (byArray2.length > byArray.length) {
                    return 1;
                }
                for (int i = 0; i < byArray2.length; ++i) {
                    if (byArray2[i] < byArray[i]) {
                        return -1;
                    }
                    if (byArray2[i] <= byArray[i]) continue;
                    return 1;
                }
                return 0;
            }
        }
        catch (Exception exception) {
            return 1;
        }
        return super.compareTo(object, object2);
    }

    public BinaryDataType clone() {
        return (BinaryDataType)super.clone();
    }

    public Object prepareValue(Object object) throws ModelException {
        if (object instanceof RemoteFileHandle && this.getCellEditor() != null) {
            RemoteFileHandle remoteFileHandle = (RemoteFileHandle)object;
            try {
                return FileUtil.getContent(remoteFileHandle.getInputStream());
            }
            catch (IOException iOException) {
                throw new ModelException(iOException);
            }
        }
        return object;
    }

    public static final byte[] getContent(Object object) throws IOException {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof IFileHandle) {
            return FileUtil.getContent(((IFileHandle)object).getInputStream());
        }
        if (object instanceof File) {
            return FileUtil.getContent((File)object);
        }
        if (object instanceof InputStream) {
            return FileUtil.getContent((InputStream)object);
        }
        if (object instanceof InputStreamReader) {
            return FileUtil.getContent((InputStreamReader)object);
        }
        throw new IOException(object.getClass() + " is a not supported binary object!");
    }
}

