/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.io;

import com.sibvisions.util.type.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.rad.io.IFileHandle;

public class FileHandle
implements IFileHandle,
Serializable {
    private String fileName;
    private transient ByteArrayOutputStream gZIPContent;
    private transient File file;

    public FileHandle() {
        this.fileName = null;
        this.gZIPContent = null;
        this.file = null;
    }

    public FileHandle(String string) {
        this.fileName = FileUtil.getName(string);
        this.gZIPContent = null;
        this.file = new File(string);
    }

    public FileHandle(String string, byte[] byArray) throws IOException {
        this.fileName = FileUtil.getName(string);
        this.setContent(byArray);
    }

    public FileHandle(String string, InputStream inputStream) throws IOException {
        this.fileName = FileUtil.getName(string);
        this.setContent(inputStream);
    }

    public FileHandle(File file) throws IOException {
        this.fileName = null;
        this.setContent(file);
    }

    public String getFileName() {
        return this.fileName;
    }

    public InputStream getInputStream() throws IOException {
        if (this.gZIPContent != null) {
            return new GZIPInputStream(new ByteArrayInputStream(this.gZIPContent.toByteArray()));
        }
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        if (this.fileName != null) {
            return new FileInputStream(this.fileName);
        }
        return null;
    }

    public long getLength() throws IOException {
        if (this.gZIPContent != null) {
            byte[] byArray = this.gZIPContent.toByteArray();
            return (byArray[byArray.length - 1] & 0xFF) << 24 | (byArray[byArray.length - 2] & 0xFF) << 16 | (byArray[byArray.length - 3] & 0xFF) << 8 | byArray[byArray.length - 4] & 0xFF;
        }
        if (this.file != null) {
            return this.file.length();
        }
        if (this.fileName != null) {
            return new File(this.fileName).length();
        }
        return -1L;
    }

    public void setFileName(String string) {
        this.fileName = FileUtil.getName(string);
    }

    public File getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getGZIPContent() throws IOException {
        block6: {
            if (this.gZIPContent != null) {
                return this.gZIPContent.toByteArray();
            }
            if (this.file == null && this.fileName == null) break block6;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FileInputStream fileInputStream = this.file != null ? new FileInputStream(this.file) : new FileInputStream(this.fileName);
            try {
                FileUtil.copy(fileInputStream, true, new GZIPOutputStream(byteArrayOutputStream), true);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            return byteArrayOutputStream.toByteArray();
        }
        return null;
    }

    public void setGZIPContent(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.file = null;
            this.gZIPContent = null;
        } else {
            this.file = null;
            this.gZIPContent = new ByteArrayOutputStream(byArray.length);
            this.gZIPContent.write(byArray);
            this.gZIPContent.close();
        }
    }

    public OutputStream getOutputStream() throws IOException {
        this.file = null;
        this.gZIPContent = new ByteArrayOutputStream();
        return new GZIPOutputStream(this.gZIPContent);
    }

    public void setContent(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.gZIPContent = null;
            this.file = null;
        } else {
            OutputStream outputStream = this.getOutputStream();
            outputStream.write(byArray);
            outputStream.close();
        }
    }

    public void setContent(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            this.gZIPContent = null;
            this.file = null;
        } else {
            FileUtil.copy(inputStream, true, this.getOutputStream(), true);
        }
    }

    public void setContent(File file) throws IOException {
        this.gZIPContent = null;
        if (file != null && this.fileName == null) {
            this.fileName = file.getName();
        }
        this.file = file;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        byte[] byArray = this.getGZIPContent();
        if (byArray == null) {
            objectOutputStream.writeInt(-1);
        } else {
            objectOutputStream.writeInt(byArray.length);
            objectOutputStream.write(byArray);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.file = null;
        int n = objectInputStream.readInt();
        if (n < 0) {
            this.gZIPContent = null;
        } else {
            byte[] byArray = new byte[n];
            objectInputStream.readFully(byArray);
            this.setGZIPContent(byArray);
        }
    }
}

