/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.genui;

import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.StringUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.rad.genui.UIColor;
import javax.rad.genui.UICursor;
import javax.rad.genui.UIDimension;
import javax.rad.genui.UIFactoryManager;
import javax.rad.genui.UIFont;
import javax.rad.genui.UIResource;
import javax.rad.model.ui.ITranslatable;
import javax.rad.ui.IColor;
import javax.rad.ui.IComponent;
import javax.rad.ui.IContainer;
import javax.rad.ui.ICursor;
import javax.rad.ui.IDimension;
import javax.rad.ui.IFactory;
import javax.rad.ui.IFont;
import javax.rad.ui.IImage;
import javax.rad.ui.IInsets;
import javax.rad.ui.IPoint;
import javax.rad.ui.IRectangle;
import javax.rad.ui.Style;
import javax.rad.ui.control.ICellFormatter;
import javax.rad.ui.control.INodeFormatter;
import javax.rad.ui.event.ComponentHandler;
import javax.rad.ui.event.FocusHandler;
import javax.rad.ui.event.Key;
import javax.rad.ui.event.KeyHandler;
import javax.rad.ui.event.MouseHandler;
import javax.rad.ui.event.UIKeyEvent;
import javax.rad.ui.event.UIMouseEvent;
import javax.rad.ui.menu.IPopupMenu;
import javax.rad.util.EventHandler;
import javax.rad.util.TranslationMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIComponent<C extends IComponent>
extends UIResource<C>
implements IComponent,
ITranslatable {
    private static EventHandler<Runnable> runnableEventHandler = new EventHandler<Runnable>(Runnable.class, new Class[0]);
    private static EventHandler<ICellFormatter> cellFormatterProvider = new EventHandler<ICellFormatter>(ICellFormatter.class, new Class[0]);
    private static EventHandler<INodeFormatter> nodeFormatterProvider = new EventHandler<INodeFormatter>(INodeFormatter.class, new Class[0]);
    private ILogger logger = null;
    protected IContainer parent = null;
    protected IPopupMenu popupMenu = null;
    private IComponent parentExpected = null;
    private TranslationMap tmpUserdefined = null;
    private TranslationMap tmpCurrent = null;
    private Map<Key, KeyHandler> mpEventKeys;
    private String sToolTip = null;
    protected long lLastTranslationModified = -1L;
    private boolean bBeforeNotified = false;
    private boolean bNotified = false;
    protected boolean bTranslate = true;
    private String sDefaultName = null;
    private String sRootName = null;
    private Set<String> stExistingNames = null;

    protected UIComponent(C c) {
        super(c);
        c.setEventSource(this);
    }

    @Override
    public String getName() {
        return ((IComponent)this.uiResource).getName();
    }

    @Override
    public void setName(String string) {
        ((IComponent)this.uiResource).setName(string);
    }

    @Override
    public IFactory getFactory() {
        return ((IComponent)this.uiResource).getFactory();
    }

    @Override
    public IDimension getPreferredSize() {
        return this.getComponentUIResource().getPreferredSize();
    }

    @Override
    public void setPreferredSize(IDimension iDimension) {
        if (iDimension instanceof UIDimension) {
            this.getComponentUIResource().setPreferredSize((IDimension)((UIDimension)iDimension).uiResource);
        } else {
            this.getComponentUIResource().setPreferredSize(iDimension);
        }
    }

    @Override
    public boolean isPreferredSizeSet() {
        return this.getComponentUIResource().isPreferredSizeSet();
    }

    @Override
    public IDimension getMinimumSize() {
        return this.getComponentUIResource().getMinimumSize();
    }

    @Override
    public void setMinimumSize(IDimension iDimension) {
        if (iDimension instanceof UIDimension) {
            this.getComponentUIResource().setMinimumSize((IDimension)((UIDimension)iDimension).uiResource);
        } else {
            this.getComponentUIResource().setMinimumSize(iDimension);
        }
    }

    @Override
    public boolean isMinimumSizeSet() {
        return this.getComponentUIResource().isMinimumSizeSet();
    }

    @Override
    public IDimension getMaximumSize() {
        return this.getComponentUIResource().getMaximumSize();
    }

    @Override
    public void setMaximumSize(IDimension iDimension) {
        if (iDimension instanceof UIDimension) {
            this.getComponentUIResource().setMaximumSize((IDimension)((UIDimension)iDimension).uiResource);
        } else {
            this.getComponentUIResource().setMaximumSize(iDimension);
        }
    }

    @Override
    public boolean isMaximumSizeSet() {
        return this.getComponentUIResource().isMaximumSizeSet();
    }

    @Override
    public IColor getBackground() {
        return ((IComponent)this.uiResource).getBackground();
    }

    @Override
    public void setBackground(IColor iColor) {
        if (iColor instanceof UIColor) {
            ((IComponent)this.uiResource).setBackground((IColor)((UIColor)iColor).getUIResource());
        } else {
            ((IComponent)this.uiResource).setBackground(iColor);
        }
    }

    @Override
    public boolean isBackgroundSet() {
        return ((IComponent)this.uiResource).isBackgroundSet();
    }

    @Override
    public IColor getForeground() {
        return ((IComponent)this.uiResource).getForeground();
    }

    @Override
    public void setForeground(IColor iColor) {
        if (iColor instanceof UIColor) {
            ((IComponent)this.uiResource).setForeground((IColor)((UIColor)iColor).getUIResource());
        } else {
            ((IComponent)this.uiResource).setForeground(iColor);
        }
    }

    @Override
    public boolean isForegroundSet() {
        return ((IComponent)this.uiResource).isForegroundSet();
    }

    @Override
    public ICursor getCursor() {
        return ((IComponent)this.uiResource).getCursor();
    }

    @Override
    public void setCursor(ICursor iCursor) {
        if (iCursor instanceof UICursor) {
            ((IComponent)this.uiResource).setCursor((ICursor)((UICursor)iCursor).uiResource);
        } else {
            ((IComponent)this.uiResource).setCursor(iCursor);
        }
    }

    @Override
    public boolean isCursorSet() {
        return ((IComponent)this.uiResource).isCursorSet();
    }

    @Override
    public IFont getFont() {
        return ((IComponent)this.uiResource).getFont();
    }

    @Override
    public void setFont(IFont iFont) {
        if (iFont instanceof UIFont) {
            ((IComponent)this.uiResource).setFont((IFont)((UIFont)iFont).getUIResource());
        } else {
            ((IComponent)this.uiResource).setFont(iFont);
        }
    }

    @Override
    public boolean isFontSet() {
        return ((IComponent)this.uiResource).isFontSet();
    }

    @Override
    public String getToolTipText() {
        return this.sToolTip;
    }

    @Override
    public void setToolTipText(String string) {
        this.sToolTip = string;
        ((IComponent)this.uiResource).setToolTipText(this.translate(string));
    }

    @Override
    public void setFocusable(boolean bl) {
        ((IComponent)this.uiResource).setFocusable(bl);
    }

    @Override
    public boolean isFocusable() {
        return ((IComponent)this.uiResource).isFocusable();
    }

    @Override
    public Integer getTabIndex() {
        return ((IComponent)this.uiResource).getTabIndex();
    }

    @Override
    public void setTabIndex(Integer n) {
        ((IComponent)this.uiResource).setTabIndex(n);
    }

    @Override
    public void requestFocus() {
        ((IComponent)this.uiResource).requestFocus();
    }

    @Override
    public IContainer getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IContainer iContainer) {
        if (iContainer == null) {
            if (this.parent != null && this.parent.indexOf(this) >= 0) {
                throw new IllegalArgumentException("Can't unset parent, because this component is still added!");
            }
        } else if (iContainer.indexOf(this) < 0) {
            throw new IllegalArgumentException("Can't set parent, because this component is not added!");
        }
        boolean bl = this.parent != null && this.parent != iContainer;
        this.parent = iContainer;
        if (bl && this.isNotified()) {
            this.updateTranslation();
        }
    }

    @Override
    public boolean isVisible() {
        return this.getComponentUIResource().isVisible();
    }

    @Override
    public void setVisible(boolean bl) {
        this.getComponentUIResource().setVisible(bl);
    }

    @Override
    public void setEnabled(boolean bl) {
        ((IComponent)this.uiResource).setEnabled(bl);
    }

    @Override
    public boolean isEnabled() {
        return ((IComponent)this.uiResource).isEnabled();
    }

    @Override
    public IPoint getLocationRelativeTo(IComponent iComponent) {
        return ((IComponent)this.uiResource).getLocationRelativeTo(iComponent);
    }

    @Override
    public void setLocationRelativeTo(IComponent iComponent, IPoint iPoint) {
        ((IComponent)this.uiResource).setLocationRelativeTo(iComponent, iPoint);
    }

    @Override
    public IPoint getLocation() {
        IPoint iPoint = this.getComponentUIResource().getLocation();
        IInsets iInsets = this.getComponentUIResourceInsets();
        if (iInsets != null) {
            iPoint.setX(iPoint.getX() + iInsets.getLeft());
            iPoint.setY(iPoint.getY() + iInsets.getTop());
        }
        return iPoint;
    }

    @Override
    public void setLocation(IPoint iPoint) {
        this.setLocation(iPoint.getX(), iPoint.getY());
    }

    @Override
    public IDimension getSize() {
        IDimension iDimension = this.getComponentUIResource().getSize();
        IInsets iInsets = this.getComponentUIResourceInsets();
        if (iInsets != null) {
            iDimension.setWidth(iDimension.getWidth() - iInsets.getLeft() - iInsets.getRight());
            iDimension.setHeight(iDimension.getHeight() - iInsets.getTop() - iInsets.getBottom());
        }
        return this.getComponentUIResource().getSize();
    }

    @Override
    public void setSize(IDimension iDimension) {
        if (iDimension != null) {
            this.setSize(iDimension.getWidth(), iDimension.getHeight());
        } else {
            this.getComponentUIResource().setSize(null);
        }
    }

    @Override
    public IRectangle getBounds() {
        IRectangle iRectangle = this.getComponentUIResource().getBounds();
        IInsets iInsets = this.getComponentUIResourceInsets();
        if (iInsets != null) {
            int n = iInsets.getLeft();
            int n2 = iInsets.getTop();
            iRectangle.setX(iRectangle.getX() + n);
            iRectangle.setY(iRectangle.getY() + n2);
            iRectangle.setWidth(iRectangle.getWidth() - n - iInsets.getRight());
            iRectangle.setHeight(iRectangle.getHeight() - n2 - iInsets.getBottom());
        }
        return iRectangle;
    }

    @Override
    public void setBounds(IRectangle iRectangle) {
        this.setBounds(iRectangle.getX(), iRectangle.getY(), iRectangle.getWidth(), iRectangle.getHeight());
    }

    @Override
    public Object getResource() {
        return this.getComponentUIResource().getResource();
    }

    @Override
    public IComponent getEventSource() {
        return ((IComponent)this.uiResource).getEventSource();
    }

    @Override
    public void setStyle(Style style) {
        ((IComponent)this.uiResource).setStyle(style);
    }

    @Override
    public Style getStyle() {
        return ((IComponent)this.uiResource).getStyle();
    }

    @Override
    public void setEventSource(IComponent iComponent) {
        ((IComponent)this.uiResource).setEventSource(iComponent);
    }

    @Override
    public MouseHandler eventMousePressed() {
        return ((IComponent)this.uiResource).eventMousePressed();
    }

    @Override
    public MouseHandler eventMouseReleased() {
        return ((IComponent)this.uiResource).eventMouseReleased();
    }

    @Override
    public MouseHandler eventMouseClicked() {
        return ((IComponent)this.uiResource).eventMouseClicked();
    }

    @Override
    public MouseHandler eventMouseEntered() {
        return ((IComponent)this.uiResource).eventMouseEntered();
    }

    @Override
    public MouseHandler eventMouseExited() {
        return ((IComponent)this.uiResource).eventMouseExited();
    }

    @Override
    public KeyHandler eventKeyPressed() {
        return ((IComponent)this.uiResource).eventKeyPressed();
    }

    @Override
    public KeyHandler eventKeyReleased() {
        return ((IComponent)this.uiResource).eventKeyReleased();
    }

    @Override
    public KeyHandler eventKeyTyped() {
        return ((IComponent)this.uiResource).eventKeyTyped();
    }

    @Override
    public ComponentHandler eventComponentResized() {
        return ((IComponent)this.uiResource).eventComponentResized();
    }

    @Override
    public ComponentHandler eventComponentMoved() {
        return ((IComponent)this.uiResource).eventComponentMoved();
    }

    @Override
    public FocusHandler eventFocusGained() {
        return ((IComponent)this.uiResource).eventFocusGained();
    }

    @Override
    public FocusHandler eventFocusLost() {
        return ((IComponent)this.uiResource).eventFocusLost();
    }

    @Override
    public IImage capture(int n, int n2) {
        return this.getComponentUIResource().capture(n, n2);
    }

    @Override
    public void setTranslation(TranslationMap translationMap) {
        if (this.tmpCurrent != translationMap) {
            this.lLastTranslationModified = -1L;
        }
        this.tmpUserdefined = translationMap;
        this.tmpCurrent = translationMap;
        if (this.isNotified()) {
            this.updateTranslation();
        }
    }

    @Override
    public TranslationMap getTranslation() {
        return this.tmpUserdefined;
    }

    @Override
    public void setTranslationEnabled(boolean bl) {
        this.bTranslate = bl;
    }

    @Override
    public boolean isTranslationEnabled() {
        return this.bTranslate;
    }

    protected static String incrementNameIfExists(String string, Set<String> set, boolean bl) {
        if (string == null || set == null) {
            if (string != null && bl) {
                return string + "1";
            }
            return string;
        }
        String string2 = string;
        int n = 1;
        if (bl) {
            string2 = string2 + Integer.toString(n);
        }
        while (set.contains(string2)) {
            string2 = string + Integer.toString(++n);
        }
        return string2;
    }

    public IPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void setPopupMenu(IPopupMenu iPopupMenu) {
        if (this.popupMenu != null) {
            this.eventMousePressed().removeListener(this, "doTriggerPopMenu");
            this.eventMouseReleased().removeListener(this, "doTriggerPopMenu");
        }
        this.popupMenu = iPopupMenu;
        if (this.popupMenu != null) {
            this.eventMousePressed().addListener(this, "doTriggerPopMenu");
            this.eventMouseReleased().addListener(this, "doTriggerPopMenu");
        }
    }

    public String getDefaultName() {
        return this.sDefaultName;
    }

    public final String getRootName() {
        return this.sRootName;
    }

    public void doTriggerPopMenu(UIMouseEvent uIMouseEvent) {
        if (uIMouseEvent.isPopupTrigger() && this.popupMenu != null) {
            this.popupMenu.show(this, uIMouseEvent.getX(), uIMouseEvent.getY());
        }
    }

    public void setPreferredSize(int n, int n2) {
        this.getComponentUIResource().setPreferredSize(this.getFactory().createDimension(n, n2));
    }

    public void setMinimumSize(int n, int n2) {
        this.getComponentUIResource().setMinimumSize(this.getFactory().createDimension(n, n2));
    }

    public void setMaximumSize(int n, int n2) {
        this.getComponentUIResource().setMaximumSize(this.getFactory().createDimension(n, n2));
    }

    public void setLocation(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        IInsets iInsets = this.getComponentUIResourceInsets();
        if (iInsets != null) {
            n3 = iInsets.getLeft();
            n4 = iInsets.getTop();
        }
        this.getComponentUIResource().setLocation(this.getFactory().createPoint(n - n3, n2 - n4));
    }

    public void setSize(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        IInsets iInsets = this.getComponentUIResourceInsets();
        if (iInsets != null) {
            n3 = iInsets.getLeft();
            n4 = iInsets.getTop();
            n5 = iInsets.getRight();
            n6 = iInsets.getBottom();
        }
        this.getComponentUIResource().setSize(this.getFactory().createDimension(n + n3 + n5, n2 + n4 + n6));
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        IInsets iInsets = this.getComponentUIResourceInsets();
        if (iInsets != null) {
            n5 = iInsets.getLeft();
            n6 = iInsets.getTop();
            n7 = iInsets.getRight();
            n8 = iInsets.getBottom();
        }
        this.getComponentUIResource().setBounds(this.getFactory().createRectangle(n - n5, n2 - n6, n3 + n5 + n7, n4 + n6 + n8));
    }

    public static ICellFormatter createCellFormatter(Object object, String string) {
        return cellFormatterProvider.createListener(object, string);
    }

    public static INodeFormatter createNodeFormatter(Object object, String string) {
        return nodeFormatterProvider.createListener(object, string);
    }

    protected IComponent getComponentUIResource() {
        return (IComponent)this.getUIResource();
    }

    protected IInsets getComponentUIResourceInsets() {
        return null;
    }

    public void debug(Object ... objectArray) {
        if (this.logger == null) {
            this.logger = LoggerFactory.getInstance(this.getClass());
        }
        this.logger.debug(objectArray);
    }

    public void info(Object ... objectArray) {
        if (this.logger == null) {
            this.logger = LoggerFactory.getInstance(this.getClass());
        }
        this.logger.info(objectArray);
    }

    public void error(Object ... objectArray) {
        if (this.logger == null) {
            this.logger = LoggerFactory.getInstance(this.getClass());
        }
        this.logger.error(objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeAddNotify(IComponent iComponent) {
        this.parentExpected = iComponent;
        this.bBeforeNotified = true;
        try {
            this.updateTranslation();
        }
        finally {
            this.parentExpected = null;
        }
    }

    public boolean isBeforeNotified() {
        return this.bBeforeNotified;
    }

    public void addNotify() {
        this.bNotified = true;
        if (!this.bBeforeNotified) {
            this.updateTranslation();
        }
        this.nameComponent();
    }

    public boolean isNotified() {
        return this.bNotified;
    }

    public void removeNotify() {
        this.bBeforeNotified = false;
        this.bNotified = false;
        if (this.sDefaultName.equals(this.getName())) {
            this.setName(null);
        }
        this.stExistingNames.remove(this.sDefaultName);
        this.sDefaultName = null;
        this.sRootName = null;
        this.stExistingNames = null;
    }

    protected TranslationMap getCurrentTranslation() {
        return this.tmpCurrent;
    }

    public String translate(String string) {
        if (this.bTranslate && this.tmpCurrent != null) {
            return this.tmpCurrent.translate(string);
        }
        return string;
    }

    public void updateTranslation() {
        IComponent iComponent = this.parent == null ? this.parentExpected : this.parent;
        if (iComponent != null && this.tmpUserdefined == null) {
            if (this.tmpCurrent != ((UIComponent)iComponent).tmpCurrent) {
                this.lLastTranslationModified = -1L;
            }
            this.tmpCurrent = ((UIComponent)iComponent).tmpCurrent;
        }
        if (this.isTranslationChanged()) {
            if (this.bTranslate && this.sToolTip != null) {
                ((IComponent)this.uiResource).setToolTipText(this.translate(this.sToolTip));
            }
            if (this.tmpCurrent != null) {
                this.lLastTranslationModified = this.tmpCurrent.lastModified();
            }
        }
    }

    public void doEventKey(UIKeyEvent uIKeyEvent) {
        Key key = Key.getKey(uIKeyEvent);
        if (this.mpEventKeys.containsKey(key)) {
            this.mpEventKeys.get(key).dispatchEvent(uIKeyEvent);
        }
    }

    public KeyHandler eventKey(Key key) {
        if (this.mpEventKeys == null) {
            this.mpEventKeys = new HashMap<Key, KeyHandler>();
            this.eventKeyPressed().addListener(this, "doEventKey");
            this.eventKeyReleased().addListener(this, "doEventKey");
            this.eventKeyTyped().addListener(this, "doEventKey");
        }
        if (!this.mpEventKeys.containsKey(key)) {
            String string = null;
            switch (key.getKeyEventType()) {
                case 401: {
                    string = "keyPressed";
                    break;
                }
                case 402: {
                    string = "keyReleased";
                    break;
                }
                case 400: {
                    string = "keyTyped";
                    break;
                }
            }
            KeyHandler keyHandler = new KeyHandler(string);
            this.mpEventKeys.put(key, keyHandler);
            return keyHandler;
        }
        return this.mpEventKeys.get(key);
    }

    protected boolean isTranslationChanged() {
        IComponent iComponent = this.parent == null ? this.parentExpected : this.parent;
        return this.lLastTranslationModified == -1L || iComponent != null && this.tmpCurrent != ((UIComponent)iComponent).tmpCurrent || this.tmpCurrent != null && this.tmpCurrent.lastModified() != this.lLastTranslationModified;
    }

    public static void invokeLater(Runnable runnable) {
        UIFactoryManager.getFactory().invokeLater(runnable);
    }

    public static void invokeLater(Object object, String string) {
        UIFactoryManager.getFactory().invokeLater(runnableEventHandler.createListener(object, string));
    }

    public static void invokeAndWait(Runnable runnable) throws Exception {
        UIFactoryManager.getFactory().invokeAndWait(runnable);
    }

    public static void invokeAndWait(Object object, String string) throws Exception {
        UIFactoryManager.getFactory().invokeAndWait(runnableEventHandler.createListener(object, string));
    }

    public static void invokeInThread(Runnable runnable) {
        UIFactoryManager.getFactory().invokeInThread(runnable);
    }

    public static void invokeInThread(Object object, String string) {
        UIFactoryManager.getFactory().invokeInThread(runnableEventHandler.createListener(object, string));
    }

    protected String createComponentName() {
        String string = this.getClass().getSimpleName();
        if (string.startsWith("UI")) {
            string = string.substring(2);
        }
        string = StringUtil.getText(string, StringUtil.TextType.UpperCase);
        if (this.getParent() != null) {
            string = this.getParent().getName() + "_" + string;
        }
        return UIComponent.incrementNameIfExists(string, this.stExistingNames, true);
    }

    protected String createComponentNamePrefix() {
        String string = this.getClass().getSimpleName();
        if (string.startsWith("UI")) {
            string = string.substring(2);
        }
        string = StringUtil.getText(string, StringUtil.TextType.UpperCase);
        if (!StringUtil.isEmpty(this.sRootName)) {
            string = this.sRootName + "_" + string;
        }
        return string;
    }

    protected final Set<String> getExistingNames() {
        return this.stExistingNames;
    }

    protected void setDefaultName(String string) {
        this.sDefaultName = string;
    }

    protected void setRootName(String string) {
        this.sRootName = string;
        this.stExistingNames = new HashSet<String>();
    }

    private void nameComponent() {
        if (this.parent instanceof UIComponent && this.sRootName == null) {
            this.stExistingNames = ((UIComponent)((Object)this.parent)).stExistingNames;
            this.sRootName = ((UIComponent)((Object)this.parent)).sRootName;
        }
        if (this.sDefaultName == null) {
            this.sDefaultName = this.createComponentName();
        }
        if (this.sDefaultName != null) {
            this.sDefaultName = this.sDefaultName.intern();
        }
        if (this.sRootName == null) {
            this.setRootName(this.sDefaultName);
        }
        if (((IComponent)this.uiResource).getName() == null) {
            ((IComponent)this.uiResource).setName(this.sDefaultName);
        }
        if (!StringUtil.isEmpty(((IComponent)this.uiResource).getName())) {
            this.stExistingNames.add(((IComponent)this.uiResource).getName());
        }
    }
}

