/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.application.genui;

import com.sibvisions.util.KeyValueList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.rad.application.genui.Content;
import javax.rad.model.IDataBook;
import javax.rad.model.ModelException;
import javax.rad.model.ui.IControl;
import javax.rad.model.ui.IControllable;
import javax.rad.model.ui.IController;
import javax.rad.ui.IContainer;
import javax.rad.ui.component.IActionComponent;
import javax.rad.ui.container.IInternalFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerContent
extends Content
implements IController,
IControllable,
IControl {
    private IController controller = null;
    private IControllable activeControllable = null;
    private IControllable activeControl = null;
    private IDataBook activeDataBook = null;
    private IInternalFrame internalFrame = null;
    private HashMap<String, Object> hmpProperties;
    private KeyValueList<String, IActionComponent> commandButtons = new KeyValueList();
    private boolean bFirstNotifyRepaintCall = true;

    @Override
    public IControllable getActiveControllable() {
        return this.activeControllable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setActiveControllable(IControllable iControllable) {
        boolean bl;
        boolean bl2 = iControllable != this.activeControllable;
        IControllable iControllable2 = this.activeControllable = iControllable;
        while (iControllable2 instanceof IController) {
            iControllable2 = ((IController)((Object)iControllable2)).getActiveControllable();
        }
        IDataBook iDataBook = iControllable2 == null ? null : iControllable2.getActiveDataBook();
        boolean bl3 = iControllable2 != this.activeControl;
        boolean bl4 = bl = iDataBook != this.activeDataBook;
        if (this.activeDataBook != null) {
            this.activeDataBook.removeControl(this);
        }
        this.activeControl = iControllable2;
        this.activeDataBook = iDataBook;
        this.doNotifyController();
        try {
            if (bl2) {
                this.doActiveControllableChanged();
            }
            if (bl3) {
                this.doActiveControlChanged();
            }
            if (bl) {
                this.doActiveDataBookChanged();
            }
            if (bl2 || bl3 || bl) {
                this.doConfigureCommandButtons();
            }
        }
        catch (Throwable throwable) {
            this.error(throwable);
        }
        finally {
            this.bFirstNotifyRepaintCall = true;
        }
        if (this.activeDataBook != null) {
            this.activeDataBook.addControl(this);
        }
    }

    @Override
    public void setControllerProperty(String string, Object object) {
        if (object != null) {
            if (this.hmpProperties == null) {
                this.hmpProperties = new HashMap();
            }
            this.hmpProperties.put(string, object);
        } else if (this.hmpProperties != null) {
            this.hmpProperties.remove(string);
        }
    }

    @Override
    public Object getControllerProperty(String string) {
        if (this.hmpProperties != null && this.hmpProperties.containsKey(string)) {
            return this.hmpProperties.get(string);
        }
        IController iController = this.getController();
        if (iController != null) {
            return iController.getControllerProperty(string);
        }
        return null;
    }

    @Override
    public IController getController() {
        return this.controller;
    }

    @Override
    public void setController(IController iController) {
        this.controller = iController;
    }

    @Override
    public IDataBook getActiveDataBook() {
        return this.activeDataBook;
    }

    @Override
    public boolean isCommandEnabled(String string) {
        if (string == "COMMAND_FIRST") {
            return this.isFirstEnabled();
        }
        if (string == "COMMAND_LAST") {
            return this.isLastEnabled();
        }
        if (string == "COMMAND_NEXT") {
            return this.isNextEnabled();
        }
        if (string == "COMMAND_PREVIOUS") {
            return this.isPreviousEnabled();
        }
        if (string == "COMMAND_EDIT") {
            return this.isEditEnabled();
        }
        if (string == "COMMAND_INSERT") {
            return this.isInsertEnabled();
        }
        if (string == "COMMAND_INSERT_SUB") {
            return this.isInsertSubEnabled();
        }
        if (string == "COMMAND_RESTORE") {
            return this.isRestoreEnabled();
        }
        if (string == "COMMAND_DELETE") {
            return this.isDeleteEnabled();
        }
        if (string == "COMMAND_DUPLICATE") {
            return this.isDuplicateEnabled();
        }
        if (string == "COMMAND_EXPORT") {
            return this.isExportEnabled();
        }
        if (this.activeControllable == null) {
            return false;
        }
        return this.activeControllable.isCommandEnabled(string);
    }

    @Override
    public void doCommand(String string) throws Throwable {
        if (string == "COMMAND_FIRST") {
            this.doFirst();
        } else if (string == "COMMAND_LAST") {
            this.doLast();
        } else if (string == "COMMAND_NEXT") {
            this.doNext();
        } else if (string == "COMMAND_PREVIOUS") {
            this.doPrevious();
        } else if (string == "COMMAND_EDIT") {
            this.doEdit();
        } else if (string == "COMMAND_INSERT") {
            this.doInsert();
        } else if (string == "COMMAND_INSERT_SUB") {
            this.doInsertSub();
        } else if (string == "COMMAND_RESTORE") {
            this.doRestore();
        } else if (string == "COMMAND_DELETE") {
            this.doDelete();
        } else if (string == "COMMAND_DUPLICATE") {
            this.doDuplicate();
        } else if (string == "COMMAND_EXPORT") {
            this.doExport();
        } else if (this.activeControllable != null) {
            this.activeControllable.doCommand(string);
        }
    }

    @Override
    public void cancelEditing() {
    }

    @Override
    public void notifyRepaint() {
        if (this.bFirstNotifyRepaintCall) {
            this.bFirstNotifyRepaintCall = false;
            ControllerContent.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        ControllerContent.this.doConfigureCommandButtons();
                    }
                    catch (Throwable throwable) {
                        ControllerContent.this.error(throwable);
                    }
                    finally {
                        ControllerContent.this.bFirstNotifyRepaintCall = true;
                    }
                }
            });
        }
    }

    @Override
    public void saveEditing() throws ModelException {
    }

    @Override
    public void addNotify() {
        this.searchAndSetController();
        super.addNotify();
        try {
            this.doConfigureCommandButtons();
        }
        catch (Throwable throwable) {
            this.error(throwable);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.internalFrame != null) {
            this.internalFrame.eventWindowActivated().removeListener(this);
            this.internalFrame = null;
        }
        if (this.getController() != null && this.getController().getActiveControllable() == this) {
            this.getController().setActiveControllable(null);
        }
        this.setController(null);
    }

    private void searchAndSetController() {
        IContainer iContainer;
        for (iContainer = this.getParent(); iContainer != null && !(iContainer instanceof IController); iContainer = iContainer.getParent()) {
            if (!(iContainer instanceof IInternalFrame)) continue;
            this.internalFrame = (IInternalFrame)iContainer;
        }
        this.setController((IController)((Object)iContainer));
        if (this.internalFrame != null) {
            this.internalFrame.eventWindowActivated().addListener(this, "doNotifyController");
        }
    }

    public void registerCommandButton(String string, IActionComponent iActionComponent) {
        this.commandButtons.put(string, iActionComponent);
    }

    public void unregisterCommandButton(String string, IActionComponent iActionComponent) {
        this.commandButtons.remove(string, iActionComponent);
    }

    public void unregisterCommandButton(String string) {
        this.commandButtons.remove(string);
    }

    public void unregisterAllCommandButtons() {
        this.commandButtons.clear();
    }

    public String[] getRegisteredCommands() {
        return this.commandButtons.keySet().toArray(new String[this.commandButtons.size()]);
    }

    public List<IActionComponent> getCommandButtons(String string) {
        return this.commandButtons.get(string);
    }

    public IControllable getActiveControl() {
        return this.activeControl;
    }

    public void doNotifyController() {
        if (this.controller != null && (this.internalFrame == null || !this.internalFrame.isModal() && this.internalFrame.isActive())) {
            this.controller.setActiveControllable(this);
        }
    }

    public void doActiveControllableChanged() throws Throwable {
    }

    public void doActiveControlChanged() throws Throwable {
    }

    public void doActiveDataBookChanged() throws Throwable {
    }

    public void doConfigureCommandButtons() throws Throwable {
        for (Map.Entry<String, List<IActionComponent>> entry : this.commandButtons.entrySet()) {
            for (IActionComponent iActionComponent : entry.getValue()) {
                iActionComponent.setEnabled(this.isCommandEnabled(entry.getKey()));
            }
        }
    }

    public boolean isFirstEnabled() {
        if (this.activeControllable == null) {
            return false;
        }
        return this.activeControllable.isCommandEnabled("COMMAND_FIRST");
    }

    public void doFirst() throws Throwable {
        if (this.activeControllable != null) {
            this.activeControllable.doCommand("COMMAND_FIRST");
        }
    }

    public boolean isLastEnabled() {
        if (this.activeControllable == null) {
            return false;
        }
        return this.activeControllable.isCommandEnabled("COMMAND_LAST");
    }

    public void doLast() throws Throwable {
        if (this.activeControllable != null) {
            this.activeControllable.doCommand("COMMAND_LAST");
        }
    }

    public boolean isPreviousEnabled() {
        if (this.activeControllable == null) {
            return false;
        }
        return this.activeControllable.isCommandEnabled("COMMAND_PREVIOUS");
    }

    public void doPrevious() throws Throwable {
        if (this.activeControllable != null) {
            this.activeControllable.doCommand("COMMAND_PREVIOUS");
        }
    }

    public boolean isNextEnabled() {
        if (this.activeControllable == null) {
            return false;
        }
        return this.activeControllable.isCommandEnabled("COMMAND_NEXT");
    }

    public void doNext() throws Throwable {
        if (this.activeControllable != null) {
            this.activeControllable.doCommand("COMMAND_NEXT");
        }
    }

    public boolean isInsertEnabled() {
        if (this.activeControllable == null) {
            return false;
        }
        return this.activeControllable.isCommandEnabled("COMMAND_INSERT");
    }

    public void doInsert() throws Throwable {
        if (this.activeControllable != null) {
            this.activeControllable.doCommand("COMMAND_INSERT");
        }
    }

    public boolean isInsertSubEnabled() {
        if (this.activeControllable == null) {
            return false;
        }
        return this.activeControllable.isCommandEnabled("COMMAND_INSERT_SUB");
    }

    public void doInsertSub() throws Throwable {
        if (this.activeControllable != null) {
            this.activeControllable.doCommand("COMMAND_INSERT_SUB");
        }
    }

    public boolean isDeleteEnabled() {
        if (this.activeControllable == null) {
            return false;
        }
        return this.activeControllable.isCommandEnabled("COMMAND_DELETE");
    }

    public void doDelete() throws Throwable {
        if (this.activeControllable != null) {
            this.activeControllable.doCommand("COMMAND_DELETE");
        }
    }

    public boolean isRestoreEnabled() {
        if (this.activeControllable == null) {
            return false;
        }
        return this.activeControllable.isCommandEnabled("COMMAND_RESTORE");
    }

    public void doRestore() throws Throwable {
        if (this.activeControllable != null) {
            this.activeControllable.doCommand("COMMAND_RESTORE");
        }
    }

    public boolean isDuplicateEnabled() {
        if (this.activeControllable == null) {
            return false;
        }
        return this.activeControllable.isCommandEnabled("COMMAND_DUPLICATE");
    }

    public void doDuplicate() throws Throwable {
        if (this.activeControllable != null) {
            this.activeControllable.doCommand("COMMAND_DUPLICATE");
        }
    }

    public boolean isExportEnabled() {
        if (this.activeControllable == null) {
            return false;
        }
        return this.activeControllable.isCommandEnabled("COMMAND_EXPORT");
    }

    public void doExport() throws Throwable {
        if (this.activeControllable != null) {
            this.activeControllable.doCommand("COMMAND_EXPORT");
        }
    }

    public boolean isEditEnabled() {
        if (this.activeControllable == null) {
            return false;
        }
        return this.activeControllable.isCommandEnabled("COMMAND_EDIT");
    }

    public void doEdit() throws Throwable {
        if (this.activeControllable != null) {
            this.activeControllable.doCommand("COMMAND_EDIT");
        }
    }

    public boolean isSearchEnabled() {
        if (this.activeControllable == null) {
            return false;
        }
        return this.activeControllable.isCommandEnabled("COMMAND_SEARCH");
    }

    public void doSearch() throws Throwable {
        if (this.activeControllable != null) {
            this.activeControllable.doCommand("COMMAND_SEARCH");
        }
    }
}

