/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.xml;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.Internalize;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.StringUtil;
import com.sibvisions.util.xml.XmlWorker;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlNode
implements Cloneable,
Serializable {
    public static final short TYPE_DECLARATION = -1;
    public static final short TYPE_DOCTYPE = -2;
    public static final short TYPE_COMMENT = 0;
    public static final short TYPE_TEXT = 1;
    public static final short TYPE_ATTRIBUTE = 2;
    public static final short TYPE_TEXTPART = 3;
    public static final String NAME_COMMENT = "comment";
    public static final String NAME_TEXTPART = "textpart";
    public static final String NAME_XMLDECLARATION = "xml";
    public static final String NAME_DOCTYPE = "DOCTYPE";
    private static final int MODE_GET = 0;
    private static final int MODE_GET_LIST = 1;
    private static final int MODE_SET = 2;
    private static final int MODE_DELETE = 3;
    private static final int MODE_COUNT = 4;
    private static final int MODE_INSERT = 5;
    private transient XmlNode xmnParent = null;
    private transient String sName = null;
    private transient String sValue = null;
    private transient ArrayUtil<XmlNode> auSubNodes = null;
    private transient int iLineNumber = -1;
    private transient int iColumnNumber = -1;
    private transient short shType = 1;

    public XmlNode(String string) {
        this(1, string, null, null);
    }

    public XmlNode(short s, String string) {
        this(s, string, null, null);
    }

    public XmlNode(short s, String string, String string2) {
        this(s, string, string2, null);
    }

    public XmlNode(short s, String string, XmlNode xmlNode) {
        this(s, string, null, xmlNode);
    }

    public XmlNode(short s, String string, String string2, XmlNode xmlNode) {
        this.shType = s;
        this.sName = Internalize.intern(this.prepareTagName(string));
        this.sValue = Internalize.intern(string2);
        if (xmlNode != null) {
            xmlNode.add(this);
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public Object clone() throws CloneNotSupportedException {
        XmlNode xmlNode = new XmlNode(this.getType(), this.getName(), this.getValue());
        if (this.auSubNodes != null) {
            int n = this.auSubNodes.size();
            for (int i = 0; i < n; ++i) {
                xmlNode.add((XmlNode)this.auSubNodes.get(i).clone());
            }
        }
        return xmlNode;
    }

    public void add(XmlNode xmlNode) {
        if (this.auSubNodes != null) {
            this.insert(this.auSubNodes.size(), xmlNode);
        } else {
            this.insert(0, xmlNode);
        }
    }

    public void insert(int n, XmlNode xmlNode) {
        if (this.auSubNodes == null) {
            this.auSubNodes = new ArrayUtil(1);
        }
        this.auSubNodes.add(n, xmlNode);
        if (xmlNode.xmnParent != null) {
            xmlNode.xmnParent.remove(xmlNode);
        }
        xmlNode.xmnParent = this;
    }

    public List<XmlNode> getSubNodes() {
        return this.auSubNodes;
    }

    public void setSubNodes(List<XmlNode> list) {
        this.clearSubNodes();
        if (list instanceof ArrayUtil) {
            this.auSubNodes = (ArrayUtil)list;
        } else if (list != null) {
            this.auSubNodes = new ArrayUtil();
            this.auSubNodes.addAll(list);
        }
        if (this.auSubNodes != null) {
            int n = this.auSubNodes.size();
            for (int i = 0; i < n; ++i) {
                XmlNode xmlNode = this.auSubNodes.get(i);
                if (xmlNode.xmnParent != null) {
                    xmlNode.xmnParent.remove(xmlNode);
                }
                xmlNode.xmnParent = this;
            }
        }
    }

    public boolean remove(XmlNode xmlNode) {
        if (this.auSubNodes != null) {
            boolean bl = this.auSubNodes.remove(xmlNode);
            if (bl) {
                xmlNode.xmnParent = null;
            }
            if (this.auSubNodes.isEmpty()) {
                this.auSubNodes = null;
            }
            return bl;
        }
        return false;
    }

    public void clearSubNodes() {
        if (this.auSubNodes != null) {
            int n = this.auSubNodes.size();
            for (int i = 0; i < n; ++i) {
                this.auSubNodes.get((int)i).xmnParent = null;
            }
            this.auSubNodes.clear();
            this.auSubNodes = null;
        }
    }

    public XmlNode getParent() {
        return this.xmnParent;
    }

    public short getType() {
        return this.shType;
    }

    public String getName() {
        return this.sName;
    }

    String getFullName() {
        String string = this.xmnParent != null && this.xmnParent.shType != -1 && this.xmnParent.shType != -2 ? this.xmnParent.getFullName() + "/" + this.sName : "/" + this.sName;
        return string;
    }

    public void setValue(String string) {
        this.sValue = Internalize.intern(string);
    }

    public String getValue() {
        return this.sValue;
    }

    private String getXmlValue() {
        if (this.sValue == null) {
            return null;
        }
        return XmlNode.prepareCharacters(this.sValue);
    }

    public static String getXmlValue(String string) {
        if (string == null) {
            return null;
        }
        return XmlNode.prepareCharacters(string);
    }

    public XmlNode getNode(String string) {
        return (XmlNode)this.getNode(string, 0);
    }

    public String getNodeValue(String string) {
        XmlNode xmlNode = (XmlNode)this.getNode(string, 0);
        if (xmlNode == null) {
            return null;
        }
        return xmlNode.getValue();
    }

    public List<XmlNode> getNodes(String string) {
        if (string == null) {
            return this.getSubNodes();
        }
        return (List)this.getNode(string, 1);
    }

    public int getNodeCount(String string) {
        Integer n = (Integer)this.getNode(string, 4);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public int size() {
        if (this.auSubNodes != null) {
            return this.auSubNodes.size();
        }
        return 0;
    }

    public int size(short s) {
        if (this.auSubNodes != null) {
            int n = 0;
            int n2 = this.auSubNodes.size();
            for (int i = 0; i < n2; ++i) {
                XmlNode xmlNode = this.auSubNodes.get(i);
                if (s != xmlNode.getType()) continue;
                ++n;
            }
            return n;
        }
        return 0;
    }

    public XmlNode removeNode(String string) {
        return (XmlNode)this.getNode(string, 3);
    }

    public XmlNode setNode(String string, Object object) {
        XmlNode xmlNode = (XmlNode)this.getNode(string, 2);
        if (object instanceof XmlNode) {
            XmlNode.replace(xmlNode, (XmlNode)object);
            return (XmlNode)object;
        }
        if (object != null) {
            xmlNode.setValue(object.toString());
        } else {
            xmlNode.setValue(null);
        }
        return xmlNode;
    }

    public XmlNode insertNode(String string, Object object) {
        XmlNode xmlNode = (XmlNode)this.getNode(string, 5);
        if (object instanceof XmlNode) {
            XmlNode.replace(xmlNode, (XmlNode)object);
            return (XmlNode)object;
        }
        if (object != null) {
            xmlNode.setValue(object.toString());
        } else {
            xmlNode.setValue(null);
        }
        return xmlNode;
    }

    private Object getNode(String string, int n) {
        XmlNode xmlNode = null;
        XmlNode xmlNode2 = null;
        ArrayUtil<XmlNode> arrayUtil = null;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        if (string.charAt(0) == '/') {
            string = string.substring(1);
        }
        ArrayUtil<String> arrayUtil2 = StringUtil.separateList(string, "/", true);
        int n3 = arrayUtil2.size();
        for (int i = 0; i < n3; ++i) {
            boolean bl3;
            String string2 = this.prepareTagName((String)arrayUtil2.get(i));
            boolean bl4 = i == n3 - 1;
            int n4 = string2.indexOf(40);
            int n5 = -1;
            int n6 = -1;
            int n7 = 0;
            int n8 = -1;
            if (n4 > 0) {
                n5 = string2.indexOf(41, n4 + 1);
                if (n5 <= n4) {
                    throw new IllegalArgumentException("Invalid index position: [start: " + n4 + ", end: " + n5);
                }
                try {
                    n6 = Integer.parseInt(string2.substring(n4 + 1, n5));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Invalid index: " + string2.substring(n4 + 1, n5));
                }
                string2 = string2.substring(0, n4);
            }
            boolean bl5 = bl3 = bl4 && n == 5 && n6 == -1;
            if (xmlNode == null) {
                xmlNode = this;
            }
            bl = false;
            List<XmlNode> list = xmlNode.getSubNodes();
            if (list != null) {
                if (n4 > 0) {
                    switch (n) {
                        case 0: 
                        case 1: 
                        case 4: {
                            if (n6 >= 0 && n6 <= list.size() - 1) break;
                            return null;
                        }
                        case 2: 
                        case 5: {
                            if (n6 >= 0 && n6 <= list.size()) break;
                            throw new IndexOutOfBoundsException("Invalid index: " + n6);
                        }
                        default: {
                            if (n6 >= 0 && n6 <= list.size() - 1) break;
                            throw new IndexOutOfBoundsException("Invalid index: " + n6);
                        }
                    }
                }
                bl2 = false;
                int n9 = list.size();
                for (int j = 0; j < n9 && !bl2; ++j) {
                    xmlNode2 = list.get(j);
                    if (!string2.equals(xmlNode2.getName())) continue;
                    if (n6 >= 0 || bl3) {
                        if (n7 == n6) {
                            xmlNode = xmlNode2;
                            bl = true;
                            bl2 = true;
                        }
                        ++n7;
                        n8 = j;
                    } else {
                        if (n != 4 && n != 1 || !bl4) {
                            if (n != 5 || n6 >= 0) {
                                for (int k = j + 1; k < n9; ++k) {
                                    if (!string2.equals(list.get(k).getName())) continue;
                                    throw new IllegalArgumentException("Missing index");
                                }
                            }
                            xmlNode = xmlNode2;
                        }
                        bl = true;
                        bl2 = true;
                        n8 = 0;
                    }
                    if (!bl4 || !bl || n != 4 && n != 1) continue;
                    boolean bl6 = bl2 = n6 >= 0;
                    if (n == 4) {
                        ++n2;
                        continue;
                    }
                    if (arrayUtil == null) {
                        arrayUtil = new ArrayUtil<XmlNode>();
                    }
                    arrayUtil.add(xmlNode2);
                }
            } else if (n6 > 0) {
                throw new IndexOutOfBoundsException("Invalid index: " + n6);
            }
            if (!bl) {
                if (n == 2 || n == 5) {
                    if (bl3) {
                        n6 = n7;
                    }
                    if (bl4 && n6 >= 0 && n6 > n7) {
                        throw new IndexOutOfBoundsException("The size is " + n7 + " and the index is '" + n6);
                    }
                    if (n == 5 && n8 >= 0) {
                        XmlNode xmlNode3 = new XmlNode(1, string2);
                        xmlNode.insert(n8 + 1, xmlNode3);
                        xmlNode = xmlNode3;
                        continue;
                    }
                    xmlNode = new XmlNode(1, string2, xmlNode);
                    continue;
                }
                return null;
            }
            if (!bl4) continue;
            if (n == 3) {
                xmlNode.getParent().remove(xmlNode);
                continue;
            }
            if (n != 5 || n8 < 0) continue;
            XmlNode xmlNode4 = new XmlNode(1, string2);
            xmlNode.getParent().insert(n8, xmlNode4);
            xmlNode = xmlNode4;
        }
        switch (n) {
            case 1: {
                return arrayUtil;
            }
            case 4: {
                return n2;
            }
        }
        return xmlNode;
    }

    public void createXml(OutputStream outputStream, int n, boolean bl) throws IOException {
        if (outputStream != null) {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
            if (this.getType() == -1) {
                this.createXmlStructure(outputStreamWriter, -1, n, bl);
            } else {
                this.createXmlStructure(outputStreamWriter, 0, n, bl);
            }
        }
    }

    private void createXmlStructure(Writer writer, int n, int n2, boolean bl) throws IOException {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n3 = 0;
        if (writer == null) {
            return;
        }
        int n4 = Math.max(0, n) * n2;
        for (int i = 0; i < n4; ++i) {
            stringBuilder.append(" ");
        }
        if (this.shType == 3 && stringBuilder.length() >= n2) {
            writer.append(stringBuilder.substring(n2));
        } else {
            writer.append(stringBuilder);
        }
        writer.flush();
        if (this.shType == 0) {
            string = this.sValue;
            if (string != null) {
                string = string.replace("\n", "\n" + stringBuilder);
            }
        } else {
            string = this.getXmlValue();
        }
        if (string != null) {
            boolean bl5 = bl2 = string.indexOf(10) >= 0;
        }
        if (this.shType == 0) {
            if (bl && n == 1) {
                writer.append('\n');
                writer.append(stringBuilder);
            }
            writer.append("<!--");
            if (!bl2) {
                writer.append(' ');
            } else {
                writer.append('\n');
                writer.append(stringBuilder);
            }
            writer.append(string);
            if (!bl2) {
                writer.append(' ');
            } else {
                writer.append('\n');
                writer.append(stringBuilder);
            }
            writer.append("-->");
            if (n > 0) {
                writer.append("\n");
            }
        } else {
            XmlNode xmlNode;
            int n5;
            if (this.shType == -1) {
                writer.append("<?");
            } else if (this.shType == -2) {
                writer.append("<!");
            } else if (this.shType != 3) {
                if (bl && n == 1) {
                    writer.append('\n');
                    writer.append(stringBuilder);
                }
                writer.append("<");
            }
            if (this.shType != 3) {
                writer.append(this.getName());
            }
            if (this.shType == -2) {
                String string2;
                writer.append(" ");
                writer.append(this.getNodeValue("name"));
                String string3 = this.getNodeValue("publicId");
                if (string3 != null) {
                    writer.append(" PUBLIC");
                    writer.append(" \"");
                    writer.append(string3);
                    writer.append("\"");
                }
                if ((string2 = this.getNodeValue("systemId")) != null) {
                    if (string3 == null) {
                        writer.append(" SYSTEM");
                    }
                    writer.append(" \"");
                    writer.append(string2);
                    writer.append("\"");
                }
            } else if (this.auSubNodes != null) {
                n5 = this.auSubNodes.size();
                for (n4 = 0; n4 < n5; ++n4) {
                    xmlNode = this.auSubNodes.get(n4);
                    if (xmlNode.getType() == 2) {
                        writer.append(" ");
                        writer.append(xmlNode.getName());
                        writer.append("=\"");
                        String string4 = xmlNode.getXmlValue();
                        if (string4 != null) {
                            writer.append(string4);
                        }
                        writer.append("\"");
                        continue;
                    }
                    ++n3;
                }
            }
            bl4 = this.auSubNodes != null && n3 > 0;
            boolean bl6 = bl3 = (this.sValue == null || this.sValue.length() == 0) && !bl4;
            if (this.shType == -1) {
                writer.append("?>");
            } else if (this.shType == -2) {
                writer.append(">");
            } else if (this.shType != 3) {
                if (bl3) {
                    writer.append("/>");
                } else {
                    writer.append(">");
                }
            }
            if (this.sValue != null) {
                if (bl2 || bl4) {
                    writer.append("\n");
                    writer.append(stringBuilder);
                }
                writer.append(string);
                if (bl2 && !bl4) {
                    writer.append("\n");
                    writer.append(stringBuilder);
                }
            }
            if (n3 > 0) {
                writer.append("\n");
                n5 = this.auSubNodes.size();
                for (int i = 0; i < n5; ++i) {
                    xmlNode = this.auSubNodes.get(i);
                    short s = xmlNode.getType();
                    if (s == 2) continue;
                    if (n < 0 && s != -2) {
                        writer.append("\n");
                    }
                    xmlNode.createXmlStructure(writer, n + 1, n2, bl);
                    if (n >= 0 || s != -2) continue;
                    writer.append("\n");
                }
                writer.append(stringBuilder);
            }
            if (bl && n == 0) {
                writer.append("\n");
            }
            if (this.shType != -1 && this.shType != -2 && this.shType != 3 && !bl3) {
                writer.append("</");
                writer.append(this.getName());
                writer.append(">");
            }
            if (n > 0) {
                writer.append("\n");
            }
        }
        writer.flush();
    }

    public static XmlNode createXmlDeclaration() {
        XmlNode xmlNode = new XmlNode(-1, NAME_XMLDECLARATION);
        xmlNode.add(new XmlNode(2, "version", "1.0", xmlNode));
        xmlNode.add(new XmlNode(2, "encoding", "UTF-8", xmlNode));
        return xmlNode;
    }

    public static XmlNode createDoctype(String string, String string2, String string3) {
        XmlNode xmlNode = new XmlNode(-2, NAME_DOCTYPE);
        xmlNode.add(new XmlNode(2, "name", string, xmlNode));
        xmlNode.add(new XmlNode(2, "publicId", string2, xmlNode));
        xmlNode.add(new XmlNode(2, "systemId", string3, xmlNode));
        return xmlNode;
    }

    private static String prepareCharacters(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block8;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block8;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block8;
                }
                case '\'': {
                    stringBuilder.append("&apos;");
                    continue block8;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block8;
                }
                case '\u00df': {
                    stringBuilder.append("&#223;");
                    continue block8;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private String prepareTagName(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return string;
        }
        char c = string.charAt(0);
        if (Character.isDigit(c)) {
            return "_" + string;
        }
        if (c == ':') {
            return "_" + string;
        }
        return string;
    }

    void setLineNumber(int n) {
        this.iLineNumber = n;
    }

    public int getLineNumber() {
        return this.iLineNumber;
    }

    void setColumnNumber(int n) {
        this.iColumnNumber = n;
    }

    public int getColumnNumber() {
        return this.iColumnNumber;
    }

    static void replace(XmlNode xmlNode, XmlNode xmlNode2) {
        if (xmlNode != xmlNode2 && xmlNode.xmnParent != null) {
            int n = xmlNode.xmnParent.auSubNodes.indexOf(xmlNode);
            xmlNode.xmnParent.insert(n, xmlNode2);
            xmlNode.xmnParent.remove(xmlNode);
        }
    }

    public int indexOf(String string, String string2) {
        return this.indexOf(string, string2, 0);
    }

    public int indexOf(String string, String string2, int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Invalid start position: " + n);
        }
        if (string.charAt(0) == '/') {
            string = string.substring(1);
        }
        return this.searchIndex(string, string2, n);
    }

    private int searchIndex(String string, String string2, int n) {
        String string3;
        String string4;
        int n2 = string.indexOf(47);
        if (n2 > 0) {
            string4 = string.substring(0, n2);
            string3 = string.substring(n2 + 1);
        } else {
            string4 = string;
            string3 = null;
        }
        List list = (List)this.getNode(string4, 1);
        if (list != null) {
            int n3 = list.size();
            for (int i = n; i < n3; ++i) {
                int n4;
                if (!(string3 != null ? (n4 = ((XmlNode)list.get(i)).searchIndex(string3, string2, 0)) >= 0 : CommonUtil.equals(string2, ((XmlNode)list.get(i)).getValue()))) continue;
                return i;
            }
        }
        return -1;
    }

    public String toString(boolean bl) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.createXml(byteArrayOutputStream, 2, bl);
            return new String(byteArrayOutputStream.toByteArray(), "UTF-8");
        }
        catch (IOException iOException) {
            return "Document creation failed: " + iOException.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        try {
            if (this.shType != -1 || this.shType == -2) {
                gZIPOutputStream.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n".getBytes("ISO-8859-1"));
            }
            gZIPOutputStream.write(this.toString(false).getBytes("UTF-8"));
            if (this.shType == 0 || this.shType == -2) {
                gZIPOutputStream.write("\n<empty/>".getBytes("ISO-8859-1"));
            }
            gZIPOutputStream.flush();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                gZIPOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            gZIPOutputStream.close();
        }
        catch (Exception exception) {}
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (byArray == null) {
            objectOutputStream.writeInt(-1);
        } else {
            objectOutputStream.writeInt(byArray.length);
            if (this.shType == -1) {
                objectOutputStream.writeByte(0);
            } else if (this.shType == 0) {
                objectOutputStream.writeByte(2);
            } else if (this.shType == -2) {
                objectOutputStream.writeByte(3);
            } else {
                objectOutputStream.writeByte(1);
            }
            objectOutputStream.write(byArray);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        if (n <= 0) return;
        byte by = objectInputStream.readByte();
        byte[] byArray = new byte[n];
        objectInputStream.readFully(byArray);
        XmlWorker xmlWorker = new XmlWorker();
        GZIPInputStream gZIPInputStream = null;
        try {
            try {
                gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(byArray));
                XmlNode xmlNode = xmlWorker.read(gZIPInputStream);
                if (by != 0) {
                    List<XmlNode> list = xmlNode.getSubNodes();
                    int n2 = list.size();
                    for (int i = 0; i < n2; ++i) {
                        short s = list.get(i).getType();
                        if (s == -1 || s == 2) continue;
                        xmlNode = list.get(i);
                        i = n2;
                    }
                }
                this.xmnParent = xmlNode.xmnParent;
                this.sName = xmlNode.sName;
                this.sValue = xmlNode.sValue;
                this.auSubNodes = xmlNode.auSubNodes;
                this.iLineNumber = xmlNode.iLineNumber;
                this.iColumnNumber = xmlNode.iColumnNumber;
                this.shType = xmlNode.shType;
            }
            catch (Exception exception) {
                IOException iOException = new IOException(exception.getMessage());
                iOException.setStackTrace(exception.getStackTrace());
                throw iOException;
            }
            Object var13_14 = null;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            try {
                gZIPInputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        gZIPInputStream.close();
        return;
    }
}

