/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.log.jdk;

import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.jdk.JdkLineFormatter;
import java.util.Enumeration;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class JdkLogger
implements ILogger {
    private String name;
    private Logger log;

    public JdkLogger(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setLevel(ILogger.LogLevel logLevel) {
        this.init();
        Level level = this.translate(logLevel);
        this.log.setLevel(level);
        String string = this.name + ".";
        Enumeration<String> enumeration = LogManager.getLogManager().getLoggerNames();
        while (enumeration.hasMoreElements()) {
            Logger logger;
            String string2 = enumeration.nextElement();
            if (string2.equals(this.name) || !string2.startsWith(string) || (logger = Logger.getLogger(string2)).getLevel() == null) continue;
            logger.setLevel(level);
        }
    }

    public boolean isLevelSet() {
        this.init();
        return this.log.getLevel() != null;
    }

    public ILogger.LogLevel getLevel() {
        this.init();
        Level level = this.log.getLevel();
        for (Logger logger = this.log.getParent(); level == null && logger != null; logger = logger.getParent()) {
            level = logger.getLevel();
        }
        if (level == null) {
            return ILogger.LogLevel.OFF;
        }
        if (level.equals(Level.OFF)) {
            return ILogger.LogLevel.OFF;
        }
        if (level.equals(Level.ALL)) {
            return ILogger.LogLevel.ALL;
        }
        if (level.equals(Level.FINE) || level.equals(Level.FINER) || level.equals(Level.FINEST)) {
            return ILogger.LogLevel.DEBUG;
        }
        if (level.equals(Level.INFO) || level.equals(Level.CONFIG) || level.equals(Level.WARNING)) {
            return ILogger.LogLevel.INFO;
        }
        if (level.equals(Level.SEVERE)) {
            return ILogger.LogLevel.ERROR;
        }
        return ILogger.LogLevel.OFF;
    }

    public void debug(Object ... objectArray) {
        this.logWithCaller(Level.FINE, objectArray);
    }

    public void info(Object ... objectArray) {
        this.logWithCaller(Level.INFO, objectArray);
    }

    public void error(Object ... objectArray) {
        this.logWithCaller(Level.SEVERE, objectArray);
    }

    public boolean isEnabled(ILogger.LogLevel logLevel) {
        this.init();
        return logLevel != ILogger.LogLevel.OFF && this.log.isLoggable(this.translate(logLevel));
    }

    private final void logWithCaller(Level level, Object ... objectArray) {
        this.init();
        if (this.log.isLoggable(level)) {
            String string = null;
            String string2 = null;
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                if (!this.name.equals(stackTraceElementArray[i].getClassName())) continue;
                string = stackTraceElementArray[i].getClassName();
                string2 = stackTraceElementArray[i].getMethodName() + " (Line: " + stackTraceElementArray[i].getLineNumber() + ")";
                i = stackTraceElementArray.length;
            }
            if (string == null && stackTraceElementArray.length > 2) {
                String string3 = this.getClass().getName();
                for (int i = 0; i < stackTraceElementArray.length; ++i) {
                    if (stackTraceElementArray[i].getClassName().equals(string3)) continue;
                    string = stackTraceElementArray[i].getClassName();
                    string2 = stackTraceElementArray[i].getMethodName() + " (Line: " + stackTraceElementArray[i].getLineNumber() + ")";
                    i = stackTraceElementArray.length;
                }
            }
            LogRecord logRecord = new LogRecord(level, JdkLineFormatter.concat(objectArray));
            logRecord.setSourceClassName(string);
            logRecord.setSourceMethodName(string2);
            this.publish(logRecord);
        }
    }

    protected void publish(LogRecord logRecord) {
        this.log.logrb(logRecord.getLevel(), logRecord.getSourceClassName(), logRecord.getSourceMethodName(), logRecord.getResourceBundleName(), logRecord.getMessage());
    }

    private Level translate(ILogger.LogLevel logLevel) {
        if (logLevel == null) {
            return null;
        }
        switch (logLevel) {
            case ALL: {
                return Level.ALL;
            }
            case DEBUG: {
                return Level.FINE;
            }
            case INFO: {
                return Level.INFO;
            }
            case ERROR: {
                return Level.SEVERE;
            }
        }
        return Level.OFF;
    }

    private void init() {
        if (this.log == null) {
            this.log = Logger.getLogger(this.name);
            LogManager logManager = LogManager.getLogManager();
            for (Logger logger = this.log.getParent(); logger != null; logger = logger.getParent()) {
                Handler[] handlerArray = logger.getHandlers();
                int n = handlerArray.length;
                for (int i = 0; i < n; ++i) {
                    String string;
                    String string2 = logManager.getProperty(handlerArray[i].getClass().getName() + ".formatter");
                    if (string2 != null && !handlerArray[i].getFormatter().getClass().getName().equals(string2)) {
                        try {
                            handlerArray[i].setFormatter((Formatter)Class.forName(string2).newInstance());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if ((string = logManager.getProperty(handlerArray[i].getClass().getName() + ".filter")) == null || handlerArray[i].getFilter() == null || handlerArray[i].getFilter().getClass().getName().equals(string)) continue;
                    try {
                        handlerArray[i].setFilter((Filter)Class.forName(string).newInstance());
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

