/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util;

import com.sibvisions.util.IValidatable;
import com.sibvisions.util.ThreadHandler;
import java.util.Hashtable;
import java.util.Map;
import java.util.UUID;

public class ObjectCache {
    private static final long CHECK_DELAY = 30000L;
    private static Hashtable<Object, Element> htStore = new Hashtable();
    private static Thread thCheckTimeout = null;

    protected ObjectCache() {
    }

    public static Object createKey() {
        return UUID.randomUUID().toString();
    }

    public static Object put(Object object, long l) {
        if (object == null) {
            throw new NullPointerException("Object is null!");
        }
        Object object2 = ObjectCache.createKey();
        ObjectCache.put(object2, object, l);
        return object2;
    }

    public static Object put(IValidatable iValidatable) {
        if (iValidatable == null) {
            throw new NullPointerException("Object is null!");
        }
        Object object = ObjectCache.createKey();
        ObjectCache.put(object, iValidatable);
        return object;
    }

    public static Object put(Object object, Object object2, long l) {
        if (object2 == null) {
            return htStore.remove(object);
        }
        return ObjectCache.put(object, new Element(object2, l));
    }

    public static Object put(Object object, IValidatable iValidatable) {
        if (iValidatable == null) {
            return htStore.remove(object);
        }
        return ObjectCache.put(object, new Element(iValidatable));
    }

    public static Object get(Object object) {
        if (object == null) {
            return null;
        }
        Element element = htStore.get(object);
        if (element == null) {
            return null;
        }
        if (element.isValid()) {
            return element.object;
        }
        htStore.remove(object);
        return null;
    }

    public static Object remove(Object object) {
        Element element = htStore.remove(object);
        if (element != null && element.isValid()) {
            return element;
        }
        return null;
    }

    private static Object put(Object object, Element element) {
        Element element2 = htStore.put(object, element);
        ObjectCache.startTimeoutCheck();
        if (element2 != null && element2.isValid()) {
            return element2.object;
        }
        return null;
    }

    private static void startTimeoutCheck() {
        if (ThreadHandler.isStopped(thCheckTimeout)) {
            thCheckTimeout = ThreadHandler.start(new Check());
        }
    }

    private static class Check
    implements Runnable {
        private Check() {
        }

        public void run() {
            try {
                while (!ThreadHandler.isStopped(thCheckTimeout)) {
                    Thread.sleep(30000L);
                    Hashtable hashtable = new Hashtable(htStore);
                    for (Map.Entry entry : hashtable.entrySet()) {
                        if (((Element)entry.getValue()).isValid()) continue;
                        htStore.remove(entry.getKey());
                    }
                    hashtable = null;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static final class Element {
        private long creation = System.currentTimeMillis();
        private long timeout;
        private Object object;
        private boolean isValidatable;

        private Element(Object object, long l) {
            this.object = object;
            this.timeout = l;
        }

        private Element(IValidatable iValidatable) {
            this.object = iValidatable;
            this.isValidatable = true;
        }

        public boolean isValid() {
            if (this.isValidatable) {
                return ((IValidatable)this.object).isValid();
            }
            return this.timeout <= 0L || this.creation + this.timeout >= System.currentTimeMillis();
        }
    }
}

