/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;

public class JVxGridLayout
implements LayoutManager2 {
    private final Map<Component, CellConstraints> constraintMap;
    private Insets margins = new Insets(0, 0, 0, 0);
    private int rows = 1;
    private int columns = 1;
    private int horizontalGap;
    private int verticalGap;

    public JVxGridLayout(int n, int n2) {
        if (n < 1) {
            throw new IllegalArgumentException("There must be at least 1 column.");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("There must be at least 1 row.");
        }
        this.setRows(n2);
        this.setColumns(n);
        int n3 = this.rows * this.columns / 2;
        this.constraintMap = new HashMap<Component, CellConstraints>(n3);
    }

    public void addLayoutComponent(String string, Component component) {
        throw new UnsupportedOperationException("Use #addLayoutComponent(Component, Object) instead.");
    }

    public void removeLayoutComponent(Component component) {
        this.constraintMap.remove(component);
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        int n = 0;
        int n2 = 0;
        Insets insets = container.getInsets();
        for (Map.Entry<Component, CellConstraints> entry : this.constraintMap.entrySet()) {
            Component component = entry.getKey();
            Dimension dimension2 = component.getPreferredSize();
            if (dimension2.height > n) {
                n = dimension2.height;
            }
            if (dimension2.width <= n2) continue;
            n2 = dimension2.width;
        }
        dimension.height = n * this.rows + insets.bottom + insets.top + this.margins.top + this.margins.bottom + this.verticalGap * this.rows - 1;
        dimension.width = n2 * this.columns + insets.left + insets.right + this.margins.left + this.margins.right + this.horizontalGap * this.columns - 1;
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        return new Dimension(0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            int n = (this.columns - 1) * this.horizontalGap;
            int n2 = (this.rows - 1) * this.verticalGap;
            int n3 = dimension.width - insets.left - insets.right - this.margins.right - this.margins.left - n;
            int n4 = dimension.height - insets.top - insets.bottom - this.margins.top - this.margins.bottom - n2;
            int n5 = n3 / this.columns;
            int n6 = n4 / this.rows;
            for (Map.Entry<Component, CellConstraints> entry : this.constraintMap.entrySet()) {
                Component component = entry.getKey();
                CellConstraints cellConstraints = entry.getValue();
                Rectangle rectangle = new Rectangle();
                Insets insets2 = cellConstraints.insets != null ? cellConstraints.insets : CellConstraints.EMPTY_INSETS;
                rectangle.x = cellConstraints.gridX * n3 / this.columns + insets2.left + this.margins.left + this.horizontalGap * cellConstraints.gridX;
                rectangle.y = cellConstraints.gridY * n4 / this.rows + insets2.top + this.margins.top + this.verticalGap * cellConstraints.gridY;
                rectangle.width = (cellConstraints.gridX + cellConstraints.gridWidth - 1) * n3 / this.columns - cellConstraints.gridX * n3 / this.columns + n5 - insets2.right - insets2.left + this.horizontalGap * (cellConstraints.gridWidth - 1);
                rectangle.height = (cellConstraints.gridY + cellConstraints.gridHeight - 1) * n4 / this.rows - cellConstraints.gridY * n4 / this.rows + n6 - insets2.bottom - insets2.top + this.verticalGap * (cellConstraints.gridHeight - 1);
                component.setBounds(rectangle);
            }
        }
    }

    public void addLayoutComponent(Component component, Object object) {
        JVxGridLayout.checkNotNull(object, "The constraints must not be null.");
        if (!(object instanceof CellConstraints)) {
            throw new IllegalArgumentException("Illegal constraint type " + object.getClass());
        }
        this.setConstraints(component, (CellConstraints)object);
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int n) {
        this.columns = n;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int n) {
        this.rows = n;
    }

    public CellConstraints getConstraints(Component component) {
        return this.constraintMap.get(component);
    }

    public CellConstraints getConstraints(int n, int n2) {
        return new CellConstraints(n, n2, 1, 1);
    }

    public CellConstraints getConstraints(int n, int n2, int n3, int n4) {
        return new CellConstraints(n, n2, n3, n4);
    }

    public CellConstraints getConstraints(int n, int n2, int n3, int n4, Insets insets) {
        return new CellConstraints(n, n2, n3, n4, insets);
    }

    public void setConstraints(Component component, CellConstraints cellConstraints) {
        JVxGridLayout.checkNotNull(component, "The component must not be null.");
        JVxGridLayout.checkNotNull(cellConstraints, "The constraints must not be null.");
        this.constraintMap.put(component, (CellConstraints)cellConstraints.clone());
    }

    public Insets getMargins() {
        return this.margins;
    }

    public void setMargins(Insets insets) {
        this.margins = insets == null ? new Insets(0, 0, 0, 0) : insets;
    }

    public int getHorizontalGap() {
        return this.horizontalGap;
    }

    public void setHorizontalGap(int n) {
        this.horizontalGap = n;
    }

    public int getVerticalGap() {
        return this.verticalGap;
    }

    public void setVerticalGap(int n) {
        this.verticalGap = n;
    }

    public static void checkNotNull(Object object, String string) {
        if (object == null) {
            throw new NullPointerException(string);
        }
    }

    public static class CellConstraints
    implements Cloneable {
        private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
        private int gridX;
        private int gridY;
        private int gridWidth;
        private int gridHeight;
        private Insets insets;

        public CellConstraints() {
            this(0, 0);
        }

        public CellConstraints(int n, int n2) {
            this(n, n2, 1, 1, EMPTY_INSETS);
        }

        public CellConstraints(int n, int n2, int n3, int n4) {
            this(n, n2, n3, n4, EMPTY_INSETS);
        }

        public CellConstraints(int n, int n2, int n3, int n4, Insets insets) {
            if (n < 0) {
                throw new IndexOutOfBoundsException("The grid x must be a positive number.");
            }
            if (n2 < 0) {
                throw new IndexOutOfBoundsException("The grid y must be a positive number.");
            }
            if (n3 <= 0) {
                throw new IndexOutOfBoundsException("The grid width must be a positive number.");
            }
            if (n4 <= 0) {
                throw new IndexOutOfBoundsException("The grid height must be a positive number.");
            }
            this.gridX = n;
            this.gridY = n2;
            this.gridWidth = n3;
            this.gridHeight = n4;
            this.insets = insets;
        }

        public int getGridX() {
            return this.gridX;
        }

        public int getGridY() {
            return this.gridY;
        }

        public int getGridWidth() {
            return this.gridWidth;
        }

        public int getGridHeight() {
            return this.gridHeight;
        }

        public Insets getInsets() {
            return this.insets;
        }

        public void setGridX(int n) {
            this.gridX = n;
        }

        public void setGridY(int n) {
            this.gridY = n;
        }

        public void setGridHeight(int n) {
            this.gridHeight = n;
        }

        public void setGridWidth(int n) {
            this.gridWidth = n;
        }

        public void setInsets(Insets insets) {
            this.insets = insets;
        }

        public Object clone() {
            try {
                CellConstraints cellConstraints = (CellConstraints)super.clone();
                cellConstraints.insets = (Insets)this.insets.clone();
                return cellConstraints;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }
    }
}

