/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext;

import com.sibvisions.rad.ui.awt.impl.AwtFactory;
import com.sibvisions.rad.ui.swing.ext.JVxUtil;
import com.sibvisions.rad.ui.swing.ext.event.ITabListener;
import com.sibvisions.rad.ui.swing.ext.event.TabEvent;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.ImageUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.rad.util.ExceptionHandler;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;

public class JVxTabbedPane
extends JTabbedPane {
    private static Image icoClose;
    private static Image icoCloseSelect;
    private static Image icoCloseOver;
    private static Image icoClosePress;
    private int iPressed = -1;
    private int iDragged = -1;
    private int iClose = -1;
    private volatile int iShowTab = -1;
    private ArrayUtil<TabInfo> auTabInfo = null;
    private ArrayUtil<ITabListener> auTabListener = null;
    private JViewport vpScroll = null;
    private boolean bIgnoreSelection = false;
    private boolean bDragable = false;
    private boolean bNavigationKeyEnabled = false;

    public JVxTabbedPane() {
        this.initIcons();
        this.setBackground(null);
    }

    private void initIcons() {
        if (icoClose == null) {
            icoClose = JVxUtil.getImage("/com/sibvisions/rad/ui/swing/ext/images/tabclose.png");
            icoCloseSelect = JVxUtil.getImage("/com/sibvisions/rad/ui/swing/ext/images/tabclose_select.png");
            icoCloseOver = JVxUtil.getImage("/com/sibvisions/rad/ui/swing/ext/images/tabclose_over.png");
            icoClosePress = JVxUtil.getImage("/com/sibvisions/rad/ui/swing/ext/images/tabclose_press.png");
        }
    }

    public void setUI(TabbedPaneUI tabbedPaneUI) {
        super.setUI(tabbedPaneUI);
        this.updateTabIcons();
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        int n = this.getUI().tabForCoordinate(this, mouseEvent.getX(), mouseEvent.getY());
        this.unsetCloseRollover(n);
        if (mouseEvent.getID() == 503) {
            this.updateMouseOverClose(mouseEvent, n);
        } else if (mouseEvent.getID() == 506 && this.isDragable() && this.getTabRunCount() == 1 && n >= 0 && (this.iPressed >= 0 && this.iDragged == -1 && this.isEnabledAt(this.iPressed) || this.iDragged >= 0)) {
            boolean bl = this.getTabInfo(n).isCloseRollover();
            boolean bl2 = this.iPressed >= 0 ? this.getTabInfo(this.iPressed).isClosePressed() : false;
            if (!bl && !bl2) {
                if (this.iDragged == -1) {
                    this.iDragged = n;
                    this.putClientProperty("TabbedPane.dragging", Boolean.TRUE);
                    this.repaint();
                    this.setCursor(Cursor.getPredefinedCursor(12));
                }
                if (this.iDragged >= 0 && n >= 0 && this.iDragged != n) {
                    Component component = this.getComponentAt(this.iDragged);
                    TabInfo tabInfo = this.getTabInfo(this.iDragged);
                    String string = this.getToolTipTextAt(this.iDragged);
                    this.fireMoveTab(this.iDragged, n);
                    ArrayUtil<ITabListener> arrayUtil = this.auTabListener;
                    this.auTabListener = null;
                    if (component != this.getComponentAt(n)) {
                        this.removeTabAt(this.iDragged);
                        this.insertTab(tabInfo.getTitle(), tabInfo.getIcon(), component, string, n);
                    }
                    this.setClosableAt(n, tabInfo.isClosable());
                    Icon icon = tabInfo.getDisabledIcon();
                    if (icon != null) {
                        this.setDisabledIconAt(n, icon);
                    }
                    this.iDragged = n;
                    this.setSelectedIndex(n);
                    this.auTabListener = arrayUtil;
                }
            }
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        int n = this.getUI().tabForCoordinate(this, mouseEvent.getX(), mouseEvent.getY());
        int n2 = mouseEvent.getID();
        boolean bl = false;
        if (n2 == 501) {
            if (n >= 0) {
                TabInfo tabInfo = this.getTabInfo(n);
                this.iPressed = n;
                if (tabInfo.isClosable() && tabInfo.getCloseBounds() != null) {
                    tabInfo.setClosePressed(tabInfo.isCloseRollover());
                    this.repaint(this.getUI().getTabBounds(this, n));
                    if (tabInfo.isCloseRollover()) {
                        bl = true;
                    }
                }
            }
        } else if (n2 == 502) {
            TabInfo tabInfo;
            int n3 = -1;
            if (this.iDragged >= 0) {
                this.setCursor(Cursor.getPredefinedCursor(0));
                this.putClientProperty("TabbedPane.dragging", null);
                this.iDragged = -1;
            } else if (n >= 0 && this.iPressed == n) {
                n3 = n;
            } else if (this.iPressed >= 0) {
                n3 = this.iPressed;
            }
            if (n3 >= 0 && (tabInfo = this.getTabInfo(n3)) != null && tabInfo.isClosable() && this.isEnabledAt(n3)) {
                boolean bl2 = tabInfo.getCloseBounds().intersects(this.translateX(mouseEvent.getX()), this.translateY(mouseEvent.getY()), 1.0, 1.0);
                if (bl2) {
                    try {
                        int n4 = this.getSelectedIndex();
                        this.bIgnoreSelection = true;
                        try {
                            Component component = this.getComponentAt(n3);
                            this.fireCloseTab(n3);
                            if (n3 < this.getTabCount() && component == this.getComponentAt(n3)) {
                                this.removeTabAt(n3);
                            }
                            if ((n = this.getUI().tabForCoordinate(this, mouseEvent.getX(), mouseEvent.getY())) >= 0 && (tabInfo = this.getTabInfo(n)).isClosable() && tabInfo.getCloseBounds() != null) {
                                this.paintImmediately(this.getUI().getTabBounds(this, n));
                                bl2 = tabInfo.getCloseBounds().intersects(this.translateX(mouseEvent.getX()), this.translateY(mouseEvent.getY()), 1.0, 1.0);
                                tabInfo.setCloseRollover(bl2);
                                tabInfo.updateTabIcon();
                                if (bl2) {
                                    this.iClose = n;
                                    this.repaint(this.getUI().getTabBounds(this, n));
                                }
                            }
                            this.bIgnoreSelection = false;
                        }
                        catch (Exception exception) {
                            this.bIgnoreSelection = false;
                            tabInfo.setClosePressed(false);
                            throw exception;
                        }
                        if (n3 < n4) {
                            this.setSelectedIndex(n4 - 1);
                        }
                        this.showTab(this.getSelectedIndex());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    tabInfo.setCloseRollover(false);
                    tabInfo.setClosePressed(false);
                    this.repaint(this.getUI().getTabBounds(this, n3));
                }
            }
        } else if (n2 == 505) {
            this.unsetCloseRollover(n);
        }
        if (!bl) {
            super.processMouseEvent(mouseEvent);
            if (n2 == 502) {
                this.updateMouseOverClose(mouseEvent, n);
            }
        }
    }

    public void setTitleAt(int n, String string) {
        TabInfo tabInfo = this.getTabInfo(n);
        tabInfo.setTitle(string);
        super.setTitleAt(n, "");
    }

    public void setIconAt(int n, Icon icon) {
        TabInfo tabInfo = this.getTabInfo(n);
        tabInfo.setIcon(icon);
        super.setIconAt(n, tabInfo);
    }

    public Icon getIconAt(int n) {
        TabInfo tabInfo = (TabInfo)super.getIconAt(n);
        tabInfo.setEnabled(this.isEnabled() && this.isEnabledAt(n));
        return tabInfo;
    }

    public Icon getDisabledIconAt(int n) {
        return this.getIconAt(n);
    }

    public void setDisabledIconAt(int n, Icon icon) {
        TabInfo tabInfo = this.getTabInfo(n);
        tabInfo.setDisabledIcon(icon);
        super.setDisabledIconAt(n, null);
    }

    public void insertTab(String string, Icon icon, Component component, String string2, int n) {
        TabInfo tabInfo = this.createTabInfo(n);
        tabInfo.sTitle = string;
        tabInfo.icon = icon;
        super.insertTab(null, tabInfo, component, string2, n);
        tabInfo.setTitle(tabInfo.sTitle);
        tabInfo.setIcon(tabInfo.icon);
        this.showTab(n);
    }

    public void removeTabAt(int n) {
        this.setCloseSelected(this.getSelectedIndex(), false);
        this.fireDeselectTab(n);
        super.removeTabAt(n);
        this.auTabInfo.remove(n);
        this.iPressed = -1;
        this.iClose = -1;
        this.setCloseSelected(this.getSelectedIndex(), true);
        this.fireSelectTab(n, this.getSelectedIndex());
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.updateTabIcons();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.updateTabIcons();
    }

    public void setTabLayoutPolicy(int n) {
        super.setTabLayoutPolicy(n);
        if (this.isBackgroundSet() && this.getBackground() instanceof UIResource) {
            this.setBackground(null);
        }
        if (n == 1) {
            int n2 = this.getComponentCount();
            for (int i = 0; i < n2; ++i) {
                Component component = this.getComponent(i);
                if (!(component instanceof JViewport) || !"TabbedPane.scrollableViewport".equals(component.getName())) continue;
                this.vpScroll = (JViewport)component;
            }
        } else {
            this.vpScroll = null;
        }
    }

    public void setSelectedIndex(int n) {
        if (!this.bIgnoreSelection) {
            int n2 = this.getSelectedIndex();
            if (n2 == n) {
                return;
            }
            this.setCloseSelected(n2, false);
            this.fireDeselectTab(n2);
            super.setSelectedIndex(n);
            this.showTab(n);
            this.setCloseSelected(n, true);
            this.fireSelectTab(n2, n);
        }
    }

    public boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (this.isNavigationKeysEnabled()) {
            int n2 = 0;
            if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 34) {
                n2 = -1;
            } else if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 33) {
                n2 = 1;
            }
            if (n2 != 0) {
                int n3;
                int n4 = n3 = this.getSelectedIndex();
                do {
                    if ((n4 += n2) < 0) {
                        n4 = this.getTabCount() - 1;
                    } else if (n4 > this.getTabCount() - 1) {
                        n4 = 0;
                    }
                    if (!this.isEnabledAt(n4)) continue;
                    this.setSelectedIndex(n4);
                    return true;
                } while (n4 != n3);
            }
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    public void addTabListener(ITabListener iTabListener) {
        if (this.auTabListener == null) {
            this.auTabListener = new ArrayUtil();
        }
        this.auTabListener.add(iTabListener);
    }

    public void removeTabListener(ITabListener iTabListener) {
        if (this.auTabListener != null) {
            this.auTabListener.remove(iTabListener);
            if (this.auTabListener.size() == 0) {
                this.auTabListener = null;
            }
        }
    }

    private void fireCloseTab(int n) {
        if (this.auTabListener != null) {
            TabEvent tabEvent = new TabEvent(this, n, n, AwtFactory.getMostRecentEventTime(), AwtFactory.getCurrentModifiers());
            try {
                int n2 = this.auTabListener.size();
                for (int i = 0; i < n2; ++i) {
                    this.auTabListener.get(i).closeTab(tabEvent);
                }
            }
            catch (Exception exception) {
                ExceptionHandler.raise(exception);
            }
        }
    }

    private void fireSelectTab(int n, int n2) {
        if (this.auTabListener != null) {
            TabEvent tabEvent = new TabEvent(this, n, n2, AwtFactory.getMostRecentEventTime(), AwtFactory.getCurrentModifiers());
            int n3 = this.auTabListener.size();
            for (int i = 0; i < n3; ++i) {
                this.auTabListener.get(i).selectTab(tabEvent);
            }
        }
    }

    private void fireDeselectTab(int n) {
        if (this.auTabListener != null && n >= 0 && this.getSelectedIndex() == n) {
            TabEvent tabEvent = new TabEvent(this, n, n, AwtFactory.getMostRecentEventTime(), AwtFactory.getCurrentModifiers());
            try {
                int n2 = this.auTabListener.size();
                for (int i = 0; i < n2; ++i) {
                    this.auTabListener.get(i).deselectTab(tabEvent);
                }
            }
            catch (Exception exception) {
                ExceptionHandler.raise(exception);
            }
        }
    }

    private void fireMoveTab(int n, int n2) {
        if (this.auTabListener != null) {
            TabEvent tabEvent = new TabEvent(this, n, n2, AwtFactory.getMostRecentEventTime(), AwtFactory.getCurrentModifiers());
            int n3 = this.auTabListener.size();
            for (int i = 0; i < n3; ++i) {
                this.auTabListener.get(i).moveTab(tabEvent);
            }
        }
    }

    private TabInfo createTabInfo(int n) {
        if (n < 0) {
            return null;
        }
        if (this.auTabInfo == null) {
            this.auTabInfo = new ArrayUtil();
        }
        TabInfo tabInfo = new TabInfo(this);
        this.auTabInfo.add(n, tabInfo);
        return tabInfo;
    }

    private TabInfo getTabInfo(int n) {
        if (n < 0) {
            return null;
        }
        if (this.auTabInfo == null) {
            this.auTabInfo = new ArrayUtil();
        }
        if (n < this.auTabInfo.size()) {
            return this.auTabInfo.get(n);
        }
        return null;
    }

    private void updateTabIcons() {
        if (this.auTabInfo != null) {
            int n = this.auTabInfo.size();
            for (int i = 0; i < n; ++i) {
                this.auTabInfo.get(i).updateTabIcon();
            }
            this.repaint();
        }
    }

    private void unsetCloseRollover(int n) {
        if (n != this.iClose && this.iClose >= 0) {
            TabInfo tabInfo = this.getTabInfo(this.iClose);
            tabInfo.setCloseRollover(false);
            this.repaint(this.getUI().getTabBounds(this, this.iClose));
            this.iClose = -1;
        }
    }

    public void setClosableAt(int n, boolean bl) {
        TabInfo tabInfo = this.getTabInfo(n);
        if (tabInfo != null) {
            tabInfo.setClosable(bl);
            this.repaint(this.getUI().getTabBounds(this, n));
        }
    }

    private int translateX(int n) {
        if (this.vpScroll != null) {
            return n - this.vpScroll.getLocation().x + this.vpScroll.getViewPosition().x;
        }
        return n;
    }

    private int translateY(int n) {
        if (this.vpScroll != null) {
            return n - this.vpScroll.getLocation().y + this.vpScroll.getViewPosition().y;
        }
        return n;
    }

    private void setCloseSelected(int n, boolean bl) {
        TabInfo tabInfo = this.getTabInfo(n);
        if (tabInfo != null) {
            tabInfo.setSelected(bl);
        }
    }

    private void updateMouseOverClose(MouseEvent mouseEvent, int n) {
        TabInfo tabInfo;
        if (n >= 0 && (tabInfo = this.getTabInfo(n)).isClosable() && tabInfo.getCloseBounds() != null) {
            boolean bl = tabInfo.getCloseBounds().intersects(this.translateX(mouseEvent.getX()), this.translateY(mouseEvent.getY()), 1.0, 1.0);
            tabInfo.setCloseRollover(bl);
            if (bl) {
                this.iClose = n;
            }
            this.repaint(this.getUI().getTabBounds(this, n));
        }
    }

    public void setDragable(boolean bl) {
        this.bDragable = bl;
    }

    public boolean isDragable() {
        return this.bDragable;
    }

    private void showTab(int n) {
        if (this.vpScroll != null && n >= 0 && this.iShowTab == -1) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (JVxTabbedPane.this.iShowTab >= 0 && JVxTabbedPane.this.iShowTab < JVxTabbedPane.this.getTabCount()) {
                        Rectangle rectangle = JVxTabbedPane.this.getUI().getTabBounds(JVxTabbedPane.this, JVxTabbedPane.this.iShowTab);
                        if (rectangle.x < 0) {
                            JVxTabbedPane.this.vpScroll.setViewPosition(new Point(JVxTabbedPane.this.translateX(rectangle.x), JVxTabbedPane.this.translateY(rectangle.y)));
                        } else {
                            JVxTabbedPane.this.vpScroll.getView().invalidate();
                            JVxTabbedPane.this.vpScroll.scrollRectToVisible(new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
                        }
                        JVxTabbedPane.this.iShowTab = -1;
                    }
                }
            });
        }
        this.iShowTab = n;
    }

    public void setNavigationKeysEnabled(boolean bl) {
        this.bNavigationKeyEnabled = bl;
    }

    public boolean isNavigationKeysEnabled() {
        return this.bNavigationKeyEnabled;
    }

    private static final class TabInfo
    extends ImageIcon {
        private JVxTabbedPane tabParent;
        private String sTitle = null;
        private Icon icon = null;
        private Icon iconDisabled = null;
        private Rectangle rectCloseInTab = null;
        private Rectangle rectCloseInTabbedPane;
        private boolean bSelected = false;
        private boolean bClosable = false;
        private boolean bCloseRollover = false;
        private boolean bClosePressed = false;
        private boolean bEnabled = true;

        private TabInfo(JVxTabbedPane jVxTabbedPane) {
            this.tabParent = jVxTabbedPane;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.rectCloseInTab != null) {
                this.rectCloseInTabbedPane = new Rectangle(this.rectCloseInTab.x + n, this.rectCloseInTab.y + n2, this.rectCloseInTab.width, this.rectCloseInTab.height);
            }
            super.paintIcon(component, graphics, n, n2);
        }

        private void setIcon(Icon icon) {
            this.icon = icon != null && icon.getIconHeight() > 16 ? ImageUtil.getScaledIcon(icon, icon.getIconWidth(), 16, true) : icon;
            this.updateTabIcon();
        }

        private Icon getIcon() {
            return this.icon;
        }

        private void setDisabledIcon(Icon icon) {
            this.iconDisabled = icon != null && icon.getIconHeight() > 16 ? ImageUtil.getScaledIcon(icon, icon.getIconWidth(), 16, true) : icon;
            this.updateTabIcon();
        }

        private Icon getDisabledIcon() {
            return this.iconDisabled;
        }

        private void setTitle(String string) {
            if (this.sTitle != string || this.sTitle != null && !this.sTitle.equals(string) || string != null && !string.equals(this.sTitle)) {
                this.sTitle = string;
                this.updateTabIcon();
            }
        }

        private String getTitle() {
            return this.sTitle;
        }

        private void setClosable(boolean bl) {
            if (this.bClosable != bl) {
                this.bClosable = bl;
                this.updateTabIcon();
            }
        }

        private boolean isClosable() {
            return this.bClosable;
        }

        private Rectangle getCloseBounds() {
            return this.rectCloseInTabbedPane;
        }

        private void setCloseRollover(boolean bl) {
            if (this.bCloseRollover != bl) {
                this.bCloseRollover = bl;
                this.updateTabIcon();
            }
        }

        private boolean isCloseRollover() {
            return this.bCloseRollover;
        }

        private void setClosePressed(boolean bl) {
            if (this.bClosePressed != bl) {
                this.bClosePressed = bl;
                this.updateTabIcon();
            }
        }

        private boolean isClosePressed() {
            return this.bClosePressed;
        }

        private void setSelected(boolean bl) {
            if (this.bSelected != bl) {
                this.bSelected = bl;
                this.updateTabIcon();
            }
        }

        private void setEnabled(boolean bl) {
            if (this.bEnabled != bl) {
                this.bEnabled = bl;
                this.updateTabIcon();
            }
        }

        private void updateTabIcon() {
            Insets insets = this.tabParent.getInsets();
            int n = UIManager.getInt("TabbedPane.textIconGap");
            int n2 = 0;
            int n3 = 0;
            int n4 = insets.top + insets.bottom;
            int n5 = insets.left + insets.right;
            if (n5 < 5) {
                n5 = 5;
            }
            if (n4 < 5) {
                n4 = 5;
            }
            if (this.icon != null) {
                n2 = this.icon.getIconHeight();
                n3 = this.icon.getIconWidth();
            }
            if (this.iconDisabled != null) {
                n2 = Math.max(n2, this.iconDisabled.getIconHeight());
                n3 = Math.max(n3, this.iconDisabled.getIconWidth());
            }
            n4 = Math.max(n4, n2);
            n5 = Math.max(n5, n3);
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            Font font = null;
            Color color = null;
            if (this.sTitle != null) {
                Component component;
                if (this.icon != null) {
                    n5 += n;
                }
                if ((component = this.tabParent.getComponentAt(this.tabParent.auTabInfo.indexOf(this))).isFontSet()) {
                    font = component.getFont();
                    if (font instanceof UIResource) {
                        font = this.tabParent.getFont();
                    }
                } else {
                    font = this.tabParent.getFont();
                }
                if (component.isForegroundSet()) {
                    color = component.getForeground();
                    if (color instanceof UIResource) {
                        color = this.tabParent.getForeground();
                    }
                } else {
                    color = this.tabParent.getForeground();
                }
                FontMetrics fontMetrics = this.tabParent.getFontMetrics(font);
                n8 = fontMetrics.stringWidth(this.sTitle);
                n7 = fontMetrics.getHeight();
                n5 += n8;
                n4 = Math.max(n4, insets.top + insets.bottom + n7);
                n6 = fontMetrics.getAscent();
            }
            int n9 = 0;
            int n10 = 0;
            if (this.bClosable) {
                n9 = icoClose.getHeight(null);
                n10 = 10;
                if (this.icon != null || this.sTitle != null) {
                    n5 += n10;
                }
                n5 += n9;
                n4 = Math.max(n4, insets.top + insets.bottom + n9);
            }
            int n11 = this.tabParent.getTabPlacement() == 3 ? -insets.top : insets.top;
            BufferedImage bufferedImage = new BufferedImage(n5, n4, 2);
            Graphics graphics = ((Image)bufferedImage).getGraphics();
            int n12 = insets.left;
            if (this.bEnabled) {
                if (this.icon != null) {
                    this.icon.paintIcon(this.tabParent, graphics, n12, n11 + (n4 - n2) / 2);
                    n12 += this.icon.getIconWidth();
                }
            } else if (this.iconDisabled != null) {
                this.iconDisabled.paintIcon(this.tabParent, graphics, n12, n11 + (n4 - n2) / 2);
                n12 += this.iconDisabled.getIconWidth();
            }
            if (this.sTitle != null) {
                if (this.icon != null) {
                    n12 += n;
                }
                graphics.setFont(font);
                graphics.setColor(color);
                graphics.drawString(this.sTitle, n12, n11 + (n4 - n7) / 2 + n6);
                n12 += n8 + n10;
            }
            if (this.bClosable) {
                int n13 = n11 + (n4 - n9) / 2;
                if (this.bClosePressed) {
                    graphics.drawImage(icoClosePress, n12, n13, null);
                } else if (this.bCloseRollover) {
                    graphics.drawImage(icoCloseOver, n12, n13, null);
                } else if (this.bSelected) {
                    graphics.drawImage(icoCloseSelect, n12, n13, null);
                } else {
                    graphics.drawImage(icoClose, n12, n13, null);
                }
                this.rectCloseInTab = new Rectangle(n12, n13, n9, n9);
            } else {
                this.rectCloseInTab = null;
                this.rectCloseInTabbedPane = null;
            }
            graphics.dispose();
            if (this.bEnabled) {
                this.setImage(bufferedImage);
            } else {
                this.setImage(GrayFilter.createDisabledImage(bufferedImage));
            }
            this.tabParent.revalidate();
            this.tabParent.repaint();
        }
    }
}

