/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.remote.ISerializer;
import com.sibvisions.rad.server.AbstractSession;
import com.sibvisions.rad.server.Call;
import com.sibvisions.rad.server.DefaultObjectProvider;
import com.sibvisions.rad.server.DefaultSessionManager;
import com.sibvisions.rad.server.IDirectServer;
import com.sibvisions.rad.server.IRequest;
import com.sibvisions.rad.server.IResponse;
import com.sibvisions.rad.server.Monitoring;
import com.sibvisions.rad.server.ServerContextImpl;
import com.sibvisions.rad.server.config.Configuration;
import com.sibvisions.rad.server.config.ServerZone;
import com.sibvisions.rad.server.plugin.IServerPlugin;
import com.sibvisions.rad.server.protocol.ProtocolFactory;
import com.sibvisions.rad.server.protocol.Record;
import com.sibvisions.rad.server.security.AbstractSecurityManager;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.ChangedHashtable;
import com.sibvisions.util.Reflective;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.StringUtil;
import com.sibvisions.util.xml.XmlNode;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.naming.InitialContext;
import javax.rad.remote.IConnectionConstants;
import javax.rad.remote.event.ICallBackListener;
import javax.rad.server.AbstractObjectProvider;
import javax.rad.server.ISession;
import javax.rad.server.ResultObject;
import javax.rad.server.ServerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
implements IDirectServer {
    private static final Exception EXCEPTION_CONTENT = new Exception("Invalid content!");
    private ILogger log;
    private static Server instance = null;
    private DefaultSessionManager sessman = null;
    private AbstractObjectProvider objectprov = null;
    private Monitoring monitoring = null;
    private WeakHashMap<ISession, CachedResponse> whmResponse = new WeakHashMap();

    public Server() {
        Object object;
        String string;
        ServerZone serverZone = Configuration.getServerZone();
        try {
            string = serverZone.getProperty("logfactory");
        }
        catch (Exception exception) {
            string = null;
        }
        LoggerFactory.init(string);
        this.log = LoggerFactory.getInstance(Server.class);
        try {
            object = serverZone.getProperty("/server/sessionmanager/class");
            this.sessman = (DefaultSessionManager)Reflective.construct((String)object, this);
            this.log.debug("Use ", object, " as SessionManager");
        }
        catch (Throwable throwable) {
            this.log.debug("NO PROBLEM! Use default SessionManager", throwable);
            this.sessman = new DefaultSessionManager(this);
        }
        try {
            object = serverZone.getProperty("/server/sessionmanager/controllerInterval");
            if (!StringUtil.isEmpty((String)object)) {
                DefaultSessionManager.setControllerInterval(Long.parseLong((String)object));
            }
        }
        catch (Throwable throwable) {
            this.log.debug(throwable);
        }
        try {
            object = serverZone.getProperty("/server/objectprovider/class");
            this.objectprov = (AbstractObjectProvider)Reflective.construct((String)object, this);
            this.log.debug("Use ", object, " as ObjectProvider");
        }
        catch (Throwable throwable) {
            this.log.debug("NO PROBLEM! Use default ObjectProvider", throwable);
            this.objectprov = new DefaultObjectProvider(this);
        }
        this.monitoring = new Monitoring(this);
        try {
            object = serverZone.getNodes("/server/plugin");
            if (object != null) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    XmlNode xmlNode = (XmlNode)iterator.next();
                    String string2 = xmlNode.getNodeValue("/class");
                    try {
                        IServerPlugin iServerPlugin = (IServerPlugin)Reflective.construct(string2, new Object[0]);
                        iServerPlugin.install(this);
                    }
                    catch (Throwable throwable) {
                        this.log.error("Can't install plugin '", string2, "'", throwable);
                    }
                }
            }
        }
        catch (Exception exception) {
            this.log.debug("Can't access plugin configuration!", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Server getInstance() {
        if (instance == null) {
            try {
                InitialContext initialContext = new InitialContext();
                try {
                    if (initialContext != null) {
                        instance = (Server)initialContext.lookup("java:/comp/env/jvx/server");
                    }
                    Object var2_2 = null;
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    initialContext.close();
                    throw throwable;
                }
                initialContext.close();
                {
                }
            }
            catch (Exception exception) {
                LoggerFactory.getInstance(Server.class).debug("Server is not configured as JNDI resource", exception);
            }
            if (instance == null) {
                instance = new Server();
            }
        }
        return instance;
    }

    @Override
    public final DefaultSessionManager getSessionManager() {
        return this.sessman;
    }

    @Override
    public final AbstractObjectProvider getObjectProvider() {
        return this.objectprov;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object createSession(ChangedHashtable<String, Object> changedHashtable) throws Throwable {
        Object object;
        Record record = ProtocolFactory.openRecord("createSession", new Object[0]);
        ServerContext serverContext = this.createServerContext();
        try {
            block7: {
                Throwable throwable = null;
                Object object2 = null;
                long l = System.currentTimeMillis();
                try {
                    object = object2 = this.createSessionIntern(null, null, changedHashtable);
                    Object var10_9 = null;
                    if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) break block7;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = AbstractSecurityManager.prepareException(throwable2);
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        Object var10_10 = null;
                        if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) throw throwable3;
                        this.log(null, "direct", "Session!", "createSession", new Object[]{changedHashtable}, null, object2, throwable, System.currentTimeMillis() - l);
                        throw throwable3;
                    }
                }
                this.log(null, "direct", "Session!", "createSession", new Object[]{changedHashtable}, null, object2, throwable, System.currentTimeMillis() - l);
            }
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            CommonUtil.close(record);
            serverContext.release();
            throw throwable;
        }
        CommonUtil.close(record);
        serverContext.release();
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object createSubSession(Object object, ChangedHashtable<String, Object> changedHashtable) throws Throwable {
        Object object2;
        ServerContext serverContext = this.createServerContext();
        Record record = ProtocolFactory.openRecord("createSubSession", new Object[0]);
        try {
            block7: {
                Throwable throwable = null;
                Object object3 = null;
                long l = System.currentTimeMillis();
                try {
                    object2 = object3 = this.createSubSessionIntern(null, this.sessman.get(object), changedHashtable);
                    Object var11_10 = null;
                    if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) break block7;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = AbstractSecurityManager.prepareException(throwable2);
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        Object var11_11 = null;
                        if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) throw throwable3;
                        this.log(object, "direct", "Session!", "createSubSession", new Object[]{changedHashtable}, null, object3, throwable, System.currentTimeMillis() - l);
                        throw throwable3;
                    }
                }
                this.log(object, "direct", "Session!", "createSubSession", new Object[]{changedHashtable}, null, object3, throwable, System.currentTimeMillis() - l);
            }
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            CommonUtil.close(record);
            serverContext.release();
            throw throwable;
        }
        CommonUtil.close(record);
        serverContext.release();
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroySession(Object object) {
        ServerContext serverContext = this.createServerContext();
        Record record = ProtocolFactory.openRecord("destroySession", new Object[0]);
        try {
            long l = System.currentTimeMillis();
            try {
                this.destroySessionIntern(object);
                Object var7_5 = null;
                if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                    this.log(object, "direct", "Session!", "destroySession", null, null, null, null, System.currentTimeMillis() - l);
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                    this.log(object, "direct", "Session!", "destroySession", null, null, null, null, System.currentTimeMillis() - l);
                }
                throw throwable;
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            CommonUtil.close(record);
            serverContext.release();
            throw throwable;
        }
        CommonUtil.close(record);
        serverContext.release();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object execute(Object object, String string, String string2, Object ... objectArray) throws Throwable {
        ServerContext serverContext = this.createServerContext();
        Record record = ProtocolFactory.openRecord("execute", string, string2, objectArray);
        try {
            Object object2;
            block6: {
                Throwable throwable = null;
                Object object3 = null;
                long l = System.currentTimeMillis();
                try {
                    AbstractSession abstractSession = this.sessman.get(object);
                    ((ServerContextImpl)serverContext).setSession(abstractSession);
                    object2 = object3 = this.executeIntern(abstractSession, new Call(null, string, string2, objectArray));
                    Object var14_13 = null;
                    if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) break block6;
                    this.log(object, "direct", string, string2, objectArray, null, object3, throwable, System.currentTimeMillis() - l);
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = AbstractSecurityManager.prepareException(throwable2);
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        Object var14_14 = null;
                        if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) throw throwable3;
                        this.log(object, "direct", string, string2, objectArray, null, object3, throwable, System.currentTimeMillis() - l);
                        throw throwable3;
                    }
                }
            }
            Object var16_15 = null;
            CommonUtil.close(record);
            serverContext.release();
            return object2;
        }
        catch (Throwable throwable4) {
            Object var16_16 = null;
            CommonUtil.close(record);
            serverContext.release();
            throw throwable4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeCallBack(Object object, Object object2, String string, String string2, Object ... objectArray) throws Throwable {
        ServerContext serverContext = this.createServerContext();
        Record record = ProtocolFactory.openRecord("executeCallBack", string, string2, objectArray);
        try {
            Throwable throwable = null;
            long l = System.currentTimeMillis();
            try {
                try {
                    AbstractSession abstractSession = this.sessman.get(object);
                    ((ServerContextImpl)serverContext).setSession(abstractSession);
                    this.validateCallBack(abstractSession, string);
                    Call call = new Call(object2, string, string2, objectArray);
                    call.setForceCallBack(true);
                    this.executeIntern(abstractSession, call);
                }
                catch (Throwable throwable2) {
                    throwable = AbstractSecurityManager.prepareException(throwable2);
                    throw throwable2;
                }
                Object var14_13 = null;
                if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                    this.log(object, "direct", string, string2, objectArray, object2, null, throwable, System.currentTimeMillis() - l);
                }
            }
            catch (Throwable throwable3) {
                Object var14_14 = null;
                if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                    this.log(object, "direct", string, string2, objectArray, object2, null, throwable, System.currentTimeMillis() - l);
                }
                throw throwable3;
            }
            Object var16_16 = null;
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            CommonUtil.close(record);
            serverContext.release();
            throw throwable;
        }
        CommonUtil.close(record);
        serverContext.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeCallBack(Object object, ICallBackListener iCallBackListener, String string, String string2, Object ... objectArray) throws Throwable {
        ServerContext serverContext = this.createServerContext();
        Record record = ProtocolFactory.openRecord("executeCallBack", string, string2, objectArray);
        try {
            Throwable throwable = null;
            long l = System.currentTimeMillis();
            try {
                try {
                    AbstractSession abstractSession = this.sessman.get(object);
                    ((ServerContextImpl)serverContext).setSession(abstractSession);
                    this.validateCallBack(abstractSession, string);
                    Call call = new Call(iCallBackListener, string, string2, objectArray);
                    call.setForceCallBack(true);
                    this.executeIntern(abstractSession, call);
                }
                catch (Throwable throwable2) {
                    throwable = AbstractSecurityManager.prepareException(throwable2);
                    throw throwable2;
                }
                Object var14_13 = null;
                if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                    this.log(object, "direct", string, string2, objectArray, iCallBackListener, null, throwable, System.currentTimeMillis() - l);
                }
            }
            catch (Throwable throwable3) {
                Object var14_14 = null;
                if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                    this.log(object, "direct", string, string2, objectArray, iCallBackListener, null, throwable, System.currentTimeMillis() - l);
                }
                throw throwable3;
            }
            Object var16_16 = null;
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            CommonUtil.close(record);
            serverContext.release();
            throw throwable;
        }
        CommonUtil.close(record);
        serverContext.release();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object executeAction(Object object, String string, Object ... objectArray) throws Throwable {
        ServerContext serverContext = this.createServerContext();
        Record record = ProtocolFactory.openRecord("executeAction", string, objectArray);
        try {
            Object object2;
            block6: {
                Throwable throwable = null;
                Object object3 = null;
                long l = System.currentTimeMillis();
                try {
                    AbstractSession abstractSession = this.sessman.get(object);
                    ((ServerContextImpl)serverContext).setSession(abstractSession);
                    object2 = object3 = this.executeIntern(abstractSession, new Call(null, null, string, objectArray));
                    Object var13_12 = null;
                    if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) break block6;
                    this.log(object, "direct", null, string, objectArray, null, object3, throwable, System.currentTimeMillis() - l);
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = AbstractSecurityManager.prepareException(throwable2);
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        Object var13_13 = null;
                        if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) throw throwable3;
                        this.log(object, "direct", null, string, objectArray, null, object3, throwable, System.currentTimeMillis() - l);
                        throw throwable3;
                    }
                }
            }
            Object var15_14 = null;
            CommonUtil.close(record);
            serverContext.release();
            return object2;
        }
        catch (Throwable throwable4) {
            Object var15_15 = null;
            CommonUtil.close(record);
            serverContext.release();
            throw throwable4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeActionCallBack(Object object, Object object2, String string, Object ... objectArray) throws Throwable {
        ServerContext serverContext = this.createServerContext();
        Record record = ProtocolFactory.openRecord("executeActionCallBack", string, objectArray);
        try {
            Throwable throwable = null;
            long l = System.currentTimeMillis();
            try {
                try {
                    AbstractSession abstractSession = this.sessman.get(object);
                    ((ServerContextImpl)serverContext).setSession(abstractSession);
                    this.validateCallBack(abstractSession, null);
                    Call call = new Call(object2, null, string, objectArray);
                    call.setForceCallBack(true);
                    this.executeIntern(abstractSession, call);
                }
                catch (Throwable throwable2) {
                    throwable = AbstractSecurityManager.prepareException(throwable2);
                    throw throwable2;
                }
                Object var13_12 = null;
                if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                    this.log(object, "direct", null, string, objectArray, object2, null, throwable, System.currentTimeMillis() - l);
                }
            }
            catch (Throwable throwable3) {
                Object var13_13 = null;
                if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                    this.log(object, "direct", null, string, objectArray, object2, null, throwable, System.currentTimeMillis() - l);
                }
                throw throwable3;
            }
            Object var15_15 = null;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            CommonUtil.close(record);
            serverContext.release();
            throw throwable;
        }
        CommonUtil.close(record);
        serverContext.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeActionCallBack(Object object, ICallBackListener iCallBackListener, String string, Object ... objectArray) throws Throwable {
        ServerContext serverContext = this.createServerContext();
        Record record = ProtocolFactory.openRecord("executeActionCallBack", string, objectArray);
        try {
            Throwable throwable = null;
            long l = System.currentTimeMillis();
            try {
                try {
                    AbstractSession abstractSession = this.sessman.get(object);
                    ((ServerContextImpl)serverContext).setSession(abstractSession);
                    this.validateCallBack(abstractSession, null);
                    Call call = new Call(iCallBackListener, null, string, objectArray);
                    call.setForceCallBack(true);
                    this.executeIntern(abstractSession, call);
                }
                catch (Throwable throwable2) {
                    throwable = AbstractSecurityManager.prepareException(throwable2);
                    throw throwable2;
                }
                Object var13_12 = null;
                if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                    this.log(object, "direct", null, string, objectArray, iCallBackListener, null, throwable, System.currentTimeMillis() - l);
                }
            }
            catch (Throwable throwable3) {
                Object var13_13 = null;
                if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                    this.log(object, "direct", null, string, objectArray, iCallBackListener, null, throwable, System.currentTimeMillis() - l);
                }
                throw throwable3;
            }
            Object var15_15 = null;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            CommonUtil.close(record);
            serverContext.release();
            throw throwable;
        }
        CommonUtil.close(record);
        serverContext.release();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setProperty(Object object, String string, Object object2) throws Throwable {
        ServerContext serverContext;
        block6: {
            serverContext = this.createServerContext();
            Throwable throwable = null;
            long l = System.currentTimeMillis();
            try {
                try {
                    AbstractSession abstractSession = this.sessman.get(object);
                    ((ServerContextImpl)serverContext).setSession(abstractSession);
                    this.setPropertyIntern(abstractSession, string, object2);
                }
                catch (Throwable throwable2) {
                    throwable = AbstractSecurityManager.prepareException(throwable2);
                    throw throwable2;
                }
                Object var10_9 = null;
                if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) break block6;
            }
            catch (Throwable throwable3) {
                Object var10_10 = null;
                if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                    this.log(object, "direct", "Session!", "setProperty", new Object[]{string, object2}, null, null, throwable, System.currentTimeMillis() - l);
                }
                serverContext.release();
                throw throwable3;
            }
            this.log(object, "direct", "Session!", "setProperty", new Object[]{string, object2}, null, null, throwable, System.currentTimeMillis() - l);
        }
        serverContext.release();
    }

    @Override
    public Object getProperty(Object object, String string) throws Throwable {
        Throwable throwable = null;
        Object object2 = null;
        long l = System.currentTimeMillis();
        try {
            try {
                object2 = this.getPropertyIntern(this.sessman.get(object), string);
            }
            catch (Throwable throwable2) {
                throwable = AbstractSecurityManager.prepareException(throwable2);
                throw throwable2;
            }
            Object var9_6 = null;
            if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                this.log(object, "direct", "Session!", "getProperty", null, null, object2, throwable, System.currentTimeMillis() - l);
            }
        }
        catch (Throwable throwable3) {
            Object var9_7 = null;
            if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                this.log(object, "direct", "Session!", "getProperty", null, null, object2, throwable, System.currentTimeMillis() - l);
            }
            throw throwable3;
        }
        return object2;
    }

    @Override
    public ChangedHashtable<String, Object> getProperties(Object object) throws Throwable {
        Throwable throwable = null;
        ChangedHashtable<String, Object> changedHashtable = null;
        long l = System.currentTimeMillis();
        try {
            try {
                changedHashtable = this.getPropertiesIntern(this.sessman.get(object));
            }
            catch (Throwable throwable2) {
                throwable = AbstractSecurityManager.prepareException(throwable2);
                throw throwable2;
            }
            Object var8_5 = null;
            if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                this.log(object, "direct", "Session!", "getProperties", null, null, changedHashtable, throwable, System.currentTimeMillis() - l);
            }
        }
        catch (Throwable throwable3) {
            Object var8_6 = null;
            if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                this.log(object, "direct", "Session!", "getProperties", null, null, changedHashtable, throwable, System.currentTimeMillis() - l);
            }
            throw throwable3;
        }
        return changedHashtable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ResultObject> getCallBackResults(Object object) throws Throwable {
        ArrayUtil<ResultObject> arrayUtil;
        ServerContext serverContext;
        block6: {
            serverContext = this.createServerContext();
            Throwable throwable = null;
            arrayUtil = null;
            long l = System.currentTimeMillis();
            try {
                try {
                    AbstractSession abstractSession = this.sessman.get(object);
                    ((ServerContextImpl)serverContext).setSession(abstractSession);
                    arrayUtil = this.getCallBackResultsIntern(abstractSession);
                }
                catch (Throwable throwable2) {
                    throwable = AbstractSecurityManager.prepareException(throwable2);
                    throw throwable2;
                }
                Object var9_8 = null;
                if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) break block6;
            }
            catch (Throwable throwable3) {
                Object var9_9 = null;
                if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                    this.log(object, "direct", "Session!", "getCallBackResults", new Object[]{object}, null, arrayUtil, throwable, System.currentTimeMillis() - l);
                }
                serverContext.release();
                throw throwable3;
            }
            this.log(object, "direct", "Session!", "getCallBackResults", new Object[]{object}, null, arrayUtil, throwable, System.currentTimeMillis() - l);
        }
        serverContext.release();
        return arrayUtil;
    }

    @Override
    public Object[] setAndCheckAlive(Object object, Object ... objectArray) throws Throwable {
        ServerContext serverContext = this.createServerContext();
        Throwable throwable = null;
        Object[] objectArray2 = null;
        long l = System.currentTimeMillis();
        try {
            try {
                AbstractSession abstractSession = this.sessman.get(object);
                ((ServerContextImpl)serverContext).setSession(abstractSession);
                objectArray2 = this.setAndCheckAliveIntern(abstractSession, objectArray);
            }
            catch (Throwable throwable2) {
                throwable = AbstractSecurityManager.prepareException(throwable2);
                throw throwable2;
            }
            Object var10_9 = null;
            if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                this.log(object, "direct", "Session!", "setAndCheckAlive", objectArray, null, objectArray2, throwable, System.currentTimeMillis() - l);
            }
            serverContext.release();
        }
        catch (Throwable throwable3) {
            Object var10_10 = null;
            if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                this.log(object, "direct", "Session!", "setAndCheckAlive", objectArray, null, objectArray2, throwable, System.currentTimeMillis() - l);
            }
            serverContext.release();
            throw throwable3;
        }
        return objectArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setNewPassword(Object object, String string, String string2) throws Throwable {
        ServerContext serverContext = this.createServerContext();
        Record record = ProtocolFactory.openRecord("setNewPassword", new Object[0]);
        try {
            block6: {
                Throwable throwable = null;
                long l = System.currentTimeMillis();
                try {
                    try {
                        AbstractSession abstractSession = this.sessman.get(object);
                        ((ServerContextImpl)serverContext).setSession(abstractSession);
                        this.setNewPasswordInternal(abstractSession, string, string2);
                    }
                    catch (Throwable throwable2) {
                        throwable = AbstractSecurityManager.prepareException(throwable2);
                        throw throwable2;
                    }
                    Object var11_10 = null;
                    if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) break block6;
                }
                catch (Throwable throwable3) {
                    Object var11_11 = null;
                    if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) throw throwable3;
                    this.log(object, "direct", "Session!", "setNewPassword", new Object[]{"****"}, null, null, throwable, System.currentTimeMillis() - l);
                    throw throwable3;
                }
                this.log(object, "direct", "Session!", "setNewPassword", new Object[]{"****"}, null, null, throwable, System.currentTimeMillis() - l);
            }
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            CommonUtil.close(record);
            serverContext.release();
            throw throwable;
        }
        CommonUtil.close(record);
        serverContext.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ISession process(IRequest var1_1, IResponse var2_2) throws Exception {
        block140: {
            var3_3 = this.createServerContext();
            var4_4 = ProtocolFactory.openRecord("process", new Object[0]);
            try {
                block142: {
                    block136: {
                        var5_5 = null;
                        var8_6 = null;
                        var9_7 = null;
                        var10_8 = null;
                        var12_9 = null;
                        var13_10 = null;
                        var6_11 = var1_1.getInputStream();
                        var14_12 = (char)var6_11.read();
                        if (var14_12 != 'A' && var14_12 != 'E') {
                            throw new IOException("Invalid stream identifier '" + var14_12 + "'");
                        }
                        var15_15 = var6_11.read();
                        var16_16 = var15_15 == 2 ? new GZIPInputStream(var6_11) : var6_11;
                        var17_17 = new DataInputStream(var16_16);
                        var18_18 = null;
                        if (var14_12 == 'A') {
                            var18_18 = var17_17.readUTF();
                            var8_6 = (ISerializer)Class.forName(var18_18).newInstance();
                        }
                        if ((var19_19 = var17_17.readUTF()).trim().length() == 0) {
                            var19_19 = null;
                        }
                        if (var19_19 != null) {
                            var5_5 = this.sessman.get(var19_19);
                            ((ServerContextImpl)var3_3).setSession(var5_5);
                            var8_6 = var5_5.getSerializer();
                        }
                        if (var8_6 == null) {
                            throw new SecurityException("Invalid serializer '" + var18_18 + "'");
                        }
                        var20_20 = var8_6.read(var17_17);
                        if (!(var20_20 instanceof String)) ** GOTO lbl184
                        var10_8 = Long.valueOf((String)var20_20);
                        if (var5_5 == null) ** GOTO lbl183
                        var21_21 = this.sessman.getMasterSession(var5_5);
                        var13_10 = this.whmResponse.get(var21_21);
                        if (var13_10 == null) ** GOTO lbl180
                        if (!var13_10.id.equals(var10_8)) ** GOTO lbl176
                        if (var13_10.content == null) {
                            var22_22 = var13_10;
                            synchronized (var22_22) {
                                var13_10.wait(10000L);
                            }
                        }
                        if (var13_10.content == null) break block136;
                        this.sendContent(var2_2, var13_10.content);
                        var22_22 = var5_5;
                        var32_25 = null;
                        try {
                            var1_1.close();
                        }
                        catch (Throwable var33_29) {
                            this.log.error(new Object[]{var33_29});
                        }
                        if (!var2_2.isClosed()) {
                            var7_33 = new ByteArrayOutputStream();
                            if (var8_6 == null) {
                                var7_33.write(66);
                                var7_33.write(1);
                                var33_29 = new DataOutputStream(var7_33);
                                try {
                                    var36_45 = var9_7.size();
                                    var37_53 = 0;
                                    for (var35_37 = 0; var35_37 < var36_45 && var37_53 == 0; ++var35_37) {
                                        if (((ResultObject)var9_7.get(var35_37)).getType() != 4) continue;
                                        var34_65 = (Throwable)((ResultObject)var9_7.get(var35_37)).getObject();
                                        if (var34_65 != null) {
                                            var38_73 = var34_65.getStackTrace();
                                            var33_29.writeUTF(var34_65.getClass().getName());
                                            var33_29.writeUTF(CommonUtil.nvl(var34_65.getMessage(), ""));
                                            if (var38_73 != null) {
                                                var33_29.write(var38_73.length);
                                                var40_85 = var38_73.length;
                                                for (var39_81 = 0; var39_81 < var40_85; ++var39_81) {
                                                    var33_29.writeUTF(CommonUtil.nvl(var38_73[var39_81].getClassName(), ""));
                                                    var33_29.writeUTF(CommonUtil.nvl(var38_73[var39_81].getMethodName(), ""));
                                                    var33_29.writeUTF(CommonUtil.nvl(var38_73[var39_81].getFileName(), ""));
                                                    var33_29.writeInt(var38_73[var39_81].getLineNumber());
                                                }
                                            } else {
                                                var33_29.write(0);
                                            }
                                        } else {
                                            var33_29.writeUTF("");
                                        }
                                        ++var37_53;
                                    }
                                    var42_89 = null;
                                    var33_29.flush();
                                }
                                catch (Throwable var41_97) {
                                    var42_90 = null;
                                    var33_29.flush();
                                    throw var41_97;
                                }
                            }
                            var33_29 = null;
                            var34_66 = var5_5 != null ? var5_5.getProperties().getChanges(IConnectionConstants.PROPERTY_CLASSES) : (var12_9 != null ? var12_9.getChanges(IConnectionConstants.PROPERTY_CLASSES) : null);
                            if (var34_66 != null && var34_66.size() > 0) {
                                var35_38 = new ArrayUtil<E>(var34_66.size());
                                for (Object var37_54 : var34_66) {
                                    var35_38.add(new Object[]{var37_54.getKey(), var37_54.getValue()});
                                    var2_2.setProperty((String)var37_54.getKey(), var37_54.getValue());
                                }
                                if (var33_29 == null) {
                                    var33_29 = new ArrayUtil<E>();
                                }
                                var33_29.add(new ResultObject(5, var35_38));
                            }
                            if (var5_5 != null) {
                                if (var33_29 == null) {
                                    var33_29 = new ArrayUtil<ResultObject>();
                                }
                                if ((var35_38 = this.getCallBackResultsIntern(var5_5)) != null) {
                                    var33_29.addAll(var35_38);
                                }
                            }
                            if (var9_7 != null) {
                                if (var33_29 == null) {
                                    var33_29 = new ArrayUtil<E>();
                                }
                                var33_29.addAll(var9_7);
                            }
                            var11_101 = var33_29 != null ? var33_29.size() : 0;
                            var35_38 = new ByteArrayOutputStream(256);
                            var36_46 = new DataOutputStream((OutputStream)var35_38);
                            try {
                                var8_6.write(var36_46, var11_101);
                                if (var33_29 != null) {
                                    var37_54 = var33_29.iterator();
                                    while (var37_54.hasNext()) {
                                        var38_74 = (ResultObject)var37_54.next();
                                        var8_6.write(var36_46, var38_74.getType());
                                        var8_6.write(var36_46, var38_74.getObject());
                                        if (var38_74.getType() != 2 && var38_74.getType() != 1) continue;
                                        var8_6.write(var36_46, var38_74.getCallBackId());
                                    }
                                }
                                var44_106 = null;
                                var35_38.close();
                                var36_46.close();
                            }
                            catch (Throwable var43_114) {
                                var44_107 = null;
                                var35_38.close();
                                var36_46.close();
                                throw var43_114;
                            }
                            var7_33.write(69);
                            v0 = var37_55 = var5_5 != null && Boolean.parseBoolean((String)var5_5.getProperties().get("client.session.compression")) != false;
                            if (var37_55 && var35_38.size() > 256) {
                                var7_33.write(2);
                                var38_74 = new GZIPOutputStream(var7_33);
                                var38_74.write(var35_38.toByteArray());
                                var38_74.flush();
                                var38_74.finish();
                            } else {
                                var7_33.write(1);
                                var7_33.write(var35_38.toByteArray());
                            }
                            var7_33.flush();
                            var7_33.close();
                            if (var13_10 != null) {
                                var13_10.content = var7_33;
                                var33_29 = var13_10;
                                synchronized (var33_29) {
                                    var13_10.notifyAll();
                                }
                            } else if (var5_5 != null) {
                                this.whmResponse.put(this.sessman.getMasterSession(var5_5), new CachedResponse(var10_8, var7_33));
                            }
                            this.sendContent(var2_2, var7_33);
                        }
                        var47_118 = null;
                        CommonUtil.close(new Object[]{var4_4});
                        var3_3.release();
                        return var22_22;
                    }
                    try {
                        block148: {
                            block149: {
                                block147: {
                                    block146: {
                                        var2_2.close();
                                        throw Server.EXCEPTION_CONTENT;
lbl176:
                                        // 1 sources

                                        if (var13_10.id + 1L != var10_8) {
                                            var11_102 = (Integer)var8_6.read(var17_17);
                                            var23_121 = 0;
                                            break block140;
                                        }
lbl180:
                                        // 3 sources

                                        var13_10 = new CachedResponse(var10_8);
                                        this.whmResponse.put((ISession)var21_21, (CachedResponse)var13_10);
lbl183:
                                        // 2 sources

                                        var20_20 = var8_6.read(var17_17);
lbl184:
                                        // 2 sources

                                        var11_103 = (Integer)var20_20;
                                        var9_7 = new ArrayUtil<E>(var11_103);
                                        for (var26_123 = 0; var26_123 < var11_103; ++var26_123) {
                                            var24_124 = System.currentTimeMillis();
                                            var23_122 = (Object[])var8_6.read(var17_17);
                                            if (!(var23_122.length != 4 || var23_122[0] != null && var23_122[0].getClass() != String.class || var23_122[1].getClass() != String.class || var23_122[2] != null && !(var23_122[2] instanceof Object[]))) {
                                                var21_21 = null;
                                                var22_24 = null;
                                                try {
                                                    try {
                                                        var22_24 = this.process(var1_1, var8_6, var5_5, (String)var23_122[0], (String)var23_122[1], (Object[])var23_122[2], var23_122[3], (ChangedHashtable<String, Object>)var12_9);
                                                    }
                                                    catch (Throwable var27_126) {
                                                        var21_21 = var27_126;
                                                        throw var27_126;
                                                    }
                                                    var29_129 = null;
                                                    if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                                                        this.log(var5_5 != null ? var5_5.getId() : null, var10_8, (String)var23_122[0], (String)var23_122[1], (Object[])var23_122[2], var23_122[3], var22_24, (Throwable)var21_21, System.currentTimeMillis() - var24_124);
                                                    }
                                                }
                                                catch (Throwable var28_128) {
                                                    var29_129 = null;
                                                    if (this.log.isEnabled(ILogger.LogLevel.DEBUG) == false) throw var28_128;
                                                    this.log(var5_5 != null ? var5_5.getId() : null, var10_8, (String)var23_122[0], (String)var23_122[1], (Object[])var23_122[2], var23_122[3], var22_24, (Throwable)var21_21, System.currentTimeMillis() - var24_124);
                                                    throw var28_128;
                                                }
                                                if ("Session!".equals((String)var23_122[0]) && "setProperty".equals((String)var23_122[1])) {
                                                    var27_125 = (List)var22_24;
                                                    if (var27_125 == null) continue;
                                                    var12_9 = new ChangedHashtable<String, ?>();
                                                    var30_131 = var27_125.size();
                                                    for (var29_130 = 0; var29_130 < var30_131; ++var29_130) {
                                                        var28_127 = (Object[])var27_125.get(var29_130);
                                                        var12_9.put((String)var28_127[0], var28_127[1], false);
                                                    }
                                                    continue;
                                                }
                                                if (var5_5 == null) {
                                                    var5_5 = this.sessman.get(var22_24);
                                                }
                                                var9_7.add(new ResultObject(3, var22_24));
                                                continue;
                                            }
                                            this.log.debug(new Object[]{"Invalid request parameters!", var23_122});
                                            throw new SecurityException("Invalid request parameters!");
                                        }
                                        var32_26 = null;
                                        ** try [egrp 7[TRYBLOCK] [11 : 1148->1157)] { 
lbl230:
                                        // 1 sources

                                        var1_1.close();
                                        break block146;
lbl232:
                                        // 1 sources

                                        catch (Throwable var33_30) {
                                            this.log.error(new Object[]{var33_30});
                                        }
                                    }
                                    if (var2_2.isClosed()) break block142;
                                    var7_34 = new ByteArrayOutputStream();
                                    if (var8_6 != null) break block147;
                                    var7_34.write(66);
                                    var7_34.write(1);
                                    var33_30 = new DataOutputStream(var7_34);
                                    ** try [egrp 8[TRYBLOCK] [12 : 1224->1471)] { 
lbl242:
                                    // 1 sources

                                    var36_47 = var9_7.size();
                                    var37_56 = 0;
                                    for (var35_39 = 0; var35_39 < var36_47 && var37_56 == 0; ++var35_39) {
                                        if (((ResultObject)var9_7.get(var35_39)).getType() != 4) continue;
                                        var34_67 = (Throwable)((ResultObject)var9_7.get(var35_39)).getObject();
                                        if (var34_67 != null) {
                                            var38_75 = var34_67.getStackTrace();
                                            var33_30.writeUTF(var34_67.getClass().getName());
                                            var33_30.writeUTF(CommonUtil.nvl(var34_67.getMessage(), ""));
                                            if (var38_75 != null) {
                                                var33_30.write(var38_75.length);
                                                var40_86 = var38_75.length;
                                                for (var39_82 = 0; var39_82 < var40_86; ++var39_82) {
                                                    var33_30.writeUTF(CommonUtil.nvl(var38_75[var39_82].getClassName(), ""));
                                                    var33_30.writeUTF(CommonUtil.nvl(var38_75[var39_82].getMethodName(), ""));
                                                    var33_30.writeUTF(CommonUtil.nvl(var38_75[var39_82].getFileName(), ""));
                                                    var33_30.writeInt(var38_75[var39_82].getLineNumber());
                                                }
                                            } else {
                                                var33_30.write(0);
                                            }
                                        } else {
                                            var33_30.writeUTF("");
                                        }
                                        ++var37_56;
                                    }
                                    var42_91 = null;
                                    var33_30.flush();
                                    break block148;
lbl270:
                                    // 1 sources

                                    catch (Throwable var41_98) {
                                        var42_92 = null;
                                        var33_30.flush();
                                        throw var41_98;
                                    }
                                }
                                var33_30 = null;
                                var34_68 = var5_5 != null ? var5_5.getProperties().getChanges(IConnectionConstants.PROPERTY_CLASSES) : (var12_9 != null ? var12_9.getChanges(IConnectionConstants.PROPERTY_CLASSES) : null);
                                if (var34_68 != null && var34_68.size() > 0) {
                                    var35_40 = new ArrayUtil<E>(var34_68.size());
                                    for (Object var37_57 : var34_68) {
                                        var35_40.add(new Object[]{var37_57.getKey(), var37_57.getValue()});
                                        var2_2.setProperty((String)var37_57.getKey(), var37_57.getValue());
                                    }
                                    if (var33_30 == null) {
                                        var33_30 = new ArrayUtil<E>();
                                    }
                                    var33_30.add(new ResultObject(5, var35_40));
                                }
                                if (var5_5 != null) {
                                    if (var33_30 == null) {
                                        var33_30 = new ArrayUtil<ResultObject>();
                                    }
                                    if ((var35_40 = this.getCallBackResultsIntern(var5_5)) != null) {
                                        var33_30.addAll(var35_40);
                                    }
                                }
                                if (var9_7 != null) {
                                    if (var33_30 == null) {
                                        var33_30 = new ArrayUtil<E>();
                                    }
                                    var33_30.addAll(var9_7);
                                }
                                var11_103 = var33_30 != null ? var33_30.size() : 0;
                                var35_40 = new ByteArrayOutputStream(256);
                                var36_48 = new DataOutputStream((OutputStream)var35_40);
                                ** try [egrp 9[TRYBLOCK] [14 : 1792->1912)] { 
lbl304:
                                // 1 sources

                                var8_6.write(var36_48, var11_103);
                                if (var33_30 != null) {
                                    var37_57 = var33_30.iterator();
                                    while (var37_57.hasNext()) {
                                        var38_76 = (ResultObject)var37_57.next();
                                        var8_6.write(var36_48, var38_76.getType());
                                        var8_6.write(var36_48, var38_76.getObject());
                                        if (var38_76.getType() != 2 && var38_76.getType() != 1) continue;
                                        var8_6.write(var36_48, var38_76.getCallBackId());
                                    }
                                }
                                break block149;
lbl315:
                                // 1 sources

                                catch (Throwable var43_115) {
                                    var44_109 = null;
                                    var35_40.close();
                                    var36_48.close();
                                    throw var43_115;
                                }
                            }
                            var44_108 = null;
                            var35_40.close();
                            var36_48.close();
                            var7_34.write(69);
                            v1 = var37_58 = var5_5 != null && Boolean.parseBoolean((String)var5_5.getProperties().get("client.session.compression")) != false;
                            if (var37_58 && var35_40.size() > 256) {
                                var7_34.write(2);
                                var38_76 = new GZIPOutputStream(var7_34);
                                var38_76.write(var35_40.toByteArray());
                                var38_76.flush();
                                var38_76.finish();
                            } else {
                                var7_34.write(1);
                                var7_34.write(var35_40.toByteArray());
                            }
                        }
                        var7_34.flush();
                        var7_34.close();
                        if (var13_10 != null) {
                            var13_10.content = var7_34;
                            var33_30 = var13_10;
                            synchronized (var33_30) {
                                var13_10.notifyAll();
                            }
                        } else if (var5_5 != null) {
                            this.whmResponse.put(this.sessman.getMasterSession(var5_5), new CachedResponse(var10_8, var7_34));
                        }
                        this.sendContent(var2_2, var7_34);
                        break block142;
                        catch (Throwable var14_13) {
                            block152: {
                                block153: {
                                    block151: {
                                        block150: {
                                            if (var14_13 == Server.EXCEPTION_CONTENT) {
                                                throw Server.EXCEPTION_CONTENT;
                                            }
                                            this.log.error(new Object[]{var14_13});
                                            if (var9_7 == null) {
                                                var9_7 = new ArrayUtil<ResultObject>(1);
                                            }
                                            var9_7.add(new ResultObject(4, AbstractSecurityManager.prepareException(var14_13)));
                                            var32_27 = null;
                                            ** try [egrp 7[TRYBLOCK] [11 : 1148->1157)] { 
lbl361:
                                            // 1 sources

                                            var1_1.close();
                                            break block150;
lbl363:
                                            // 1 sources

                                            catch (Throwable var33_31) {
                                                this.log.error(new Object[]{var33_31});
                                            }
                                        }
                                        if (var2_2.isClosed()) break block142;
                                        var7_35 = new ByteArrayOutputStream();
                                        if (var8_6 != null) break block151;
                                        var7_35.write(66);
                                        var7_35.write(1);
                                        var33_31 = new DataOutputStream(var7_35);
                                        ** try [egrp 8[TRYBLOCK] [12 : 1224->1471)] { 
lbl373:
                                        // 1 sources

                                        var36_49 = var9_7.size();
                                        var37_59 = 0;
                                        for (var35_41 = 0; var35_41 < var36_49 && var37_59 == 0; ++var35_41) {
                                            if (((ResultObject)var9_7.get(var35_41)).getType() != 4) continue;
                                            var34_69 = (Throwable)((ResultObject)var9_7.get(var35_41)).getObject();
                                            if (var34_69 != null) {
                                                var38_77 = var34_69.getStackTrace();
                                                var33_31.writeUTF(var34_69.getClass().getName());
                                                var33_31.writeUTF(CommonUtil.nvl(var34_69.getMessage(), ""));
                                                if (var38_77 != null) {
                                                    var33_31.write(var38_77.length);
                                                    var40_87 = var38_77.length;
                                                    for (var39_83 = 0; var39_83 < var40_87; ++var39_83) {
                                                        var33_31.writeUTF(CommonUtil.nvl(var38_77[var39_83].getClassName(), ""));
                                                        var33_31.writeUTF(CommonUtil.nvl(var38_77[var39_83].getMethodName(), ""));
                                                        var33_31.writeUTF(CommonUtil.nvl(var38_77[var39_83].getFileName(), ""));
                                                        var33_31.writeInt(var38_77[var39_83].getLineNumber());
                                                    }
                                                } else {
                                                    var33_31.write(0);
                                                }
                                            } else {
                                                var33_31.writeUTF("");
                                            }
                                            ++var37_59;
                                        }
                                        var42_93 = null;
                                        var33_31.flush();
                                        break block152;
lbl401:
                                        // 1 sources

                                        catch (Throwable var41_99) {
                                            var42_94 = null;
                                            var33_31.flush();
                                            throw var41_99;
                                        }
                                    }
                                    var33_31 = null;
                                    var34_70 = var5_5 != null ? var5_5.getProperties().getChanges(IConnectionConstants.PROPERTY_CLASSES) : (var12_9 != null ? var12_9.getChanges(IConnectionConstants.PROPERTY_CLASSES) : null);
                                    if (var34_70 != null && var34_70.size() > 0) {
                                        var35_42 = new ArrayUtil<E>(var34_70.size());
                                        for (Object var37_60 : var34_70) {
                                            var35_42.add(new Object[]{var37_60.getKey(), var37_60.getValue()});
                                            var2_2.setProperty((String)var37_60.getKey(), var37_60.getValue());
                                        }
                                        if (var33_31 == null) {
                                            var33_31 = new ArrayUtil<E>();
                                        }
                                        var33_31.add(new ResultObject(5, var35_42));
                                    }
                                    if (var5_5 != null) {
                                        if (var33_31 == null) {
                                            var33_31 = new ArrayUtil<ResultObject>();
                                        }
                                        if ((var35_42 = this.getCallBackResultsIntern(var5_5)) != null) {
                                            var33_31.addAll(var35_42);
                                        }
                                    }
                                    if (var9_7 != null) {
                                        if (var33_31 == null) {
                                            var33_31 = new ArrayUtil<E>();
                                        }
                                        var33_31.addAll(var9_7);
                                    }
                                    var11_104 = var33_31 != null ? var33_31.size() : 0;
                                    var35_42 = new ByteArrayOutputStream(256);
                                    var36_50 = new DataOutputStream((OutputStream)var35_42);
                                    ** try [egrp 9[TRYBLOCK] [14 : 1792->1912)] { 
lbl435:
                                    // 1 sources

                                    var8_6.write(var36_50, var11_104);
                                    if (var33_31 != null) {
                                        var37_60 = var33_31.iterator();
                                        while (var37_60.hasNext()) {
                                            var38_78 = (ResultObject)var37_60.next();
                                            var8_6.write(var36_50, var38_78.getType());
                                            var8_6.write(var36_50, var38_78.getObject());
                                            if (var38_78.getType() != 2 && var38_78.getType() != 1) continue;
                                            var8_6.write(var36_50, var38_78.getCallBackId());
                                        }
                                    }
                                    break block153;
lbl446:
                                    // 1 sources

                                    catch (Throwable var43_116) {
                                        var44_111 = null;
                                        var35_42.close();
                                        var36_50.close();
                                        throw var43_116;
                                    }
                                }
                                var44_110 = null;
                                var35_42.close();
                                var36_50.close();
                                var7_35.write(69);
                                v2 = var37_61 = var5_5 != null && Boolean.parseBoolean((String)var5_5.getProperties().get("client.session.compression")) != false;
                                if (var37_61 && var35_42.size() > 256) {
                                    var7_35.write(2);
                                    var38_78 = new GZIPOutputStream(var7_35);
                                    var38_78.write(var35_42.toByteArray());
                                    var38_78.flush();
                                    var38_78.finish();
                                } else {
                                    var7_35.write(1);
                                    var7_35.write(var35_42.toByteArray());
                                }
                            }
                            var7_35.flush();
                            var7_35.close();
                            if (var13_10 != null) {
                                var13_10.content = var7_35;
                                var33_31 = var13_10;
                                synchronized (var33_31) {
                                    var13_10.notifyAll();
                                }
                            } else if (var5_5 != null) {
                                this.whmResponse.put(this.sessman.getMasterSession(var5_5), new CachedResponse(var10_8, var7_35));
                            }
                            this.sendContent(var2_2, var7_35);
                        }
                    }
                    catch (Throwable var31_132) {
                        block156: {
                            block157: {
                                block155: {
                                    block154: {
                                        var32_28 = null;
                                        ** try [egrp 7[TRYBLOCK] [11 : 1148->1157)] { 
lbl485:
                                        // 1 sources

                                        var1_1.close();
                                        break block154;
lbl487:
                                        // 1 sources

                                        catch (Throwable var33_32 /* !! */ ) {
                                            this.log.error(new Object[]{var33_32 /* !! */ });
                                        }
                                    }
                                    if (var2_2.isClosed() != false) throw var31_132;
                                    var7_36 = new ByteArrayOutputStream();
                                    if (var8_6 != null) break block155;
                                    var7_36.write(66);
                                    var7_36.write(1);
                                    var33_32 /* !! */  = new DataOutputStream(var7_36);
                                    ** try [egrp 8[TRYBLOCK] [12 : 1224->1471)] { 
lbl497:
                                    // 1 sources

                                    var36_51 = var9_7.size();
                                    var37_62 = 0;
                                    for (var35_43 = 0; var35_43 < var36_51 && var37_62 == 0; ++var35_43) {
                                        if (((ResultObject)var9_7.get(var35_43)).getType() != 4) continue;
                                        var34_71 = (Throwable)((ResultObject)var9_7.get(var35_43)).getObject();
                                        if (var34_71 != null) {
                                            var38_79 = var34_71.getStackTrace();
                                            var33_32 /* !! */ .writeUTF(var34_71.getClass().getName());
                                            var33_32 /* !! */ .writeUTF(CommonUtil.nvl(var34_71.getMessage(), ""));
                                            if (var38_79 != null) {
                                                var33_32 /* !! */ .write(var38_79.length);
                                                var40_88 = var38_79.length;
                                                for (var39_84 = 0; var39_84 < var40_88; ++var39_84) {
                                                    var33_32 /* !! */ .writeUTF(CommonUtil.nvl(var38_79[var39_84].getClassName(), ""));
                                                    var33_32 /* !! */ .writeUTF(CommonUtil.nvl(var38_79[var39_84].getMethodName(), ""));
                                                    var33_32 /* !! */ .writeUTF(CommonUtil.nvl(var38_79[var39_84].getFileName(), ""));
                                                    var33_32 /* !! */ .writeInt(var38_79[var39_84].getLineNumber());
                                                }
                                            } else {
                                                var33_32 /* !! */ .write(0);
                                            }
                                        } else {
                                            var33_32 /* !! */ .writeUTF("");
                                        }
                                        ++var37_62;
                                    }
                                    var42_95 = null;
                                    var33_32 /* !! */ .flush();
                                    break block156;
lbl525:
                                    // 1 sources

                                    catch (Throwable var41_100) {
                                        var42_96 = null;
                                        var33_32 /* !! */ .flush();
                                        throw var41_100;
                                    }
                                }
                                var33_32 /* !! */  = null;
                                var34_72 = var5_5 != null ? var5_5.getProperties().getChanges(IConnectionConstants.PROPERTY_CLASSES) : (var12_9 != null ? var12_9.getChanges(IConnectionConstants.PROPERTY_CLASSES) : null);
                                if (var34_72 != null && var34_72.size() > 0) {
                                    var35_44 = new ArrayUtil<E>(var34_72.size());
                                    for (Object var37_63 : var34_72) {
                                        var35_44.add(new Object[]{var37_63.getKey(), var37_63.getValue()});
                                        var2_2.setProperty((String)var37_63.getKey(), var37_63.getValue());
                                    }
                                    if (var33_32 /* !! */  == null) {
                                        var33_32 /* !! */  = new ArrayUtil<E>();
                                    }
                                    var33_32 /* !! */ .add(new ResultObject(5, var35_44));
                                }
                                if (var5_5 != null) {
                                    if (var33_32 /* !! */  == null) {
                                        var33_32 /* !! */  = new ArrayUtil<ResultObject>();
                                    }
                                    if ((var35_44 = this.getCallBackResultsIntern(var5_5)) != null) {
                                        var33_32 /* !! */ .addAll((Collection<ResultObject>)var35_44);
                                    }
                                }
                                if (var9_7 != null) {
                                    if (var33_32 /* !! */  == null) {
                                        var33_32 /* !! */  = new ArrayUtil<E>();
                                    }
                                    var33_32 /* !! */ .addAll(var9_7);
                                }
                                var11_105 = var33_32 /* !! */  != null ? var33_32 /* !! */ .size() : 0;
                                var35_44 = new ByteArrayOutputStream(256);
                                var36_52 = new DataOutputStream((OutputStream)var35_44);
                                ** try [egrp 9[TRYBLOCK] [14 : 1792->1912)] { 
lbl559:
                                // 1 sources

                                var8_6.write(var36_52, var11_105);
                                if (var33_32 /* !! */  != null) {
                                    for (Object var38_80 : var33_32 /* !! */ ) {
                                        var8_6.write(var36_52, var38_80.getType());
                                        var8_6.write(var36_52, var38_80.getObject());
                                        if (var38_80.getType() != 2 && var38_80.getType() != 1) continue;
                                        var8_6.write(var36_52, var38_80.getCallBackId());
                                    }
                                }
                                break block157;
lbl568:
                                // 1 sources

                                catch (Throwable var43_117) {
                                    var44_113 = null;
                                    var35_44.close();
                                    var36_52.close();
                                    throw var43_117;
                                }
                            }
                            var44_112 = null;
                            var35_44.close();
                            var36_52.close();
                            var7_36.write(69);
                            v3 = var37_64 = var5_5 != null && Boolean.parseBoolean((String)var5_5.getProperties().get("client.session.compression")) != false;
                            if (var37_64 && var35_44.size() > 256) {
                                var7_36.write(2);
                                var38_80 = new GZIPOutputStream(var7_36);
                                var38_80.write(var35_44.toByteArray());
                                var38_80.flush();
                                var38_80.finish();
                            } else {
                                var7_36.write(1);
                                var7_36.write(var35_44.toByteArray());
                            }
                        }
                        var7_36.flush();
                        var7_36.close();
                        if (var13_10 != null) {
                            var13_10.content = var7_36;
                            var33_32 /* !! */  = var13_10;
                            synchronized (var33_32 /* !! */ ) {
                                var13_10.notifyAll();
                            }
                        } else if (var5_5 != null) {
                            this.whmResponse.put(this.sessman.getMasterSession(var5_5), new CachedResponse(var10_8, var7_36));
                        }
                        this.sendContent(var2_2, var7_36);
                        throw var31_132;
                    }
                }
                var14_14 = var5_5;
                var47_119 = null;
            }
            catch (Throwable var46_133) {
                var47_120 = null;
                CommonUtil.close(new Object[]{var4_4});
                var3_3.release();
                throw var46_133;
            }
            CommonUtil.close(new Object[]{var4_4});
            var3_3.release();
            return var14_14;
        }
        while (var23_121 < var11_102) {
            var22_23 = (Object[])var8_6.read(var17_17);
            if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                this.log(var5_5 != null ? var5_5.getId() : null, var10_8, (String)var22_23[0], (String)var22_23[1], (Object[])var22_23[2], var22_23[3], null, null, -1L);
            }
            ++var23_121;
        }
        throw new IOException("Invalid communication state! " + var10_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendContent(IResponse iResponse, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        try {
            OutputStream outputStream = iResponse.getOutputStream();
            byteArrayOutputStream.writeTo(outputStream);
            outputStream.flush();
            Object var5_4 = null;
            iResponse.close();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            iResponse.close();
            throw throwable;
        }
    }

    private Object process(IRequest iRequest, ISerializer iSerializer, AbstractSession abstractSession, String string, String string2, Object[] objectArray, Object object, ChangedHashtable<String, Object> changedHashtable) throws Throwable {
        if (object != null) {
            this.validateCallBack(abstractSession, string);
        }
        if (string != null && "Session!".equals(string)) {
            if ("createSession".equals(string2)) {
                if (abstractSession != null) {
                    throw new SecurityException("Session is already open!");
                }
                return this.createSessionIntern(iRequest, iSerializer, changedHashtable);
            }
            if ("createSubSession".equals(string2)) {
                if (abstractSession != null) {
                    throw new SecurityException("Session is already open!");
                }
                return this.createSubSessionIntern(iRequest, this.sessman.get(objectArray[0]), changedHashtable);
            }
            if ("setProperty".equals(string2) && abstractSession == null) {
                return (List)objectArray[0];
            }
            if (abstractSession != null) {
                if ("setAndCheckAlive".equals(string2)) {
                    return this.setAndCheckAliveIntern(abstractSession, objectArray);
                }
                if ("destroySession".equals(string2)) {
                    this.destroySessionIntern(abstractSession.getId());
                    return null;
                }
                if ("getProperty".equals(string2)) {
                    return this.getPropertyIntern(abstractSession, (String)objectArray[0]);
                }
                if ("getProperties".equals(string2)) {
                    return this.getPropertiesIntern(abstractSession);
                }
                if ("setProperty".equals(string2)) {
                    this.setPropertiesIntern(abstractSession, (List)objectArray[0]);
                    return null;
                }
                if ("setNewPassword".equals(string2)) {
                    this.setNewPasswordInternal(abstractSession, (String)objectArray[0], (String)objectArray[1]);
                    return null;
                }
            }
        }
        return this.executeIntern(abstractSession, new Call(object, string, string2, objectArray));
    }

    private Object executeIntern(AbstractSession abstractSession, Call call) throws Throwable {
        if (abstractSession != null) {
            return abstractSession.execute(call);
        }
        throw new SecurityException("No session for call '" + call.formatMethod() + "'");
    }

    private void validateCallBack(AbstractSession abstractSession, String string) {
        if (abstractSession == null) {
            throw new SecurityException("Call back is not allowed!");
        }
        if (string != null && "Session!".equals(string)) {
            throw new SecurityException("Call back is not allowed!");
        }
    }

    private Object createSessionIntern(IRequest iRequest, ISerializer iSerializer, ChangedHashtable<String, Object> changedHashtable) throws Throwable {
        return this.sessman.createSession(iRequest, iSerializer, changedHashtable);
    }

    private Object createSubSessionIntern(IRequest iRequest, AbstractSession abstractSession, ChangedHashtable<String, Object> changedHashtable) throws Throwable {
        return this.sessman.createSubSession(iRequest, abstractSession, changedHashtable);
    }

    private void destroySessionIntern(Object object) {
        this.sessman.destroy(object);
    }

    private void setPropertyIntern(AbstractSession abstractSession, String string, Object object) {
        abstractSession.setProperty(string, object);
    }

    private void setPropertiesIntern(AbstractSession abstractSession, List<Object[]> list) {
        abstractSession.setProperties(list);
    }

    private Object getPropertyIntern(AbstractSession abstractSession, String string) {
        Object object = abstractSession.getProperty(string);
        if (object != null) {
            for (int i = 0; i < IConnectionConstants.PROPERTY_CLASSES.length; ++i) {
                if (!IConnectionConstants.PROPERTY_CLASSES[i].isAssignableFrom(object.getClass())) continue;
                return object;
            }
        }
        return null;
    }

    private ChangedHashtable<String, Object> getPropertiesIntern(AbstractSession abstractSession) {
        List list = ((ChangedHashtable)abstractSession.getProperties()).getMapping(IConnectionConstants.PROPERTY_CLASSES);
        ChangedHashtable<String, Object> changedHashtable = new ChangedHashtable<String, Object>();
        for (Map.Entry entry : list) {
            Object obj = entry.getValue();
            if (obj == null) continue;
            changedHashtable.put((String)entry.getKey(), obj, false);
        }
        return changedHashtable;
    }

    private ArrayUtil<ResultObject> getCallBackResultsIntern(AbstractSession abstractSession) {
        if (abstractSession != null) {
            return abstractSession.removeCallBackResults();
        }
        return null;
    }

    private Object[] setAndCheckAliveIntern(AbstractSession abstractSession, Object[] objectArray) {
        abstractSession.setLastAliveTime(System.currentTimeMillis());
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        ArrayUtil<Object> arrayUtil = new ArrayUtil<Object>();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            try {
                this.sessman.get(objectArray[i]);
                continue;
            }
            catch (RuntimeException runtimeException) {
                arrayUtil.add(objectArray[i]);
            }
        }
        if (arrayUtil.size() > 0) {
            Object[] objectArray2 = new Object[arrayUtil.size()];
            arrayUtil.toArray(objectArray2);
            return objectArray2;
        }
        return null;
    }

    private void setNewPasswordInternal(AbstractSession abstractSession, String string, String string2) throws Throwable {
        abstractSession.setNewPassword(string, string2);
    }

    public final Monitoring getMonitoring() {
        return this.monitoring;
    }

    private final void log(Object object, Object object2, String string, String string2, Object[] objectArray, Object object3, Object object4, Throwable throwable, long l) {
        this.log.debug("SESSION-ID: ", object, "\nCOMMUNICATION-ID: ", object2, "\nOBJECTNAME: ", string, "\nMETHOD:     ", string2, "\nPARAMS:     ", objectArray, "\nCALLBACK:   ", object3, "\nRESULT:     ", object4, "\nEXCEPTION:  ", throwable, throwable != null ? "DURATION:   " : "\nDURATION:   ", l, " ms");
    }

    final ServerContext createServerContext() {
        ServerContextImpl serverContextImpl = new ServerContextImpl(this);
        return serverContextImpl;
    }

    private final class CachedResponse {
        protected Long id;
        protected ByteArrayOutputStream content;

        private CachedResponse(Long l) {
            this.id = l;
        }

        private CachedResponse(Long l, ByteArrayOutputStream byteArrayOutputStream) {
            this.id = l;
            this.content = byteArrayOutputStream;
        }
    }
}

